/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.batch.model.JobDetail;
import software.amazon.awssdk.services.batch.model.JobDetailListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeJobsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, DescribeJobsResponse> {
    private final List<JobDetail> jobs;

    private DescribeJobsResponse(BuilderImpl builder) {
        this.jobs = builder.jobs;
    }

    public List<JobDetail> jobs() {
        return this.jobs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.jobs() == null ? 0 : this.jobs().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeJobsResponse)) {
            return false;
        }
        DescribeJobsResponse other = (DescribeJobsResponse)((Object)obj);
        if (other.jobs() == null ^ this.jobs() == null) {
            return false;
        }
        return other.jobs() == null || other.jobs().equals(this.jobs());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.jobs() != null) {
            sb.append("Jobs: ").append(this.jobs()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<JobDetail> jobs;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeJobsResponse model) {
            this.setJobs(model.jobs);
        }

        public final Collection<JobDetail> getJobs() {
            return this.jobs;
        }

        @Override
        public final Builder jobs(Collection<JobDetail> jobs) {
            this.jobs = JobDetailListCopier.copy(jobs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobs(JobDetail ... jobs) {
            this.jobs(Arrays.asList(jobs));
            return this;
        }

        public final void setJobs(Collection<JobDetail> jobs) {
            this.jobs = JobDetailListCopier.copy(jobs);
        }

        public DescribeJobsResponse build() {
            return new DescribeJobsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, DescribeJobsResponse> {
        public Builder jobs(Collection<JobDetail> var1);

        public Builder jobs(JobDetail ... var1);
    }
}

