/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.batch.model.ArrayProperties;

public class ArrayPropertiesUnmarshaller
implements Unmarshaller<ArrayProperties, JsonUnmarshallerContext> {
    private static final ArrayPropertiesUnmarshaller INSTANCE = new ArrayPropertiesUnmarshaller();

    public ArrayProperties unmarshall(JsonUnmarshallerContext context) throws Exception {
        ArrayProperties.Builder arrayPropertiesBuilder = ArrayProperties.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("size", targetDepth)) {
                    context.nextToken();
                    arrayPropertiesBuilder.size((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (ArrayProperties)arrayPropertiesBuilder.build();
    }

    public static ArrayPropertiesUnmarshaller getInstance() {
        return INSTANCE;
    }
}

