/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.protocol.json.AwsJsonProtocol;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolMetadata;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.http.JsonResponseHandler;
import software.amazon.awssdk.core.internal.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.protocol.json.JsonClientMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorResponseMetadata;
import software.amazon.awssdk.core.protocol.json.JsonErrorShapeMetadata;
import software.amazon.awssdk.core.protocol.json.JsonOperationMetadata;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.batch.BatchClient;
import software.amazon.awssdk.services.batch.model.BatchException;
import software.amazon.awssdk.services.batch.model.CancelJobRequest;
import software.amazon.awssdk.services.batch.model.CancelJobResponse;
import software.amazon.awssdk.services.batch.model.ClientException;
import software.amazon.awssdk.services.batch.model.CreateComputeEnvironmentRequest;
import software.amazon.awssdk.services.batch.model.CreateComputeEnvironmentResponse;
import software.amazon.awssdk.services.batch.model.CreateJobQueueRequest;
import software.amazon.awssdk.services.batch.model.CreateJobQueueResponse;
import software.amazon.awssdk.services.batch.model.DeleteComputeEnvironmentRequest;
import software.amazon.awssdk.services.batch.model.DeleteComputeEnvironmentResponse;
import software.amazon.awssdk.services.batch.model.DeleteJobQueueRequest;
import software.amazon.awssdk.services.batch.model.DeleteJobQueueResponse;
import software.amazon.awssdk.services.batch.model.DeregisterJobDefinitionRequest;
import software.amazon.awssdk.services.batch.model.DeregisterJobDefinitionResponse;
import software.amazon.awssdk.services.batch.model.DescribeComputeEnvironmentsRequest;
import software.amazon.awssdk.services.batch.model.DescribeComputeEnvironmentsResponse;
import software.amazon.awssdk.services.batch.model.DescribeJobDefinitionsRequest;
import software.amazon.awssdk.services.batch.model.DescribeJobDefinitionsResponse;
import software.amazon.awssdk.services.batch.model.DescribeJobQueuesRequest;
import software.amazon.awssdk.services.batch.model.DescribeJobQueuesResponse;
import software.amazon.awssdk.services.batch.model.DescribeJobsRequest;
import software.amazon.awssdk.services.batch.model.DescribeJobsResponse;
import software.amazon.awssdk.services.batch.model.ListJobsRequest;
import software.amazon.awssdk.services.batch.model.ListJobsResponse;
import software.amazon.awssdk.services.batch.model.RegisterJobDefinitionRequest;
import software.amazon.awssdk.services.batch.model.RegisterJobDefinitionResponse;
import software.amazon.awssdk.services.batch.model.ServerException;
import software.amazon.awssdk.services.batch.model.SubmitJobRequest;
import software.amazon.awssdk.services.batch.model.SubmitJobResponse;
import software.amazon.awssdk.services.batch.model.TerminateJobRequest;
import software.amazon.awssdk.services.batch.model.TerminateJobResponse;
import software.amazon.awssdk.services.batch.model.UpdateComputeEnvironmentRequest;
import software.amazon.awssdk.services.batch.model.UpdateComputeEnvironmentResponse;
import software.amazon.awssdk.services.batch.model.UpdateJobQueueRequest;
import software.amazon.awssdk.services.batch.model.UpdateJobQueueResponse;
import software.amazon.awssdk.services.batch.transform.CancelJobRequestMarshaller;
import software.amazon.awssdk.services.batch.transform.CancelJobResponseUnmarshaller;
import software.amazon.awssdk.services.batch.transform.CreateComputeEnvironmentRequestMarshaller;
import software.amazon.awssdk.services.batch.transform.CreateComputeEnvironmentResponseUnmarshaller;
import software.amazon.awssdk.services.batch.transform.CreateJobQueueRequestMarshaller;
import software.amazon.awssdk.services.batch.transform.CreateJobQueueResponseUnmarshaller;
import software.amazon.awssdk.services.batch.transform.DeleteComputeEnvironmentRequestMarshaller;
import software.amazon.awssdk.services.batch.transform.DeleteComputeEnvironmentResponseUnmarshaller;
import software.amazon.awssdk.services.batch.transform.DeleteJobQueueRequestMarshaller;
import software.amazon.awssdk.services.batch.transform.DeleteJobQueueResponseUnmarshaller;
import software.amazon.awssdk.services.batch.transform.DeregisterJobDefinitionRequestMarshaller;
import software.amazon.awssdk.services.batch.transform.DeregisterJobDefinitionResponseUnmarshaller;
import software.amazon.awssdk.services.batch.transform.DescribeComputeEnvironmentsRequestMarshaller;
import software.amazon.awssdk.services.batch.transform.DescribeComputeEnvironmentsResponseUnmarshaller;
import software.amazon.awssdk.services.batch.transform.DescribeJobDefinitionsRequestMarshaller;
import software.amazon.awssdk.services.batch.transform.DescribeJobDefinitionsResponseUnmarshaller;
import software.amazon.awssdk.services.batch.transform.DescribeJobQueuesRequestMarshaller;
import software.amazon.awssdk.services.batch.transform.DescribeJobQueuesResponseUnmarshaller;
import software.amazon.awssdk.services.batch.transform.DescribeJobsRequestMarshaller;
import software.amazon.awssdk.services.batch.transform.DescribeJobsResponseUnmarshaller;
import software.amazon.awssdk.services.batch.transform.ListJobsRequestMarshaller;
import software.amazon.awssdk.services.batch.transform.ListJobsResponseUnmarshaller;
import software.amazon.awssdk.services.batch.transform.RegisterJobDefinitionRequestMarshaller;
import software.amazon.awssdk.services.batch.transform.RegisterJobDefinitionResponseUnmarshaller;
import software.amazon.awssdk.services.batch.transform.SubmitJobRequestMarshaller;
import software.amazon.awssdk.services.batch.transform.SubmitJobResponseUnmarshaller;
import software.amazon.awssdk.services.batch.transform.TerminateJobRequestMarshaller;
import software.amazon.awssdk.services.batch.transform.TerminateJobResponseUnmarshaller;
import software.amazon.awssdk.services.batch.transform.UpdateComputeEnvironmentRequestMarshaller;
import software.amazon.awssdk.services.batch.transform.UpdateComputeEnvironmentResponseUnmarshaller;
import software.amazon.awssdk.services.batch.transform.UpdateJobQueueRequestMarshaller;
import software.amazon.awssdk.services.batch.transform.UpdateJobQueueResponseUnmarshaller;

@SdkInternalApi
final class DefaultBatchClient
implements BatchClient {
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultBatchClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(false);
    }

    public final String serviceName() {
        return "batch";
    }

    @Override
    public CancelJobResponse cancelJob(CancelJobRequest cancelJobRequest) throws ClientException, ServerException, AwsServiceException, SdkClientException, BatchException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CancelJobResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (CancelJobResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)cancelJobRequest).withMarshaller((Marshaller)new CancelJobRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateComputeEnvironmentResponse createComputeEnvironment(CreateComputeEnvironmentRequest createComputeEnvironmentRequest) throws ClientException, ServerException, AwsServiceException, SdkClientException, BatchException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateComputeEnvironmentResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (CreateComputeEnvironmentResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createComputeEnvironmentRequest).withMarshaller((Marshaller)new CreateComputeEnvironmentRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public CreateJobQueueResponse createJobQueue(CreateJobQueueRequest createJobQueueRequest) throws ClientException, ServerException, AwsServiceException, SdkClientException, BatchException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new CreateJobQueueResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (CreateJobQueueResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createJobQueueRequest).withMarshaller((Marshaller)new CreateJobQueueRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteComputeEnvironmentResponse deleteComputeEnvironment(DeleteComputeEnvironmentRequest deleteComputeEnvironmentRequest) throws ClientException, ServerException, AwsServiceException, SdkClientException, BatchException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteComputeEnvironmentResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (DeleteComputeEnvironmentResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteComputeEnvironmentRequest).withMarshaller((Marshaller)new DeleteComputeEnvironmentRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeleteJobQueueResponse deleteJobQueue(DeleteJobQueueRequest deleteJobQueueRequest) throws ClientException, ServerException, AwsServiceException, SdkClientException, BatchException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeleteJobQueueResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (DeleteJobQueueResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteJobQueueRequest).withMarshaller((Marshaller)new DeleteJobQueueRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DeregisterJobDefinitionResponse deregisterJobDefinition(DeregisterJobDefinitionRequest deregisterJobDefinitionRequest) throws ClientException, ServerException, AwsServiceException, SdkClientException, BatchException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DeregisterJobDefinitionResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (DeregisterJobDefinitionResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deregisterJobDefinitionRequest).withMarshaller((Marshaller)new DeregisterJobDefinitionRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeComputeEnvironmentsResponse describeComputeEnvironments(DescribeComputeEnvironmentsRequest describeComputeEnvironmentsRequest) throws ClientException, ServerException, AwsServiceException, SdkClientException, BatchException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeComputeEnvironmentsResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (DescribeComputeEnvironmentsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeComputeEnvironmentsRequest).withMarshaller((Marshaller)new DescribeComputeEnvironmentsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeJobDefinitionsResponse describeJobDefinitions(DescribeJobDefinitionsRequest describeJobDefinitionsRequest) throws ClientException, ServerException, AwsServiceException, SdkClientException, BatchException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeJobDefinitionsResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (DescribeJobDefinitionsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeJobDefinitionsRequest).withMarshaller((Marshaller)new DescribeJobDefinitionsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeJobQueuesResponse describeJobQueues(DescribeJobQueuesRequest describeJobQueuesRequest) throws ClientException, ServerException, AwsServiceException, SdkClientException, BatchException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeJobQueuesResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (DescribeJobQueuesResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeJobQueuesRequest).withMarshaller((Marshaller)new DescribeJobQueuesRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public DescribeJobsResponse describeJobs(DescribeJobsRequest describeJobsRequest) throws ClientException, ServerException, AwsServiceException, SdkClientException, BatchException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new DescribeJobsResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (DescribeJobsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)describeJobsRequest).withMarshaller((Marshaller)new DescribeJobsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public ListJobsResponse listJobs(ListJobsRequest listJobsRequest) throws ClientException, ServerException, AwsServiceException, SdkClientException, BatchException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new ListJobsResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (ListJobsResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listJobsRequest).withMarshaller((Marshaller)new ListJobsRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public RegisterJobDefinitionResponse registerJobDefinition(RegisterJobDefinitionRequest registerJobDefinitionRequest) throws ClientException, ServerException, AwsServiceException, SdkClientException, BatchException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new RegisterJobDefinitionResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (RegisterJobDefinitionResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)registerJobDefinitionRequest).withMarshaller((Marshaller)new RegisterJobDefinitionRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public SubmitJobResponse submitJob(SubmitJobRequest submitJobRequest) throws ClientException, ServerException, AwsServiceException, SdkClientException, BatchException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new SubmitJobResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (SubmitJobResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)submitJobRequest).withMarshaller((Marshaller)new SubmitJobRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public TerminateJobResponse terminateJob(TerminateJobRequest terminateJobRequest) throws ClientException, ServerException, AwsServiceException, SdkClientException, BatchException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new TerminateJobResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (TerminateJobResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)terminateJobRequest).withMarshaller((Marshaller)new TerminateJobRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public UpdateComputeEnvironmentResponse updateComputeEnvironment(UpdateComputeEnvironmentRequest updateComputeEnvironmentRequest) throws ClientException, ServerException, AwsServiceException, SdkClientException, BatchException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateComputeEnvironmentResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (UpdateComputeEnvironmentResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateComputeEnvironmentRequest).withMarshaller((Marshaller)new UpdateComputeEnvironmentRequestMarshaller(this.protocolFactory)));
    }

    @Override
    public UpdateJobQueueResponse updateJobQueue(UpdateJobQueueRequest updateJobQueueRequest) throws ClientException, ServerException, AwsServiceException, SdkClientException, BatchException {
        JsonResponseHandler responseHandler = this.protocolFactory.createResponseHandler(new JsonOperationMetadata().withPayloadJson(true).withHasStreamingSuccessResponse(false), (Unmarshaller)new UpdateJobQueueResponseUnmarshaller());
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler(this.protocolFactory);
        return (UpdateJobQueueResponse)this.clientHandler.execute(new ClientExecutionParams().withResponseHandler((HttpResponseHandler)responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateJobQueueRequest).withMarshaller((Marshaller)new UpdateJobQueueRequestMarshaller(this.protocolFactory)));
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(AwsJsonProtocolFactory protocolFactory) {
        return protocolFactory.createErrorResponseHandler(new JsonErrorResponseMetadata());
    }

    private AwsJsonProtocolFactory init(boolean supportsCbor) {
        return new AwsJsonProtocolFactory(new JsonClientMetadata().withSupportsCbor(supportsCbor).withSupportsIon(false).withBaseServiceExceptionClass(BatchException.class).withContentTypeOverride("").addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ServerException").withModeledClass(ServerException.class)).addErrorMetadata(new JsonErrorShapeMetadata().withErrorCode("ClientException").withModeledClass(ClientException.class)), AwsJsonProtocolMetadata.builder().protocolVersion("1.1").protocol(AwsJsonProtocol.REST_JSON).build());
    }

    public void close() {
        this.clientHandler.close();
    }
}

