/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.batch.model.JobDependency;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class JobDependencyMarshaller {
    private static final MarshallingInfo<String> JOBID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("jobId").isBinary(false).build();
    private static final JobDependencyMarshaller INSTANCE = new JobDependencyMarshaller();

    private JobDependencyMarshaller() {
    }

    public static JobDependencyMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(JobDependency jobDependency, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)jobDependency, (String)"jobDependency");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)jobDependency.jobId(), JOBID_BINDING);
        }
        catch (Exception e) {
            throw SdkClientException.builder().message("Unable to marshall request to JSON: " + e.getMessage()).cause((Throwable)e).build();
        }
    }
}

