/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.batch.model.UpdateJobQueueRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class UpdateJobQueueRequestModelMarshaller {
    private static final MarshallingInfo<String> JOBQUEUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("jobQueue").isBinary(false).build();
    private static final MarshallingInfo<String> STATE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("state").isBinary(false).build();
    private static final MarshallingInfo<Integer> PRIORITY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("priority").isBinary(false).build();
    private static final MarshallingInfo<List> COMPUTEENVIRONMENTORDER_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("computeEnvironmentOrder").isBinary(false).build();
    private static final UpdateJobQueueRequestModelMarshaller INSTANCE = new UpdateJobQueueRequestModelMarshaller();

    private UpdateJobQueueRequestModelMarshaller() {
    }

    public static UpdateJobQueueRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(UpdateJobQueueRequest updateJobQueueRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)updateJobQueueRequest), (String)"updateJobQueueRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)updateJobQueueRequest.jobQueue(), JOBQUEUE_BINDING);
            protocolMarshaller.marshall((Object)updateJobQueueRequest.stateAsString(), STATE_BINDING);
            protocolMarshaller.marshall((Object)updateJobQueueRequest.priority(), PRIORITY_BINDING);
            protocolMarshaller.marshall(updateJobQueueRequest.computeEnvironmentOrder(), COMPUTEENVIRONMENTORDER_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

