/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.batch.model.ListJobsRequest;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ListJobsRequestModelMarshaller {
    private static final MarshallingInfo<String> JOBQUEUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("jobQueue").isBinary(false).build();
    private static final MarshallingInfo<String> JOBSTATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("jobStatus").isBinary(false).build();
    private static final MarshallingInfo<Integer> MAXRESULTS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INTEGER).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("maxResults").isBinary(false).build();
    private static final MarshallingInfo<String> NEXTTOKEN_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("nextToken").isBinary(false).build();
    private static final ListJobsRequestModelMarshaller INSTANCE = new ListJobsRequestModelMarshaller();

    private ListJobsRequestModelMarshaller() {
    }

    public static ListJobsRequestModelMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ListJobsRequest listJobsRequest, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)((Object)listJobsRequest), (String)"listJobsRequest");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)listJobsRequest.jobQueue(), JOBQUEUE_BINDING);
            protocolMarshaller.marshall((Object)listJobsRequest.jobStatusAsString(), JOBSTATUS_BINDING);
            protocolMarshaller.marshall((Object)listJobsRequest.maxResults(), MAXRESULTS_BINDING);
            protocolMarshaller.marshall((Object)listJobsRequest.nextToken(), NEXTTOKEN_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

