/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.batch.model.KeyValuePair;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class KeyValuePairMarshaller {
    private static final MarshallingInfo<String> NAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("name").isBinary(false).build();
    private static final MarshallingInfo<String> VALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("value").isBinary(false).build();
    private static final KeyValuePairMarshaller INSTANCE = new KeyValuePairMarshaller();

    private KeyValuePairMarshaller() {
    }

    public static KeyValuePairMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(KeyValuePair keyValuePair, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)keyValuePair, (String)"keyValuePair");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)keyValuePair.name(), NAME_BINDING);
            protocolMarshaller.marshall((Object)keyValuePair.value(), VALUE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

