/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.batch.transform.UlimitMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class Ulimit
implements StructuredPojo,
ToCopyableBuilder<Builder, Ulimit> {
    private final Integer hardLimit;
    private final String name;
    private final Integer softLimit;

    private Ulimit(BuilderImpl builder) {
        this.hardLimit = builder.hardLimit;
        this.name = builder.name;
        this.softLimit = builder.softLimit;
    }

    public Integer hardLimit() {
        return this.hardLimit;
    }

    public String name() {
        return this.name;
    }

    public Integer softLimit() {
        return this.softLimit;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hardLimit());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.softLimit());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Ulimit)) {
            return false;
        }
        Ulimit other = (Ulimit)obj;
        return Objects.equals(this.hardLimit(), other.hardLimit()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.softLimit(), other.softLimit());
    }

    public String toString() {
        return ToString.builder((String)"Ulimit").add("HardLimit", (Object)this.hardLimit()).add("Name", (Object)this.name()).add("SoftLimit", (Object)this.softLimit()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "hardLimit": {
                return Optional.of(clazz.cast(this.hardLimit()));
            }
            case "name": {
                return Optional.of(clazz.cast(this.name()));
            }
            case "softLimit": {
                return Optional.of(clazz.cast(this.softLimit()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        UlimitMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer hardLimit;
        private String name;
        private Integer softLimit;

        private BuilderImpl() {
        }

        private BuilderImpl(Ulimit model) {
            this.hardLimit(model.hardLimit);
            this.name(model.name);
            this.softLimit(model.softLimit);
        }

        public final Integer getHardLimit() {
            return this.hardLimit;
        }

        @Override
        public final Builder hardLimit(Integer hardLimit) {
            this.hardLimit = hardLimit;
            return this;
        }

        public final void setHardLimit(Integer hardLimit) {
            this.hardLimit = hardLimit;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final Integer getSoftLimit() {
            return this.softLimit;
        }

        @Override
        public final Builder softLimit(Integer softLimit) {
            this.softLimit = softLimit;
            return this;
        }

        public final void setSoftLimit(Integer softLimit) {
            this.softLimit = softLimit;
        }

        public Ulimit build() {
            return new Ulimit(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, Ulimit> {
        public Builder hardLimit(Integer var1);

        public Builder name(String var1);

        public Builder softLimit(Integer var1);
    }
}

