/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.batch.model.BatchRequest;
import software.amazon.awssdk.services.batch.model.StringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class DescribeJobQueuesRequest
extends BatchRequest
implements ToCopyableBuilder<Builder, DescribeJobQueuesRequest> {
    private final List<String> jobQueues;
    private final Integer maxResults;
    private final String nextToken;

    private DescribeJobQueuesRequest(BuilderImpl builder) {
        super(builder);
        this.jobQueues = builder.jobQueues;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public List<String> jobQueues() {
        return this.jobQueues;
    }

    public Integer maxResults() {
        return this.maxResults;
    }

    public String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jobQueues());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeJobQueuesRequest)) {
            return false;
        }
        DescribeJobQueuesRequest other = (DescribeJobQueuesRequest)((Object)obj);
        return Objects.equals(this.jobQueues(), other.jobQueues()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"DescribeJobQueuesRequest").add("JobQueues", this.jobQueues()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "jobQueues": {
                return Optional.of(clazz.cast(this.jobQueues()));
            }
            case "maxResults": {
                return Optional.of(clazz.cast(this.maxResults()));
            }
            case "nextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends BatchRequest.BuilderImpl
    implements Builder {
        private List<String> jobQueues;
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeJobQueuesRequest model) {
            super(model);
            this.jobQueues(model.jobQueues);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getJobQueues() {
            return this.jobQueues;
        }

        @Override
        public final Builder jobQueues(Collection<String> jobQueues) {
            this.jobQueues = StringListCopier.copy(jobQueues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobQueues(String ... jobQueues) {
            this.jobQueues(Arrays.asList(jobQueues));
            return this;
        }

        public final void setJobQueues(Collection<String> jobQueues) {
            this.jobQueues = StringListCopier.copy(jobQueues);
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public DescribeJobQueuesRequest build() {
            return new DescribeJobQueuesRequest(this);
        }
    }

    public static interface Builder
    extends BatchRequest.Builder,
    CopyableBuilder<Builder, DescribeJobQueuesRequest> {
        public Builder jobQueues(Collection<String> var1);

        public Builder jobQueues(String ... var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

