/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.batch.model.BatchRequest;
import software.amazon.awssdk.services.batch.model.CEState;
import software.amazon.awssdk.services.batch.model.CEType;
import software.amazon.awssdk.services.batch.model.ComputeResource;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateComputeEnvironmentRequest
extends BatchRequest
implements ToCopyableBuilder<Builder, CreateComputeEnvironmentRequest> {
    private final String computeEnvironmentName;
    private final String type;
    private final String state;
    private final ComputeResource computeResources;
    private final String serviceRole;

    private CreateComputeEnvironmentRequest(BuilderImpl builder) {
        super(builder);
        this.computeEnvironmentName = builder.computeEnvironmentName;
        this.type = builder.type;
        this.state = builder.state;
        this.computeResources = builder.computeResources;
        this.serviceRole = builder.serviceRole;
    }

    public String computeEnvironmentName() {
        return this.computeEnvironmentName;
    }

    public CEType type() {
        return CEType.fromValue(this.type);
    }

    public String typeAsString() {
        return this.type;
    }

    public CEState state() {
        return CEState.fromValue(this.state);
    }

    public String stateAsString() {
        return this.state;
    }

    public ComputeResource computeResources() {
        return this.computeResources;
    }

    public String serviceRole() {
        return this.serviceRole;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.computeEnvironmentName());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.computeResources());
        hashCode = 31 * hashCode + Objects.hashCode(this.serviceRole());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateComputeEnvironmentRequest)) {
            return false;
        }
        CreateComputeEnvironmentRequest other = (CreateComputeEnvironmentRequest)((Object)obj);
        return Objects.equals(this.computeEnvironmentName(), other.computeEnvironmentName()) && Objects.equals(this.typeAsString(), other.typeAsString()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.computeResources(), other.computeResources()) && Objects.equals(this.serviceRole(), other.serviceRole());
    }

    public String toString() {
        return ToString.builder((String)"CreateComputeEnvironmentRequest").add("ComputeEnvironmentName", (Object)this.computeEnvironmentName()).add("Type", (Object)this.typeAsString()).add("State", (Object)this.stateAsString()).add("ComputeResources", (Object)this.computeResources()).add("ServiceRole", (Object)this.serviceRole()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "computeEnvironmentName": {
                return Optional.of(clazz.cast(this.computeEnvironmentName()));
            }
            case "type": {
                return Optional.of(clazz.cast(this.typeAsString()));
            }
            case "state": {
                return Optional.of(clazz.cast(this.stateAsString()));
            }
            case "computeResources": {
                return Optional.of(clazz.cast(this.computeResources()));
            }
            case "serviceRole": {
                return Optional.of(clazz.cast(this.serviceRole()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends BatchRequest.BuilderImpl
    implements Builder {
        private String computeEnvironmentName;
        private String type;
        private String state;
        private ComputeResource computeResources;
        private String serviceRole;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateComputeEnvironmentRequest model) {
            super(model);
            this.computeEnvironmentName(model.computeEnvironmentName);
            this.type(model.type);
            this.state(model.state);
            this.computeResources(model.computeResources);
            this.serviceRole(model.serviceRole);
        }

        public final String getComputeEnvironmentName() {
            return this.computeEnvironmentName;
        }

        @Override
        public final Builder computeEnvironmentName(String computeEnvironmentName) {
            this.computeEnvironmentName = computeEnvironmentName;
            return this;
        }

        public final void setComputeEnvironmentName(String computeEnvironmentName) {
            this.computeEnvironmentName = computeEnvironmentName;
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(CEType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final String getState() {
            return this.state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(CEState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final ComputeResource.Builder getComputeResources() {
            return this.computeResources != null ? this.computeResources.toBuilder() : null;
        }

        @Override
        public final Builder computeResources(ComputeResource computeResources) {
            this.computeResources = computeResources;
            return this;
        }

        public final void setComputeResources(ComputeResource.BuilderImpl computeResources) {
            this.computeResources = computeResources != null ? computeResources.build() : null;
        }

        public final String getServiceRole() {
            return this.serviceRole;
        }

        @Override
        public final Builder serviceRole(String serviceRole) {
            this.serviceRole = serviceRole;
            return this;
        }

        public final void setServiceRole(String serviceRole) {
            this.serviceRole = serviceRole;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateComputeEnvironmentRequest build() {
            return new CreateComputeEnvironmentRequest(this);
        }
    }

    public static interface Builder
    extends BatchRequest.Builder,
    CopyableBuilder<Builder, CreateComputeEnvironmentRequest> {
        public Builder computeEnvironmentName(String var1);

        public Builder type(String var1);

        public Builder type(CEType var1);

        public Builder state(String var1);

        public Builder state(CEState var1);

        public Builder computeResources(ComputeResource var1);

        default public Builder computeResources(Consumer<ComputeResource.Builder> computeResources) {
            return this.computeResources((ComputeResource)((ComputeResource.Builder)ComputeResource.builder().apply(computeResources)).build());
        }

        public Builder serviceRole(String var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

