/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.batch.model.CRType;
import software.amazon.awssdk.services.batch.model.StringListCopier;
import software.amazon.awssdk.services.batch.model.TagsMapCopier;
import software.amazon.awssdk.services.batch.transform.ComputeResourceMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ComputeResource
implements StructuredPojo,
ToCopyableBuilder<Builder, ComputeResource> {
    private final String type;
    private final Integer minvCpus;
    private final Integer maxvCpus;
    private final Integer desiredvCpus;
    private final List<String> instanceTypes;
    private final String imageId;
    private final List<String> subnets;
    private final List<String> securityGroupIds;
    private final String ec2KeyPair;
    private final String instanceRole;
    private final Map<String, String> tags;
    private final Integer bidPercentage;
    private final String spotIamFleetRole;

    private ComputeResource(BuilderImpl builder) {
        this.type = builder.type;
        this.minvCpus = builder.minvCpus;
        this.maxvCpus = builder.maxvCpus;
        this.desiredvCpus = builder.desiredvCpus;
        this.instanceTypes = builder.instanceTypes;
        this.imageId = builder.imageId;
        this.subnets = builder.subnets;
        this.securityGroupIds = builder.securityGroupIds;
        this.ec2KeyPair = builder.ec2KeyPair;
        this.instanceRole = builder.instanceRole;
        this.tags = builder.tags;
        this.bidPercentage = builder.bidPercentage;
        this.spotIamFleetRole = builder.spotIamFleetRole;
    }

    public String type() {
        return this.type;
    }

    public Integer minvCpus() {
        return this.minvCpus;
    }

    public Integer maxvCpus() {
        return this.maxvCpus;
    }

    public Integer desiredvCpus() {
        return this.desiredvCpus;
    }

    public List<String> instanceTypes() {
        return this.instanceTypes;
    }

    public String imageId() {
        return this.imageId;
    }

    public List<String> subnets() {
        return this.subnets;
    }

    public List<String> securityGroupIds() {
        return this.securityGroupIds;
    }

    public String ec2KeyPair() {
        return this.ec2KeyPair;
    }

    public String instanceRole() {
        return this.instanceRole;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public Integer bidPercentage() {
        return this.bidPercentage;
    }

    public String spotIamFleetRole() {
        return this.spotIamFleetRole;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.type() == null ? 0 : this.type().hashCode());
        hashCode = 31 * hashCode + (this.minvCpus() == null ? 0 : this.minvCpus().hashCode());
        hashCode = 31 * hashCode + (this.maxvCpus() == null ? 0 : this.maxvCpus().hashCode());
        hashCode = 31 * hashCode + (this.desiredvCpus() == null ? 0 : this.desiredvCpus().hashCode());
        hashCode = 31 * hashCode + (this.instanceTypes() == null ? 0 : this.instanceTypes().hashCode());
        hashCode = 31 * hashCode + (this.imageId() == null ? 0 : this.imageId().hashCode());
        hashCode = 31 * hashCode + (this.subnets() == null ? 0 : this.subnets().hashCode());
        hashCode = 31 * hashCode + (this.securityGroupIds() == null ? 0 : this.securityGroupIds().hashCode());
        hashCode = 31 * hashCode + (this.ec2KeyPair() == null ? 0 : this.ec2KeyPair().hashCode());
        hashCode = 31 * hashCode + (this.instanceRole() == null ? 0 : this.instanceRole().hashCode());
        hashCode = 31 * hashCode + (this.tags() == null ? 0 : this.tags().hashCode());
        hashCode = 31 * hashCode + (this.bidPercentage() == null ? 0 : this.bidPercentage().hashCode());
        hashCode = 31 * hashCode + (this.spotIamFleetRole() == null ? 0 : this.spotIamFleetRole().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComputeResource)) {
            return false;
        }
        ComputeResource other = (ComputeResource)obj;
        if (other.type() == null ^ this.type() == null) {
            return false;
        }
        if (other.type() != null && !other.type().equals(this.type())) {
            return false;
        }
        if (other.minvCpus() == null ^ this.minvCpus() == null) {
            return false;
        }
        if (other.minvCpus() != null && !other.minvCpus().equals(this.minvCpus())) {
            return false;
        }
        if (other.maxvCpus() == null ^ this.maxvCpus() == null) {
            return false;
        }
        if (other.maxvCpus() != null && !other.maxvCpus().equals(this.maxvCpus())) {
            return false;
        }
        if (other.desiredvCpus() == null ^ this.desiredvCpus() == null) {
            return false;
        }
        if (other.desiredvCpus() != null && !other.desiredvCpus().equals(this.desiredvCpus())) {
            return false;
        }
        if (other.instanceTypes() == null ^ this.instanceTypes() == null) {
            return false;
        }
        if (other.instanceTypes() != null && !other.instanceTypes().equals(this.instanceTypes())) {
            return false;
        }
        if (other.imageId() == null ^ this.imageId() == null) {
            return false;
        }
        if (other.imageId() != null && !other.imageId().equals(this.imageId())) {
            return false;
        }
        if (other.subnets() == null ^ this.subnets() == null) {
            return false;
        }
        if (other.subnets() != null && !other.subnets().equals(this.subnets())) {
            return false;
        }
        if (other.securityGroupIds() == null ^ this.securityGroupIds() == null) {
            return false;
        }
        if (other.securityGroupIds() != null && !other.securityGroupIds().equals(this.securityGroupIds())) {
            return false;
        }
        if (other.ec2KeyPair() == null ^ this.ec2KeyPair() == null) {
            return false;
        }
        if (other.ec2KeyPair() != null && !other.ec2KeyPair().equals(this.ec2KeyPair())) {
            return false;
        }
        if (other.instanceRole() == null ^ this.instanceRole() == null) {
            return false;
        }
        if (other.instanceRole() != null && !other.instanceRole().equals(this.instanceRole())) {
            return false;
        }
        if (other.tags() == null ^ this.tags() == null) {
            return false;
        }
        if (other.tags() != null && !other.tags().equals(this.tags())) {
            return false;
        }
        if (other.bidPercentage() == null ^ this.bidPercentage() == null) {
            return false;
        }
        if (other.bidPercentage() != null && !other.bidPercentage().equals(this.bidPercentage())) {
            return false;
        }
        if (other.spotIamFleetRole() == null ^ this.spotIamFleetRole() == null) {
            return false;
        }
        return other.spotIamFleetRole() == null || other.spotIamFleetRole().equals(this.spotIamFleetRole());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.type() != null) {
            sb.append("Type: ").append(this.type()).append(",");
        }
        if (this.minvCpus() != null) {
            sb.append("MinvCpus: ").append(this.minvCpus()).append(",");
        }
        if (this.maxvCpus() != null) {
            sb.append("MaxvCpus: ").append(this.maxvCpus()).append(",");
        }
        if (this.desiredvCpus() != null) {
            sb.append("DesiredvCpus: ").append(this.desiredvCpus()).append(",");
        }
        if (this.instanceTypes() != null) {
            sb.append("InstanceTypes: ").append(this.instanceTypes()).append(",");
        }
        if (this.imageId() != null) {
            sb.append("ImageId: ").append(this.imageId()).append(",");
        }
        if (this.subnets() != null) {
            sb.append("Subnets: ").append(this.subnets()).append(",");
        }
        if (this.securityGroupIds() != null) {
            sb.append("SecurityGroupIds: ").append(this.securityGroupIds()).append(",");
        }
        if (this.ec2KeyPair() != null) {
            sb.append("Ec2KeyPair: ").append(this.ec2KeyPair()).append(",");
        }
        if (this.instanceRole() != null) {
            sb.append("InstanceRole: ").append(this.instanceRole()).append(",");
        }
        if (this.tags() != null) {
            sb.append("Tags: ").append(this.tags()).append(",");
        }
        if (this.bidPercentage() != null) {
            sb.append("BidPercentage: ").append(this.bidPercentage()).append(",");
        }
        if (this.spotIamFleetRole() != null) {
            sb.append("SpotIamFleetRole: ").append(this.spotIamFleetRole()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ComputeResourceMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private String type;
        private Integer minvCpus;
        private Integer maxvCpus;
        private Integer desiredvCpus;
        private List<String> instanceTypes;
        private String imageId;
        private List<String> subnets;
        private List<String> securityGroupIds;
        private String ec2KeyPair;
        private String instanceRole;
        private Map<String, String> tags;
        private Integer bidPercentage;
        private String spotIamFleetRole;

        private BuilderImpl() {
        }

        private BuilderImpl(ComputeResource model) {
            this.setType(model.type);
            this.setMinvCpus(model.minvCpus);
            this.setMaxvCpus(model.maxvCpus);
            this.setDesiredvCpus(model.desiredvCpus);
            this.setInstanceTypes(model.instanceTypes);
            this.setImageId(model.imageId);
            this.setSubnets(model.subnets);
            this.setSecurityGroupIds(model.securityGroupIds);
            this.setEc2KeyPair(model.ec2KeyPair);
            this.setInstanceRole(model.instanceRole);
            this.setTags(model.tags);
            this.setBidPercentage(model.bidPercentage);
            this.setSpotIamFleetRole(model.spotIamFleetRole);
        }

        public final String getType() {
            return this.type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(CRType type) {
            this.type(type.toString());
            return this;
        }

        public final void setType(String type) {
            this.type = type;
        }

        public final void setType(CRType type) {
            this.type(type.toString());
        }

        public final Integer getMinvCpus() {
            return this.minvCpus;
        }

        @Override
        public final Builder minvCpus(Integer minvCpus) {
            this.minvCpus = minvCpus;
            return this;
        }

        public final void setMinvCpus(Integer minvCpus) {
            this.minvCpus = minvCpus;
        }

        public final Integer getMaxvCpus() {
            return this.maxvCpus;
        }

        @Override
        public final Builder maxvCpus(Integer maxvCpus) {
            this.maxvCpus = maxvCpus;
            return this;
        }

        public final void setMaxvCpus(Integer maxvCpus) {
            this.maxvCpus = maxvCpus;
        }

        public final Integer getDesiredvCpus() {
            return this.desiredvCpus;
        }

        @Override
        public final Builder desiredvCpus(Integer desiredvCpus) {
            this.desiredvCpus = desiredvCpus;
            return this;
        }

        public final void setDesiredvCpus(Integer desiredvCpus) {
            this.desiredvCpus = desiredvCpus;
        }

        public final Collection<String> getInstanceTypes() {
            return this.instanceTypes;
        }

        @Override
        public final Builder instanceTypes(Collection<String> instanceTypes) {
            this.instanceTypes = StringListCopier.copy(instanceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder instanceTypes(String ... instanceTypes) {
            if (this.instanceTypes == null) {
                this.instanceTypes = new ArrayList<String>(instanceTypes.length);
            }
            for (String e : instanceTypes) {
                this.instanceTypes.add(e);
            }
            return this;
        }

        public final void setInstanceTypes(Collection<String> instanceTypes) {
            this.instanceTypes = StringListCopier.copy(instanceTypes);
        }

        @SafeVarargs
        public final void setInstanceTypes(String ... instanceTypes) {
            if (this.instanceTypes == null) {
                this.instanceTypes = new ArrayList<String>(instanceTypes.length);
            }
            for (String e : instanceTypes) {
                this.instanceTypes.add(e);
            }
        }

        public final String getImageId() {
            return this.imageId;
        }

        @Override
        public final Builder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public final void setImageId(String imageId) {
            this.imageId = imageId;
        }

        public final Collection<String> getSubnets() {
            return this.subnets;
        }

        @Override
        public final Builder subnets(Collection<String> subnets) {
            this.subnets = StringListCopier.copy(subnets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnets(String ... subnets) {
            if (this.subnets == null) {
                this.subnets = new ArrayList<String>(subnets.length);
            }
            for (String e : subnets) {
                this.subnets.add(e);
            }
            return this;
        }

        public final void setSubnets(Collection<String> subnets) {
            this.subnets = StringListCopier.copy(subnets);
        }

        @SafeVarargs
        public final void setSubnets(String ... subnets) {
            if (this.subnets == null) {
                this.subnets = new ArrayList<String>(subnets.length);
            }
            for (String e : subnets) {
                this.subnets.add(e);
            }
        }

        public final Collection<String> getSecurityGroupIds() {
            return this.securityGroupIds;
        }

        @Override
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = StringListCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroupIds(String ... securityGroupIds) {
            if (this.securityGroupIds == null) {
                this.securityGroupIds = new ArrayList<String>(securityGroupIds.length);
            }
            for (String e : securityGroupIds) {
                this.securityGroupIds.add(e);
            }
            return this;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = StringListCopier.copy(securityGroupIds);
        }

        @SafeVarargs
        public final void setSecurityGroupIds(String ... securityGroupIds) {
            if (this.securityGroupIds == null) {
                this.securityGroupIds = new ArrayList<String>(securityGroupIds.length);
            }
            for (String e : securityGroupIds) {
                this.securityGroupIds.add(e);
            }
        }

        public final String getEc2KeyPair() {
            return this.ec2KeyPair;
        }

        @Override
        public final Builder ec2KeyPair(String ec2KeyPair) {
            this.ec2KeyPair = ec2KeyPair;
            return this;
        }

        public final void setEc2KeyPair(String ec2KeyPair) {
            this.ec2KeyPair = ec2KeyPair;
        }

        public final String getInstanceRole() {
            return this.instanceRole;
        }

        @Override
        public final Builder instanceRole(String instanceRole) {
            this.instanceRole = instanceRole;
            return this;
        }

        public final void setInstanceRole(String instanceRole) {
            this.instanceRole = instanceRole;
        }

        public final Map<String, String> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        public final Integer getBidPercentage() {
            return this.bidPercentage;
        }

        @Override
        public final Builder bidPercentage(Integer bidPercentage) {
            this.bidPercentage = bidPercentage;
            return this;
        }

        public final void setBidPercentage(Integer bidPercentage) {
            this.bidPercentage = bidPercentage;
        }

        public final String getSpotIamFleetRole() {
            return this.spotIamFleetRole;
        }

        @Override
        public final Builder spotIamFleetRole(String spotIamFleetRole) {
            this.spotIamFleetRole = spotIamFleetRole;
            return this;
        }

        public final void setSpotIamFleetRole(String spotIamFleetRole) {
            this.spotIamFleetRole = spotIamFleetRole;
        }

        public ComputeResource build() {
            return new ComputeResource(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ComputeResource> {
        public Builder type(String var1);

        public Builder type(CRType var1);

        public Builder minvCpus(Integer var1);

        public Builder maxvCpus(Integer var1);

        public Builder desiredvCpus(Integer var1);

        public Builder instanceTypes(Collection<String> var1);

        public Builder instanceTypes(String ... var1);

        public Builder imageId(String var1);

        public Builder subnets(Collection<String> var1);

        public Builder subnets(String ... var1);

        public Builder securityGroupIds(Collection<String> var1);

        public Builder securityGroupIds(String ... var1);

        public Builder ec2KeyPair(String var1);

        public Builder instanceRole(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder bidPercentage(Integer var1);

        public Builder spotIamFleetRole(String var1);
    }
}

