/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.batch.model;

import software.amazon.awssdk.annotation.SdkInternalApi;
import software.amazon.awssdk.protocol.ProtocolMarshaller;
import software.amazon.awssdk.protocol.StructuredPojo;
import software.amazon.awssdk.services.batch.transform.ComputeEnvironmentOrderMarshaller;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ComputeEnvironmentOrder
implements StructuredPojo,
ToCopyableBuilder<Builder, ComputeEnvironmentOrder> {
    private final Integer order;
    private final String computeEnvironment;

    private ComputeEnvironmentOrder(BuilderImpl builder) {
        this.order = builder.order;
        this.computeEnvironment = builder.computeEnvironment;
    }

    public Integer order() {
        return this.order;
    }

    public String computeEnvironment() {
        return this.computeEnvironment;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.order() == null ? 0 : this.order().hashCode());
        hashCode = 31 * hashCode + (this.computeEnvironment() == null ? 0 : this.computeEnvironment().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComputeEnvironmentOrder)) {
            return false;
        }
        ComputeEnvironmentOrder other = (ComputeEnvironmentOrder)obj;
        if (other.order() == null ^ this.order() == null) {
            return false;
        }
        if (other.order() != null && !other.order().equals(this.order())) {
            return false;
        }
        if (other.computeEnvironment() == null ^ this.computeEnvironment() == null) {
            return false;
        }
        return other.computeEnvironment() == null || other.computeEnvironment().equals(this.computeEnvironment());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.order() != null) {
            sb.append("Order: ").append(this.order()).append(",");
        }
        if (this.computeEnvironment() != null) {
            sb.append("ComputeEnvironment: ").append(this.computeEnvironment()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ComputeEnvironmentOrderMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    private static final class BuilderImpl
    implements Builder {
        private Integer order;
        private String computeEnvironment;

        private BuilderImpl() {
        }

        private BuilderImpl(ComputeEnvironmentOrder model) {
            this.setOrder(model.order);
            this.setComputeEnvironment(model.computeEnvironment);
        }

        public final Integer getOrder() {
            return this.order;
        }

        @Override
        public final Builder order(Integer order) {
            this.order = order;
            return this;
        }

        public final void setOrder(Integer order) {
            this.order = order;
        }

        public final String getComputeEnvironment() {
            return this.computeEnvironment;
        }

        @Override
        public final Builder computeEnvironment(String computeEnvironment) {
            this.computeEnvironment = computeEnvironment;
            return this;
        }

        public final void setComputeEnvironment(String computeEnvironment) {
            this.computeEnvironment = computeEnvironment;
        }

        public ComputeEnvironmentOrder build() {
            return new ComputeEnvironmentOrder(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ComputeEnvironmentOrder> {
        public Builder order(Integer var1);

        public Builder computeEnvironment(String var1);
    }
}

