/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backupstorage.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.backupstorage.model.BackupStorageResponse;
import software.amazon.awssdk.services.backupstorage.model.Chunk;
import software.amazon.awssdk.services.backupstorage.model.ChunkListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListChunksResponse
extends BackupStorageResponse
implements ToCopyableBuilder<Builder, ListChunksResponse> {
    private static final SdkField<List<Chunk>> CHUNK_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ChunkList").getter(ListChunksResponse.getter(ListChunksResponse::chunkList)).setter(ListChunksResponse.setter(Builder::chunkList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChunkList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Chunk::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListChunksResponse.getter(ListChunksResponse::nextToken)).setter(ListChunksResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHUNK_LIST_FIELD, NEXT_TOKEN_FIELD));
    private final List<Chunk> chunkList;
    private final String nextToken;

    private ListChunksResponse(BuilderImpl builder) {
        super(builder);
        this.chunkList = builder.chunkList;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasChunkList() {
        return this.chunkList != null && !(this.chunkList instanceof SdkAutoConstructList);
    }

    public final List<Chunk> chunkList() {
        return this.chunkList;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasChunkList() ? this.chunkList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListChunksResponse)) {
            return false;
        }
        ListChunksResponse other = (ListChunksResponse)((Object)obj);
        return this.hasChunkList() == other.hasChunkList() && Objects.equals(this.chunkList(), other.chunkList()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListChunksResponse").add("ChunkList", this.hasChunkList() ? this.chunkList() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ChunkList": {
                return Optional.ofNullable(clazz.cast(this.chunkList()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListChunksResponse, T> g) {
        return obj -> g.apply((ListChunksResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BackupStorageResponse.BuilderImpl
    implements Builder {
        private List<Chunk> chunkList = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListChunksResponse model) {
            super(model);
            this.chunkList(model.chunkList);
            this.nextToken(model.nextToken);
        }

        public final List<Chunk.Builder> getChunkList() {
            List<Chunk.Builder> result = ChunkListCopier.copyToBuilder(this.chunkList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setChunkList(Collection<Chunk.BuilderImpl> chunkList) {
            this.chunkList = ChunkListCopier.copyFromBuilder(chunkList);
        }

        @Override
        public final Builder chunkList(Collection<Chunk> chunkList) {
            this.chunkList = ChunkListCopier.copy(chunkList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder chunkList(Chunk ... chunkList) {
            this.chunkList(Arrays.asList(chunkList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder chunkList(Consumer<Chunk.Builder> ... chunkList) {
            this.chunkList(Stream.of(chunkList).map(c -> (Chunk)((Chunk.Builder)Chunk.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListChunksResponse build() {
            return new ListChunksResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends BackupStorageResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListChunksResponse> {
        public Builder chunkList(Collection<Chunk> var1);

        public Builder chunkList(Chunk ... var1);

        public Builder chunkList(Consumer<Chunk.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

