/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backupstorage.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartObjectRequest extends BackupStorageRequest implements
        ToCopyableBuilder<StartObjectRequest.Builder, StartObjectRequest> {
    private static final SdkField<String> BACKUP_JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BackupJobId").getter(getter(StartObjectRequest::backupJobId)).setter(setter(Builder::backupJobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("jobId").build()).build();

    private static final SdkField<String> OBJECT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ObjectName").getter(getter(StartObjectRequest::objectName)).setter(setter(Builder::objectName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("objectName").build()).build();

    private static final SdkField<Boolean> THROW_ON_DUPLICATE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ThrowOnDuplicate").getter(getter(StartObjectRequest::throwOnDuplicate))
            .setter(setter(Builder::throwOnDuplicate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThrowOnDuplicate").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKUP_JOB_ID_FIELD,
            OBJECT_NAME_FIELD, THROW_ON_DUPLICATE_FIELD));

    private final String backupJobId;

    private final String objectName;

    private final Boolean throwOnDuplicate;

    private StartObjectRequest(BuilderImpl builder) {
        super(builder);
        this.backupJobId = builder.backupJobId;
        this.objectName = builder.objectName;
        this.throwOnDuplicate = builder.throwOnDuplicate;
    }

    /**
     * Backup job Id for the in-progress backup
     * 
     * @return Backup job Id for the in-progress backup
     */
    public final String backupJobId() {
        return backupJobId;
    }

    /**
     * Name for the object.
     * 
     * @return Name for the object.
     */
    public final String objectName() {
        return objectName;
    }

    /**
     * Throw an exception if Object name is already exist.
     * 
     * @return Throw an exception if Object name is already exist.
     */
    public final Boolean throwOnDuplicate() {
        return throwOnDuplicate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(backupJobId());
        hashCode = 31 * hashCode + Objects.hashCode(objectName());
        hashCode = 31 * hashCode + Objects.hashCode(throwOnDuplicate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartObjectRequest)) {
            return false;
        }
        StartObjectRequest other = (StartObjectRequest) obj;
        return Objects.equals(backupJobId(), other.backupJobId()) && Objects.equals(objectName(), other.objectName())
                && Objects.equals(throwOnDuplicate(), other.throwOnDuplicate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartObjectRequest").add("BackupJobId", backupJobId()).add("ObjectName", objectName())
                .add("ThrowOnDuplicate", throwOnDuplicate()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BackupJobId":
            return Optional.ofNullable(clazz.cast(backupJobId()));
        case "ObjectName":
            return Optional.ofNullable(clazz.cast(objectName()));
        case "ThrowOnDuplicate":
            return Optional.ofNullable(clazz.cast(throwOnDuplicate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartObjectRequest, T> g) {
        return obj -> g.apply((StartObjectRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BackupStorageRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartObjectRequest> {
        /**
         * Backup job Id for the in-progress backup
         * 
         * @param backupJobId
         *        Backup job Id for the in-progress backup
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupJobId(String backupJobId);

        /**
         * Name for the object.
         * 
         * @param objectName
         *        Name for the object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder objectName(String objectName);

        /**
         * Throw an exception if Object name is already exist.
         * 
         * @param throwOnDuplicate
         *        Throw an exception if Object name is already exist.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder throwOnDuplicate(Boolean throwOnDuplicate);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BackupStorageRequest.BuilderImpl implements Builder {
        private String backupJobId;

        private String objectName;

        private Boolean throwOnDuplicate;

        private BuilderImpl() {
        }

        private BuilderImpl(StartObjectRequest model) {
            super(model);
            backupJobId(model.backupJobId);
            objectName(model.objectName);
            throwOnDuplicate(model.throwOnDuplicate);
        }

        public final String getBackupJobId() {
            return backupJobId;
        }

        public final void setBackupJobId(String backupJobId) {
            this.backupJobId = backupJobId;
        }

        @Override
        public final Builder backupJobId(String backupJobId) {
            this.backupJobId = backupJobId;
            return this;
        }

        public final String getObjectName() {
            return objectName;
        }

        public final void setObjectName(String objectName) {
            this.objectName = objectName;
        }

        @Override
        public final Builder objectName(String objectName) {
            this.objectName = objectName;
            return this;
        }

        public final Boolean getThrowOnDuplicate() {
            return throwOnDuplicate;
        }

        public final void setThrowOnDuplicate(Boolean throwOnDuplicate) {
            this.throwOnDuplicate = throwOnDuplicate;
        }

        @Override
        public final Builder throwOnDuplicate(Boolean throwOnDuplicate) {
            this.throwOnDuplicate = throwOnDuplicate;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartObjectRequest build() {
            return new StartObjectRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
