/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backupstorage.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutObjectRequest extends BackupStorageRequest implements
        ToCopyableBuilder<PutObjectRequest.Builder, PutObjectRequest> {
    private static final SdkField<String> BACKUP_JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BackupJobId").getter(getter(PutObjectRequest::backupJobId)).setter(setter(Builder::backupJobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("jobId").build()).build();

    private static final SdkField<String> OBJECT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ObjectName").getter(getter(PutObjectRequest::objectName)).setter(setter(Builder::objectName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("objectName").build()).build();

    private static final SdkField<String> METADATA_STRING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MetadataString").getter(getter(PutObjectRequest::metadataString))
            .setter(setter(Builder::metadataString))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("metadata-string").build())
            .build();

    private static final SdkField<Long> INLINE_CHUNK_LENGTH_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("InlineChunkLength").getter(getter(PutObjectRequest::inlineChunkLength))
            .setter(setter(Builder::inlineChunkLength))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("length").build()).build();

    private static final SdkField<String> INLINE_CHUNK_CHECKSUM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InlineChunkChecksum").getter(getter(PutObjectRequest::inlineChunkChecksum))
            .setter(setter(Builder::inlineChunkChecksum))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("checksum").build()).build();

    private static final SdkField<String> INLINE_CHUNK_CHECKSUM_ALGORITHM_FIELD = SdkField
            .<String> builder(MarshallingType.STRING).memberName("InlineChunkChecksumAlgorithm")
            .getter(getter(PutObjectRequest::inlineChunkChecksumAlgorithm)).setter(setter(Builder::inlineChunkChecksumAlgorithm))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("checksum-algorithm").build())
            .build();

    private static final SdkField<String> OBJECT_CHECKSUM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ObjectChecksum").getter(getter(PutObjectRequest::objectChecksum))
            .setter(setter(Builder::objectChecksum))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("object-checksum").build())
            .build();

    private static final SdkField<String> OBJECT_CHECKSUM_ALGORITHM_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("ObjectChecksumAlgorithm")
            .getter(getter(PutObjectRequest::objectChecksumAlgorithmAsString))
            .setter(setter(Builder::objectChecksumAlgorithm))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("object-checksum-algorithm")
                    .build()).build();

    private static final SdkField<Boolean> THROW_ON_DUPLICATE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("ThrowOnDuplicate").getter(getter(PutObjectRequest::throwOnDuplicate))
            .setter(setter(Builder::throwOnDuplicate))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("throwOnDuplicate").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKUP_JOB_ID_FIELD,
            OBJECT_NAME_FIELD, METADATA_STRING_FIELD, INLINE_CHUNK_LENGTH_FIELD, INLINE_CHUNK_CHECKSUM_FIELD,
            INLINE_CHUNK_CHECKSUM_ALGORITHM_FIELD, OBJECT_CHECKSUM_FIELD, OBJECT_CHECKSUM_ALGORITHM_FIELD,
            THROW_ON_DUPLICATE_FIELD));

    private final String backupJobId;

    private final String objectName;

    private final String metadataString;

    private final Long inlineChunkLength;

    private final String inlineChunkChecksum;

    private final String inlineChunkChecksumAlgorithm;

    private final String objectChecksum;

    private final String objectChecksumAlgorithm;

    private final Boolean throwOnDuplicate;

    private PutObjectRequest(BuilderImpl builder) {
        super(builder);
        this.backupJobId = builder.backupJobId;
        this.objectName = builder.objectName;
        this.metadataString = builder.metadataString;
        this.inlineChunkLength = builder.inlineChunkLength;
        this.inlineChunkChecksum = builder.inlineChunkChecksum;
        this.inlineChunkChecksumAlgorithm = builder.inlineChunkChecksumAlgorithm;
        this.objectChecksum = builder.objectChecksum;
        this.objectChecksumAlgorithm = builder.objectChecksumAlgorithm;
        this.throwOnDuplicate = builder.throwOnDuplicate;
    }

    /**
     * Backup job Id for the in-progress backup.
     * 
     * @return Backup job Id for the in-progress backup.
     */
    public final String backupJobId() {
        return backupJobId;
    }

    /**
     * The name of the Object to be uploaded.
     * 
     * @return The name of the Object to be uploaded.
     */
    public final String objectName() {
        return objectName;
    }

    /**
     * Store user defined metadata like backup checksum, disk ids, restore metadata etc.
     * 
     * @return Store user defined metadata like backup checksum, disk ids, restore metadata etc.
     */
    public final String metadataString() {
        return metadataString;
    }

    /**
     * Length of the inline chunk data.
     * 
     * @return Length of the inline chunk data.
     */
    public final Long inlineChunkLength() {
        return inlineChunkLength;
    }

    /**
     * Inline chunk checksum
     * 
     * @return Inline chunk checksum
     */
    public final String inlineChunkChecksum() {
        return inlineChunkChecksum;
    }

    /**
     * Inline chunk checksum algorithm
     * 
     * @return Inline chunk checksum algorithm
     */
    public final String inlineChunkChecksumAlgorithm() {
        return inlineChunkChecksumAlgorithm;
    }

    /**
     * object checksum
     * 
     * @return object checksum
     */
    public final String objectChecksum() {
        return objectChecksum;
    }

    /**
     * object checksum algorithm
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #objectChecksumAlgorithm} will return {@link SummaryChecksumAlgorithm#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #objectChecksumAlgorithmAsString}.
     * </p>
     * 
     * @return object checksum algorithm
     * @see SummaryChecksumAlgorithm
     */
    public final SummaryChecksumAlgorithm objectChecksumAlgorithm() {
        return SummaryChecksumAlgorithm.fromValue(objectChecksumAlgorithm);
    }

    /**
     * object checksum algorithm
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #objectChecksumAlgorithm} will return {@link SummaryChecksumAlgorithm#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #objectChecksumAlgorithmAsString}.
     * </p>
     * 
     * @return object checksum algorithm
     * @see SummaryChecksumAlgorithm
     */
    public final String objectChecksumAlgorithmAsString() {
        return objectChecksumAlgorithm;
    }

    /**
     * Throw an exception if Object name is already exist.
     * 
     * @return Throw an exception if Object name is already exist.
     */
    public final Boolean throwOnDuplicate() {
        return throwOnDuplicate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(backupJobId());
        hashCode = 31 * hashCode + Objects.hashCode(objectName());
        hashCode = 31 * hashCode + Objects.hashCode(metadataString());
        hashCode = 31 * hashCode + Objects.hashCode(inlineChunkLength());
        hashCode = 31 * hashCode + Objects.hashCode(inlineChunkChecksum());
        hashCode = 31 * hashCode + Objects.hashCode(inlineChunkChecksumAlgorithm());
        hashCode = 31 * hashCode + Objects.hashCode(objectChecksum());
        hashCode = 31 * hashCode + Objects.hashCode(objectChecksumAlgorithmAsString());
        hashCode = 31 * hashCode + Objects.hashCode(throwOnDuplicate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutObjectRequest)) {
            return false;
        }
        PutObjectRequest other = (PutObjectRequest) obj;
        return Objects.equals(backupJobId(), other.backupJobId()) && Objects.equals(objectName(), other.objectName())
                && Objects.equals(metadataString(), other.metadataString())
                && Objects.equals(inlineChunkLength(), other.inlineChunkLength())
                && Objects.equals(inlineChunkChecksum(), other.inlineChunkChecksum())
                && Objects.equals(inlineChunkChecksumAlgorithm(), other.inlineChunkChecksumAlgorithm())
                && Objects.equals(objectChecksum(), other.objectChecksum())
                && Objects.equals(objectChecksumAlgorithmAsString(), other.objectChecksumAlgorithmAsString())
                && Objects.equals(throwOnDuplicate(), other.throwOnDuplicate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutObjectRequest").add("BackupJobId", backupJobId()).add("ObjectName", objectName())
                .add("MetadataString", metadataString()).add("InlineChunkLength", inlineChunkLength())
                .add("InlineChunkChecksum", inlineChunkChecksum())
                .add("InlineChunkChecksumAlgorithm", inlineChunkChecksumAlgorithm()).add("ObjectChecksum", objectChecksum())
                .add("ObjectChecksumAlgorithm", objectChecksumAlgorithmAsString()).add("ThrowOnDuplicate", throwOnDuplicate())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BackupJobId":
            return Optional.ofNullable(clazz.cast(backupJobId()));
        case "ObjectName":
            return Optional.ofNullable(clazz.cast(objectName()));
        case "MetadataString":
            return Optional.ofNullable(clazz.cast(metadataString()));
        case "InlineChunkLength":
            return Optional.ofNullable(clazz.cast(inlineChunkLength()));
        case "InlineChunkChecksum":
            return Optional.ofNullable(clazz.cast(inlineChunkChecksum()));
        case "InlineChunkChecksumAlgorithm":
            return Optional.ofNullable(clazz.cast(inlineChunkChecksumAlgorithm()));
        case "ObjectChecksum":
            return Optional.ofNullable(clazz.cast(objectChecksum()));
        case "ObjectChecksumAlgorithm":
            return Optional.ofNullable(clazz.cast(objectChecksumAlgorithmAsString()));
        case "ThrowOnDuplicate":
            return Optional.ofNullable(clazz.cast(throwOnDuplicate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutObjectRequest, T> g) {
        return obj -> g.apply((PutObjectRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BackupStorageRequest.Builder, SdkPojo, CopyableBuilder<Builder, PutObjectRequest> {
        /**
         * Backup job Id for the in-progress backup.
         * 
         * @param backupJobId
         *        Backup job Id for the in-progress backup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupJobId(String backupJobId);

        /**
         * The name of the Object to be uploaded.
         * 
         * @param objectName
         *        The name of the Object to be uploaded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder objectName(String objectName);

        /**
         * Store user defined metadata like backup checksum, disk ids, restore metadata etc.
         * 
         * @param metadataString
         *        Store user defined metadata like backup checksum, disk ids, restore metadata etc.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadataString(String metadataString);

        /**
         * Length of the inline chunk data.
         * 
         * @param inlineChunkLength
         *        Length of the inline chunk data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inlineChunkLength(Long inlineChunkLength);

        /**
         * Inline chunk checksum
         * 
         * @param inlineChunkChecksum
         *        Inline chunk checksum
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inlineChunkChecksum(String inlineChunkChecksum);

        /**
         * Inline chunk checksum algorithm
         * 
         * @param inlineChunkChecksumAlgorithm
         *        Inline chunk checksum algorithm
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inlineChunkChecksumAlgorithm(String inlineChunkChecksumAlgorithm);

        /**
         * object checksum
         * 
         * @param objectChecksum
         *        object checksum
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder objectChecksum(String objectChecksum);

        /**
         * object checksum algorithm
         * 
         * @param objectChecksumAlgorithm
         *        object checksum algorithm
         * @see SummaryChecksumAlgorithm
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SummaryChecksumAlgorithm
         */
        Builder objectChecksumAlgorithm(String objectChecksumAlgorithm);

        /**
         * object checksum algorithm
         * 
         * @param objectChecksumAlgorithm
         *        object checksum algorithm
         * @see SummaryChecksumAlgorithm
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SummaryChecksumAlgorithm
         */
        Builder objectChecksumAlgorithm(SummaryChecksumAlgorithm objectChecksumAlgorithm);

        /**
         * Throw an exception if Object name is already exist.
         * 
         * @param throwOnDuplicate
         *        Throw an exception if Object name is already exist.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder throwOnDuplicate(Boolean throwOnDuplicate);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BackupStorageRequest.BuilderImpl implements Builder {
        private String backupJobId;

        private String objectName;

        private String metadataString;

        private Long inlineChunkLength;

        private String inlineChunkChecksum;

        private String inlineChunkChecksumAlgorithm;

        private String objectChecksum;

        private String objectChecksumAlgorithm;

        private Boolean throwOnDuplicate;

        private BuilderImpl() {
        }

        private BuilderImpl(PutObjectRequest model) {
            super(model);
            backupJobId(model.backupJobId);
            objectName(model.objectName);
            metadataString(model.metadataString);
            inlineChunkLength(model.inlineChunkLength);
            inlineChunkChecksum(model.inlineChunkChecksum);
            inlineChunkChecksumAlgorithm(model.inlineChunkChecksumAlgorithm);
            objectChecksum(model.objectChecksum);
            objectChecksumAlgorithm(model.objectChecksumAlgorithm);
            throwOnDuplicate(model.throwOnDuplicate);
        }

        public final String getBackupJobId() {
            return backupJobId;
        }

        public final void setBackupJobId(String backupJobId) {
            this.backupJobId = backupJobId;
        }

        @Override
        public final Builder backupJobId(String backupJobId) {
            this.backupJobId = backupJobId;
            return this;
        }

        public final String getObjectName() {
            return objectName;
        }

        public final void setObjectName(String objectName) {
            this.objectName = objectName;
        }

        @Override
        public final Builder objectName(String objectName) {
            this.objectName = objectName;
            return this;
        }

        public final String getMetadataString() {
            return metadataString;
        }

        public final void setMetadataString(String metadataString) {
            this.metadataString = metadataString;
        }

        @Override
        public final Builder metadataString(String metadataString) {
            this.metadataString = metadataString;
            return this;
        }

        public final Long getInlineChunkLength() {
            return inlineChunkLength;
        }

        public final void setInlineChunkLength(Long inlineChunkLength) {
            this.inlineChunkLength = inlineChunkLength;
        }

        @Override
        public final Builder inlineChunkLength(Long inlineChunkLength) {
            this.inlineChunkLength = inlineChunkLength;
            return this;
        }

        public final String getInlineChunkChecksum() {
            return inlineChunkChecksum;
        }

        public final void setInlineChunkChecksum(String inlineChunkChecksum) {
            this.inlineChunkChecksum = inlineChunkChecksum;
        }

        @Override
        public final Builder inlineChunkChecksum(String inlineChunkChecksum) {
            this.inlineChunkChecksum = inlineChunkChecksum;
            return this;
        }

        public final String getInlineChunkChecksumAlgorithm() {
            return inlineChunkChecksumAlgorithm;
        }

        public final void setInlineChunkChecksumAlgorithm(String inlineChunkChecksumAlgorithm) {
            this.inlineChunkChecksumAlgorithm = inlineChunkChecksumAlgorithm;
        }

        @Override
        public final Builder inlineChunkChecksumAlgorithm(String inlineChunkChecksumAlgorithm) {
            this.inlineChunkChecksumAlgorithm = inlineChunkChecksumAlgorithm;
            return this;
        }

        public final String getObjectChecksum() {
            return objectChecksum;
        }

        public final void setObjectChecksum(String objectChecksum) {
            this.objectChecksum = objectChecksum;
        }

        @Override
        public final Builder objectChecksum(String objectChecksum) {
            this.objectChecksum = objectChecksum;
            return this;
        }

        public final String getObjectChecksumAlgorithm() {
            return objectChecksumAlgorithm;
        }

        public final void setObjectChecksumAlgorithm(String objectChecksumAlgorithm) {
            this.objectChecksumAlgorithm = objectChecksumAlgorithm;
        }

        @Override
        public final Builder objectChecksumAlgorithm(String objectChecksumAlgorithm) {
            this.objectChecksumAlgorithm = objectChecksumAlgorithm;
            return this;
        }

        @Override
        public final Builder objectChecksumAlgorithm(SummaryChecksumAlgorithm objectChecksumAlgorithm) {
            this.objectChecksumAlgorithm(objectChecksumAlgorithm == null ? null : objectChecksumAlgorithm.toString());
            return this;
        }

        public final Boolean getThrowOnDuplicate() {
            return throwOnDuplicate;
        }

        public final void setThrowOnDuplicate(Boolean throwOnDuplicate) {
            this.throwOnDuplicate = throwOnDuplicate;
        }

        @Override
        public final Builder throwOnDuplicate(Boolean throwOnDuplicate) {
            this.throwOnDuplicate = throwOnDuplicate;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutObjectRequest build() {
            return new PutObjectRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
