/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backupstorage.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.backupstorage.model.BackupStorageRequest;
import software.amazon.awssdk.services.backupstorage.model.DataChecksumAlgorithm;
import software.amazon.awssdk.services.backupstorage.model.SummaryChecksumAlgorithm;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NotifyObjectCompleteRequest
extends BackupStorageRequest
implements ToCopyableBuilder<Builder, NotifyObjectCompleteRequest> {
    private static final SdkField<String> BACKUP_JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BackupJobId").getter(NotifyObjectCompleteRequest.getter(NotifyObjectCompleteRequest::backupJobId)).setter(NotifyObjectCompleteRequest.setter(Builder::backupJobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("jobId").build()}).build();
    private static final SdkField<String> UPLOAD_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("UploadId").getter(NotifyObjectCompleteRequest.getter(NotifyObjectCompleteRequest::uploadId)).setter(NotifyObjectCompleteRequest.setter(Builder::uploadId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("uploadId").build()}).build();
    private static final SdkField<String> OBJECT_CHECKSUM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ObjectChecksum").getter(NotifyObjectCompleteRequest.getter(NotifyObjectCompleteRequest::objectChecksum)).setter(NotifyObjectCompleteRequest.setter(Builder::objectChecksum)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("checksum").build()}).build();
    private static final SdkField<String> OBJECT_CHECKSUM_ALGORITHM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ObjectChecksumAlgorithm").getter(NotifyObjectCompleteRequest.getter(NotifyObjectCompleteRequest::objectChecksumAlgorithmAsString)).setter(NotifyObjectCompleteRequest.setter(Builder::objectChecksumAlgorithm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("checksum-algorithm").build()}).build();
    private static final SdkField<String> METADATA_STRING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MetadataString").getter(NotifyObjectCompleteRequest.getter(NotifyObjectCompleteRequest::metadataString)).setter(NotifyObjectCompleteRequest.setter(Builder::metadataString)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("metadata-string").build()}).build();
    private static final SdkField<Long> METADATA_BLOB_LENGTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("MetadataBlobLength").getter(NotifyObjectCompleteRequest.getter(NotifyObjectCompleteRequest::metadataBlobLength)).setter(NotifyObjectCompleteRequest.setter(Builder::metadataBlobLength)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("metadata-blob-length").build()}).build();
    private static final SdkField<String> METADATA_BLOB_CHECKSUM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MetadataBlobChecksum").getter(NotifyObjectCompleteRequest.getter(NotifyObjectCompleteRequest::metadataBlobChecksum)).setter(NotifyObjectCompleteRequest.setter(Builder::metadataBlobChecksum)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("metadata-checksum").build()}).build();
    private static final SdkField<String> METADATA_BLOB_CHECKSUM_ALGORITHM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MetadataBlobChecksumAlgorithm").getter(NotifyObjectCompleteRequest.getter(NotifyObjectCompleteRequest::metadataBlobChecksumAlgorithmAsString)).setter(NotifyObjectCompleteRequest.setter(Builder::metadataBlobChecksumAlgorithm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("metadata-checksum-algorithm").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKUP_JOB_ID_FIELD, UPLOAD_ID_FIELD, OBJECT_CHECKSUM_FIELD, OBJECT_CHECKSUM_ALGORITHM_FIELD, METADATA_STRING_FIELD, METADATA_BLOB_LENGTH_FIELD, METADATA_BLOB_CHECKSUM_FIELD, METADATA_BLOB_CHECKSUM_ALGORITHM_FIELD));
    private final String backupJobId;
    private final String uploadId;
    private final String objectChecksum;
    private final String objectChecksumAlgorithm;
    private final String metadataString;
    private final Long metadataBlobLength;
    private final String metadataBlobChecksum;
    private final String metadataBlobChecksumAlgorithm;

    private NotifyObjectCompleteRequest(BuilderImpl builder) {
        super(builder);
        this.backupJobId = builder.backupJobId;
        this.uploadId = builder.uploadId;
        this.objectChecksum = builder.objectChecksum;
        this.objectChecksumAlgorithm = builder.objectChecksumAlgorithm;
        this.metadataString = builder.metadataString;
        this.metadataBlobLength = builder.metadataBlobLength;
        this.metadataBlobChecksum = builder.metadataBlobChecksum;
        this.metadataBlobChecksumAlgorithm = builder.metadataBlobChecksumAlgorithm;
    }

    public final String backupJobId() {
        return this.backupJobId;
    }

    public final String uploadId() {
        return this.uploadId;
    }

    public final String objectChecksum() {
        return this.objectChecksum;
    }

    public final SummaryChecksumAlgorithm objectChecksumAlgorithm() {
        return SummaryChecksumAlgorithm.fromValue(this.objectChecksumAlgorithm);
    }

    public final String objectChecksumAlgorithmAsString() {
        return this.objectChecksumAlgorithm;
    }

    public final String metadataString() {
        return this.metadataString;
    }

    public final Long metadataBlobLength() {
        return this.metadataBlobLength;
    }

    public final String metadataBlobChecksum() {
        return this.metadataBlobChecksum;
    }

    public final DataChecksumAlgorithm metadataBlobChecksumAlgorithm() {
        return DataChecksumAlgorithm.fromValue(this.metadataBlobChecksumAlgorithm);
    }

    public final String metadataBlobChecksumAlgorithmAsString() {
        return this.metadataBlobChecksumAlgorithm;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.backupJobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.uploadId());
        hashCode = 31 * hashCode + Objects.hashCode(this.objectChecksum());
        hashCode = 31 * hashCode + Objects.hashCode(this.objectChecksumAlgorithmAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.metadataString());
        hashCode = 31 * hashCode + Objects.hashCode(this.metadataBlobLength());
        hashCode = 31 * hashCode + Objects.hashCode(this.metadataBlobChecksum());
        hashCode = 31 * hashCode + Objects.hashCode(this.metadataBlobChecksumAlgorithmAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NotifyObjectCompleteRequest)) {
            return false;
        }
        NotifyObjectCompleteRequest other = (NotifyObjectCompleteRequest)((Object)obj);
        return Objects.equals(this.backupJobId(), other.backupJobId()) && Objects.equals(this.uploadId(), other.uploadId()) && Objects.equals(this.objectChecksum(), other.objectChecksum()) && Objects.equals(this.objectChecksumAlgorithmAsString(), other.objectChecksumAlgorithmAsString()) && Objects.equals(this.metadataString(), other.metadataString()) && Objects.equals(this.metadataBlobLength(), other.metadataBlobLength()) && Objects.equals(this.metadataBlobChecksum(), other.metadataBlobChecksum()) && Objects.equals(this.metadataBlobChecksumAlgorithmAsString(), other.metadataBlobChecksumAlgorithmAsString());
    }

    public final String toString() {
        return ToString.builder((String)"NotifyObjectCompleteRequest").add("BackupJobId", (Object)this.backupJobId()).add("UploadId", (Object)this.uploadId()).add("ObjectChecksum", (Object)this.objectChecksum()).add("ObjectChecksumAlgorithm", (Object)this.objectChecksumAlgorithmAsString()).add("MetadataString", (Object)this.metadataString()).add("MetadataBlobLength", (Object)this.metadataBlobLength()).add("MetadataBlobChecksum", (Object)this.metadataBlobChecksum()).add("MetadataBlobChecksumAlgorithm", (Object)this.metadataBlobChecksumAlgorithmAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "BackupJobId": {
                return Optional.ofNullable(clazz.cast(this.backupJobId()));
            }
            case "UploadId": {
                return Optional.ofNullable(clazz.cast(this.uploadId()));
            }
            case "ObjectChecksum": {
                return Optional.ofNullable(clazz.cast(this.objectChecksum()));
            }
            case "ObjectChecksumAlgorithm": {
                return Optional.ofNullable(clazz.cast(this.objectChecksumAlgorithmAsString()));
            }
            case "MetadataString": {
                return Optional.ofNullable(clazz.cast(this.metadataString()));
            }
            case "MetadataBlobLength": {
                return Optional.ofNullable(clazz.cast(this.metadataBlobLength()));
            }
            case "MetadataBlobChecksum": {
                return Optional.ofNullable(clazz.cast(this.metadataBlobChecksum()));
            }
            case "MetadataBlobChecksumAlgorithm": {
                return Optional.ofNullable(clazz.cast(this.metadataBlobChecksumAlgorithmAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NotifyObjectCompleteRequest, T> g) {
        return obj -> g.apply((NotifyObjectCompleteRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BackupStorageRequest.BuilderImpl
    implements Builder {
        private String backupJobId;
        private String uploadId;
        private String objectChecksum;
        private String objectChecksumAlgorithm;
        private String metadataString;
        private Long metadataBlobLength;
        private String metadataBlobChecksum;
        private String metadataBlobChecksumAlgorithm;

        private BuilderImpl() {
        }

        private BuilderImpl(NotifyObjectCompleteRequest model) {
            super(model);
            this.backupJobId(model.backupJobId);
            this.uploadId(model.uploadId);
            this.objectChecksum(model.objectChecksum);
            this.objectChecksumAlgorithm(model.objectChecksumAlgorithm);
            this.metadataString(model.metadataString);
            this.metadataBlobLength(model.metadataBlobLength);
            this.metadataBlobChecksum(model.metadataBlobChecksum);
            this.metadataBlobChecksumAlgorithm(model.metadataBlobChecksumAlgorithm);
        }

        public final String getBackupJobId() {
            return this.backupJobId;
        }

        public final void setBackupJobId(String backupJobId) {
            this.backupJobId = backupJobId;
        }

        @Override
        public final Builder backupJobId(String backupJobId) {
            this.backupJobId = backupJobId;
            return this;
        }

        public final String getUploadId() {
            return this.uploadId;
        }

        public final void setUploadId(String uploadId) {
            this.uploadId = uploadId;
        }

        @Override
        public final Builder uploadId(String uploadId) {
            this.uploadId = uploadId;
            return this;
        }

        public final String getObjectChecksum() {
            return this.objectChecksum;
        }

        public final void setObjectChecksum(String objectChecksum) {
            this.objectChecksum = objectChecksum;
        }

        @Override
        public final Builder objectChecksum(String objectChecksum) {
            this.objectChecksum = objectChecksum;
            return this;
        }

        public final String getObjectChecksumAlgorithm() {
            return this.objectChecksumAlgorithm;
        }

        public final void setObjectChecksumAlgorithm(String objectChecksumAlgorithm) {
            this.objectChecksumAlgorithm = objectChecksumAlgorithm;
        }

        @Override
        public final Builder objectChecksumAlgorithm(String objectChecksumAlgorithm) {
            this.objectChecksumAlgorithm = objectChecksumAlgorithm;
            return this;
        }

        @Override
        public final Builder objectChecksumAlgorithm(SummaryChecksumAlgorithm objectChecksumAlgorithm) {
            this.objectChecksumAlgorithm(objectChecksumAlgorithm == null ? null : objectChecksumAlgorithm.toString());
            return this;
        }

        public final String getMetadataString() {
            return this.metadataString;
        }

        public final void setMetadataString(String metadataString) {
            this.metadataString = metadataString;
        }

        @Override
        public final Builder metadataString(String metadataString) {
            this.metadataString = metadataString;
            return this;
        }

        public final Long getMetadataBlobLength() {
            return this.metadataBlobLength;
        }

        public final void setMetadataBlobLength(Long metadataBlobLength) {
            this.metadataBlobLength = metadataBlobLength;
        }

        @Override
        public final Builder metadataBlobLength(Long metadataBlobLength) {
            this.metadataBlobLength = metadataBlobLength;
            return this;
        }

        public final String getMetadataBlobChecksum() {
            return this.metadataBlobChecksum;
        }

        public final void setMetadataBlobChecksum(String metadataBlobChecksum) {
            this.metadataBlobChecksum = metadataBlobChecksum;
        }

        @Override
        public final Builder metadataBlobChecksum(String metadataBlobChecksum) {
            this.metadataBlobChecksum = metadataBlobChecksum;
            return this;
        }

        public final String getMetadataBlobChecksumAlgorithm() {
            return this.metadataBlobChecksumAlgorithm;
        }

        public final void setMetadataBlobChecksumAlgorithm(String metadataBlobChecksumAlgorithm) {
            this.metadataBlobChecksumAlgorithm = metadataBlobChecksumAlgorithm;
        }

        @Override
        public final Builder metadataBlobChecksumAlgorithm(String metadataBlobChecksumAlgorithm) {
            this.metadataBlobChecksumAlgorithm = metadataBlobChecksumAlgorithm;
            return this;
        }

        @Override
        public final Builder metadataBlobChecksumAlgorithm(DataChecksumAlgorithm metadataBlobChecksumAlgorithm) {
            this.metadataBlobChecksumAlgorithm(metadataBlobChecksumAlgorithm == null ? null : metadataBlobChecksumAlgorithm.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public NotifyObjectCompleteRequest build() {
            return new NotifyObjectCompleteRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends BackupStorageRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, NotifyObjectCompleteRequest> {
        public Builder backupJobId(String var1);

        public Builder uploadId(String var1);

        public Builder objectChecksum(String var1);

        public Builder objectChecksumAlgorithm(String var1);

        public Builder objectChecksumAlgorithm(SummaryChecksumAlgorithm var1);

        public Builder metadataString(String var1);

        public Builder metadataBlobLength(Long var1);

        public Builder metadataBlobChecksum(String var1);

        public Builder metadataBlobChecksumAlgorithm(String var1);

        public Builder metadataBlobChecksumAlgorithm(DataChecksumAlgorithm var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

