/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backupstorage.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DataChecksumAlgorithm {
    SHA256("SHA256"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DataChecksumAlgorithm> VALUE_MAP;
    private final String value;

    private DataChecksumAlgorithm(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DataChecksumAlgorithm fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DataChecksumAlgorithm> knownValues() {
        EnumSet<DataChecksumAlgorithm> knownValues = EnumSet.allOf(DataChecksumAlgorithm.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DataChecksumAlgorithm.class, DataChecksumAlgorithm::toString);
    }
}

