/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backupstorage.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.backupstorage.model.DataChecksumAlgorithm;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Chunk
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Chunk> {
    private static final SdkField<Long> INDEX_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("Index").getter(Chunk.getter(Chunk::index)).setter(Chunk.setter(Builder::index)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Index").build()}).build();
    private static final SdkField<Long> LENGTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("Length").getter(Chunk.getter(Chunk::length)).setter(Chunk.setter(Builder::length)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Length").build()}).build();
    private static final SdkField<String> CHECKSUM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Checksum").getter(Chunk.getter(Chunk::checksum)).setter(Chunk.setter(Builder::checksum)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Checksum").build()}).build();
    private static final SdkField<String> CHECKSUM_ALGORITHM_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChecksumAlgorithm").getter(Chunk.getter(Chunk::checksumAlgorithmAsString)).setter(Chunk.setter(Builder::checksumAlgorithm)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChecksumAlgorithm").build()}).build();
    private static final SdkField<String> CHUNK_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ChunkToken").getter(Chunk.getter(Chunk::chunkToken)).setter(Chunk.setter(Builder::chunkToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChunkToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INDEX_FIELD, LENGTH_FIELD, CHECKSUM_FIELD, CHECKSUM_ALGORITHM_FIELD, CHUNK_TOKEN_FIELD));
    private static final long serialVersionUID = 1L;
    private final Long index;
    private final Long length;
    private final String checksum;
    private final String checksumAlgorithm;
    private final String chunkToken;

    private Chunk(BuilderImpl builder) {
        this.index = builder.index;
        this.length = builder.length;
        this.checksum = builder.checksum;
        this.checksumAlgorithm = builder.checksumAlgorithm;
        this.chunkToken = builder.chunkToken;
    }

    public final Long index() {
        return this.index;
    }

    public final Long length() {
        return this.length;
    }

    public final String checksum() {
        return this.checksum;
    }

    public final DataChecksumAlgorithm checksumAlgorithm() {
        return DataChecksumAlgorithm.fromValue(this.checksumAlgorithm);
    }

    public final String checksumAlgorithmAsString() {
        return this.checksumAlgorithm;
    }

    public final String chunkToken() {
        return this.chunkToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.index());
        hashCode = 31 * hashCode + Objects.hashCode(this.length());
        hashCode = 31 * hashCode + Objects.hashCode(this.checksum());
        hashCode = 31 * hashCode + Objects.hashCode(this.checksumAlgorithmAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.chunkToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Chunk)) {
            return false;
        }
        Chunk other = (Chunk)obj;
        return Objects.equals(this.index(), other.index()) && Objects.equals(this.length(), other.length()) && Objects.equals(this.checksum(), other.checksum()) && Objects.equals(this.checksumAlgorithmAsString(), other.checksumAlgorithmAsString()) && Objects.equals(this.chunkToken(), other.chunkToken());
    }

    public final String toString() {
        return ToString.builder((String)"Chunk").add("Index", (Object)this.index()).add("Length", (Object)this.length()).add("Checksum", (Object)this.checksum()).add("ChecksumAlgorithm", (Object)this.checksumAlgorithmAsString()).add("ChunkToken", (Object)this.chunkToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Index": {
                return Optional.ofNullable(clazz.cast(this.index()));
            }
            case "Length": {
                return Optional.ofNullable(clazz.cast(this.length()));
            }
            case "Checksum": {
                return Optional.ofNullable(clazz.cast(this.checksum()));
            }
            case "ChecksumAlgorithm": {
                return Optional.ofNullable(clazz.cast(this.checksumAlgorithmAsString()));
            }
            case "ChunkToken": {
                return Optional.ofNullable(clazz.cast(this.chunkToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Chunk, T> g) {
        return obj -> g.apply((Chunk)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long index;
        private Long length;
        private String checksum;
        private String checksumAlgorithm;
        private String chunkToken;

        private BuilderImpl() {
        }

        private BuilderImpl(Chunk model) {
            this.index(model.index);
            this.length(model.length);
            this.checksum(model.checksum);
            this.checksumAlgorithm(model.checksumAlgorithm);
            this.chunkToken(model.chunkToken);
        }

        public final Long getIndex() {
            return this.index;
        }

        public final void setIndex(Long index) {
            this.index = index;
        }

        @Override
        public final Builder index(Long index) {
            this.index = index;
            return this;
        }

        public final Long getLength() {
            return this.length;
        }

        public final void setLength(Long length) {
            this.length = length;
        }

        @Override
        public final Builder length(Long length) {
            this.length = length;
            return this;
        }

        public final String getChecksum() {
            return this.checksum;
        }

        public final void setChecksum(String checksum) {
            this.checksum = checksum;
        }

        @Override
        public final Builder checksum(String checksum) {
            this.checksum = checksum;
            return this;
        }

        public final String getChecksumAlgorithm() {
            return this.checksumAlgorithm;
        }

        public final void setChecksumAlgorithm(String checksumAlgorithm) {
            this.checksumAlgorithm = checksumAlgorithm;
        }

        @Override
        public final Builder checksumAlgorithm(String checksumAlgorithm) {
            this.checksumAlgorithm = checksumAlgorithm;
            return this;
        }

        @Override
        public final Builder checksumAlgorithm(DataChecksumAlgorithm checksumAlgorithm) {
            this.checksumAlgorithm(checksumAlgorithm == null ? null : checksumAlgorithm.toString());
            return this;
        }

        public final String getChunkToken() {
            return this.chunkToken;
        }

        public final void setChunkToken(String chunkToken) {
            this.chunkToken = chunkToken;
        }

        @Override
        public final Builder chunkToken(String chunkToken) {
            this.chunkToken = chunkToken;
            return this;
        }

        public Chunk build() {
            return new Chunk(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Chunk> {
        public Builder index(Long var1);

        public Builder length(Long var1);

        public Builder checksum(String var1);

        public Builder checksumAlgorithm(String var1);

        public Builder checksumAlgorithm(DataChecksumAlgorithm var1);

        public Builder chunkToken(String var1);
    }
}

