/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backupsearch.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.backupsearch.BackupSearchClient;
import software.amazon.awssdk.services.backupsearch.internal.UserAgentUtils;
import software.amazon.awssdk.services.backupsearch.model.ListSearchJobResultsRequest;
import software.amazon.awssdk.services.backupsearch.model.ListSearchJobResultsResponse;
import software.amazon.awssdk.services.backupsearch.model.ResultItem;

public class ListSearchJobResultsIterable
implements SdkIterable<ListSearchJobResultsResponse> {
    private final BackupSearchClient client;
    private final ListSearchJobResultsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSearchJobResultsIterable(BackupSearchClient client, ListSearchJobResultsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListSearchJobResultsResponseFetcher();
    }

    public Iterator<ListSearchJobResultsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ResultItem> results() {
        Function<ListSearchJobResultsResponse, Iterator> getIterator = response -> {
            if (response != null && response.results() != null) {
                return response.results().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListSearchJobResultsResponseFetcher
    implements SyncPageFetcher<ListSearchJobResultsResponse> {
        private ListSearchJobResultsResponseFetcher() {
        }

        public boolean hasNextPage(ListSearchJobResultsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListSearchJobResultsResponse nextPage(ListSearchJobResultsResponse previousPage) {
            if (previousPage == null) {
                return ListSearchJobResultsIterable.this.client.listSearchJobResults(ListSearchJobResultsIterable.this.firstRequest);
            }
            return ListSearchJobResultsIterable.this.client.listSearchJobResults((ListSearchJobResultsRequest)((Object)ListSearchJobResultsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

