/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backupsearch.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.backupsearch.BackupSearchClient;
import software.amazon.awssdk.services.backupsearch.internal.UserAgentUtils;
import software.amazon.awssdk.services.backupsearch.model.ListSearchJobBackupsRequest;
import software.amazon.awssdk.services.backupsearch.model.ListSearchJobBackupsResponse;
import software.amazon.awssdk.services.backupsearch.model.SearchJobBackupsResult;

public class ListSearchJobBackupsIterable
implements SdkIterable<ListSearchJobBackupsResponse> {
    private final BackupSearchClient client;
    private final ListSearchJobBackupsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSearchJobBackupsIterable(BackupSearchClient client, ListSearchJobBackupsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListSearchJobBackupsResponseFetcher();
    }

    public Iterator<ListSearchJobBackupsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<SearchJobBackupsResult> results() {
        Function<ListSearchJobBackupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.results() != null) {
                return response.results().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListSearchJobBackupsResponseFetcher
    implements SyncPageFetcher<ListSearchJobBackupsResponse> {
        private ListSearchJobBackupsResponseFetcher() {
        }

        public boolean hasNextPage(ListSearchJobBackupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListSearchJobBackupsResponse nextPage(ListSearchJobBackupsResponse previousPage) {
            if (previousPage == null) {
                return ListSearchJobBackupsIterable.this.client.listSearchJobBackups(ListSearchJobBackupsIterable.this.firstRequest);
            }
            return ListSearchJobBackupsIterable.this.client.listSearchJobBackups((ListSearchJobBackupsRequest)((Object)ListSearchJobBackupsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

