/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backupsearch.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.backupsearch.BackupSearchAsyncClient;
import software.amazon.awssdk.services.backupsearch.internal.UserAgentUtils;
import software.amazon.awssdk.services.backupsearch.model.ListSearchJobsRequest;
import software.amazon.awssdk.services.backupsearch.model.ListSearchJobsResponse;
import software.amazon.awssdk.services.backupsearch.model.SearchJobSummary;

public class ListSearchJobsPublisher
implements SdkPublisher<ListSearchJobsResponse> {
    private final BackupSearchAsyncClient client;
    private final ListSearchJobsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListSearchJobsPublisher(BackupSearchAsyncClient client, ListSearchJobsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListSearchJobsPublisher(BackupSearchAsyncClient client, ListSearchJobsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListSearchJobsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListSearchJobsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<SearchJobSummary> searchJobs() {
        Function<ListSearchJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.searchJobs() != null) {
                return response.searchJobs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListSearchJobsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListSearchJobsResponseFetcher
    implements AsyncPageFetcher<ListSearchJobsResponse> {
        private ListSearchJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListSearchJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListSearchJobsResponse> nextPage(ListSearchJobsResponse previousPage) {
            if (previousPage == null) {
                return ListSearchJobsPublisher.this.client.listSearchJobs(ListSearchJobsPublisher.this.firstRequest);
            }
            return ListSearchJobsPublisher.this.client.listSearchJobs((ListSearchJobsRequest)((Object)ListSearchJobsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

