/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backupsearch;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.backupsearch.BackupSearchClientBuilder;
import software.amazon.awssdk.services.backupsearch.BackupSearchServiceClientConfiguration;
import software.amazon.awssdk.services.backupsearch.DefaultBackupSearchClientBuilder;
import software.amazon.awssdk.services.backupsearch.model.AccessDeniedException;
import software.amazon.awssdk.services.backupsearch.model.BackupSearchException;
import software.amazon.awssdk.services.backupsearch.model.ConflictException;
import software.amazon.awssdk.services.backupsearch.model.GetSearchJobRequest;
import software.amazon.awssdk.services.backupsearch.model.GetSearchJobResponse;
import software.amazon.awssdk.services.backupsearch.model.GetSearchResultExportJobRequest;
import software.amazon.awssdk.services.backupsearch.model.GetSearchResultExportJobResponse;
import software.amazon.awssdk.services.backupsearch.model.InternalServerException;
import software.amazon.awssdk.services.backupsearch.model.ListSearchJobBackupsRequest;
import software.amazon.awssdk.services.backupsearch.model.ListSearchJobBackupsResponse;
import software.amazon.awssdk.services.backupsearch.model.ListSearchJobResultsRequest;
import software.amazon.awssdk.services.backupsearch.model.ListSearchJobResultsResponse;
import software.amazon.awssdk.services.backupsearch.model.ListSearchJobsRequest;
import software.amazon.awssdk.services.backupsearch.model.ListSearchJobsResponse;
import software.amazon.awssdk.services.backupsearch.model.ListSearchResultExportJobsRequest;
import software.amazon.awssdk.services.backupsearch.model.ListSearchResultExportJobsResponse;
import software.amazon.awssdk.services.backupsearch.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.backupsearch.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.backupsearch.model.ResourceNotFoundException;
import software.amazon.awssdk.services.backupsearch.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.backupsearch.model.StartSearchJobRequest;
import software.amazon.awssdk.services.backupsearch.model.StartSearchJobResponse;
import software.amazon.awssdk.services.backupsearch.model.StartSearchResultExportJobRequest;
import software.amazon.awssdk.services.backupsearch.model.StartSearchResultExportJobResponse;
import software.amazon.awssdk.services.backupsearch.model.StopSearchJobRequest;
import software.amazon.awssdk.services.backupsearch.model.StopSearchJobResponse;
import software.amazon.awssdk.services.backupsearch.model.TagResourceRequest;
import software.amazon.awssdk.services.backupsearch.model.TagResourceResponse;
import software.amazon.awssdk.services.backupsearch.model.ThrottlingException;
import software.amazon.awssdk.services.backupsearch.model.UntagResourceRequest;
import software.amazon.awssdk.services.backupsearch.model.UntagResourceResponse;
import software.amazon.awssdk.services.backupsearch.model.ValidationException;
import software.amazon.awssdk.services.backupsearch.paginators.ListSearchJobBackupsIterable;
import software.amazon.awssdk.services.backupsearch.paginators.ListSearchJobResultsIterable;
import software.amazon.awssdk.services.backupsearch.paginators.ListSearchJobsIterable;
import software.amazon.awssdk.services.backupsearch.paginators.ListSearchResultExportJobsIterable;

@SdkPublicApi
@ThreadSafe
public interface BackupSearchClient
extends AwsClient {
    public static final String SERVICE_NAME = "backup-search";
    public static final String SERVICE_METADATA_ID = "backup-search";

    default public GetSearchJobResponse getSearchJob(GetSearchJobRequest getSearchJobRequest) throws ResourceNotFoundException, ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, BackupSearchException {
        throw new UnsupportedOperationException();
    }

    default public GetSearchJobResponse getSearchJob(Consumer<GetSearchJobRequest.Builder> getSearchJobRequest) throws ResourceNotFoundException, ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, BackupSearchException {
        return this.getSearchJob((GetSearchJobRequest)((Object)((GetSearchJobRequest.Builder)GetSearchJobRequest.builder().applyMutation(getSearchJobRequest)).build()));
    }

    default public GetSearchResultExportJobResponse getSearchResultExportJob(GetSearchResultExportJobRequest getSearchResultExportJobRequest) throws ResourceNotFoundException, ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, BackupSearchException {
        throw new UnsupportedOperationException();
    }

    default public GetSearchResultExportJobResponse getSearchResultExportJob(Consumer<GetSearchResultExportJobRequest.Builder> getSearchResultExportJobRequest) throws ResourceNotFoundException, ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, BackupSearchException {
        return this.getSearchResultExportJob((GetSearchResultExportJobRequest)((Object)((GetSearchResultExportJobRequest.Builder)GetSearchResultExportJobRequest.builder().applyMutation(getSearchResultExportJobRequest)).build()));
    }

    default public ListSearchJobBackupsResponse listSearchJobBackups(ListSearchJobBackupsRequest listSearchJobBackupsRequest) throws ResourceNotFoundException, ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, BackupSearchException {
        throw new UnsupportedOperationException();
    }

    default public ListSearchJobBackupsResponse listSearchJobBackups(Consumer<ListSearchJobBackupsRequest.Builder> listSearchJobBackupsRequest) throws ResourceNotFoundException, ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, BackupSearchException {
        return this.listSearchJobBackups((ListSearchJobBackupsRequest)((Object)((ListSearchJobBackupsRequest.Builder)ListSearchJobBackupsRequest.builder().applyMutation(listSearchJobBackupsRequest)).build()));
    }

    default public ListSearchJobBackupsIterable listSearchJobBackupsPaginator(ListSearchJobBackupsRequest listSearchJobBackupsRequest) throws ResourceNotFoundException, ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, BackupSearchException {
        return new ListSearchJobBackupsIterable(this, listSearchJobBackupsRequest);
    }

    default public ListSearchJobBackupsIterable listSearchJobBackupsPaginator(Consumer<ListSearchJobBackupsRequest.Builder> listSearchJobBackupsRequest) throws ResourceNotFoundException, ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, BackupSearchException {
        return this.listSearchJobBackupsPaginator((ListSearchJobBackupsRequest)((Object)((ListSearchJobBackupsRequest.Builder)ListSearchJobBackupsRequest.builder().applyMutation(listSearchJobBackupsRequest)).build()));
    }

    default public ListSearchJobResultsResponse listSearchJobResults(ListSearchJobResultsRequest listSearchJobResultsRequest) throws ResourceNotFoundException, ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, BackupSearchException {
        throw new UnsupportedOperationException();
    }

    default public ListSearchJobResultsResponse listSearchJobResults(Consumer<ListSearchJobResultsRequest.Builder> listSearchJobResultsRequest) throws ResourceNotFoundException, ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, BackupSearchException {
        return this.listSearchJobResults((ListSearchJobResultsRequest)((Object)((ListSearchJobResultsRequest.Builder)ListSearchJobResultsRequest.builder().applyMutation(listSearchJobResultsRequest)).build()));
    }

    default public ListSearchJobResultsIterable listSearchJobResultsPaginator(ListSearchJobResultsRequest listSearchJobResultsRequest) throws ResourceNotFoundException, ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, BackupSearchException {
        return new ListSearchJobResultsIterable(this, listSearchJobResultsRequest);
    }

    default public ListSearchJobResultsIterable listSearchJobResultsPaginator(Consumer<ListSearchJobResultsRequest.Builder> listSearchJobResultsRequest) throws ResourceNotFoundException, ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, BackupSearchException {
        return this.listSearchJobResultsPaginator((ListSearchJobResultsRequest)((Object)((ListSearchJobResultsRequest.Builder)ListSearchJobResultsRequest.builder().applyMutation(listSearchJobResultsRequest)).build()));
    }

    default public ListSearchJobsResponse listSearchJobs(ListSearchJobsRequest listSearchJobsRequest) throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, BackupSearchException {
        throw new UnsupportedOperationException();
    }

    default public ListSearchJobsResponse listSearchJobs(Consumer<ListSearchJobsRequest.Builder> listSearchJobsRequest) throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, BackupSearchException {
        return this.listSearchJobs((ListSearchJobsRequest)((Object)((ListSearchJobsRequest.Builder)ListSearchJobsRequest.builder().applyMutation(listSearchJobsRequest)).build()));
    }

    default public ListSearchJobsIterable listSearchJobsPaginator(ListSearchJobsRequest listSearchJobsRequest) throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, BackupSearchException {
        return new ListSearchJobsIterable(this, listSearchJobsRequest);
    }

    default public ListSearchJobsIterable listSearchJobsPaginator(Consumer<ListSearchJobsRequest.Builder> listSearchJobsRequest) throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, BackupSearchException {
        return this.listSearchJobsPaginator((ListSearchJobsRequest)((Object)((ListSearchJobsRequest.Builder)ListSearchJobsRequest.builder().applyMutation(listSearchJobsRequest)).build()));
    }

    default public ListSearchResultExportJobsResponse listSearchResultExportJobs(ListSearchResultExportJobsRequest listSearchResultExportJobsRequest) throws ResourceNotFoundException, ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, BackupSearchException {
        throw new UnsupportedOperationException();
    }

    default public ListSearchResultExportJobsResponse listSearchResultExportJobs(Consumer<ListSearchResultExportJobsRequest.Builder> listSearchResultExportJobsRequest) throws ResourceNotFoundException, ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, BackupSearchException {
        return this.listSearchResultExportJobs((ListSearchResultExportJobsRequest)((Object)((ListSearchResultExportJobsRequest.Builder)ListSearchResultExportJobsRequest.builder().applyMutation(listSearchResultExportJobsRequest)).build()));
    }

    default public ListSearchResultExportJobsIterable listSearchResultExportJobsPaginator(ListSearchResultExportJobsRequest listSearchResultExportJobsRequest) throws ResourceNotFoundException, ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, BackupSearchException {
        return new ListSearchResultExportJobsIterable(this, listSearchResultExportJobsRequest);
    }

    default public ListSearchResultExportJobsIterable listSearchResultExportJobsPaginator(Consumer<ListSearchResultExportJobsRequest.Builder> listSearchResultExportJobsRequest) throws ResourceNotFoundException, ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, BackupSearchException {
        return this.listSearchResultExportJobsPaginator((ListSearchResultExportJobsRequest)((Object)((ListSearchResultExportJobsRequest.Builder)ListSearchResultExportJobsRequest.builder().applyMutation(listSearchResultExportJobsRequest)).build()));
    }

    default public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws ResourceNotFoundException, ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, BackupSearchException {
        throw new UnsupportedOperationException();
    }

    default public ListTagsForResourceResponse listTagsForResource(Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ResourceNotFoundException, ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, BackupSearchException {
        return this.listTagsForResource((ListTagsForResourceRequest)((Object)((ListTagsForResourceRequest.Builder)ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest)).build()));
    }

    default public StartSearchJobResponse startSearchJob(StartSearchJobRequest startSearchJobRequest) throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, ServiceQuotaExceededException, ConflictException, AwsServiceException, SdkClientException, BackupSearchException {
        throw new UnsupportedOperationException();
    }

    default public StartSearchJobResponse startSearchJob(Consumer<StartSearchJobRequest.Builder> startSearchJobRequest) throws ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, ServiceQuotaExceededException, ConflictException, AwsServiceException, SdkClientException, BackupSearchException {
        return this.startSearchJob((StartSearchJobRequest)((Object)((StartSearchJobRequest.Builder)StartSearchJobRequest.builder().applyMutation(startSearchJobRequest)).build()));
    }

    default public StartSearchResultExportJobResponse startSearchResultExportJob(StartSearchResultExportJobRequest startSearchResultExportJobRequest) throws ResourceNotFoundException, ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, ServiceQuotaExceededException, ConflictException, AwsServiceException, SdkClientException, BackupSearchException {
        throw new UnsupportedOperationException();
    }

    default public StartSearchResultExportJobResponse startSearchResultExportJob(Consumer<StartSearchResultExportJobRequest.Builder> startSearchResultExportJobRequest) throws ResourceNotFoundException, ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, ServiceQuotaExceededException, ConflictException, AwsServiceException, SdkClientException, BackupSearchException {
        return this.startSearchResultExportJob((StartSearchResultExportJobRequest)((Object)((StartSearchResultExportJobRequest.Builder)StartSearchResultExportJobRequest.builder().applyMutation(startSearchResultExportJobRequest)).build()));
    }

    default public StopSearchJobResponse stopSearchJob(StopSearchJobRequest stopSearchJobRequest) throws ResourceNotFoundException, ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, ConflictException, AwsServiceException, SdkClientException, BackupSearchException {
        throw new UnsupportedOperationException();
    }

    default public StopSearchJobResponse stopSearchJob(Consumer<StopSearchJobRequest.Builder> stopSearchJobRequest) throws ResourceNotFoundException, ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, ConflictException, AwsServiceException, SdkClientException, BackupSearchException {
        return this.stopSearchJob((StopSearchJobRequest)((Object)((StopSearchJobRequest.Builder)StopSearchJobRequest.builder().applyMutation(stopSearchJobRequest)).build()));
    }

    default public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ResourceNotFoundException, ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, BackupSearchException {
        throw new UnsupportedOperationException();
    }

    default public TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) throws ResourceNotFoundException, ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, BackupSearchException {
        return this.tagResource((TagResourceRequest)((Object)((TagResourceRequest.Builder)TagResourceRequest.builder().applyMutation(tagResourceRequest)).build()));
    }

    default public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ResourceNotFoundException, ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, BackupSearchException {
        throw new UnsupportedOperationException();
    }

    default public UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) throws ResourceNotFoundException, ThrottlingException, AccessDeniedException, ValidationException, InternalServerException, AwsServiceException, SdkClientException, BackupSearchException {
        return this.untagResource((UntagResourceRequest)((Object)((UntagResourceRequest.Builder)UntagResourceRequest.builder().applyMutation(untagResourceRequest)).build()));
    }

    public static BackupSearchClient create() {
        return (BackupSearchClient)BackupSearchClient.builder().build();
    }

    public static BackupSearchClientBuilder builder() {
        return new DefaultBackupSearchClientBuilder();
    }

    public static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of((String)"backup-search");
    }

    default public BackupSearchServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}

