/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backupgateway.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetHypervisorResponse extends BackupGatewayResponse implements
        ToCopyableBuilder<GetHypervisorResponse.Builder, GetHypervisorResponse> {
    private static final SdkField<HypervisorDetails> HYPERVISOR_FIELD = SdkField
            .<HypervisorDetails> builder(MarshallingType.SDK_POJO).memberName("Hypervisor")
            .getter(getter(GetHypervisorResponse::hypervisor)).setter(setter(Builder::hypervisor))
            .constructor(HypervisorDetails::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Hypervisor").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HYPERVISOR_FIELD));

    private final HypervisorDetails hypervisor;

    private GetHypervisorResponse(BuilderImpl builder) {
        super(builder);
        this.hypervisor = builder.hypervisor;
    }

    /**
     * <p>
     * Details about the requested hypervisor.
     * </p>
     * 
     * @return Details about the requested hypervisor.
     */
    public final HypervisorDetails hypervisor() {
        return hypervisor;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hypervisor());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetHypervisorResponse)) {
            return false;
        }
        GetHypervisorResponse other = (GetHypervisorResponse) obj;
        return Objects.equals(hypervisor(), other.hypervisor());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetHypervisorResponse").add("Hypervisor", hypervisor()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Hypervisor":
            return Optional.ofNullable(clazz.cast(hypervisor()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetHypervisorResponse, T> g) {
        return obj -> g.apply((GetHypervisorResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BackupGatewayResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetHypervisorResponse> {
        /**
         * <p>
         * Details about the requested hypervisor.
         * </p>
         * 
         * @param hypervisor
         *        Details about the requested hypervisor.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hypervisor(HypervisorDetails hypervisor);

        /**
         * <p>
         * Details about the requested hypervisor.
         * </p>
         * This is a convenience method that creates an instance of the {@link HypervisorDetails.Builder} avoiding the
         * need to create one manually via {@link HypervisorDetails#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HypervisorDetails.Builder#build()} is called immediately and its
         * result is passed to {@link #hypervisor(HypervisorDetails)}.
         * 
         * @param hypervisor
         *        a consumer that will call methods on {@link HypervisorDetails.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hypervisor(HypervisorDetails)
         */
        default Builder hypervisor(Consumer<HypervisorDetails.Builder> hypervisor) {
            return hypervisor(HypervisorDetails.builder().applyMutation(hypervisor).build());
        }
    }

    static final class BuilderImpl extends BackupGatewayResponse.BuilderImpl implements Builder {
        private HypervisorDetails hypervisor;

        private BuilderImpl() {
        }

        private BuilderImpl(GetHypervisorResponse model) {
            super(model);
            hypervisor(model.hypervisor);
        }

        public final HypervisorDetails.Builder getHypervisor() {
            return hypervisor != null ? hypervisor.toBuilder() : null;
        }

        public final void setHypervisor(HypervisorDetails.BuilderImpl hypervisor) {
            this.hypervisor = hypervisor != null ? hypervisor.build() : null;
        }

        @Override
        public final Builder hypervisor(HypervisorDetails hypervisor) {
            this.hypervisor = hypervisor;
            return this;
        }

        @Override
        public GetHypervisorResponse build() {
            return new GetHypervisorResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
