/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backupgateway.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.backupgateway.model.GatewayType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Gateway
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Gateway> {
    private static final SdkField<String> GATEWAY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GatewayArn").getter(Gateway.getter(Gateway::gatewayArn)).setter(Gateway.setter(Builder::gatewayArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayArn").build()}).build();
    private static final SdkField<String> GATEWAY_DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GatewayDisplayName").getter(Gateway.getter(Gateway::gatewayDisplayName)).setter(Gateway.setter(Builder::gatewayDisplayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayDisplayName").build()}).build();
    private static final SdkField<String> GATEWAY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("GatewayType").getter(Gateway.getter(Gateway::gatewayTypeAsString)).setter(Gateway.setter(Builder::gatewayType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("GatewayType").build()}).build();
    private static final SdkField<String> HYPERVISOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("HypervisorId").getter(Gateway.getter(Gateway::hypervisorId)).setter(Gateway.setter(Builder::hypervisorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("HypervisorId").build()}).build();
    private static final SdkField<Instant> LAST_SEEN_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastSeenTime").getter(Gateway.getter(Gateway::lastSeenTime)).setter(Gateway.setter(Builder::lastSeenTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastSeenTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GATEWAY_ARN_FIELD, GATEWAY_DISPLAY_NAME_FIELD, GATEWAY_TYPE_FIELD, HYPERVISOR_ID_FIELD, LAST_SEEN_TIME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String gatewayArn;
    private final String gatewayDisplayName;
    private final String gatewayType;
    private final String hypervisorId;
    private final Instant lastSeenTime;

    private Gateway(BuilderImpl builder) {
        this.gatewayArn = builder.gatewayArn;
        this.gatewayDisplayName = builder.gatewayDisplayName;
        this.gatewayType = builder.gatewayType;
        this.hypervisorId = builder.hypervisorId;
        this.lastSeenTime = builder.lastSeenTime;
    }

    public final String gatewayArn() {
        return this.gatewayArn;
    }

    public final String gatewayDisplayName() {
        return this.gatewayDisplayName;
    }

    public final GatewayType gatewayType() {
        return GatewayType.fromValue(this.gatewayType);
    }

    public final String gatewayTypeAsString() {
        return this.gatewayType;
    }

    public final String hypervisorId() {
        return this.hypervisorId;
    }

    public final Instant lastSeenTime() {
        return this.lastSeenTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayDisplayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.gatewayTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hypervisorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastSeenTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Gateway)) {
            return false;
        }
        Gateway other = (Gateway)obj;
        return Objects.equals(this.gatewayArn(), other.gatewayArn()) && Objects.equals(this.gatewayDisplayName(), other.gatewayDisplayName()) && Objects.equals(this.gatewayTypeAsString(), other.gatewayTypeAsString()) && Objects.equals(this.hypervisorId(), other.hypervisorId()) && Objects.equals(this.lastSeenTime(), other.lastSeenTime());
    }

    public final String toString() {
        return ToString.builder((String)"Gateway").add("GatewayArn", (Object)this.gatewayArn()).add("GatewayDisplayName", (Object)this.gatewayDisplayName()).add("GatewayType", (Object)this.gatewayTypeAsString()).add("HypervisorId", (Object)this.hypervisorId()).add("LastSeenTime", (Object)this.lastSeenTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "GatewayArn": {
                return Optional.ofNullable(clazz.cast(this.gatewayArn()));
            }
            case "GatewayDisplayName": {
                return Optional.ofNullable(clazz.cast(this.gatewayDisplayName()));
            }
            case "GatewayType": {
                return Optional.ofNullable(clazz.cast(this.gatewayTypeAsString()));
            }
            case "HypervisorId": {
                return Optional.ofNullable(clazz.cast(this.hypervisorId()));
            }
            case "LastSeenTime": {
                return Optional.ofNullable(clazz.cast(this.lastSeenTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Gateway, T> g) {
        return obj -> g.apply((Gateway)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String gatewayArn;
        private String gatewayDisplayName;
        private String gatewayType;
        private String hypervisorId;
        private Instant lastSeenTime;

        private BuilderImpl() {
        }

        private BuilderImpl(Gateway model) {
            this.gatewayArn(model.gatewayArn);
            this.gatewayDisplayName(model.gatewayDisplayName);
            this.gatewayType(model.gatewayType);
            this.hypervisorId(model.hypervisorId);
            this.lastSeenTime(model.lastSeenTime);
        }

        public final String getGatewayArn() {
            return this.gatewayArn;
        }

        public final void setGatewayArn(String gatewayArn) {
            this.gatewayArn = gatewayArn;
        }

        @Override
        public final Builder gatewayArn(String gatewayArn) {
            this.gatewayArn = gatewayArn;
            return this;
        }

        public final String getGatewayDisplayName() {
            return this.gatewayDisplayName;
        }

        public final void setGatewayDisplayName(String gatewayDisplayName) {
            this.gatewayDisplayName = gatewayDisplayName;
        }

        @Override
        public final Builder gatewayDisplayName(String gatewayDisplayName) {
            this.gatewayDisplayName = gatewayDisplayName;
            return this;
        }

        public final String getGatewayType() {
            return this.gatewayType;
        }

        public final void setGatewayType(String gatewayType) {
            this.gatewayType = gatewayType;
        }

        @Override
        public final Builder gatewayType(String gatewayType) {
            this.gatewayType = gatewayType;
            return this;
        }

        @Override
        public final Builder gatewayType(GatewayType gatewayType) {
            this.gatewayType(gatewayType == null ? null : gatewayType.toString());
            return this;
        }

        public final String getHypervisorId() {
            return this.hypervisorId;
        }

        public final void setHypervisorId(String hypervisorId) {
            this.hypervisorId = hypervisorId;
        }

        @Override
        public final Builder hypervisorId(String hypervisorId) {
            this.hypervisorId = hypervisorId;
            return this;
        }

        public final Instant getLastSeenTime() {
            return this.lastSeenTime;
        }

        public final void setLastSeenTime(Instant lastSeenTime) {
            this.lastSeenTime = lastSeenTime;
        }

        @Override
        public final Builder lastSeenTime(Instant lastSeenTime) {
            this.lastSeenTime = lastSeenTime;
            return this;
        }

        public Gateway build() {
            return new Gateway(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Gateway> {
        public Builder gatewayArn(String var1);

        public Builder gatewayDisplayName(String var1);

        public Builder gatewayType(String var1);

        public Builder gatewayType(GatewayType var1);

        public Builder hypervisorId(String var1);

        public Builder lastSeenTime(Instant var1);
    }
}

