/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backupgateway;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.backupgateway.BackupGatewayClient;
import software.amazon.awssdk.services.backupgateway.model.AccessDeniedException;
import software.amazon.awssdk.services.backupgateway.model.AssociateGatewayToServerRequest;
import software.amazon.awssdk.services.backupgateway.model.AssociateGatewayToServerResponse;
import software.amazon.awssdk.services.backupgateway.model.BackupGatewayException;
import software.amazon.awssdk.services.backupgateway.model.BackupGatewayRequest;
import software.amazon.awssdk.services.backupgateway.model.ConflictException;
import software.amazon.awssdk.services.backupgateway.model.CreateGatewayRequest;
import software.amazon.awssdk.services.backupgateway.model.CreateGatewayResponse;
import software.amazon.awssdk.services.backupgateway.model.DeleteGatewayRequest;
import software.amazon.awssdk.services.backupgateway.model.DeleteGatewayResponse;
import software.amazon.awssdk.services.backupgateway.model.DeleteHypervisorRequest;
import software.amazon.awssdk.services.backupgateway.model.DeleteHypervisorResponse;
import software.amazon.awssdk.services.backupgateway.model.DisassociateGatewayFromServerRequest;
import software.amazon.awssdk.services.backupgateway.model.DisassociateGatewayFromServerResponse;
import software.amazon.awssdk.services.backupgateway.model.GetBandwidthRateLimitScheduleRequest;
import software.amazon.awssdk.services.backupgateway.model.GetBandwidthRateLimitScheduleResponse;
import software.amazon.awssdk.services.backupgateway.model.GetGatewayRequest;
import software.amazon.awssdk.services.backupgateway.model.GetGatewayResponse;
import software.amazon.awssdk.services.backupgateway.model.GetHypervisorPropertyMappingsRequest;
import software.amazon.awssdk.services.backupgateway.model.GetHypervisorPropertyMappingsResponse;
import software.amazon.awssdk.services.backupgateway.model.GetHypervisorRequest;
import software.amazon.awssdk.services.backupgateway.model.GetHypervisorResponse;
import software.amazon.awssdk.services.backupgateway.model.GetVirtualMachineRequest;
import software.amazon.awssdk.services.backupgateway.model.GetVirtualMachineResponse;
import software.amazon.awssdk.services.backupgateway.model.ImportHypervisorConfigurationRequest;
import software.amazon.awssdk.services.backupgateway.model.ImportHypervisorConfigurationResponse;
import software.amazon.awssdk.services.backupgateway.model.InternalServerException;
import software.amazon.awssdk.services.backupgateway.model.ListGatewaysRequest;
import software.amazon.awssdk.services.backupgateway.model.ListGatewaysResponse;
import software.amazon.awssdk.services.backupgateway.model.ListHypervisorsRequest;
import software.amazon.awssdk.services.backupgateway.model.ListHypervisorsResponse;
import software.amazon.awssdk.services.backupgateway.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.backupgateway.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.backupgateway.model.ListVirtualMachinesRequest;
import software.amazon.awssdk.services.backupgateway.model.ListVirtualMachinesResponse;
import software.amazon.awssdk.services.backupgateway.model.PutBandwidthRateLimitScheduleRequest;
import software.amazon.awssdk.services.backupgateway.model.PutBandwidthRateLimitScheduleResponse;
import software.amazon.awssdk.services.backupgateway.model.PutHypervisorPropertyMappingsRequest;
import software.amazon.awssdk.services.backupgateway.model.PutHypervisorPropertyMappingsResponse;
import software.amazon.awssdk.services.backupgateway.model.PutMaintenanceStartTimeRequest;
import software.amazon.awssdk.services.backupgateway.model.PutMaintenanceStartTimeResponse;
import software.amazon.awssdk.services.backupgateway.model.ResourceNotFoundException;
import software.amazon.awssdk.services.backupgateway.model.StartVirtualMachinesMetadataSyncRequest;
import software.amazon.awssdk.services.backupgateway.model.StartVirtualMachinesMetadataSyncResponse;
import software.amazon.awssdk.services.backupgateway.model.TagResourceRequest;
import software.amazon.awssdk.services.backupgateway.model.TagResourceResponse;
import software.amazon.awssdk.services.backupgateway.model.TestHypervisorConfigurationRequest;
import software.amazon.awssdk.services.backupgateway.model.TestHypervisorConfigurationResponse;
import software.amazon.awssdk.services.backupgateway.model.ThrottlingException;
import software.amazon.awssdk.services.backupgateway.model.UntagResourceRequest;
import software.amazon.awssdk.services.backupgateway.model.UntagResourceResponse;
import software.amazon.awssdk.services.backupgateway.model.UpdateGatewayInformationRequest;
import software.amazon.awssdk.services.backupgateway.model.UpdateGatewayInformationResponse;
import software.amazon.awssdk.services.backupgateway.model.UpdateGatewaySoftwareNowRequest;
import software.amazon.awssdk.services.backupgateway.model.UpdateGatewaySoftwareNowResponse;
import software.amazon.awssdk.services.backupgateway.model.UpdateHypervisorRequest;
import software.amazon.awssdk.services.backupgateway.model.UpdateHypervisorResponse;
import software.amazon.awssdk.services.backupgateway.model.ValidationException;
import software.amazon.awssdk.services.backupgateway.paginators.ListGatewaysIterable;
import software.amazon.awssdk.services.backupgateway.paginators.ListHypervisorsIterable;
import software.amazon.awssdk.services.backupgateway.paginators.ListVirtualMachinesIterable;
import software.amazon.awssdk.services.backupgateway.transform.AssociateGatewayToServerRequestMarshaller;
import software.amazon.awssdk.services.backupgateway.transform.CreateGatewayRequestMarshaller;
import software.amazon.awssdk.services.backupgateway.transform.DeleteGatewayRequestMarshaller;
import software.amazon.awssdk.services.backupgateway.transform.DeleteHypervisorRequestMarshaller;
import software.amazon.awssdk.services.backupgateway.transform.DisassociateGatewayFromServerRequestMarshaller;
import software.amazon.awssdk.services.backupgateway.transform.GetBandwidthRateLimitScheduleRequestMarshaller;
import software.amazon.awssdk.services.backupgateway.transform.GetGatewayRequestMarshaller;
import software.amazon.awssdk.services.backupgateway.transform.GetHypervisorPropertyMappingsRequestMarshaller;
import software.amazon.awssdk.services.backupgateway.transform.GetHypervisorRequestMarshaller;
import software.amazon.awssdk.services.backupgateway.transform.GetVirtualMachineRequestMarshaller;
import software.amazon.awssdk.services.backupgateway.transform.ImportHypervisorConfigurationRequestMarshaller;
import software.amazon.awssdk.services.backupgateway.transform.ListGatewaysRequestMarshaller;
import software.amazon.awssdk.services.backupgateway.transform.ListHypervisorsRequestMarshaller;
import software.amazon.awssdk.services.backupgateway.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.backupgateway.transform.ListVirtualMachinesRequestMarshaller;
import software.amazon.awssdk.services.backupgateway.transform.PutBandwidthRateLimitScheduleRequestMarshaller;
import software.amazon.awssdk.services.backupgateway.transform.PutHypervisorPropertyMappingsRequestMarshaller;
import software.amazon.awssdk.services.backupgateway.transform.PutMaintenanceStartTimeRequestMarshaller;
import software.amazon.awssdk.services.backupgateway.transform.StartVirtualMachinesMetadataSyncRequestMarshaller;
import software.amazon.awssdk.services.backupgateway.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.backupgateway.transform.TestHypervisorConfigurationRequestMarshaller;
import software.amazon.awssdk.services.backupgateway.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.backupgateway.transform.UpdateGatewayInformationRequestMarshaller;
import software.amazon.awssdk.services.backupgateway.transform.UpdateGatewaySoftwareNowRequestMarshaller;
import software.amazon.awssdk.services.backupgateway.transform.UpdateHypervisorRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
final class DefaultBackupGatewayClient
implements BackupGatewayClient {
    private static final Logger log = Logger.loggerFor(DefaultBackupGatewayClient.class);
    private final SyncClientHandler clientHandler;
    private final AwsJsonProtocolFactory protocolFactory;
    private final SdkClientConfiguration clientConfiguration;

    protected DefaultBackupGatewayClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = this.init(AwsJsonProtocolFactory.builder()).build();
    }

    public final String serviceName() {
        return "backup-gateway";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AssociateGatewayToServerResponse associateGatewayToServer(AssociateGatewayToServerRequest associateGatewayToServerRequest) throws ValidationException, ConflictException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, BackupGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, AssociateGatewayToServerResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultBackupGatewayClient.resolveMetricPublishers(this.clientConfiguration, associateGatewayToServerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Backup Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"AssociateGatewayToServer");
            AssociateGatewayToServerResponse associateGatewayToServerResponse = (AssociateGatewayToServerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("AssociateGatewayToServer").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)associateGatewayToServerRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new AssociateGatewayToServerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return associateGatewayToServerResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultBackupGatewayClient.lambda$associateGatewayToServer$0((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CreateGatewayResponse createGateway(CreateGatewayRequest createGatewayRequest) throws ValidationException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, BackupGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, CreateGatewayResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultBackupGatewayClient.resolveMetricPublishers(this.clientConfiguration, createGatewayRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Backup Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"CreateGateway");
            CreateGatewayResponse createGatewayResponse = (CreateGatewayResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("CreateGateway").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)createGatewayRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new CreateGatewayRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return createGatewayResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultBackupGatewayClient.lambda$createGateway$1((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteGatewayResponse deleteGateway(DeleteGatewayRequest deleteGatewayRequest) throws ValidationException, InternalServerException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, BackupGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteGatewayResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultBackupGatewayClient.resolveMetricPublishers(this.clientConfiguration, deleteGatewayRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Backup Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteGateway");
            DeleteGatewayResponse deleteGatewayResponse = (DeleteGatewayResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteGateway").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteGatewayRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteGatewayRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteGatewayResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultBackupGatewayClient.lambda$deleteGateway$2((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DeleteHypervisorResponse deleteHypervisor(DeleteHypervisorRequest deleteHypervisorRequest) throws ValidationException, ConflictException, InternalServerException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, BackupGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DeleteHypervisorResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultBackupGatewayClient.resolveMetricPublishers(this.clientConfiguration, deleteHypervisorRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Backup Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DeleteHypervisor");
            DeleteHypervisorResponse deleteHypervisorResponse = (DeleteHypervisorResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DeleteHypervisor").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)deleteHypervisorRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DeleteHypervisorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return deleteHypervisorResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultBackupGatewayClient.lambda$deleteHypervisor$3((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DisassociateGatewayFromServerResponse disassociateGatewayFromServer(DisassociateGatewayFromServerRequest disassociateGatewayFromServerRequest) throws ValidationException, ConflictException, InternalServerException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, BackupGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, DisassociateGatewayFromServerResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultBackupGatewayClient.resolveMetricPublishers(this.clientConfiguration, disassociateGatewayFromServerRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Backup Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"DisassociateGatewayFromServer");
            DisassociateGatewayFromServerResponse disassociateGatewayFromServerResponse = (DisassociateGatewayFromServerResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("DisassociateGatewayFromServer").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)disassociateGatewayFromServerRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new DisassociateGatewayFromServerRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return disassociateGatewayFromServerResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultBackupGatewayClient.lambda$disassociateGatewayFromServer$4((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetBandwidthRateLimitScheduleResponse getBandwidthRateLimitSchedule(GetBandwidthRateLimitScheduleRequest getBandwidthRateLimitScheduleRequest) throws ValidationException, InternalServerException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, BackupGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetBandwidthRateLimitScheduleResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultBackupGatewayClient.resolveMetricPublishers(this.clientConfiguration, getBandwidthRateLimitScheduleRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Backup Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetBandwidthRateLimitSchedule");
            GetBandwidthRateLimitScheduleResponse getBandwidthRateLimitScheduleResponse = (GetBandwidthRateLimitScheduleResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetBandwidthRateLimitSchedule").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getBandwidthRateLimitScheduleRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetBandwidthRateLimitScheduleRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getBandwidthRateLimitScheduleResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultBackupGatewayClient.lambda$getBandwidthRateLimitSchedule$5((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetGatewayResponse getGateway(GetGatewayRequest getGatewayRequest) throws ValidationException, InternalServerException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, BackupGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetGatewayResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultBackupGatewayClient.resolveMetricPublishers(this.clientConfiguration, getGatewayRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Backup Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetGateway");
            GetGatewayResponse getGatewayResponse = (GetGatewayResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetGateway").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getGatewayRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetGatewayRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getGatewayResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultBackupGatewayClient.lambda$getGateway$6((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetHypervisorResponse getHypervisor(GetHypervisorRequest getHypervisorRequest) throws ValidationException, InternalServerException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, BackupGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetHypervisorResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultBackupGatewayClient.resolveMetricPublishers(this.clientConfiguration, getHypervisorRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Backup Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetHypervisor");
            GetHypervisorResponse getHypervisorResponse = (GetHypervisorResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetHypervisor").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getHypervisorRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetHypervisorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getHypervisorResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultBackupGatewayClient.lambda$getHypervisor$7((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetHypervisorPropertyMappingsResponse getHypervisorPropertyMappings(GetHypervisorPropertyMappingsRequest getHypervisorPropertyMappingsRequest) throws ValidationException, InternalServerException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, BackupGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetHypervisorPropertyMappingsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultBackupGatewayClient.resolveMetricPublishers(this.clientConfiguration, getHypervisorPropertyMappingsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Backup Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetHypervisorPropertyMappings");
            GetHypervisorPropertyMappingsResponse getHypervisorPropertyMappingsResponse = (GetHypervisorPropertyMappingsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetHypervisorPropertyMappings").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getHypervisorPropertyMappingsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetHypervisorPropertyMappingsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getHypervisorPropertyMappingsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultBackupGatewayClient.lambda$getHypervisorPropertyMappings$8((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetVirtualMachineResponse getVirtualMachine(GetVirtualMachineRequest getVirtualMachineRequest) throws ValidationException, InternalServerException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, BackupGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, GetVirtualMachineResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultBackupGatewayClient.resolveMetricPublishers(this.clientConfiguration, getVirtualMachineRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Backup Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"GetVirtualMachine");
            GetVirtualMachineResponse getVirtualMachineResponse = (GetVirtualMachineResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("GetVirtualMachine").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)getVirtualMachineRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new GetVirtualMachineRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return getVirtualMachineResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultBackupGatewayClient.lambda$getVirtualMachine$9((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ImportHypervisorConfigurationResponse importHypervisorConfiguration(ImportHypervisorConfigurationRequest importHypervisorConfigurationRequest) throws ValidationException, ConflictException, InternalServerException, AccessDeniedException, ThrottlingException, AwsServiceException, SdkClientException, BackupGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ImportHypervisorConfigurationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultBackupGatewayClient.resolveMetricPublishers(this.clientConfiguration, importHypervisorConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Backup Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ImportHypervisorConfiguration");
            ImportHypervisorConfigurationResponse importHypervisorConfigurationResponse = (ImportHypervisorConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ImportHypervisorConfiguration").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)importHypervisorConfigurationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ImportHypervisorConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return importHypervisorConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultBackupGatewayClient.lambda$importHypervisorConfiguration$10((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListGatewaysResponse listGateways(ListGatewaysRequest listGatewaysRequest) throws ValidationException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, BackupGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListGatewaysResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultBackupGatewayClient.resolveMetricPublishers(this.clientConfiguration, listGatewaysRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Backup Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListGateways");
            ListGatewaysResponse listGatewaysResponse = (ListGatewaysResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListGateways").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listGatewaysRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListGatewaysRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listGatewaysResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultBackupGatewayClient.lambda$listGateways$11((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListGatewaysIterable listGatewaysPaginator(ListGatewaysRequest listGatewaysRequest) throws ValidationException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, BackupGatewayException {
        return new ListGatewaysIterable(this, this.applyPaginatorUserAgent(listGatewaysRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListHypervisorsResponse listHypervisors(ListHypervisorsRequest listHypervisorsRequest) throws ValidationException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, BackupGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListHypervisorsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultBackupGatewayClient.resolveMetricPublishers(this.clientConfiguration, listHypervisorsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Backup Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListHypervisors");
            ListHypervisorsResponse listHypervisorsResponse = (ListHypervisorsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListHypervisors").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listHypervisorsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListHypervisorsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listHypervisorsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultBackupGatewayClient.lambda$listHypervisors$12((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListHypervisorsIterable listHypervisorsPaginator(ListHypervisorsRequest listHypervisorsRequest) throws ValidationException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, BackupGatewayException {
        return new ListHypervisorsIterable(this, this.applyPaginatorUserAgent(listHypervisorsRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest) throws ValidationException, InternalServerException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, BackupGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListTagsForResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultBackupGatewayClient.resolveMetricPublishers(this.clientConfiguration, listTagsForResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Backup Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListTagsForResource");
            ListTagsForResourceResponse listTagsForResourceResponse = (ListTagsForResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListTagsForResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listTagsForResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListTagsForResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listTagsForResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultBackupGatewayClient.lambda$listTagsForResource$13((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ListVirtualMachinesResponse listVirtualMachines(ListVirtualMachinesRequest listVirtualMachinesRequest) throws ValidationException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, BackupGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, ListVirtualMachinesResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultBackupGatewayClient.resolveMetricPublishers(this.clientConfiguration, listVirtualMachinesRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Backup Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"ListVirtualMachines");
            ListVirtualMachinesResponse listVirtualMachinesResponse = (ListVirtualMachinesResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("ListVirtualMachines").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)listVirtualMachinesRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new ListVirtualMachinesRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return listVirtualMachinesResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultBackupGatewayClient.lambda$listVirtualMachines$14((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    @Override
    public ListVirtualMachinesIterable listVirtualMachinesPaginator(ListVirtualMachinesRequest listVirtualMachinesRequest) throws ValidationException, InternalServerException, ThrottlingException, AwsServiceException, SdkClientException, BackupGatewayException {
        return new ListVirtualMachinesIterable(this, this.applyPaginatorUserAgent(listVirtualMachinesRequest));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutBandwidthRateLimitScheduleResponse putBandwidthRateLimitSchedule(PutBandwidthRateLimitScheduleRequest putBandwidthRateLimitScheduleRequest) throws ValidationException, InternalServerException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, BackupGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutBandwidthRateLimitScheduleResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultBackupGatewayClient.resolveMetricPublishers(this.clientConfiguration, putBandwidthRateLimitScheduleRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Backup Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutBandwidthRateLimitSchedule");
            PutBandwidthRateLimitScheduleResponse putBandwidthRateLimitScheduleResponse = (PutBandwidthRateLimitScheduleResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutBandwidthRateLimitSchedule").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putBandwidthRateLimitScheduleRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutBandwidthRateLimitScheduleRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putBandwidthRateLimitScheduleResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultBackupGatewayClient.lambda$putBandwidthRateLimitSchedule$15((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutHypervisorPropertyMappingsResponse putHypervisorPropertyMappings(PutHypervisorPropertyMappingsRequest putHypervisorPropertyMappingsRequest) throws ValidationException, ConflictException, InternalServerException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, BackupGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutHypervisorPropertyMappingsResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultBackupGatewayClient.resolveMetricPublishers(this.clientConfiguration, putHypervisorPropertyMappingsRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Backup Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutHypervisorPropertyMappings");
            PutHypervisorPropertyMappingsResponse putHypervisorPropertyMappingsResponse = (PutHypervisorPropertyMappingsResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutHypervisorPropertyMappings").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putHypervisorPropertyMappingsRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutHypervisorPropertyMappingsRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putHypervisorPropertyMappingsResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultBackupGatewayClient.lambda$putHypervisorPropertyMappings$16((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PutMaintenanceStartTimeResponse putMaintenanceStartTime(PutMaintenanceStartTimeRequest putMaintenanceStartTimeRequest) throws ValidationException, ConflictException, InternalServerException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, BackupGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, PutMaintenanceStartTimeResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultBackupGatewayClient.resolveMetricPublishers(this.clientConfiguration, putMaintenanceStartTimeRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Backup Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"PutMaintenanceStartTime");
            PutMaintenanceStartTimeResponse putMaintenanceStartTimeResponse = (PutMaintenanceStartTimeResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("PutMaintenanceStartTime").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)putMaintenanceStartTimeRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new PutMaintenanceStartTimeRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return putMaintenanceStartTimeResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultBackupGatewayClient.lambda$putMaintenanceStartTime$17((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StartVirtualMachinesMetadataSyncResponse startVirtualMachinesMetadataSync(StartVirtualMachinesMetadataSyncRequest startVirtualMachinesMetadataSyncRequest) throws ValidationException, InternalServerException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, BackupGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, StartVirtualMachinesMetadataSyncResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultBackupGatewayClient.resolveMetricPublishers(this.clientConfiguration, startVirtualMachinesMetadataSyncRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Backup Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"StartVirtualMachinesMetadataSync");
            StartVirtualMachinesMetadataSyncResponse startVirtualMachinesMetadataSyncResponse = (StartVirtualMachinesMetadataSyncResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("StartVirtualMachinesMetadataSync").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)startVirtualMachinesMetadataSyncRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new StartVirtualMachinesMetadataSyncRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return startVirtualMachinesMetadataSyncResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultBackupGatewayClient.lambda$startVirtualMachinesMetadataSync$18((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ValidationException, InternalServerException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, BackupGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultBackupGatewayClient.resolveMetricPublishers(this.clientConfiguration, tagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Backup Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TagResource");
            TagResourceResponse tagResourceResponse = (TagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)tagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return tagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultBackupGatewayClient.lambda$tagResource$19((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TestHypervisorConfigurationResponse testHypervisorConfiguration(TestHypervisorConfigurationRequest testHypervisorConfigurationRequest) throws ValidationException, ConflictException, InternalServerException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, BackupGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, TestHypervisorConfigurationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultBackupGatewayClient.resolveMetricPublishers(this.clientConfiguration, testHypervisorConfigurationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Backup Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"TestHypervisorConfiguration");
            TestHypervisorConfigurationResponse testHypervisorConfigurationResponse = (TestHypervisorConfigurationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("TestHypervisorConfiguration").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)testHypervisorConfigurationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new TestHypervisorConfigurationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return testHypervisorConfigurationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultBackupGatewayClient.lambda$testHypervisorConfiguration$20((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ValidationException, InternalServerException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, BackupGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UntagResourceResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultBackupGatewayClient.resolveMetricPublishers(this.clientConfiguration, untagResourceRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Backup Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UntagResource");
            UntagResourceResponse untagResourceResponse = (UntagResourceResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UntagResource").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)untagResourceRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UntagResourceRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return untagResourceResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultBackupGatewayClient.lambda$untagResource$21((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateGatewayInformationResponse updateGatewayInformation(UpdateGatewayInformationRequest updateGatewayInformationRequest) throws ValidationException, ConflictException, InternalServerException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, BackupGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateGatewayInformationResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultBackupGatewayClient.resolveMetricPublishers(this.clientConfiguration, updateGatewayInformationRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Backup Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateGatewayInformation");
            UpdateGatewayInformationResponse updateGatewayInformationResponse = (UpdateGatewayInformationResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateGatewayInformation").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateGatewayInformationRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateGatewayInformationRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateGatewayInformationResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultBackupGatewayClient.lambda$updateGatewayInformation$22((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateGatewaySoftwareNowResponse updateGatewaySoftwareNow(UpdateGatewaySoftwareNowRequest updateGatewaySoftwareNowRequest) throws ValidationException, InternalServerException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, BackupGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateGatewaySoftwareNowResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultBackupGatewayClient.resolveMetricPublishers(this.clientConfiguration, updateGatewaySoftwareNowRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Backup Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateGatewaySoftwareNow");
            UpdateGatewaySoftwareNowResponse updateGatewaySoftwareNowResponse = (UpdateGatewaySoftwareNowResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateGatewaySoftwareNow").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateGatewaySoftwareNowRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateGatewaySoftwareNowRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateGatewaySoftwareNowResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultBackupGatewayClient.lambda$updateGatewaySoftwareNow$23((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public UpdateHypervisorResponse updateHypervisor(UpdateHypervisorRequest updateHypervisorRequest) throws ValidationException, ConflictException, InternalServerException, AccessDeniedException, ResourceNotFoundException, ThrottlingException, AwsServiceException, SdkClientException, BackupGatewayException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false).isPayloadJson(true).build();
        HttpResponseHandler responseHandler = this.protocolFactory.createResponseHandler(operationMetadata, UpdateHypervisorResponse::builder);
        HttpResponseHandler<AwsServiceException> errorResponseHandler = this.createErrorResponseHandler((BaseAwsJsonProtocolFactory)this.protocolFactory, operationMetadata);
        List<MetricPublisher> metricPublishers = DefaultBackupGatewayClient.resolveMetricPublishers(this.clientConfiguration, updateHypervisorRequest.overrideConfiguration().orElse(null));
        NoOpMetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector.create((String)"ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, (Object)"Backup Gateway");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, (Object)"UpdateHypervisor");
            UpdateHypervisorResponse updateHypervisorResponse = (UpdateHypervisorResponse)this.clientHandler.execute(new ClientExecutionParams().withOperationName("UpdateHypervisor").withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler).withInput((SdkRequest)updateHypervisorRequest).withMetricCollector((MetricCollector)apiCallMetricCollector).withMarshaller((Marshaller)new UpdateHypervisorRequestMarshaller((BaseAwsJsonProtocolFactory)this.protocolFactory)));
            return updateHypervisorResponse;
        }
        finally {
            metricPublishers.forEach(arg_0 -> DefaultBackupGatewayClient.lambda$updateHypervisor$24((MetricCollector)apiCallMetricCollector, arg_0));
        }
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration, RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = (List)clientConfiguration.option((ClientOption)SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory, JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return (T)builder.clientConfiguration(this.clientConfiguration).defaultServiceExceptionSupplier(BackupGatewayException::builder).protocol(AwsJsonProtocol.AWS_JSON).protocolVersion("1.0").registerModeledException(ExceptionMetadata.builder().errorCode("AccessDeniedException").exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ConflictException").exceptionBuilderSupplier(ConflictException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ResourceNotFoundException").exceptionBuilderSupplier(ResourceNotFoundException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ThrottlingException").exceptionBuilderSupplier(ThrottlingException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("ValidationException").exceptionBuilderSupplier(ValidationException::builder).httpStatusCode(Integer.valueOf(400)).build()).registerModeledException(ExceptionMetadata.builder().errorCode("InternalServerException").exceptionBuilderSupplier(InternalServerException::builder).httpStatusCode(Integer.valueOf(500)).build());
    }

    public void close() {
        this.clientHandler.close();
    }

    private <T extends BackupGatewayRequest> T applyPaginatorUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> {
            AwsRequestOverrideConfiguration.Builder cfr_ignored_0 = (AwsRequestOverrideConfiguration.Builder)b.addApiName(ApiName.builder().version("2.19.25").name("PAGINATED").build());
        };
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((BackupGatewayRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    private static /* synthetic */ void lambda$updateHypervisor$24(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateGatewaySoftwareNow$23(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$updateGatewayInformation$22(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$untagResource$21(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$testHypervisorConfiguration$20(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$tagResource$19(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$startVirtualMachinesMetadataSync$18(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putMaintenanceStartTime$17(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putHypervisorPropertyMappings$16(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$putBandwidthRateLimitSchedule$15(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listVirtualMachines$14(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listTagsForResource$13(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listHypervisors$12(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$listGateways$11(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$importHypervisorConfiguration$10(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getVirtualMachine$9(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getHypervisorPropertyMappings$8(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getHypervisor$7(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getGateway$6(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$getBandwidthRateLimitSchedule$5(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$disassociateGatewayFromServer$4(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteHypervisor$3(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$deleteGateway$2(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$createGateway$1(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }

    private static /* synthetic */ void lambda$associateGatewayToServer$0(MetricCollector apiCallMetricCollector, MetricPublisher p) {
        p.publish(apiCallMetricCollector.collect());
    }
}

