/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.backup.model.RecoveryPointStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RecoveryPointByResource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RecoveryPointByResource> {
    private static final SdkField<String> RECOVERY_POINT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RecoveryPointByResource.getter(RecoveryPointByResource::recoveryPointArn)).setter(RecoveryPointByResource.setter(Builder::recoveryPointArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecoveryPointArn").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(RecoveryPointByResource.getter(RecoveryPointByResource::creationDate)).setter(RecoveryPointByResource.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RecoveryPointByResource.getter(RecoveryPointByResource::statusAsString)).setter(RecoveryPointByResource.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> ENCRYPTION_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RecoveryPointByResource.getter(RecoveryPointByResource::encryptionKeyArn)).setter(RecoveryPointByResource.setter(Builder::encryptionKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionKeyArn").build()}).build();
    private static final SdkField<Long> BACKUP_SIZE_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).getter(RecoveryPointByResource.getter(RecoveryPointByResource::backupSizeBytes)).setter(RecoveryPointByResource.setter(Builder::backupSizeBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupSizeBytes").build()}).build();
    private static final SdkField<String> BACKUP_VAULT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RecoveryPointByResource.getter(RecoveryPointByResource::backupVaultName)).setter(RecoveryPointByResource.setter(Builder::backupVaultName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupVaultName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECOVERY_POINT_ARN_FIELD, CREATION_DATE_FIELD, STATUS_FIELD, ENCRYPTION_KEY_ARN_FIELD, BACKUP_SIZE_BYTES_FIELD, BACKUP_VAULT_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String recoveryPointArn;
    private final Instant creationDate;
    private final String status;
    private final String encryptionKeyArn;
    private final Long backupSizeBytes;
    private final String backupVaultName;

    private RecoveryPointByResource(BuilderImpl builder) {
        this.recoveryPointArn = builder.recoveryPointArn;
        this.creationDate = builder.creationDate;
        this.status = builder.status;
        this.encryptionKeyArn = builder.encryptionKeyArn;
        this.backupSizeBytes = builder.backupSizeBytes;
        this.backupVaultName = builder.backupVaultName;
    }

    public String recoveryPointArn() {
        return this.recoveryPointArn;
    }

    public Instant creationDate() {
        return this.creationDate;
    }

    public RecoveryPointStatus status() {
        return RecoveryPointStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public String encryptionKeyArn() {
        return this.encryptionKeyArn;
    }

    public Long backupSizeBytes() {
        return this.backupSizeBytes;
    }

    public String backupVaultName() {
        return this.backupVaultName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.recoveryPointArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.backupSizeBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.backupVaultName());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecoveryPointByResource)) {
            return false;
        }
        RecoveryPointByResource other = (RecoveryPointByResource)obj;
        return Objects.equals(this.recoveryPointArn(), other.recoveryPointArn()) && Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.encryptionKeyArn(), other.encryptionKeyArn()) && Objects.equals(this.backupSizeBytes(), other.backupSizeBytes()) && Objects.equals(this.backupVaultName(), other.backupVaultName());
    }

    public String toString() {
        return ToString.builder((String)"RecoveryPointByResource").add("RecoveryPointArn", (Object)this.recoveryPointArn()).add("CreationDate", (Object)this.creationDate()).add("Status", (Object)this.statusAsString()).add("EncryptionKeyArn", (Object)this.encryptionKeyArn()).add("BackupSizeBytes", (Object)this.backupSizeBytes()).add("BackupVaultName", (Object)this.backupVaultName()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RecoveryPointArn": {
                return Optional.ofNullable(clazz.cast(this.recoveryPointArn()));
            }
            case "CreationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "EncryptionKeyArn": {
                return Optional.ofNullable(clazz.cast(this.encryptionKeyArn()));
            }
            case "BackupSizeBytes": {
                return Optional.ofNullable(clazz.cast(this.backupSizeBytes()));
            }
            case "BackupVaultName": {
                return Optional.ofNullable(clazz.cast(this.backupVaultName()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RecoveryPointByResource, T> g) {
        return obj -> g.apply((RecoveryPointByResource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String recoveryPointArn;
        private Instant creationDate;
        private String status;
        private String encryptionKeyArn;
        private Long backupSizeBytes;
        private String backupVaultName;

        private BuilderImpl() {
        }

        private BuilderImpl(RecoveryPointByResource model) {
            this.recoveryPointArn(model.recoveryPointArn);
            this.creationDate(model.creationDate);
            this.status(model.status);
            this.encryptionKeyArn(model.encryptionKeyArn);
            this.backupSizeBytes(model.backupSizeBytes);
            this.backupVaultName(model.backupVaultName);
        }

        public final String getRecoveryPointArn() {
            return this.recoveryPointArn;
        }

        @Override
        public final Builder recoveryPointArn(String recoveryPointArn) {
            this.recoveryPointArn = recoveryPointArn;
            return this;
        }

        public final void setRecoveryPointArn(String recoveryPointArn) {
            this.recoveryPointArn = recoveryPointArn;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        public final String getStatusAsString() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(RecoveryPointStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final String getEncryptionKeyArn() {
            return this.encryptionKeyArn;
        }

        @Override
        public final Builder encryptionKeyArn(String encryptionKeyArn) {
            this.encryptionKeyArn = encryptionKeyArn;
            return this;
        }

        public final void setEncryptionKeyArn(String encryptionKeyArn) {
            this.encryptionKeyArn = encryptionKeyArn;
        }

        public final Long getBackupSizeBytes() {
            return this.backupSizeBytes;
        }

        @Override
        public final Builder backupSizeBytes(Long backupSizeBytes) {
            this.backupSizeBytes = backupSizeBytes;
            return this;
        }

        public final void setBackupSizeBytes(Long backupSizeBytes) {
            this.backupSizeBytes = backupSizeBytes;
        }

        public final String getBackupVaultName() {
            return this.backupVaultName;
        }

        @Override
        public final Builder backupVaultName(String backupVaultName) {
            this.backupVaultName = backupVaultName;
            return this;
        }

        public final void setBackupVaultName(String backupVaultName) {
            this.backupVaultName = backupVaultName;
        }

        public RecoveryPointByResource build() {
            return new RecoveryPointByResource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RecoveryPointByResource> {
        public Builder recoveryPointArn(String var1);

        public Builder creationDate(Instant var1);

        public Builder status(String var1);

        public Builder status(RecoveryPointStatus var1);

        public Builder encryptionKeyArn(String var1);

        public Builder backupSizeBytes(Long var1);

        public Builder backupVaultName(String var1);
    }
}

