/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.backup.model.BackupResponse;
import software.amazon.awssdk.services.backup.model.TieringConfigurationsListCopier;
import software.amazon.awssdk.services.backup.model.TieringConfigurationsListMember;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTieringConfigurationsResponse
extends BackupResponse
implements ToCopyableBuilder<Builder, ListTieringConfigurationsResponse> {
    private static final SdkField<List<TieringConfigurationsListMember>> TIERING_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TieringConfigurations").getter(ListTieringConfigurationsResponse.getter(ListTieringConfigurationsResponse::tieringConfigurations)).setter(ListTieringConfigurationsResponse.setter(Builder::tieringConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TieringConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TieringConfigurationsListMember::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListTieringConfigurationsResponse.getter(ListTieringConfigurationsResponse::nextToken)).setter(ListTieringConfigurationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIERING_CONFIGURATIONS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListTieringConfigurationsResponse.memberNameToFieldInitializer();
    private final List<TieringConfigurationsListMember> tieringConfigurations;
    private final String nextToken;

    private ListTieringConfigurationsResponse(BuilderImpl builder) {
        super(builder);
        this.tieringConfigurations = builder.tieringConfigurations;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasTieringConfigurations() {
        return this.tieringConfigurations != null && !(this.tieringConfigurations instanceof SdkAutoConstructList);
    }

    public final List<TieringConfigurationsListMember> tieringConfigurations() {
        return this.tieringConfigurations;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTieringConfigurations() ? this.tieringConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTieringConfigurationsResponse)) {
            return false;
        }
        ListTieringConfigurationsResponse other = (ListTieringConfigurationsResponse)((Object)obj);
        return this.hasTieringConfigurations() == other.hasTieringConfigurations() && Objects.equals(this.tieringConfigurations(), other.tieringConfigurations()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListTieringConfigurationsResponse").add("TieringConfigurations", this.hasTieringConfigurations() ? this.tieringConfigurations() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TieringConfigurations": {
                return Optional.ofNullable(clazz.cast(this.tieringConfigurations()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TieringConfigurations", TIERING_CONFIGURATIONS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListTieringConfigurationsResponse, T> g) {
        return obj -> g.apply((ListTieringConfigurationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BackupResponse.BuilderImpl
    implements Builder {
        private List<TieringConfigurationsListMember> tieringConfigurations = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTieringConfigurationsResponse model) {
            super(model);
            this.tieringConfigurations(model.tieringConfigurations);
            this.nextToken(model.nextToken);
        }

        public final List<TieringConfigurationsListMember.Builder> getTieringConfigurations() {
            List<TieringConfigurationsListMember.Builder> result = TieringConfigurationsListCopier.copyToBuilder(this.tieringConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTieringConfigurations(Collection<TieringConfigurationsListMember.BuilderImpl> tieringConfigurations) {
            this.tieringConfigurations = TieringConfigurationsListCopier.copyFromBuilder(tieringConfigurations);
        }

        @Override
        public final Builder tieringConfigurations(Collection<TieringConfigurationsListMember> tieringConfigurations) {
            this.tieringConfigurations = TieringConfigurationsListCopier.copy(tieringConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tieringConfigurations(TieringConfigurationsListMember ... tieringConfigurations) {
            this.tieringConfigurations(Arrays.asList(tieringConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tieringConfigurations(Consumer<TieringConfigurationsListMember.Builder> ... tieringConfigurations) {
            this.tieringConfigurations(Stream.of(tieringConfigurations).map(c -> (TieringConfigurationsListMember)((TieringConfigurationsListMember.Builder)TieringConfigurationsListMember.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListTieringConfigurationsResponse build() {
            return new ListTieringConfigurationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BackupResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTieringConfigurationsResponse> {
        public Builder tieringConfigurations(Collection<TieringConfigurationsListMember> var1);

        public Builder tieringConfigurations(TieringConfigurationsListMember ... var1);

        public Builder tieringConfigurations(Consumer<TieringConfigurationsListMember.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

