/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.backup.model.BackupResponse;
import software.amazon.awssdk.services.backup.model.CalculatedLifecycle;
import software.amazon.awssdk.services.backup.model.EncryptionKeyType;
import software.amazon.awssdk.services.backup.model.IndexStatus;
import software.amazon.awssdk.services.backup.model.Lifecycle;
import software.amazon.awssdk.services.backup.model.RecoveryPointCreator;
import software.amazon.awssdk.services.backup.model.RecoveryPointStatus;
import software.amazon.awssdk.services.backup.model.ScanResult;
import software.amazon.awssdk.services.backup.model.ScanResultsCopier;
import software.amazon.awssdk.services.backup.model.StorageClass;
import software.amazon.awssdk.services.backup.model.VaultType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeRecoveryPointResponse
extends BackupResponse
implements ToCopyableBuilder<Builder, DescribeRecoveryPointResponse> {
    private static final SdkField<String> RECOVERY_POINT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RecoveryPointArn").getter(DescribeRecoveryPointResponse.getter(DescribeRecoveryPointResponse::recoveryPointArn)).setter(DescribeRecoveryPointResponse.setter(Builder::recoveryPointArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecoveryPointArn").build()}).build();
    private static final SdkField<String> BACKUP_VAULT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BackupVaultName").getter(DescribeRecoveryPointResponse.getter(DescribeRecoveryPointResponse::backupVaultName)).setter(DescribeRecoveryPointResponse.setter(Builder::backupVaultName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupVaultName").build()}).build();
    private static final SdkField<String> BACKUP_VAULT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BackupVaultArn").getter(DescribeRecoveryPointResponse.getter(DescribeRecoveryPointResponse::backupVaultArn)).setter(DescribeRecoveryPointResponse.setter(Builder::backupVaultArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupVaultArn").build()}).build();
    private static final SdkField<String> SOURCE_BACKUP_VAULT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SourceBackupVaultArn").getter(DescribeRecoveryPointResponse.getter(DescribeRecoveryPointResponse::sourceBackupVaultArn)).setter(DescribeRecoveryPointResponse.setter(Builder::sourceBackupVaultArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceBackupVaultArn").build()}).build();
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceArn").getter(DescribeRecoveryPointResponse.getter(DescribeRecoveryPointResponse::resourceArn)).setter(DescribeRecoveryPointResponse.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceType").getter(DescribeRecoveryPointResponse.getter(DescribeRecoveryPointResponse::resourceType)).setter(DescribeRecoveryPointResponse.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()}).build();
    private static final SdkField<RecoveryPointCreator> CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CreatedBy").getter(DescribeRecoveryPointResponse.getter(DescribeRecoveryPointResponse::createdBy)).setter(DescribeRecoveryPointResponse.setter(Builder::createdBy)).constructor(RecoveryPointCreator::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()}).build();
    private static final SdkField<String> IAM_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IamRoleArn").getter(DescribeRecoveryPointResponse.getter(DescribeRecoveryPointResponse::iamRoleArn)).setter(DescribeRecoveryPointResponse.setter(Builder::iamRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamRoleArn").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(DescribeRecoveryPointResponse.getter(DescribeRecoveryPointResponse::statusAsString)).setter(DescribeRecoveryPointResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusMessage").getter(DescribeRecoveryPointResponse.getter(DescribeRecoveryPointResponse::statusMessage)).setter(DescribeRecoveryPointResponse.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationDate").getter(DescribeRecoveryPointResponse.getter(DescribeRecoveryPointResponse::creationDate)).setter(DescribeRecoveryPointResponse.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()}).build();
    private static final SdkField<Instant> INITIATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("InitiationDate").getter(DescribeRecoveryPointResponse.getter(DescribeRecoveryPointResponse::initiationDate)).setter(DescribeRecoveryPointResponse.setter(Builder::initiationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InitiationDate").build()}).build();
    private static final SdkField<Instant> COMPLETION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CompletionDate").getter(DescribeRecoveryPointResponse.getter(DescribeRecoveryPointResponse::completionDate)).setter(DescribeRecoveryPointResponse.setter(Builder::completionDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletionDate").build()}).build();
    private static final SdkField<Long> BACKUP_SIZE_IN_BYTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("BackupSizeInBytes").getter(DescribeRecoveryPointResponse.getter(DescribeRecoveryPointResponse::backupSizeInBytes)).setter(DescribeRecoveryPointResponse.setter(Builder::backupSizeInBytes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupSizeInBytes").build()}).build();
    private static final SdkField<CalculatedLifecycle> CALCULATED_LIFECYCLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CalculatedLifecycle").getter(DescribeRecoveryPointResponse.getter(DescribeRecoveryPointResponse::calculatedLifecycle)).setter(DescribeRecoveryPointResponse.setter(Builder::calculatedLifecycle)).constructor(CalculatedLifecycle::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CalculatedLifecycle").build()}).build();
    private static final SdkField<Lifecycle> LIFECYCLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Lifecycle").getter(DescribeRecoveryPointResponse.getter(DescribeRecoveryPointResponse::lifecycle)).setter(DescribeRecoveryPointResponse.setter(Builder::lifecycle)).constructor(Lifecycle::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Lifecycle").build()}).build();
    private static final SdkField<String> ENCRYPTION_KEY_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EncryptionKeyArn").getter(DescribeRecoveryPointResponse.getter(DescribeRecoveryPointResponse::encryptionKeyArn)).setter(DescribeRecoveryPointResponse.setter(Builder::encryptionKeyArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionKeyArn").build()}).build();
    private static final SdkField<Boolean> IS_ENCRYPTED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsEncrypted").getter(DescribeRecoveryPointResponse.getter(DescribeRecoveryPointResponse::isEncrypted)).setter(DescribeRecoveryPointResponse.setter(Builder::isEncrypted)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsEncrypted").build()}).build();
    private static final SdkField<String> STORAGE_CLASS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StorageClass").getter(DescribeRecoveryPointResponse.getter(DescribeRecoveryPointResponse::storageClassAsString)).setter(DescribeRecoveryPointResponse.setter(Builder::storageClass)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageClass").build()}).build();
    private static final SdkField<Instant> LAST_RESTORE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastRestoreTime").getter(DescribeRecoveryPointResponse.getter(DescribeRecoveryPointResponse::lastRestoreTime)).setter(DescribeRecoveryPointResponse.setter(Builder::lastRestoreTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastRestoreTime").build()}).build();
    private static final SdkField<String> PARENT_RECOVERY_POINT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ParentRecoveryPointArn").getter(DescribeRecoveryPointResponse.getter(DescribeRecoveryPointResponse::parentRecoveryPointArn)).setter(DescribeRecoveryPointResponse.setter(Builder::parentRecoveryPointArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParentRecoveryPointArn").build()}).build();
    private static final SdkField<String> COMPOSITE_MEMBER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CompositeMemberIdentifier").getter(DescribeRecoveryPointResponse.getter(DescribeRecoveryPointResponse::compositeMemberIdentifier)).setter(DescribeRecoveryPointResponse.setter(Builder::compositeMemberIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompositeMemberIdentifier").build()}).build();
    private static final SdkField<Boolean> IS_PARENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("IsParent").getter(DescribeRecoveryPointResponse.getter(DescribeRecoveryPointResponse::isParent)).setter(DescribeRecoveryPointResponse.setter(Builder::isParent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsParent").build()}).build();
    private static final SdkField<String> RESOURCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceName").getter(DescribeRecoveryPointResponse.getter(DescribeRecoveryPointResponse::resourceName)).setter(DescribeRecoveryPointResponse.setter(Builder::resourceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceName").build()}).build();
    private static final SdkField<String> VAULT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VaultType").getter(DescribeRecoveryPointResponse.getter(DescribeRecoveryPointResponse::vaultTypeAsString)).setter(DescribeRecoveryPointResponse.setter(Builder::vaultType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VaultType").build()}).build();
    private static final SdkField<String> INDEX_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IndexStatus").getter(DescribeRecoveryPointResponse.getter(DescribeRecoveryPointResponse::indexStatusAsString)).setter(DescribeRecoveryPointResponse.setter(Builder::indexStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexStatus").build()}).build();
    private static final SdkField<String> INDEX_STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IndexStatusMessage").getter(DescribeRecoveryPointResponse.getter(DescribeRecoveryPointResponse::indexStatusMessage)).setter(DescribeRecoveryPointResponse.setter(Builder::indexStatusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IndexStatusMessage").build()}).build();
    private static final SdkField<String> ENCRYPTION_KEY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EncryptionKeyType").getter(DescribeRecoveryPointResponse.getter(DescribeRecoveryPointResponse::encryptionKeyTypeAsString)).setter(DescribeRecoveryPointResponse.setter(Builder::encryptionKeyType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EncryptionKeyType").build()}).build();
    private static final SdkField<List<ScanResult>> SCAN_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ScanResults").getter(DescribeRecoveryPointResponse.getter(DescribeRecoveryPointResponse::scanResults)).setter(DescribeRecoveryPointResponse.setter(Builder::scanResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScanResults").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ScanResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECOVERY_POINT_ARN_FIELD, BACKUP_VAULT_NAME_FIELD, BACKUP_VAULT_ARN_FIELD, SOURCE_BACKUP_VAULT_ARN_FIELD, RESOURCE_ARN_FIELD, RESOURCE_TYPE_FIELD, CREATED_BY_FIELD, IAM_ROLE_ARN_FIELD, STATUS_FIELD, STATUS_MESSAGE_FIELD, CREATION_DATE_FIELD, INITIATION_DATE_FIELD, COMPLETION_DATE_FIELD, BACKUP_SIZE_IN_BYTES_FIELD, CALCULATED_LIFECYCLE_FIELD, LIFECYCLE_FIELD, ENCRYPTION_KEY_ARN_FIELD, IS_ENCRYPTED_FIELD, STORAGE_CLASS_FIELD, LAST_RESTORE_TIME_FIELD, PARENT_RECOVERY_POINT_ARN_FIELD, COMPOSITE_MEMBER_IDENTIFIER_FIELD, IS_PARENT_FIELD, RESOURCE_NAME_FIELD, VAULT_TYPE_FIELD, INDEX_STATUS_FIELD, INDEX_STATUS_MESSAGE_FIELD, ENCRYPTION_KEY_TYPE_FIELD, SCAN_RESULTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeRecoveryPointResponse.memberNameToFieldInitializer();
    private final String recoveryPointArn;
    private final String backupVaultName;
    private final String backupVaultArn;
    private final String sourceBackupVaultArn;
    private final String resourceArn;
    private final String resourceType;
    private final RecoveryPointCreator createdBy;
    private final String iamRoleArn;
    private final String status;
    private final String statusMessage;
    private final Instant creationDate;
    private final Instant initiationDate;
    private final Instant completionDate;
    private final Long backupSizeInBytes;
    private final CalculatedLifecycle calculatedLifecycle;
    private final Lifecycle lifecycle;
    private final String encryptionKeyArn;
    private final Boolean isEncrypted;
    private final String storageClass;
    private final Instant lastRestoreTime;
    private final String parentRecoveryPointArn;
    private final String compositeMemberIdentifier;
    private final Boolean isParent;
    private final String resourceName;
    private final String vaultType;
    private final String indexStatus;
    private final String indexStatusMessage;
    private final String encryptionKeyType;
    private final List<ScanResult> scanResults;

    private DescribeRecoveryPointResponse(BuilderImpl builder) {
        super(builder);
        this.recoveryPointArn = builder.recoveryPointArn;
        this.backupVaultName = builder.backupVaultName;
        this.backupVaultArn = builder.backupVaultArn;
        this.sourceBackupVaultArn = builder.sourceBackupVaultArn;
        this.resourceArn = builder.resourceArn;
        this.resourceType = builder.resourceType;
        this.createdBy = builder.createdBy;
        this.iamRoleArn = builder.iamRoleArn;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.creationDate = builder.creationDate;
        this.initiationDate = builder.initiationDate;
        this.completionDate = builder.completionDate;
        this.backupSizeInBytes = builder.backupSizeInBytes;
        this.calculatedLifecycle = builder.calculatedLifecycle;
        this.lifecycle = builder.lifecycle;
        this.encryptionKeyArn = builder.encryptionKeyArn;
        this.isEncrypted = builder.isEncrypted;
        this.storageClass = builder.storageClass;
        this.lastRestoreTime = builder.lastRestoreTime;
        this.parentRecoveryPointArn = builder.parentRecoveryPointArn;
        this.compositeMemberIdentifier = builder.compositeMemberIdentifier;
        this.isParent = builder.isParent;
        this.resourceName = builder.resourceName;
        this.vaultType = builder.vaultType;
        this.indexStatus = builder.indexStatus;
        this.indexStatusMessage = builder.indexStatusMessage;
        this.encryptionKeyType = builder.encryptionKeyType;
        this.scanResults = builder.scanResults;
    }

    public final String recoveryPointArn() {
        return this.recoveryPointArn;
    }

    public final String backupVaultName() {
        return this.backupVaultName;
    }

    public final String backupVaultArn() {
        return this.backupVaultArn;
    }

    public final String sourceBackupVaultArn() {
        return this.sourceBackupVaultArn;
    }

    public final String resourceArn() {
        return this.resourceArn;
    }

    public final String resourceType() {
        return this.resourceType;
    }

    public final RecoveryPointCreator createdBy() {
        return this.createdBy;
    }

    public final String iamRoleArn() {
        return this.iamRoleArn;
    }

    public final RecoveryPointStatus status() {
        return RecoveryPointStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public final Instant creationDate() {
        return this.creationDate;
    }

    public final Instant initiationDate() {
        return this.initiationDate;
    }

    public final Instant completionDate() {
        return this.completionDate;
    }

    public final Long backupSizeInBytes() {
        return this.backupSizeInBytes;
    }

    public final CalculatedLifecycle calculatedLifecycle() {
        return this.calculatedLifecycle;
    }

    public final Lifecycle lifecycle() {
        return this.lifecycle;
    }

    public final String encryptionKeyArn() {
        return this.encryptionKeyArn;
    }

    public final Boolean isEncrypted() {
        return this.isEncrypted;
    }

    public final StorageClass storageClass() {
        return StorageClass.fromValue(this.storageClass);
    }

    public final String storageClassAsString() {
        return this.storageClass;
    }

    public final Instant lastRestoreTime() {
        return this.lastRestoreTime;
    }

    public final String parentRecoveryPointArn() {
        return this.parentRecoveryPointArn;
    }

    public final String compositeMemberIdentifier() {
        return this.compositeMemberIdentifier;
    }

    public final Boolean isParent() {
        return this.isParent;
    }

    public final String resourceName() {
        return this.resourceName;
    }

    public final VaultType vaultType() {
        return VaultType.fromValue(this.vaultType);
    }

    public final String vaultTypeAsString() {
        return this.vaultType;
    }

    public final IndexStatus indexStatus() {
        return IndexStatus.fromValue(this.indexStatus);
    }

    public final String indexStatusAsString() {
        return this.indexStatus;
    }

    public final String indexStatusMessage() {
        return this.indexStatusMessage;
    }

    public final EncryptionKeyType encryptionKeyType() {
        return EncryptionKeyType.fromValue(this.encryptionKeyType);
    }

    public final String encryptionKeyTypeAsString() {
        return this.encryptionKeyType;
    }

    public final boolean hasScanResults() {
        return this.scanResults != null && !(this.scanResults instanceof SdkAutoConstructList);
    }

    public final List<ScanResult> scanResults() {
        return this.scanResults;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.recoveryPointArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.backupVaultName());
        hashCode = 31 * hashCode + Objects.hashCode(this.backupVaultArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceBackupVaultArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.initiationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.completionDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.backupSizeInBytes());
        hashCode = 31 * hashCode + Objects.hashCode(this.calculatedLifecycle());
        hashCode = 31 * hashCode + Objects.hashCode(this.lifecycle());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionKeyArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.isEncrypted());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageClassAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastRestoreTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.parentRecoveryPointArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.compositeMemberIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.isParent());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.vaultTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.indexStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.indexStatusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.encryptionKeyTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasScanResults() ? this.scanResults() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeRecoveryPointResponse)) {
            return false;
        }
        DescribeRecoveryPointResponse other = (DescribeRecoveryPointResponse)((Object)obj);
        return Objects.equals(this.recoveryPointArn(), other.recoveryPointArn()) && Objects.equals(this.backupVaultName(), other.backupVaultName()) && Objects.equals(this.backupVaultArn(), other.backupVaultArn()) && Objects.equals(this.sourceBackupVaultArn(), other.sourceBackupVaultArn()) && Objects.equals(this.resourceArn(), other.resourceArn()) && Objects.equals(this.resourceType(), other.resourceType()) && Objects.equals(this.createdBy(), other.createdBy()) && Objects.equals(this.iamRoleArn(), other.iamRoleArn()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.statusMessage(), other.statusMessage()) && Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.initiationDate(), other.initiationDate()) && Objects.equals(this.completionDate(), other.completionDate()) && Objects.equals(this.backupSizeInBytes(), other.backupSizeInBytes()) && Objects.equals(this.calculatedLifecycle(), other.calculatedLifecycle()) && Objects.equals(this.lifecycle(), other.lifecycle()) && Objects.equals(this.encryptionKeyArn(), other.encryptionKeyArn()) && Objects.equals(this.isEncrypted(), other.isEncrypted()) && Objects.equals(this.storageClassAsString(), other.storageClassAsString()) && Objects.equals(this.lastRestoreTime(), other.lastRestoreTime()) && Objects.equals(this.parentRecoveryPointArn(), other.parentRecoveryPointArn()) && Objects.equals(this.compositeMemberIdentifier(), other.compositeMemberIdentifier()) && Objects.equals(this.isParent(), other.isParent()) && Objects.equals(this.resourceName(), other.resourceName()) && Objects.equals(this.vaultTypeAsString(), other.vaultTypeAsString()) && Objects.equals(this.indexStatusAsString(), other.indexStatusAsString()) && Objects.equals(this.indexStatusMessage(), other.indexStatusMessage()) && Objects.equals(this.encryptionKeyTypeAsString(), other.encryptionKeyTypeAsString()) && this.hasScanResults() == other.hasScanResults() && Objects.equals(this.scanResults(), other.scanResults());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeRecoveryPointResponse").add("RecoveryPointArn", (Object)this.recoveryPointArn()).add("BackupVaultName", (Object)this.backupVaultName()).add("BackupVaultArn", (Object)this.backupVaultArn()).add("SourceBackupVaultArn", (Object)this.sourceBackupVaultArn()).add("ResourceArn", (Object)this.resourceArn()).add("ResourceType", (Object)this.resourceType()).add("CreatedBy", (Object)this.createdBy()).add("IamRoleArn", (Object)this.iamRoleArn()).add("Status", (Object)this.statusAsString()).add("StatusMessage", (Object)this.statusMessage()).add("CreationDate", (Object)this.creationDate()).add("InitiationDate", (Object)this.initiationDate()).add("CompletionDate", (Object)this.completionDate()).add("BackupSizeInBytes", (Object)this.backupSizeInBytes()).add("CalculatedLifecycle", (Object)this.calculatedLifecycle()).add("Lifecycle", (Object)this.lifecycle()).add("EncryptionKeyArn", (Object)this.encryptionKeyArn()).add("IsEncrypted", (Object)this.isEncrypted()).add("StorageClass", (Object)this.storageClassAsString()).add("LastRestoreTime", (Object)this.lastRestoreTime()).add("ParentRecoveryPointArn", (Object)this.parentRecoveryPointArn()).add("CompositeMemberIdentifier", (Object)this.compositeMemberIdentifier()).add("IsParent", (Object)this.isParent()).add("ResourceName", (Object)this.resourceName()).add("VaultType", (Object)this.vaultTypeAsString()).add("IndexStatus", (Object)this.indexStatusAsString()).add("IndexStatusMessage", (Object)this.indexStatusMessage()).add("EncryptionKeyType", (Object)this.encryptionKeyTypeAsString()).add("ScanResults", this.hasScanResults() ? this.scanResults() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RecoveryPointArn": {
                return Optional.ofNullable(clazz.cast(this.recoveryPointArn()));
            }
            case "BackupVaultName": {
                return Optional.ofNullable(clazz.cast(this.backupVaultName()));
            }
            case "BackupVaultArn": {
                return Optional.ofNullable(clazz.cast(this.backupVaultArn()));
            }
            case "SourceBackupVaultArn": {
                return Optional.ofNullable(clazz.cast(this.sourceBackupVaultArn()));
            }
            case "ResourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceType()));
            }
            case "CreatedBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
            case "IamRoleArn": {
                return Optional.ofNullable(clazz.cast(this.iamRoleArn()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "StatusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
            case "CreationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
            case "InitiationDate": {
                return Optional.ofNullable(clazz.cast(this.initiationDate()));
            }
            case "CompletionDate": {
                return Optional.ofNullable(clazz.cast(this.completionDate()));
            }
            case "BackupSizeInBytes": {
                return Optional.ofNullable(clazz.cast(this.backupSizeInBytes()));
            }
            case "CalculatedLifecycle": {
                return Optional.ofNullable(clazz.cast(this.calculatedLifecycle()));
            }
            case "Lifecycle": {
                return Optional.ofNullable(clazz.cast(this.lifecycle()));
            }
            case "EncryptionKeyArn": {
                return Optional.ofNullable(clazz.cast(this.encryptionKeyArn()));
            }
            case "IsEncrypted": {
                return Optional.ofNullable(clazz.cast(this.isEncrypted()));
            }
            case "StorageClass": {
                return Optional.ofNullable(clazz.cast(this.storageClassAsString()));
            }
            case "LastRestoreTime": {
                return Optional.ofNullable(clazz.cast(this.lastRestoreTime()));
            }
            case "ParentRecoveryPointArn": {
                return Optional.ofNullable(clazz.cast(this.parentRecoveryPointArn()));
            }
            case "CompositeMemberIdentifier": {
                return Optional.ofNullable(clazz.cast(this.compositeMemberIdentifier()));
            }
            case "IsParent": {
                return Optional.ofNullable(clazz.cast(this.isParent()));
            }
            case "ResourceName": {
                return Optional.ofNullable(clazz.cast(this.resourceName()));
            }
            case "VaultType": {
                return Optional.ofNullable(clazz.cast(this.vaultTypeAsString()));
            }
            case "IndexStatus": {
                return Optional.ofNullable(clazz.cast(this.indexStatusAsString()));
            }
            case "IndexStatusMessage": {
                return Optional.ofNullable(clazz.cast(this.indexStatusMessage()));
            }
            case "EncryptionKeyType": {
                return Optional.ofNullable(clazz.cast(this.encryptionKeyTypeAsString()));
            }
            case "ScanResults": {
                return Optional.ofNullable(clazz.cast(this.scanResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("RecoveryPointArn", RECOVERY_POINT_ARN_FIELD);
        map.put("BackupVaultName", BACKUP_VAULT_NAME_FIELD);
        map.put("BackupVaultArn", BACKUP_VAULT_ARN_FIELD);
        map.put("SourceBackupVaultArn", SOURCE_BACKUP_VAULT_ARN_FIELD);
        map.put("ResourceArn", RESOURCE_ARN_FIELD);
        map.put("ResourceType", RESOURCE_TYPE_FIELD);
        map.put("CreatedBy", CREATED_BY_FIELD);
        map.put("IamRoleArn", IAM_ROLE_ARN_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("StatusMessage", STATUS_MESSAGE_FIELD);
        map.put("CreationDate", CREATION_DATE_FIELD);
        map.put("InitiationDate", INITIATION_DATE_FIELD);
        map.put("CompletionDate", COMPLETION_DATE_FIELD);
        map.put("BackupSizeInBytes", BACKUP_SIZE_IN_BYTES_FIELD);
        map.put("CalculatedLifecycle", CALCULATED_LIFECYCLE_FIELD);
        map.put("Lifecycle", LIFECYCLE_FIELD);
        map.put("EncryptionKeyArn", ENCRYPTION_KEY_ARN_FIELD);
        map.put("IsEncrypted", IS_ENCRYPTED_FIELD);
        map.put("StorageClass", STORAGE_CLASS_FIELD);
        map.put("LastRestoreTime", LAST_RESTORE_TIME_FIELD);
        map.put("ParentRecoveryPointArn", PARENT_RECOVERY_POINT_ARN_FIELD);
        map.put("CompositeMemberIdentifier", COMPOSITE_MEMBER_IDENTIFIER_FIELD);
        map.put("IsParent", IS_PARENT_FIELD);
        map.put("ResourceName", RESOURCE_NAME_FIELD);
        map.put("VaultType", VAULT_TYPE_FIELD);
        map.put("IndexStatus", INDEX_STATUS_FIELD);
        map.put("IndexStatusMessage", INDEX_STATUS_MESSAGE_FIELD);
        map.put("EncryptionKeyType", ENCRYPTION_KEY_TYPE_FIELD);
        map.put("ScanResults", SCAN_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeRecoveryPointResponse, T> g) {
        return obj -> g.apply((DescribeRecoveryPointResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BackupResponse.BuilderImpl
    implements Builder {
        private String recoveryPointArn;
        private String backupVaultName;
        private String backupVaultArn;
        private String sourceBackupVaultArn;
        private String resourceArn;
        private String resourceType;
        private RecoveryPointCreator createdBy;
        private String iamRoleArn;
        private String status;
        private String statusMessage;
        private Instant creationDate;
        private Instant initiationDate;
        private Instant completionDate;
        private Long backupSizeInBytes;
        private CalculatedLifecycle calculatedLifecycle;
        private Lifecycle lifecycle;
        private String encryptionKeyArn;
        private Boolean isEncrypted;
        private String storageClass;
        private Instant lastRestoreTime;
        private String parentRecoveryPointArn;
        private String compositeMemberIdentifier;
        private Boolean isParent;
        private String resourceName;
        private String vaultType;
        private String indexStatus;
        private String indexStatusMessage;
        private String encryptionKeyType;
        private List<ScanResult> scanResults = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeRecoveryPointResponse model) {
            super(model);
            this.recoveryPointArn(model.recoveryPointArn);
            this.backupVaultName(model.backupVaultName);
            this.backupVaultArn(model.backupVaultArn);
            this.sourceBackupVaultArn(model.sourceBackupVaultArn);
            this.resourceArn(model.resourceArn);
            this.resourceType(model.resourceType);
            this.createdBy(model.createdBy);
            this.iamRoleArn(model.iamRoleArn);
            this.status(model.status);
            this.statusMessage(model.statusMessage);
            this.creationDate(model.creationDate);
            this.initiationDate(model.initiationDate);
            this.completionDate(model.completionDate);
            this.backupSizeInBytes(model.backupSizeInBytes);
            this.calculatedLifecycle(model.calculatedLifecycle);
            this.lifecycle(model.lifecycle);
            this.encryptionKeyArn(model.encryptionKeyArn);
            this.isEncrypted(model.isEncrypted);
            this.storageClass(model.storageClass);
            this.lastRestoreTime(model.lastRestoreTime);
            this.parentRecoveryPointArn(model.parentRecoveryPointArn);
            this.compositeMemberIdentifier(model.compositeMemberIdentifier);
            this.isParent(model.isParent);
            this.resourceName(model.resourceName);
            this.vaultType(model.vaultType);
            this.indexStatus(model.indexStatus);
            this.indexStatusMessage(model.indexStatusMessage);
            this.encryptionKeyType(model.encryptionKeyType);
            this.scanResults(model.scanResults);
        }

        public final String getRecoveryPointArn() {
            return this.recoveryPointArn;
        }

        public final void setRecoveryPointArn(String recoveryPointArn) {
            this.recoveryPointArn = recoveryPointArn;
        }

        @Override
        public final Builder recoveryPointArn(String recoveryPointArn) {
            this.recoveryPointArn = recoveryPointArn;
            return this;
        }

        public final String getBackupVaultName() {
            return this.backupVaultName;
        }

        public final void setBackupVaultName(String backupVaultName) {
            this.backupVaultName = backupVaultName;
        }

        @Override
        public final Builder backupVaultName(String backupVaultName) {
            this.backupVaultName = backupVaultName;
            return this;
        }

        public final String getBackupVaultArn() {
            return this.backupVaultArn;
        }

        public final void setBackupVaultArn(String backupVaultArn) {
            this.backupVaultArn = backupVaultArn;
        }

        @Override
        public final Builder backupVaultArn(String backupVaultArn) {
            this.backupVaultArn = backupVaultArn;
            return this;
        }

        public final String getSourceBackupVaultArn() {
            return this.sourceBackupVaultArn;
        }

        public final void setSourceBackupVaultArn(String sourceBackupVaultArn) {
            this.sourceBackupVaultArn = sourceBackupVaultArn;
        }

        @Override
        public final Builder sourceBackupVaultArn(String sourceBackupVaultArn) {
            this.sourceBackupVaultArn = sourceBackupVaultArn;
            return this;
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final RecoveryPointCreator.Builder getCreatedBy() {
            return this.createdBy != null ? this.createdBy.toBuilder() : null;
        }

        public final void setCreatedBy(RecoveryPointCreator.BuilderImpl createdBy) {
            this.createdBy = createdBy != null ? createdBy.build() : null;
        }

        @Override
        public final Builder createdBy(RecoveryPointCreator createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final String getIamRoleArn() {
            return this.iamRoleArn;
        }

        public final void setIamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
        }

        @Override
        public final Builder iamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(RecoveryPointStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final Instant getInitiationDate() {
            return this.initiationDate;
        }

        public final void setInitiationDate(Instant initiationDate) {
            this.initiationDate = initiationDate;
        }

        @Override
        public final Builder initiationDate(Instant initiationDate) {
            this.initiationDate = initiationDate;
            return this;
        }

        public final Instant getCompletionDate() {
            return this.completionDate;
        }

        public final void setCompletionDate(Instant completionDate) {
            this.completionDate = completionDate;
        }

        @Override
        public final Builder completionDate(Instant completionDate) {
            this.completionDate = completionDate;
            return this;
        }

        public final Long getBackupSizeInBytes() {
            return this.backupSizeInBytes;
        }

        public final void setBackupSizeInBytes(Long backupSizeInBytes) {
            this.backupSizeInBytes = backupSizeInBytes;
        }

        @Override
        public final Builder backupSizeInBytes(Long backupSizeInBytes) {
            this.backupSizeInBytes = backupSizeInBytes;
            return this;
        }

        public final CalculatedLifecycle.Builder getCalculatedLifecycle() {
            return this.calculatedLifecycle != null ? this.calculatedLifecycle.toBuilder() : null;
        }

        public final void setCalculatedLifecycle(CalculatedLifecycle.BuilderImpl calculatedLifecycle) {
            this.calculatedLifecycle = calculatedLifecycle != null ? calculatedLifecycle.build() : null;
        }

        @Override
        public final Builder calculatedLifecycle(CalculatedLifecycle calculatedLifecycle) {
            this.calculatedLifecycle = calculatedLifecycle;
            return this;
        }

        public final Lifecycle.Builder getLifecycle() {
            return this.lifecycle != null ? this.lifecycle.toBuilder() : null;
        }

        public final void setLifecycle(Lifecycle.BuilderImpl lifecycle) {
            this.lifecycle = lifecycle != null ? lifecycle.build() : null;
        }

        @Override
        public final Builder lifecycle(Lifecycle lifecycle) {
            this.lifecycle = lifecycle;
            return this;
        }

        public final String getEncryptionKeyArn() {
            return this.encryptionKeyArn;
        }

        public final void setEncryptionKeyArn(String encryptionKeyArn) {
            this.encryptionKeyArn = encryptionKeyArn;
        }

        @Override
        public final Builder encryptionKeyArn(String encryptionKeyArn) {
            this.encryptionKeyArn = encryptionKeyArn;
            return this;
        }

        public final Boolean getIsEncrypted() {
            return this.isEncrypted;
        }

        public final void setIsEncrypted(Boolean isEncrypted) {
            this.isEncrypted = isEncrypted;
        }

        @Override
        public final Builder isEncrypted(Boolean isEncrypted) {
            this.isEncrypted = isEncrypted;
            return this;
        }

        public final String getStorageClass() {
            return this.storageClass;
        }

        public final void setStorageClass(String storageClass) {
            this.storageClass = storageClass;
        }

        @Override
        public final Builder storageClass(String storageClass) {
            this.storageClass = storageClass;
            return this;
        }

        @Override
        public final Builder storageClass(StorageClass storageClass) {
            this.storageClass(storageClass == null ? null : storageClass.toString());
            return this;
        }

        public final Instant getLastRestoreTime() {
            return this.lastRestoreTime;
        }

        public final void setLastRestoreTime(Instant lastRestoreTime) {
            this.lastRestoreTime = lastRestoreTime;
        }

        @Override
        public final Builder lastRestoreTime(Instant lastRestoreTime) {
            this.lastRestoreTime = lastRestoreTime;
            return this;
        }

        public final String getParentRecoveryPointArn() {
            return this.parentRecoveryPointArn;
        }

        public final void setParentRecoveryPointArn(String parentRecoveryPointArn) {
            this.parentRecoveryPointArn = parentRecoveryPointArn;
        }

        @Override
        public final Builder parentRecoveryPointArn(String parentRecoveryPointArn) {
            this.parentRecoveryPointArn = parentRecoveryPointArn;
            return this;
        }

        public final String getCompositeMemberIdentifier() {
            return this.compositeMemberIdentifier;
        }

        public final void setCompositeMemberIdentifier(String compositeMemberIdentifier) {
            this.compositeMemberIdentifier = compositeMemberIdentifier;
        }

        @Override
        public final Builder compositeMemberIdentifier(String compositeMemberIdentifier) {
            this.compositeMemberIdentifier = compositeMemberIdentifier;
            return this;
        }

        public final Boolean getIsParent() {
            return this.isParent;
        }

        public final void setIsParent(Boolean isParent) {
            this.isParent = isParent;
        }

        @Override
        public final Builder isParent(Boolean isParent) {
            this.isParent = isParent;
            return this;
        }

        public final String getResourceName() {
            return this.resourceName;
        }

        public final void setResourceName(String resourceName) {
            this.resourceName = resourceName;
        }

        @Override
        public final Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        public final String getVaultType() {
            return this.vaultType;
        }

        public final void setVaultType(String vaultType) {
            this.vaultType = vaultType;
        }

        @Override
        public final Builder vaultType(String vaultType) {
            this.vaultType = vaultType;
            return this;
        }

        @Override
        public final Builder vaultType(VaultType vaultType) {
            this.vaultType(vaultType == null ? null : vaultType.toString());
            return this;
        }

        public final String getIndexStatus() {
            return this.indexStatus;
        }

        public final void setIndexStatus(String indexStatus) {
            this.indexStatus = indexStatus;
        }

        @Override
        public final Builder indexStatus(String indexStatus) {
            this.indexStatus = indexStatus;
            return this;
        }

        @Override
        public final Builder indexStatus(IndexStatus indexStatus) {
            this.indexStatus(indexStatus == null ? null : indexStatus.toString());
            return this;
        }

        public final String getIndexStatusMessage() {
            return this.indexStatusMessage;
        }

        public final void setIndexStatusMessage(String indexStatusMessage) {
            this.indexStatusMessage = indexStatusMessage;
        }

        @Override
        public final Builder indexStatusMessage(String indexStatusMessage) {
            this.indexStatusMessage = indexStatusMessage;
            return this;
        }

        public final String getEncryptionKeyType() {
            return this.encryptionKeyType;
        }

        public final void setEncryptionKeyType(String encryptionKeyType) {
            this.encryptionKeyType = encryptionKeyType;
        }

        @Override
        public final Builder encryptionKeyType(String encryptionKeyType) {
            this.encryptionKeyType = encryptionKeyType;
            return this;
        }

        @Override
        public final Builder encryptionKeyType(EncryptionKeyType encryptionKeyType) {
            this.encryptionKeyType(encryptionKeyType == null ? null : encryptionKeyType.toString());
            return this;
        }

        public final List<ScanResult.Builder> getScanResults() {
            List<ScanResult.Builder> result = ScanResultsCopier.copyToBuilder(this.scanResults);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setScanResults(Collection<ScanResult.BuilderImpl> scanResults) {
            this.scanResults = ScanResultsCopier.copyFromBuilder(scanResults);
        }

        @Override
        public final Builder scanResults(Collection<ScanResult> scanResults) {
            this.scanResults = ScanResultsCopier.copy(scanResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scanResults(ScanResult ... scanResults) {
            this.scanResults(Arrays.asList(scanResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scanResults(Consumer<ScanResult.Builder> ... scanResults) {
            this.scanResults(Stream.of(scanResults).map(c -> (ScanResult)((ScanResult.Builder)ScanResult.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public DescribeRecoveryPointResponse build() {
            return new DescribeRecoveryPointResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BackupResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeRecoveryPointResponse> {
        public Builder recoveryPointArn(String var1);

        public Builder backupVaultName(String var1);

        public Builder backupVaultArn(String var1);

        public Builder sourceBackupVaultArn(String var1);

        public Builder resourceArn(String var1);

        public Builder resourceType(String var1);

        public Builder createdBy(RecoveryPointCreator var1);

        default public Builder createdBy(Consumer<RecoveryPointCreator.Builder> createdBy) {
            return this.createdBy((RecoveryPointCreator)((RecoveryPointCreator.Builder)RecoveryPointCreator.builder().applyMutation(createdBy)).build());
        }

        public Builder iamRoleArn(String var1);

        public Builder status(String var1);

        public Builder status(RecoveryPointStatus var1);

        public Builder statusMessage(String var1);

        public Builder creationDate(Instant var1);

        public Builder initiationDate(Instant var1);

        public Builder completionDate(Instant var1);

        public Builder backupSizeInBytes(Long var1);

        public Builder calculatedLifecycle(CalculatedLifecycle var1);

        default public Builder calculatedLifecycle(Consumer<CalculatedLifecycle.Builder> calculatedLifecycle) {
            return this.calculatedLifecycle((CalculatedLifecycle)((CalculatedLifecycle.Builder)CalculatedLifecycle.builder().applyMutation(calculatedLifecycle)).build());
        }

        public Builder lifecycle(Lifecycle var1);

        default public Builder lifecycle(Consumer<Lifecycle.Builder> lifecycle) {
            return this.lifecycle((Lifecycle)((Lifecycle.Builder)Lifecycle.builder().applyMutation(lifecycle)).build());
        }

        public Builder encryptionKeyArn(String var1);

        public Builder isEncrypted(Boolean var1);

        public Builder storageClass(String var1);

        public Builder storageClass(StorageClass var1);

        public Builder lastRestoreTime(Instant var1);

        public Builder parentRecoveryPointArn(String var1);

        public Builder compositeMemberIdentifier(String var1);

        public Builder isParent(Boolean var1);

        public Builder resourceName(String var1);

        public Builder vaultType(String var1);

        public Builder vaultType(VaultType var1);

        public Builder indexStatus(String var1);

        public Builder indexStatus(IndexStatus var1);

        public Builder indexStatusMessage(String var1);

        public Builder encryptionKeyType(String var1);

        public Builder encryptionKeyType(EncryptionKeyType var1);

        public Builder scanResults(Collection<ScanResult> var1);

        public Builder scanResults(ScanResult ... var1);

        public Builder scanResults(Consumer<ScanResult.Builder> ... var1);
    }
}

