/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.backup.BackupClient;
import software.amazon.awssdk.services.backup.internal.UserAgentUtils;
import software.amazon.awssdk.services.backup.model.ListTagsRequest;
import software.amazon.awssdk.services.backup.model.ListTagsResponse;

public class ListTagsIterable
implements SdkIterable<ListTagsResponse> {
    private final BackupClient client;
    private final ListTagsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTagsIterable(BackupClient client, ListTagsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListTagsResponseFetcher();
    }

    public Iterator<ListTagsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListTagsResponseFetcher
    implements SyncPageFetcher<ListTagsResponse> {
        private ListTagsResponseFetcher() {
        }

        public boolean hasNextPage(ListTagsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListTagsResponse nextPage(ListTagsResponse previousPage) {
            if (previousPage == null) {
                return ListTagsIterable.this.client.listTags(ListTagsIterable.this.firstRequest);
            }
            return ListTagsIterable.this.client.listTags((ListTagsRequest)((Object)ListTagsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

