/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.backup.BackupAsyncClient;
import software.amazon.awssdk.services.backup.internal.UserAgentUtils;
import software.amazon.awssdk.services.backup.model.CopyJob;
import software.amazon.awssdk.services.backup.model.ListCopyJobsRequest;
import software.amazon.awssdk.services.backup.model.ListCopyJobsResponse;

public class ListCopyJobsPublisher
implements SdkPublisher<ListCopyJobsResponse> {
    private final BackupAsyncClient client;
    private final ListCopyJobsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListCopyJobsPublisher(BackupAsyncClient client, ListCopyJobsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListCopyJobsPublisher(BackupAsyncClient client, ListCopyJobsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListCopyJobsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListCopyJobsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<CopyJob> copyJobs() {
        return this.flatMapIterable(response -> response.copyJobs());
    }

    private class ListCopyJobsResponseFetcher
    implements AsyncPageFetcher<ListCopyJobsResponse> {
        private ListCopyJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListCopyJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListCopyJobsResponse> nextPage(ListCopyJobsResponse previousPage) {
            if (previousPage == null) {
                return ListCopyJobsPublisher.this.client.listCopyJobs(ListCopyJobsPublisher.this.firstRequest);
            }
            return ListCopyJobsPublisher.this.client.listCopyJobs((ListCopyJobsRequest)((Object)ListCopyJobsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

