/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.backup.model.BackupRequest;
import software.amazon.awssdk.services.backup.model.TagsCopier;
import software.amazon.awssdk.services.backup.model.TieringConfigurationInputForCreate;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateTieringConfigurationRequest
extends BackupRequest
implements ToCopyableBuilder<Builder, CreateTieringConfigurationRequest> {
    private static final SdkField<TieringConfigurationInputForCreate> TIERING_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TieringConfiguration").getter(CreateTieringConfigurationRequest.getter(CreateTieringConfigurationRequest::tieringConfiguration)).setter(CreateTieringConfigurationRequest.setter(Builder::tieringConfiguration)).constructor(TieringConfigurationInputForCreate::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TieringConfiguration").build()}).build();
    private static final SdkField<Map<String, String>> TIERING_CONFIGURATION_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("TieringConfigurationTags").getter(CreateTieringConfigurationRequest.getter(CreateTieringConfigurationRequest::tieringConfigurationTags)).setter(CreateTieringConfigurationRequest.setter(Builder::tieringConfigurationTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TieringConfigurationTags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> CREATOR_REQUEST_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreatorRequestId").getter(CreateTieringConfigurationRequest.getter(CreateTieringConfigurationRequest::creatorRequestId)).setter(CreateTieringConfigurationRequest.setter(Builder::creatorRequestId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatorRequestId").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIERING_CONFIGURATION_FIELD, TIERING_CONFIGURATION_TAGS_FIELD, CREATOR_REQUEST_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateTieringConfigurationRequest.memberNameToFieldInitializer();
    private final TieringConfigurationInputForCreate tieringConfiguration;
    private final Map<String, String> tieringConfigurationTags;
    private final String creatorRequestId;

    private CreateTieringConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.tieringConfiguration = builder.tieringConfiguration;
        this.tieringConfigurationTags = builder.tieringConfigurationTags;
        this.creatorRequestId = builder.creatorRequestId;
    }

    public final TieringConfigurationInputForCreate tieringConfiguration() {
        return this.tieringConfiguration;
    }

    public final boolean hasTieringConfigurationTags() {
        return this.tieringConfigurationTags != null && !(this.tieringConfigurationTags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tieringConfigurationTags() {
        return this.tieringConfigurationTags;
    }

    public final String creatorRequestId() {
        return this.creatorRequestId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.tieringConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTieringConfigurationTags() ? this.tieringConfigurationTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.creatorRequestId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTieringConfigurationRequest)) {
            return false;
        }
        CreateTieringConfigurationRequest other = (CreateTieringConfigurationRequest)((Object)obj);
        return Objects.equals(this.tieringConfiguration(), other.tieringConfiguration()) && this.hasTieringConfigurationTags() == other.hasTieringConfigurationTags() && Objects.equals(this.tieringConfigurationTags(), other.tieringConfigurationTags()) && Objects.equals(this.creatorRequestId(), other.creatorRequestId());
    }

    public final String toString() {
        return ToString.builder((String)"CreateTieringConfigurationRequest").add("TieringConfiguration", (Object)this.tieringConfiguration()).add("TieringConfigurationTags", (Object)(this.tieringConfigurationTags() == null ? null : "*** Sensitive Data Redacted ***")).add("CreatorRequestId", (Object)this.creatorRequestId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TieringConfiguration": {
                return Optional.ofNullable(clazz.cast(this.tieringConfiguration()));
            }
            case "TieringConfigurationTags": {
                return Optional.ofNullable(clazz.cast(this.tieringConfigurationTags()));
            }
            case "CreatorRequestId": {
                return Optional.ofNullable(clazz.cast(this.creatorRequestId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TieringConfiguration", TIERING_CONFIGURATION_FIELD);
        map.put("TieringConfigurationTags", TIERING_CONFIGURATION_TAGS_FIELD);
        map.put("CreatorRequestId", CREATOR_REQUEST_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateTieringConfigurationRequest, T> g) {
        return obj -> g.apply((CreateTieringConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BackupRequest.BuilderImpl
    implements Builder {
        private TieringConfigurationInputForCreate tieringConfiguration;
        private Map<String, String> tieringConfigurationTags = DefaultSdkAutoConstructMap.getInstance();
        private String creatorRequestId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTieringConfigurationRequest model) {
            super(model);
            this.tieringConfiguration(model.tieringConfiguration);
            this.tieringConfigurationTags(model.tieringConfigurationTags);
            this.creatorRequestId(model.creatorRequestId);
        }

        public final TieringConfigurationInputForCreate.Builder getTieringConfiguration() {
            return this.tieringConfiguration != null ? this.tieringConfiguration.toBuilder() : null;
        }

        public final void setTieringConfiguration(TieringConfigurationInputForCreate.BuilderImpl tieringConfiguration) {
            this.tieringConfiguration = tieringConfiguration != null ? tieringConfiguration.build() : null;
        }

        @Override
        public final Builder tieringConfiguration(TieringConfigurationInputForCreate tieringConfiguration) {
            this.tieringConfiguration = tieringConfiguration;
            return this;
        }

        public final Map<String, String> getTieringConfigurationTags() {
            if (this.tieringConfigurationTags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tieringConfigurationTags;
        }

        public final void setTieringConfigurationTags(Map<String, String> tieringConfigurationTags) {
            this.tieringConfigurationTags = TagsCopier.copy(tieringConfigurationTags);
        }

        @Override
        public final Builder tieringConfigurationTags(Map<String, String> tieringConfigurationTags) {
            this.tieringConfigurationTags = TagsCopier.copy(tieringConfigurationTags);
            return this;
        }

        public final String getCreatorRequestId() {
            return this.creatorRequestId;
        }

        public final void setCreatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
        }

        @Override
        public final Builder creatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateTieringConfigurationRequest build() {
            return new CreateTieringConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BackupRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateTieringConfigurationRequest> {
        public Builder tieringConfiguration(TieringConfigurationInputForCreate var1);

        default public Builder tieringConfiguration(Consumer<TieringConfigurationInputForCreate.Builder> tieringConfiguration) {
            return this.tieringConfiguration((TieringConfigurationInputForCreate)((TieringConfigurationInputForCreate.Builder)TieringConfigurationInputForCreate.builder().applyMutation(tieringConfiguration)).build());
        }

        public Builder tieringConfigurationTags(Map<String, String> var1);

        public Builder creatorRequestId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

