/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.backup.BackupAsyncClient;
import software.amazon.awssdk.services.backup.internal.UserAgentUtils;
import software.amazon.awssdk.services.backup.model.ListCopyJobSummariesRequest;
import software.amazon.awssdk.services.backup.model.ListCopyJobSummariesResponse;

public class ListCopyJobSummariesPublisher
implements SdkPublisher<ListCopyJobSummariesResponse> {
    private final BackupAsyncClient client;
    private final ListCopyJobSummariesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListCopyJobSummariesPublisher(BackupAsyncClient client, ListCopyJobSummariesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListCopyJobSummariesPublisher(BackupAsyncClient client, ListCopyJobSummariesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListCopyJobSummariesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListCopyJobSummariesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class ListCopyJobSummariesResponseFetcher
    implements AsyncPageFetcher<ListCopyJobSummariesResponse> {
        private ListCopyJobSummariesResponseFetcher() {
        }

        public boolean hasNextPage(ListCopyJobSummariesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListCopyJobSummariesResponse> nextPage(ListCopyJobSummariesResponse previousPage) {
            if (previousPage == null) {
                return ListCopyJobSummariesPublisher.this.client.listCopyJobSummaries(ListCopyJobSummariesPublisher.this.firstRequest);
            }
            return ListCopyJobSummariesPublisher.this.client.listCopyJobSummaries((ListCopyJobSummariesRequest)((Object)ListCopyJobSummariesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

