/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This contains metadata about a tiering configuration returned in a list.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TieringConfigurationsListMember implements SdkPojo, Serializable,
        ToCopyableBuilder<TieringConfigurationsListMember.Builder, TieringConfigurationsListMember> {
    private static final SdkField<String> TIERING_CONFIGURATION_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TieringConfigurationArn").getter(getter(TieringConfigurationsListMember::tieringConfigurationArn))
            .setter(setter(Builder::tieringConfigurationArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TieringConfigurationArn").build())
            .build();

    private static final SdkField<String> TIERING_CONFIGURATION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TieringConfigurationName").getter(getter(TieringConfigurationsListMember::tieringConfigurationName))
            .setter(setter(Builder::tieringConfigurationName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TieringConfigurationName").build())
            .build();

    private static final SdkField<String> BACKUP_VAULT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BackupVaultName").getter(getter(TieringConfigurationsListMember::backupVaultName))
            .setter(setter(Builder::backupVaultName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupVaultName").build()).build();

    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(TieringConfigurationsListMember::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<Instant> LAST_UPDATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastUpdatedTime").getter(getter(TieringConfigurationsListMember::lastUpdatedTime))
            .setter(setter(Builder::lastUpdatedTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastUpdatedTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            TIERING_CONFIGURATION_ARN_FIELD, TIERING_CONFIGURATION_NAME_FIELD, BACKUP_VAULT_NAME_FIELD, CREATION_TIME_FIELD,
            LAST_UPDATED_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String tieringConfigurationArn;

    private final String tieringConfigurationName;

    private final String backupVaultName;

    private final Instant creationTime;

    private final Instant lastUpdatedTime;

    private TieringConfigurationsListMember(BuilderImpl builder) {
        this.tieringConfigurationArn = builder.tieringConfigurationArn;
        this.tieringConfigurationName = builder.tieringConfigurationName;
        this.backupVaultName = builder.backupVaultName;
        this.creationTime = builder.creationTime;
        this.lastUpdatedTime = builder.lastUpdatedTime;
    }

    /**
     * <p>
     * An Amazon Resource Name (ARN) that uniquely identifies the tiering configuration.
     * </p>
     * 
     * @return An Amazon Resource Name (ARN) that uniquely identifies the tiering configuration.
     */
    public final String tieringConfigurationArn() {
        return tieringConfigurationArn;
    }

    /**
     * <p>
     * The unique name of the tiering configuration.
     * </p>
     * 
     * @return The unique name of the tiering configuration.
     */
    public final String tieringConfigurationName() {
        return tieringConfigurationName;
    }

    /**
     * <p>
     * The name of the backup vault where the tiering configuration applies. Use <code>*</code> to apply to all backup
     * vaults.
     * </p>
     * 
     * @return The name of the backup vault where the tiering configuration applies. Use <code>*</code> to apply to all
     *         backup vaults.
     */
    public final String backupVaultName() {
        return backupVaultName;
    }

    /**
     * <p>
     * The date and time a tiering configuration was created, in Unix format and Coordinated Universal Time (UTC). The
     * value of <code>CreationTime</code> is accurate to milliseconds. For example, the value 1516925490.087 represents
     * Friday, January 26, 2018 12:11:30.087AM.
     * </p>
     * 
     * @return The date and time a tiering configuration was created, in Unix format and Coordinated Universal Time
     *         (UTC). The value of <code>CreationTime</code> is accurate to milliseconds. For example, the value
     *         1516925490.087 represents Friday, January 26, 2018 12:11:30.087AM.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The date and time a tiering configuration was updated, in Unix format and Coordinated Universal Time (UTC). The
     * value of <code>LastUpdatedTime</code> is accurate to milliseconds. For example, the value 1516925490.087
     * represents Friday, January 26, 2018 12:11:30.087AM.
     * </p>
     * 
     * @return The date and time a tiering configuration was updated, in Unix format and Coordinated Universal Time
     *         (UTC). The value of <code>LastUpdatedTime</code> is accurate to milliseconds. For example, the value
     *         1516925490.087 represents Friday, January 26, 2018 12:11:30.087AM.
     */
    public final Instant lastUpdatedTime() {
        return lastUpdatedTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(tieringConfigurationArn());
        hashCode = 31 * hashCode + Objects.hashCode(tieringConfigurationName());
        hashCode = 31 * hashCode + Objects.hashCode(backupVaultName());
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(lastUpdatedTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TieringConfigurationsListMember)) {
            return false;
        }
        TieringConfigurationsListMember other = (TieringConfigurationsListMember) obj;
        return Objects.equals(tieringConfigurationArn(), other.tieringConfigurationArn())
                && Objects.equals(tieringConfigurationName(), other.tieringConfigurationName())
                && Objects.equals(backupVaultName(), other.backupVaultName())
                && Objects.equals(creationTime(), other.creationTime())
                && Objects.equals(lastUpdatedTime(), other.lastUpdatedTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TieringConfigurationsListMember").add("TieringConfigurationArn", tieringConfigurationArn())
                .add("TieringConfigurationName", tieringConfigurationName()).add("BackupVaultName", backupVaultName())
                .add("CreationTime", creationTime()).add("LastUpdatedTime", lastUpdatedTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TieringConfigurationArn":
            return Optional.ofNullable(clazz.cast(tieringConfigurationArn()));
        case "TieringConfigurationName":
            return Optional.ofNullable(clazz.cast(tieringConfigurationName()));
        case "BackupVaultName":
            return Optional.ofNullable(clazz.cast(backupVaultName()));
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "LastUpdatedTime":
            return Optional.ofNullable(clazz.cast(lastUpdatedTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TieringConfigurationArn", TIERING_CONFIGURATION_ARN_FIELD);
        map.put("TieringConfigurationName", TIERING_CONFIGURATION_NAME_FIELD);
        map.put("BackupVaultName", BACKUP_VAULT_NAME_FIELD);
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("LastUpdatedTime", LAST_UPDATED_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TieringConfigurationsListMember, T> g) {
        return obj -> g.apply((TieringConfigurationsListMember) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TieringConfigurationsListMember> {
        /**
         * <p>
         * An Amazon Resource Name (ARN) that uniquely identifies the tiering configuration.
         * </p>
         * 
         * @param tieringConfigurationArn
         *        An Amazon Resource Name (ARN) that uniquely identifies the tiering configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tieringConfigurationArn(String tieringConfigurationArn);

        /**
         * <p>
         * The unique name of the tiering configuration.
         * </p>
         * 
         * @param tieringConfigurationName
         *        The unique name of the tiering configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tieringConfigurationName(String tieringConfigurationName);

        /**
         * <p>
         * The name of the backup vault where the tiering configuration applies. Use <code>*</code> to apply to all
         * backup vaults.
         * </p>
         * 
         * @param backupVaultName
         *        The name of the backup vault where the tiering configuration applies. Use <code>*</code> to apply to
         *        all backup vaults.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupVaultName(String backupVaultName);

        /**
         * <p>
         * The date and time a tiering configuration was created, in Unix format and Coordinated Universal Time (UTC).
         * The value of <code>CreationTime</code> is accurate to milliseconds. For example, the value 1516925490.087
         * represents Friday, January 26, 2018 12:11:30.087AM.
         * </p>
         * 
         * @param creationTime
         *        The date and time a tiering configuration was created, in Unix format and Coordinated Universal Time
         *        (UTC). The value of <code>CreationTime</code> is accurate to milliseconds. For example, the value
         *        1516925490.087 represents Friday, January 26, 2018 12:11:30.087AM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The date and time a tiering configuration was updated, in Unix format and Coordinated Universal Time (UTC).
         * The value of <code>LastUpdatedTime</code> is accurate to milliseconds. For example, the value 1516925490.087
         * represents Friday, January 26, 2018 12:11:30.087AM.
         * </p>
         * 
         * @param lastUpdatedTime
         *        The date and time a tiering configuration was updated, in Unix format and Coordinated Universal Time
         *        (UTC). The value of <code>LastUpdatedTime</code> is accurate to milliseconds. For example, the value
         *        1516925490.087 represents Friday, January 26, 2018 12:11:30.087AM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastUpdatedTime(Instant lastUpdatedTime);
    }

    static final class BuilderImpl implements Builder {
        private String tieringConfigurationArn;

        private String tieringConfigurationName;

        private String backupVaultName;

        private Instant creationTime;

        private Instant lastUpdatedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(TieringConfigurationsListMember model) {
            tieringConfigurationArn(model.tieringConfigurationArn);
            tieringConfigurationName(model.tieringConfigurationName);
            backupVaultName(model.backupVaultName);
            creationTime(model.creationTime);
            lastUpdatedTime(model.lastUpdatedTime);
        }

        public final String getTieringConfigurationArn() {
            return tieringConfigurationArn;
        }

        public final void setTieringConfigurationArn(String tieringConfigurationArn) {
            this.tieringConfigurationArn = tieringConfigurationArn;
        }

        @Override
        public final Builder tieringConfigurationArn(String tieringConfigurationArn) {
            this.tieringConfigurationArn = tieringConfigurationArn;
            return this;
        }

        public final String getTieringConfigurationName() {
            return tieringConfigurationName;
        }

        public final void setTieringConfigurationName(String tieringConfigurationName) {
            this.tieringConfigurationName = tieringConfigurationName;
        }

        @Override
        public final Builder tieringConfigurationName(String tieringConfigurationName) {
            this.tieringConfigurationName = tieringConfigurationName;
            return this;
        }

        public final String getBackupVaultName() {
            return backupVaultName;
        }

        public final void setBackupVaultName(String backupVaultName) {
            this.backupVaultName = backupVaultName;
        }

        @Override
        public final Builder backupVaultName(String backupVaultName) {
            this.backupVaultName = backupVaultName;
            return this;
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final Instant getLastUpdatedTime() {
            return lastUpdatedTime;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        @Override
        public TieringConfigurationsListMember build() {
            return new TieringConfigurationsListMember(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
