/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains summary information about scan jobs, including counts and metadata for a specific time period and criteria.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ScanJobSummary implements SdkPojo, Serializable, ToCopyableBuilder<ScanJobSummary.Builder, ScanJobSummary> {
    private static final SdkField<String> REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Region")
            .getter(getter(ScanJobSummary::region)).setter(setter(Builder::region))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region").build()).build();

    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountId").getter(getter(ScanJobSummary::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(ScanJobSummary::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceType").getter(getter(ScanJobSummary::resourceType)).setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()).build();

    private static final SdkField<Integer> COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Count")
            .getter(getter(ScanJobSummary::count)).setter(setter(Builder::count))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Count").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime").getter(getter(ScanJobSummary::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndTime").getter(getter(ScanJobSummary::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()).build();

    private static final SdkField<String> MALWARE_SCANNER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MalwareScanner").getter(getter(ScanJobSummary::malwareScannerAsString))
            .setter(setter(Builder::malwareScanner))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MalwareScanner").build()).build();

    private static final SdkField<String> SCAN_RESULT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ScanResultStatus").getter(getter(ScanJobSummary::scanResultStatusAsString))
            .setter(setter(Builder::scanResultStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScanResultStatus").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGION_FIELD,
            ACCOUNT_ID_FIELD, STATE_FIELD, RESOURCE_TYPE_FIELD, COUNT_FIELD, START_TIME_FIELD, END_TIME_FIELD,
            MALWARE_SCANNER_FIELD, SCAN_RESULT_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String region;

    private final String accountId;

    private final String state;

    private final String resourceType;

    private final Integer count;

    private final Instant startTime;

    private final Instant endTime;

    private final String malwareScanner;

    private final String scanResultStatus;

    private ScanJobSummary(BuilderImpl builder) {
        this.region = builder.region;
        this.accountId = builder.accountId;
        this.state = builder.state;
        this.resourceType = builder.resourceType;
        this.count = builder.count;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.malwareScanner = builder.malwareScanner;
        this.scanResultStatus = builder.scanResultStatus;
    }

    /**
     * <p>
     * The Amazon Web Services Region where the scan jobs were executed.
     * </p>
     * 
     * @return The Amazon Web Services Region where the scan jobs were executed.
     */
    public final String region() {
        return region;
    }

    /**
     * <p>
     * The account ID that owns the scan jobs included in this summary.
     * </p>
     * 
     * @return The account ID that owns the scan jobs included in this summary.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * The state of the scan jobs included in this summary.
     * </p>
     * <p>
     * Valid values: <code>CREATED</code> | <code>RUNNING</code> | <code>COMPLETED</code> |
     * <code>COMPLETED_WITH_ISSUES</code> | <code>FAILED</code> | <code>CANCELED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ScanJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the scan jobs included in this summary.</p>
     *         <p>
     *         Valid values: <code>CREATED</code> | <code>RUNNING</code> | <code>COMPLETED</code> |
     *         <code>COMPLETED_WITH_ISSUES</code> | <code>FAILED</code> | <code>CANCELED</code>.
     * @see ScanJobStatus
     */
    public final ScanJobStatus state() {
        return ScanJobStatus.fromValue(state);
    }

    /**
     * <p>
     * The state of the scan jobs included in this summary.
     * </p>
     * <p>
     * Valid values: <code>CREATED</code> | <code>RUNNING</code> | <code>COMPLETED</code> |
     * <code>COMPLETED_WITH_ISSUES</code> | <code>FAILED</code> | <code>CANCELED</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ScanJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The state of the scan jobs included in this summary.</p>
     *         <p>
     *         Valid values: <code>CREATED</code> | <code>RUNNING</code> | <code>COMPLETED</code> |
     *         <code>COMPLETED_WITH_ISSUES</code> | <code>FAILED</code> | <code>CANCELED</code>.
     * @see ScanJobStatus
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The type of Amazon Web Services resource for the scan jobs included in this summary.
     * </p>
     * 
     * @return The type of Amazon Web Services resource for the scan jobs included in this summary.
     */
    public final String resourceType() {
        return resourceType;
    }

    /**
     * <p>
     * The number of scan jobs that match the specified criteria.
     * </p>
     * 
     * @return The number of scan jobs that match the specified criteria.
     */
    public final Integer count() {
        return count;
    }

    /**
     * <p>
     * The value of time in number format of a job start time.
     * </p>
     * <p>
     * This value is the time in Unix format, Coordinated Universal Time (UTC), and accurate to milliseconds. For
     * example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
     * </p>
     * 
     * @return The value of time in number format of a job start time.</p>
     *         <p>
     *         This value is the time in Unix format, Coordinated Universal Time (UTC), and accurate to milliseconds.
     *         For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The value of time in number format of a job end time.
     * </p>
     * <p>
     * This value is the time in Unix format, Coordinated Universal Time (UTC), and accurate to milliseconds. For
     * example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
     * </p>
     * 
     * @return The value of time in number format of a job end time.</p>
     *         <p>
     *         This value is the time in Unix format, Coordinated Universal Time (UTC), and accurate to milliseconds.
     *         For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * Specifies the malware scanner used during the scan job. Currently only supports <code>GUARDDUTY</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #malwareScanner}
     * will return {@link MalwareScanner#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #malwareScannerAsString}.
     * </p>
     * 
     * @return Specifies the malware scanner used during the scan job. Currently only supports <code>GUARDDUTY</code>.
     * @see MalwareScanner
     */
    public final MalwareScanner malwareScanner() {
        return MalwareScanner.fromValue(malwareScanner);
    }

    /**
     * <p>
     * Specifies the malware scanner used during the scan job. Currently only supports <code>GUARDDUTY</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #malwareScanner}
     * will return {@link MalwareScanner#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #malwareScannerAsString}.
     * </p>
     * 
     * @return Specifies the malware scanner used during the scan job. Currently only supports <code>GUARDDUTY</code>.
     * @see MalwareScanner
     */
    public final String malwareScannerAsString() {
        return malwareScanner;
    }

    /**
     * <p>
     * The scan result status for the scan jobs included in this summary.
     * </p>
     * <p>
     * Valid values: <code>THREATS_FOUND</code> | <code>NO_THREATS_FOUND</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scanResultStatus}
     * will return {@link ScanResultStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #scanResultStatusAsString}.
     * </p>
     * 
     * @return The scan result status for the scan jobs included in this summary.</p>
     *         <p>
     *         Valid values: <code>THREATS_FOUND</code> | <code>NO_THREATS_FOUND</code>.
     * @see ScanResultStatus
     */
    public final ScanResultStatus scanResultStatus() {
        return ScanResultStatus.fromValue(scanResultStatus);
    }

    /**
     * <p>
     * The scan result status for the scan jobs included in this summary.
     * </p>
     * <p>
     * Valid values: <code>THREATS_FOUND</code> | <code>NO_THREATS_FOUND</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scanResultStatus}
     * will return {@link ScanResultStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #scanResultStatusAsString}.
     * </p>
     * 
     * @return The scan result status for the scan jobs included in this summary.</p>
     *         <p>
     *         Valid values: <code>THREATS_FOUND</code> | <code>NO_THREATS_FOUND</code>.
     * @see ScanResultStatus
     */
    public final String scanResultStatusAsString() {
        return scanResultStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(region());
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(count());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(malwareScannerAsString());
        hashCode = 31 * hashCode + Objects.hashCode(scanResultStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScanJobSummary)) {
            return false;
        }
        ScanJobSummary other = (ScanJobSummary) obj;
        return Objects.equals(region(), other.region()) && Objects.equals(accountId(), other.accountId())
                && Objects.equals(stateAsString(), other.stateAsString()) && Objects.equals(resourceType(), other.resourceType())
                && Objects.equals(count(), other.count()) && Objects.equals(startTime(), other.startTime())
                && Objects.equals(endTime(), other.endTime())
                && Objects.equals(malwareScannerAsString(), other.malwareScannerAsString())
                && Objects.equals(scanResultStatusAsString(), other.scanResultStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ScanJobSummary").add("Region", region()).add("AccountId", accountId())
                .add("State", stateAsString()).add("ResourceType", resourceType()).add("Count", count())
                .add("StartTime", startTime()).add("EndTime", endTime()).add("MalwareScanner", malwareScannerAsString())
                .add("ScanResultStatus", scanResultStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Region":
            return Optional.ofNullable(clazz.cast(region()));
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceType()));
        case "Count":
            return Optional.ofNullable(clazz.cast(count()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "MalwareScanner":
            return Optional.ofNullable(clazz.cast(malwareScannerAsString()));
        case "ScanResultStatus":
            return Optional.ofNullable(clazz.cast(scanResultStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Region", REGION_FIELD);
        map.put("AccountId", ACCOUNT_ID_FIELD);
        map.put("State", STATE_FIELD);
        map.put("ResourceType", RESOURCE_TYPE_FIELD);
        map.put("Count", COUNT_FIELD);
        map.put("StartTime", START_TIME_FIELD);
        map.put("EndTime", END_TIME_FIELD);
        map.put("MalwareScanner", MALWARE_SCANNER_FIELD);
        map.put("ScanResultStatus", SCAN_RESULT_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ScanJobSummary, T> g) {
        return obj -> g.apply((ScanJobSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ScanJobSummary> {
        /**
         * <p>
         * The Amazon Web Services Region where the scan jobs were executed.
         * </p>
         * 
         * @param region
         *        The Amazon Web Services Region where the scan jobs were executed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder region(String region);

        /**
         * <p>
         * The account ID that owns the scan jobs included in this summary.
         * </p>
         * 
         * @param accountId
         *        The account ID that owns the scan jobs included in this summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * The state of the scan jobs included in this summary.
         * </p>
         * <p>
         * Valid values: <code>CREATED</code> | <code>RUNNING</code> | <code>COMPLETED</code> |
         * <code>COMPLETED_WITH_ISSUES</code> | <code>FAILED</code> | <code>CANCELED</code>.
         * </p>
         * 
         * @param state
         *        The state of the scan jobs included in this summary.</p>
         *        <p>
         *        Valid values: <code>CREATED</code> | <code>RUNNING</code> | <code>COMPLETED</code> |
         *        <code>COMPLETED_WITH_ISSUES</code> | <code>FAILED</code> | <code>CANCELED</code>.
         * @see ScanJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScanJobStatus
         */
        Builder state(String state);

        /**
         * <p>
         * The state of the scan jobs included in this summary.
         * </p>
         * <p>
         * Valid values: <code>CREATED</code> | <code>RUNNING</code> | <code>COMPLETED</code> |
         * <code>COMPLETED_WITH_ISSUES</code> | <code>FAILED</code> | <code>CANCELED</code>.
         * </p>
         * 
         * @param state
         *        The state of the scan jobs included in this summary.</p>
         *        <p>
         *        Valid values: <code>CREATED</code> | <code>RUNNING</code> | <code>COMPLETED</code> |
         *        <code>COMPLETED_WITH_ISSUES</code> | <code>FAILED</code> | <code>CANCELED</code>.
         * @see ScanJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScanJobStatus
         */
        Builder state(ScanJobStatus state);

        /**
         * <p>
         * The type of Amazon Web Services resource for the scan jobs included in this summary.
         * </p>
         * 
         * @param resourceType
         *        The type of Amazon Web Services resource for the scan jobs included in this summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The number of scan jobs that match the specified criteria.
         * </p>
         * 
         * @param count
         *        The number of scan jobs that match the specified criteria.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder count(Integer count);

        /**
         * <p>
         * The value of time in number format of a job start time.
         * </p>
         * <p>
         * This value is the time in Unix format, Coordinated Universal Time (UTC), and accurate to milliseconds. For
         * example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
         * </p>
         * 
         * @param startTime
         *        The value of time in number format of a job start time.</p>
         *        <p>
         *        This value is the time in Unix format, Coordinated Universal Time (UTC), and accurate to milliseconds.
         *        For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The value of time in number format of a job end time.
         * </p>
         * <p>
         * This value is the time in Unix format, Coordinated Universal Time (UTC), and accurate to milliseconds. For
         * example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
         * </p>
         * 
         * @param endTime
         *        The value of time in number format of a job end time.</p>
         *        <p>
         *        This value is the time in Unix format, Coordinated Universal Time (UTC), and accurate to milliseconds.
         *        For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * Specifies the malware scanner used during the scan job. Currently only supports <code>GUARDDUTY</code>.
         * </p>
         * 
         * @param malwareScanner
         *        Specifies the malware scanner used during the scan job. Currently only supports <code>GUARDDUTY</code>
         *        .
         * @see MalwareScanner
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MalwareScanner
         */
        Builder malwareScanner(String malwareScanner);

        /**
         * <p>
         * Specifies the malware scanner used during the scan job. Currently only supports <code>GUARDDUTY</code>.
         * </p>
         * 
         * @param malwareScanner
         *        Specifies the malware scanner used during the scan job. Currently only supports <code>GUARDDUTY</code>
         *        .
         * @see MalwareScanner
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MalwareScanner
         */
        Builder malwareScanner(MalwareScanner malwareScanner);

        /**
         * <p>
         * The scan result status for the scan jobs included in this summary.
         * </p>
         * <p>
         * Valid values: <code>THREATS_FOUND</code> | <code>NO_THREATS_FOUND</code>.
         * </p>
         * 
         * @param scanResultStatus
         *        The scan result status for the scan jobs included in this summary.</p>
         *        <p>
         *        Valid values: <code>THREATS_FOUND</code> | <code>NO_THREATS_FOUND</code>.
         * @see ScanResultStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScanResultStatus
         */
        Builder scanResultStatus(String scanResultStatus);

        /**
         * <p>
         * The scan result status for the scan jobs included in this summary.
         * </p>
         * <p>
         * Valid values: <code>THREATS_FOUND</code> | <code>NO_THREATS_FOUND</code>.
         * </p>
         * 
         * @param scanResultStatus
         *        The scan result status for the scan jobs included in this summary.</p>
         *        <p>
         *        Valid values: <code>THREATS_FOUND</code> | <code>NO_THREATS_FOUND</code>.
         * @see ScanResultStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScanResultStatus
         */
        Builder scanResultStatus(ScanResultStatus scanResultStatus);
    }

    static final class BuilderImpl implements Builder {
        private String region;

        private String accountId;

        private String state;

        private String resourceType;

        private Integer count;

        private Instant startTime;

        private Instant endTime;

        private String malwareScanner;

        private String scanResultStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(ScanJobSummary model) {
            region(model.region);
            accountId(model.accountId);
            state(model.state);
            resourceType(model.resourceType);
            count(model.count);
            startTime(model.startTime);
            endTime(model.endTime);
            malwareScanner(model.malwareScanner);
            scanResultStatus(model.scanResultStatus);
        }

        public final String getRegion() {
            return region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ScanJobStatus state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final Integer getCount() {
            return count;
        }

        public final void setCount(Integer count) {
            this.count = count;
        }

        @Override
        public final Builder count(Integer count) {
            this.count = count;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getMalwareScanner() {
            return malwareScanner;
        }

        public final void setMalwareScanner(String malwareScanner) {
            this.malwareScanner = malwareScanner;
        }

        @Override
        public final Builder malwareScanner(String malwareScanner) {
            this.malwareScanner = malwareScanner;
            return this;
        }

        @Override
        public final Builder malwareScanner(MalwareScanner malwareScanner) {
            this.malwareScanner(malwareScanner == null ? null : malwareScanner.toString());
            return this;
        }

        public final String getScanResultStatus() {
            return scanResultStatus;
        }

        public final void setScanResultStatus(String scanResultStatus) {
            this.scanResultStatus = scanResultStatus;
        }

        @Override
        public final Builder scanResultStatus(String scanResultStatus) {
            this.scanResultStatus = scanResultStatus;
            return this;
        }

        @Override
        public final Builder scanResultStatus(ScanResultStatus scanResultStatus) {
            this.scanResultStatus(scanResultStatus == null ? null : scanResultStatus.toString());
            return this;
        }

        @Override
        public ScanJobSummary build() {
            return new ScanJobSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
