/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class RevokeRestoreAccessBackupVaultRequest extends BackupRequest implements
        ToCopyableBuilder<RevokeRestoreAccessBackupVaultRequest.Builder, RevokeRestoreAccessBackupVaultRequest> {
    private static final SdkField<String> BACKUP_VAULT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BackupVaultName").getter(getter(RevokeRestoreAccessBackupVaultRequest::backupVaultName))
            .setter(setter(Builder::backupVaultName))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("backupVaultName").build()).build();

    private static final SdkField<String> RESTORE_ACCESS_BACKUP_VAULT_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING).memberName("RestoreAccessBackupVaultArn")
            .getter(getter(RevokeRestoreAccessBackupVaultRequest::restoreAccessBackupVaultArn))
            .setter(setter(Builder::restoreAccessBackupVaultArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("restoreAccessBackupVaultArn").build())
            .build();

    private static final SdkField<String> REQUESTER_COMMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RequesterComment").getter(getter(RevokeRestoreAccessBackupVaultRequest::requesterComment))
            .setter(setter(Builder::requesterComment))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("requesterComment").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKUP_VAULT_NAME_FIELD,
            RESTORE_ACCESS_BACKUP_VAULT_ARN_FIELD, REQUESTER_COMMENT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String backupVaultName;

    private final String restoreAccessBackupVaultArn;

    private final String requesterComment;

    private RevokeRestoreAccessBackupVaultRequest(BuilderImpl builder) {
        super(builder);
        this.backupVaultName = builder.backupVaultName;
        this.restoreAccessBackupVaultArn = builder.restoreAccessBackupVaultArn;
        this.requesterComment = builder.requesterComment;
    }

    /**
     * <p>
     * The name of the source backup vault associated with the restore access backup vault to be revoked.
     * </p>
     * 
     * @return The name of the source backup vault associated with the restore access backup vault to be revoked.
     */
    public final String backupVaultName() {
        return backupVaultName;
    }

    /**
     * <p>
     * The ARN of the restore access backup vault to revoke.
     * </p>
     * 
     * @return The ARN of the restore access backup vault to revoke.
     */
    public final String restoreAccessBackupVaultArn() {
        return restoreAccessBackupVaultArn;
    }

    /**
     * <p>
     * A comment explaining the reason for revoking access to the restore access backup vault.
     * </p>
     * 
     * @return A comment explaining the reason for revoking access to the restore access backup vault.
     */
    public final String requesterComment() {
        return requesterComment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(backupVaultName());
        hashCode = 31 * hashCode + Objects.hashCode(restoreAccessBackupVaultArn());
        hashCode = 31 * hashCode + Objects.hashCode(requesterComment());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RevokeRestoreAccessBackupVaultRequest)) {
            return false;
        }
        RevokeRestoreAccessBackupVaultRequest other = (RevokeRestoreAccessBackupVaultRequest) obj;
        return Objects.equals(backupVaultName(), other.backupVaultName())
                && Objects.equals(restoreAccessBackupVaultArn(), other.restoreAccessBackupVaultArn())
                && Objects.equals(requesterComment(), other.requesterComment());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RevokeRestoreAccessBackupVaultRequest").add("BackupVaultName", backupVaultName())
                .add("RestoreAccessBackupVaultArn", restoreAccessBackupVaultArn())
                .add("RequesterComment", requesterComment() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BackupVaultName":
            return Optional.ofNullable(clazz.cast(backupVaultName()));
        case "RestoreAccessBackupVaultArn":
            return Optional.ofNullable(clazz.cast(restoreAccessBackupVaultArn()));
        case "RequesterComment":
            return Optional.ofNullable(clazz.cast(requesterComment()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("backupVaultName", BACKUP_VAULT_NAME_FIELD);
        map.put("restoreAccessBackupVaultArn", RESTORE_ACCESS_BACKUP_VAULT_ARN_FIELD);
        map.put("requesterComment", REQUESTER_COMMENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RevokeRestoreAccessBackupVaultRequest, T> g) {
        return obj -> g.apply((RevokeRestoreAccessBackupVaultRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BackupRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, RevokeRestoreAccessBackupVaultRequest> {
        /**
         * <p>
         * The name of the source backup vault associated with the restore access backup vault to be revoked.
         * </p>
         * 
         * @param backupVaultName
         *        The name of the source backup vault associated with the restore access backup vault to be revoked.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupVaultName(String backupVaultName);

        /**
         * <p>
         * The ARN of the restore access backup vault to revoke.
         * </p>
         * 
         * @param restoreAccessBackupVaultArn
         *        The ARN of the restore access backup vault to revoke.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restoreAccessBackupVaultArn(String restoreAccessBackupVaultArn);

        /**
         * <p>
         * A comment explaining the reason for revoking access to the restore access backup vault.
         * </p>
         * 
         * @param requesterComment
         *        A comment explaining the reason for revoking access to the restore access backup vault.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requesterComment(String requesterComment);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BackupRequest.BuilderImpl implements Builder {
        private String backupVaultName;

        private String restoreAccessBackupVaultArn;

        private String requesterComment;

        private BuilderImpl() {
        }

        private BuilderImpl(RevokeRestoreAccessBackupVaultRequest model) {
            super(model);
            backupVaultName(model.backupVaultName);
            restoreAccessBackupVaultArn(model.restoreAccessBackupVaultArn);
            requesterComment(model.requesterComment);
        }

        public final String getBackupVaultName() {
            return backupVaultName;
        }

        public final void setBackupVaultName(String backupVaultName) {
            this.backupVaultName = backupVaultName;
        }

        @Override
        public final Builder backupVaultName(String backupVaultName) {
            this.backupVaultName = backupVaultName;
            return this;
        }

        public final String getRestoreAccessBackupVaultArn() {
            return restoreAccessBackupVaultArn;
        }

        public final void setRestoreAccessBackupVaultArn(String restoreAccessBackupVaultArn) {
            this.restoreAccessBackupVaultArn = restoreAccessBackupVaultArn;
        }

        @Override
        public final Builder restoreAccessBackupVaultArn(String restoreAccessBackupVaultArn) {
            this.restoreAccessBackupVaultArn = restoreAccessBackupVaultArn;
            return this;
        }

        public final String getRequesterComment() {
            return requesterComment;
        }

        public final void setRequesterComment(String requesterComment) {
            this.requesterComment = requesterComment;
        }

        @Override
        public final Builder requesterComment(String requesterComment) {
            this.requesterComment = requesterComment;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RevokeRestoreAccessBackupVaultRequest build() {
            return new RevokeRestoreAccessBackupVaultRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
