/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that contains information about a backed-up resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProtectedResource implements SdkPojo, Serializable,
        ToCopyableBuilder<ProtectedResource.Builder, ProtectedResource> {
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceArn").getter(getter(ProtectedResource::resourceArn)).setter(setter(Builder::resourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceType").getter(getter(ProtectedResource::resourceType)).setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()).build();

    private static final SdkField<Instant> LAST_BACKUP_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("LastBackupTime").getter(getter(ProtectedResource::lastBackupTime))
            .setter(setter(Builder::lastBackupTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastBackupTime").build()).build();

    private static final SdkField<String> RESOURCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceName").getter(getter(ProtectedResource::resourceName)).setter(setter(Builder::resourceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceName").build()).build();

    private static final SdkField<String> LAST_BACKUP_VAULT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastBackupVaultArn").getter(getter(ProtectedResource::lastBackupVaultArn))
            .setter(setter(Builder::lastBackupVaultArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastBackupVaultArn").build())
            .build();

    private static final SdkField<String> LAST_RECOVERY_POINT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("LastRecoveryPointArn").getter(getter(ProtectedResource::lastRecoveryPointArn))
            .setter(setter(Builder::lastRecoveryPointArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastRecoveryPointArn").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_ARN_FIELD,
            RESOURCE_TYPE_FIELD, LAST_BACKUP_TIME_FIELD, RESOURCE_NAME_FIELD, LAST_BACKUP_VAULT_ARN_FIELD,
            LAST_RECOVERY_POINT_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String resourceArn;

    private final String resourceType;

    private final Instant lastBackupTime;

    private final String resourceName;

    private final String lastBackupVaultArn;

    private final String lastRecoveryPointArn;

    private ProtectedResource(BuilderImpl builder) {
        this.resourceArn = builder.resourceArn;
        this.resourceType = builder.resourceType;
        this.lastBackupTime = builder.lastBackupTime;
        this.resourceName = builder.resourceName;
        this.lastBackupVaultArn = builder.lastBackupVaultArn;
        this.lastRecoveryPointArn = builder.lastRecoveryPointArn;
    }

    /**
     * <p>
     * An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN depends on the resource
     * type.
     * </p>
     * 
     * @return An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN depends on the
     *         resource type.
     */
    public final String resourceArn() {
        return resourceArn;
    }

    /**
     * <p>
     * The type of Amazon Web Services resource; for example, an Amazon Elastic Block Store (Amazon EBS) volume or an
     * Amazon Relational Database Service (Amazon RDS) database. For Windows Volume Shadow Copy Service (VSS) backups,
     * the only supported resource type is Amazon EC2.
     * </p>
     * 
     * @return The type of Amazon Web Services resource; for example, an Amazon Elastic Block Store (Amazon EBS) volume
     *         or an Amazon Relational Database Service (Amazon RDS) database. For Windows Volume Shadow Copy Service
     *         (VSS) backups, the only supported resource type is Amazon EC2.
     */
    public final String resourceType() {
        return resourceType;
    }

    /**
     * <p>
     * The date and time a resource was last backed up, in Unix format and Coordinated Universal Time (UTC). The value
     * of <code>LastBackupTime</code> is accurate to milliseconds. For example, the value 1516925490.087 represents
     * Friday, January 26, 2018 12:11:30.087 AM.
     * </p>
     * 
     * @return The date and time a resource was last backed up, in Unix format and Coordinated Universal Time (UTC). The
     *         value of <code>LastBackupTime</code> is accurate to milliseconds. For example, the value 1516925490.087
     *         represents Friday, January 26, 2018 12:11:30.087 AM.
     */
    public final Instant lastBackupTime() {
        return lastBackupTime;
    }

    /**
     * <p>
     * The non-unique name of the resource that belongs to the specified backup.
     * </p>
     * 
     * @return The non-unique name of the resource that belongs to the specified backup.
     */
    public final String resourceName() {
        return resourceName;
    }

    /**
     * <p>
     * The ARN (Amazon Resource Name) of the backup vault that contains the most recent backup recovery point.
     * </p>
     * 
     * @return The ARN (Amazon Resource Name) of the backup vault that contains the most recent backup recovery point.
     */
    public final String lastBackupVaultArn() {
        return lastBackupVaultArn;
    }

    /**
     * <p>
     * The ARN (Amazon Resource Name) of the most recent recovery point.
     * </p>
     * 
     * @return The ARN (Amazon Resource Name) of the most recent recovery point.
     */
    public final String lastRecoveryPointArn() {
        return lastRecoveryPointArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(lastBackupTime());
        hashCode = 31 * hashCode + Objects.hashCode(resourceName());
        hashCode = 31 * hashCode + Objects.hashCode(lastBackupVaultArn());
        hashCode = 31 * hashCode + Objects.hashCode(lastRecoveryPointArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProtectedResource)) {
            return false;
        }
        ProtectedResource other = (ProtectedResource) obj;
        return Objects.equals(resourceArn(), other.resourceArn()) && Objects.equals(resourceType(), other.resourceType())
                && Objects.equals(lastBackupTime(), other.lastBackupTime())
                && Objects.equals(resourceName(), other.resourceName())
                && Objects.equals(lastBackupVaultArn(), other.lastBackupVaultArn())
                && Objects.equals(lastRecoveryPointArn(), other.lastRecoveryPointArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProtectedResource").add("ResourceArn", resourceArn()).add("ResourceType", resourceType())
                .add("LastBackupTime", lastBackupTime()).add("ResourceName", resourceName())
                .add("LastBackupVaultArn", lastBackupVaultArn()).add("LastRecoveryPointArn", lastRecoveryPointArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ResourceArn":
            return Optional.ofNullable(clazz.cast(resourceArn()));
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceType()));
        case "LastBackupTime":
            return Optional.ofNullable(clazz.cast(lastBackupTime()));
        case "ResourceName":
            return Optional.ofNullable(clazz.cast(resourceName()));
        case "LastBackupVaultArn":
            return Optional.ofNullable(clazz.cast(lastBackupVaultArn()));
        case "LastRecoveryPointArn":
            return Optional.ofNullable(clazz.cast(lastRecoveryPointArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ResourceArn", RESOURCE_ARN_FIELD);
        map.put("ResourceType", RESOURCE_TYPE_FIELD);
        map.put("LastBackupTime", LAST_BACKUP_TIME_FIELD);
        map.put("ResourceName", RESOURCE_NAME_FIELD);
        map.put("LastBackupVaultArn", LAST_BACKUP_VAULT_ARN_FIELD);
        map.put("LastRecoveryPointArn", LAST_RECOVERY_POINT_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ProtectedResource, T> g) {
        return obj -> g.apply((ProtectedResource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProtectedResource> {
        /**
         * <p>
         * An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN depends on the
         * resource type.
         * </p>
         * 
         * @param resourceArn
         *        An Amazon Resource Name (ARN) that uniquely identifies a resource. The format of the ARN depends on
         *        the resource type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceArn(String resourceArn);

        /**
         * <p>
         * The type of Amazon Web Services resource; for example, an Amazon Elastic Block Store (Amazon EBS) volume or
         * an Amazon Relational Database Service (Amazon RDS) database. For Windows Volume Shadow Copy Service (VSS)
         * backups, the only supported resource type is Amazon EC2.
         * </p>
         * 
         * @param resourceType
         *        The type of Amazon Web Services resource; for example, an Amazon Elastic Block Store (Amazon EBS)
         *        volume or an Amazon Relational Database Service (Amazon RDS) database. For Windows Volume Shadow Copy
         *        Service (VSS) backups, the only supported resource type is Amazon EC2.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * The date and time a resource was last backed up, in Unix format and Coordinated Universal Time (UTC). The
         * value of <code>LastBackupTime</code> is accurate to milliseconds. For example, the value 1516925490.087
         * represents Friday, January 26, 2018 12:11:30.087 AM.
         * </p>
         * 
         * @param lastBackupTime
         *        The date and time a resource was last backed up, in Unix format and Coordinated Universal Time (UTC).
         *        The value of <code>LastBackupTime</code> is accurate to milliseconds. For example, the value
         *        1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastBackupTime(Instant lastBackupTime);

        /**
         * <p>
         * The non-unique name of the resource that belongs to the specified backup.
         * </p>
         * 
         * @param resourceName
         *        The non-unique name of the resource that belongs to the specified backup.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceName(String resourceName);

        /**
         * <p>
         * The ARN (Amazon Resource Name) of the backup vault that contains the most recent backup recovery point.
         * </p>
         * 
         * @param lastBackupVaultArn
         *        The ARN (Amazon Resource Name) of the backup vault that contains the most recent backup recovery
         *        point.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastBackupVaultArn(String lastBackupVaultArn);

        /**
         * <p>
         * The ARN (Amazon Resource Name) of the most recent recovery point.
         * </p>
         * 
         * @param lastRecoveryPointArn
         *        The ARN (Amazon Resource Name) of the most recent recovery point.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lastRecoveryPointArn(String lastRecoveryPointArn);
    }

    static final class BuilderImpl implements Builder {
        private String resourceArn;

        private String resourceType;

        private Instant lastBackupTime;

        private String resourceName;

        private String lastBackupVaultArn;

        private String lastRecoveryPointArn;

        private BuilderImpl() {
        }

        private BuilderImpl(ProtectedResource model) {
            resourceArn(model.resourceArn);
            resourceType(model.resourceType);
            lastBackupTime(model.lastBackupTime);
            resourceName(model.resourceName);
            lastBackupVaultArn(model.lastBackupVaultArn);
            lastRecoveryPointArn(model.lastRecoveryPointArn);
        }

        public final String getResourceArn() {
            return resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final Instant getLastBackupTime() {
            return lastBackupTime;
        }

        public final void setLastBackupTime(Instant lastBackupTime) {
            this.lastBackupTime = lastBackupTime;
        }

        @Override
        public final Builder lastBackupTime(Instant lastBackupTime) {
            this.lastBackupTime = lastBackupTime;
            return this;
        }

        public final String getResourceName() {
            return resourceName;
        }

        public final void setResourceName(String resourceName) {
            this.resourceName = resourceName;
        }

        @Override
        public final Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        public final String getLastBackupVaultArn() {
            return lastBackupVaultArn;
        }

        public final void setLastBackupVaultArn(String lastBackupVaultArn) {
            this.lastBackupVaultArn = lastBackupVaultArn;
        }

        @Override
        public final Builder lastBackupVaultArn(String lastBackupVaultArn) {
            this.lastBackupVaultArn = lastBackupVaultArn;
            return this;
        }

        public final String getLastRecoveryPointArn() {
            return lastRecoveryPointArn;
        }

        public final void setLastRecoveryPointArn(String lastRecoveryPointArn) {
            this.lastRecoveryPointArn = lastRecoveryPointArn;
        }

        @Override
        public final Builder lastRecoveryPointArn(String lastRecoveryPointArn) {
            this.lastRecoveryPointArn = lastRecoveryPointArn;
            return this;
        }

        @Override
        public ProtectedResource build() {
            return new ProtectedResource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
