/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListScanJobSummariesRequest extends BackupRequest implements
        ToCopyableBuilder<ListScanJobSummariesRequest.Builder, ListScanJobSummariesRequest> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountId").getter(getter(ListScanJobSummariesRequest::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("AccountId").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceType").getter(getter(ListScanJobSummariesRequest::resourceType))
            .setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("ResourceType").build()).build();

    private static final SdkField<String> MALWARE_SCANNER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MalwareScanner").getter(getter(ListScanJobSummariesRequest::malwareScannerAsString))
            .setter(setter(Builder::malwareScanner))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("MalwareScanner").build())
            .build();

    private static final SdkField<String> SCAN_RESULT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ScanResultStatus").getter(getter(ListScanJobSummariesRequest::scanResultStatusAsString))
            .setter(setter(Builder::scanResultStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("ScanResultStatus").build())
            .build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(ListScanJobSummariesRequest::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("State").build()).build();

    private static final SdkField<String> AGGREGATION_PERIOD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AggregationPeriod").getter(getter(ListScanJobSummariesRequest::aggregationPeriodAsString))
            .setter(setter(Builder::aggregationPeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("AggregationPeriod").build())
            .build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListScanJobSummariesRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListScanJobSummariesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD,
            RESOURCE_TYPE_FIELD, MALWARE_SCANNER_FIELD, SCAN_RESULT_STATUS_FIELD, STATE_FIELD, AGGREGATION_PERIOD_FIELD,
            MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String accountId;

    private final String resourceType;

    private final String malwareScanner;

    private final String scanResultStatus;

    private final String state;

    private final String aggregationPeriod;

    private final Integer maxResults;

    private final String nextToken;

    private ListScanJobSummariesRequest(BuilderImpl builder) {
        super(builder);
        this.accountId = builder.accountId;
        this.resourceType = builder.resourceType;
        this.malwareScanner = builder.malwareScanner;
        this.scanResultStatus = builder.scanResultStatus;
        this.state = builder.state;
        this.aggregationPeriod = builder.aggregationPeriod;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * Returns the job count for the specified account.
     * </p>
     * <p>
     * If the request is sent from a member account or an account not part of Amazon Web Services Organizations, jobs
     * within requestor's account will be returned.
     * </p>
     * <p>
     * Root, admin, and delegated administrator accounts can use the value <code>ANY</code> to return job counts from
     * every account in the organization.
     * </p>
     * <p>
     * <code>AGGREGATE_ALL</code> aggregates job counts from all accounts within the authenticated organization, then
     * returns the sum.
     * </p>
     * 
     * @return Returns the job count for the specified account.</p>
     *         <p>
     *         If the request is sent from a member account or an account not part of Amazon Web Services Organizations,
     *         jobs within requestor's account will be returned.
     *         </p>
     *         <p>
     *         Root, admin, and delegated administrator accounts can use the value <code>ANY</code> to return job counts
     *         from every account in the organization.
     *         </p>
     *         <p>
     *         <code>AGGREGATE_ALL</code> aggregates job counts from all accounts within the authenticated organization,
     *         then returns the sum.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * Returns the job count for the specified resource type. Use request <code>GetSupportedResourceTypes</code> to
     * obtain strings for supported resource types.
     * </p>
     * <p>
     * The the value <code>ANY</code> returns count of all resource types.
     * </p>
     * <p>
     * <code>AGGREGATE_ALL</code> aggregates job counts for all resource types and returns the sum.
     * </p>
     * 
     * @return Returns the job count for the specified resource type. Use request <code>GetSupportedResourceTypes</code>
     *         to obtain strings for supported resource types.</p>
     *         <p>
     *         The the value <code>ANY</code> returns count of all resource types.
     *         </p>
     *         <p>
     *         <code>AGGREGATE_ALL</code> aggregates job counts for all resource types and returns the sum.
     */
    public final String resourceType() {
        return resourceType;
    }

    /**
     * <p>
     * Returns only the scan jobs for the specified malware scanner. Currently the only MalwareScanner is
     * <code>GUARDDUTY</code>. But the field also supports <code>ANY</code>, and <code>AGGREGATE_ALL</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #malwareScanner}
     * will return {@link MalwareScanner#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #malwareScannerAsString}.
     * </p>
     * 
     * @return Returns only the scan jobs for the specified malware scanner. Currently the only MalwareScanner is
     *         <code>GUARDDUTY</code>. But the field also supports <code>ANY</code>, and <code>AGGREGATE_ALL</code>.
     * @see MalwareScanner
     */
    public final MalwareScanner malwareScanner() {
        return MalwareScanner.fromValue(malwareScanner);
    }

    /**
     * <p>
     * Returns only the scan jobs for the specified malware scanner. Currently the only MalwareScanner is
     * <code>GUARDDUTY</code>. But the field also supports <code>ANY</code>, and <code>AGGREGATE_ALL</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #malwareScanner}
     * will return {@link MalwareScanner#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #malwareScannerAsString}.
     * </p>
     * 
     * @return Returns only the scan jobs for the specified malware scanner. Currently the only MalwareScanner is
     *         <code>GUARDDUTY</code>. But the field also supports <code>ANY</code>, and <code>AGGREGATE_ALL</code>.
     * @see MalwareScanner
     */
    public final String malwareScannerAsString() {
        return malwareScanner;
    }

    /**
     * <p>
     * Returns only the scan jobs for the specified scan results.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scanResultStatus}
     * will return {@link ScanResultStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #scanResultStatusAsString}.
     * </p>
     * 
     * @return Returns only the scan jobs for the specified scan results.
     * @see ScanResultStatus
     */
    public final ScanResultStatus scanResultStatus() {
        return ScanResultStatus.fromValue(scanResultStatus);
    }

    /**
     * <p>
     * Returns only the scan jobs for the specified scan results.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #scanResultStatus}
     * will return {@link ScanResultStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #scanResultStatusAsString}.
     * </p>
     * 
     * @return Returns only the scan jobs for the specified scan results.
     * @see ScanResultStatus
     */
    public final String scanResultStatusAsString() {
        return scanResultStatus;
    }

    /**
     * <p>
     * Returns only the scan jobs for the specified scanning job state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ScanJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return Returns only the scan jobs for the specified scanning job state.
     * @see ScanJobStatus
     */
    public final ScanJobStatus state() {
        return ScanJobStatus.fromValue(state);
    }

    /**
     * <p>
     * Returns only the scan jobs for the specified scanning job state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ScanJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return Returns only the scan jobs for the specified scanning job state.
     * @see ScanJobStatus
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The period for the returned results.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ONE_DAY</code>The daily job count for the prior 1 day.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SEVEN_DAYS</code>The daily job count for the prior 7 days.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FOURTEEN_DAYS</code>The daily job count for the prior 14 days.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #aggregationPeriod}
     * will return {@link AggregationPeriod#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #aggregationPeriodAsString}.
     * </p>
     * 
     * @return The period for the returned results.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ONE_DAY</code>The daily job count for the prior 1 day.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SEVEN_DAYS</code>The daily job count for the prior 7 days.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FOURTEEN_DAYS</code>The daily job count for the prior 14 days.
     *         </p>
     *         </li>
     * @see AggregationPeriod
     */
    public final AggregationPeriod aggregationPeriod() {
        return AggregationPeriod.fromValue(aggregationPeriod);
    }

    /**
     * <p>
     * The period for the returned results.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ONE_DAY</code>The daily job count for the prior 1 day.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SEVEN_DAYS</code>The daily job count for the prior 7 days.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FOURTEEN_DAYS</code>The daily job count for the prior 14 days.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #aggregationPeriod}
     * will return {@link AggregationPeriod#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #aggregationPeriodAsString}.
     * </p>
     * 
     * @return The period for the returned results.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ONE_DAY</code>The daily job count for the prior 1 day.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SEVEN_DAYS</code>The daily job count for the prior 7 days.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FOURTEEN_DAYS</code>The daily job count for the prior 14 days.
     *         </p>
     *         </li>
     * @see AggregationPeriod
     */
    public final String aggregationPeriodAsString() {
        return aggregationPeriod;
    }

    /**
     * <p>
     * The maximum number of items to be returned.
     * </p>
     * <p>
     * The value is an integer. Range of accepted values is from 1 to 500.
     * </p>
     * 
     * @return The maximum number of items to be returned.</p>
     *         <p>
     *         The value is an integer. Range of accepted values is from 1 to 500.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The next item following a partial list of returned items. For example, if a request is made to return
     * <code>MaxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list
     * starting at the location pointed to by the next token.
     * </p>
     * 
     * @return The next item following a partial list of returned items. For example, if a request is made to return
     *         <code>MaxResults</code> number of items, <code>NextToken</code> allows you to return more items in your
     *         list starting at the location pointed to by the next token.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(malwareScannerAsString());
        hashCode = 31 * hashCode + Objects.hashCode(scanResultStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(aggregationPeriodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListScanJobSummariesRequest)) {
            return false;
        }
        ListScanJobSummariesRequest other = (ListScanJobSummariesRequest) obj;
        return Objects.equals(accountId(), other.accountId()) && Objects.equals(resourceType(), other.resourceType())
                && Objects.equals(malwareScannerAsString(), other.malwareScannerAsString())
                && Objects.equals(scanResultStatusAsString(), other.scanResultStatusAsString())
                && Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(aggregationPeriodAsString(), other.aggregationPeriodAsString())
                && Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListScanJobSummariesRequest").add("AccountId", accountId()).add("ResourceType", resourceType())
                .add("MalwareScanner", malwareScannerAsString()).add("ScanResultStatus", scanResultStatusAsString())
                .add("State", stateAsString()).add("AggregationPeriod", aggregationPeriodAsString())
                .add("MaxResults", maxResults()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceType()));
        case "MalwareScanner":
            return Optional.ofNullable(clazz.cast(malwareScannerAsString()));
        case "ScanResultStatus":
            return Optional.ofNullable(clazz.cast(scanResultStatusAsString()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "AggregationPeriod":
            return Optional.ofNullable(clazz.cast(aggregationPeriodAsString()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AccountId", ACCOUNT_ID_FIELD);
        map.put("ResourceType", RESOURCE_TYPE_FIELD);
        map.put("MalwareScanner", MALWARE_SCANNER_FIELD);
        map.put("ScanResultStatus", SCAN_RESULT_STATUS_FIELD);
        map.put("State", STATE_FIELD);
        map.put("AggregationPeriod", AGGREGATION_PERIOD_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListScanJobSummariesRequest, T> g) {
        return obj -> g.apply((ListScanJobSummariesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BackupRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListScanJobSummariesRequest> {
        /**
         * <p>
         * Returns the job count for the specified account.
         * </p>
         * <p>
         * If the request is sent from a member account or an account not part of Amazon Web Services Organizations,
         * jobs within requestor's account will be returned.
         * </p>
         * <p>
         * Root, admin, and delegated administrator accounts can use the value <code>ANY</code> to return job counts
         * from every account in the organization.
         * </p>
         * <p>
         * <code>AGGREGATE_ALL</code> aggregates job counts from all accounts within the authenticated organization,
         * then returns the sum.
         * </p>
         * 
         * @param accountId
         *        Returns the job count for the specified account.</p>
         *        <p>
         *        If the request is sent from a member account or an account not part of Amazon Web Services
         *        Organizations, jobs within requestor's account will be returned.
         *        </p>
         *        <p>
         *        Root, admin, and delegated administrator accounts can use the value <code>ANY</code> to return job
         *        counts from every account in the organization.
         *        </p>
         *        <p>
         *        <code>AGGREGATE_ALL</code> aggregates job counts from all accounts within the authenticated
         *        organization, then returns the sum.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * Returns the job count for the specified resource type. Use request <code>GetSupportedResourceTypes</code> to
         * obtain strings for supported resource types.
         * </p>
         * <p>
         * The the value <code>ANY</code> returns count of all resource types.
         * </p>
         * <p>
         * <code>AGGREGATE_ALL</code> aggregates job counts for all resource types and returns the sum.
         * </p>
         * 
         * @param resourceType
         *        Returns the job count for the specified resource type. Use request
         *        <code>GetSupportedResourceTypes</code> to obtain strings for supported resource types.</p>
         *        <p>
         *        The the value <code>ANY</code> returns count of all resource types.
         *        </p>
         *        <p>
         *        <code>AGGREGATE_ALL</code> aggregates job counts for all resource types and returns the sum.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * Returns only the scan jobs for the specified malware scanner. Currently the only MalwareScanner is
         * <code>GUARDDUTY</code>. But the field also supports <code>ANY</code>, and <code>AGGREGATE_ALL</code>.
         * </p>
         * 
         * @param malwareScanner
         *        Returns only the scan jobs for the specified malware scanner. Currently the only MalwareScanner is
         *        <code>GUARDDUTY</code>. But the field also supports <code>ANY</code>, and <code>AGGREGATE_ALL</code>.
         * @see MalwareScanner
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MalwareScanner
         */
        Builder malwareScanner(String malwareScanner);

        /**
         * <p>
         * Returns only the scan jobs for the specified malware scanner. Currently the only MalwareScanner is
         * <code>GUARDDUTY</code>. But the field also supports <code>ANY</code>, and <code>AGGREGATE_ALL</code>.
         * </p>
         * 
         * @param malwareScanner
         *        Returns only the scan jobs for the specified malware scanner. Currently the only MalwareScanner is
         *        <code>GUARDDUTY</code>. But the field also supports <code>ANY</code>, and <code>AGGREGATE_ALL</code>.
         * @see MalwareScanner
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MalwareScanner
         */
        Builder malwareScanner(MalwareScanner malwareScanner);

        /**
         * <p>
         * Returns only the scan jobs for the specified scan results.
         * </p>
         * 
         * @param scanResultStatus
         *        Returns only the scan jobs for the specified scan results.
         * @see ScanResultStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScanResultStatus
         */
        Builder scanResultStatus(String scanResultStatus);

        /**
         * <p>
         * Returns only the scan jobs for the specified scan results.
         * </p>
         * 
         * @param scanResultStatus
         *        Returns only the scan jobs for the specified scan results.
         * @see ScanResultStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScanResultStatus
         */
        Builder scanResultStatus(ScanResultStatus scanResultStatus);

        /**
         * <p>
         * Returns only the scan jobs for the specified scanning job state.
         * </p>
         * 
         * @param state
         *        Returns only the scan jobs for the specified scanning job state.
         * @see ScanJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScanJobStatus
         */
        Builder state(String state);

        /**
         * <p>
         * Returns only the scan jobs for the specified scanning job state.
         * </p>
         * 
         * @param state
         *        Returns only the scan jobs for the specified scanning job state.
         * @see ScanJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScanJobStatus
         */
        Builder state(ScanJobStatus state);

        /**
         * <p>
         * The period for the returned results.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ONE_DAY</code>The daily job count for the prior 1 day.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SEVEN_DAYS</code>The daily job count for the prior 7 days.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FOURTEEN_DAYS</code>The daily job count for the prior 14 days.
         * </p>
         * </li>
         * </ul>
         * 
         * @param aggregationPeriod
         *        The period for the returned results.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ONE_DAY</code>The daily job count for the prior 1 day.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SEVEN_DAYS</code>The daily job count for the prior 7 days.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FOURTEEN_DAYS</code>The daily job count for the prior 14 days.
         *        </p>
         *        </li>
         * @see AggregationPeriod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AggregationPeriod
         */
        Builder aggregationPeriod(String aggregationPeriod);

        /**
         * <p>
         * The period for the returned results.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ONE_DAY</code>The daily job count for the prior 1 day.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SEVEN_DAYS</code>The daily job count for the prior 7 days.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FOURTEEN_DAYS</code>The daily job count for the prior 14 days.
         * </p>
         * </li>
         * </ul>
         * 
         * @param aggregationPeriod
         *        The period for the returned results.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ONE_DAY</code>The daily job count for the prior 1 day.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SEVEN_DAYS</code>The daily job count for the prior 7 days.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FOURTEEN_DAYS</code>The daily job count for the prior 14 days.
         *        </p>
         *        </li>
         * @see AggregationPeriod
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AggregationPeriod
         */
        Builder aggregationPeriod(AggregationPeriod aggregationPeriod);

        /**
         * <p>
         * The maximum number of items to be returned.
         * </p>
         * <p>
         * The value is an integer. Range of accepted values is from 1 to 500.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of items to be returned.</p>
         *        <p>
         *        The value is an integer. Range of accepted values is from 1 to 500.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The next item following a partial list of returned items. For example, if a request is made to return
         * <code>MaxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list
         * starting at the location pointed to by the next token.
         * </p>
         * 
         * @param nextToken
         *        The next item following a partial list of returned items. For example, if a request is made to return
         *        <code>MaxResults</code> number of items, <code>NextToken</code> allows you to return more items in
         *        your list starting at the location pointed to by the next token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BackupRequest.BuilderImpl implements Builder {
        private String accountId;

        private String resourceType;

        private String malwareScanner;

        private String scanResultStatus;

        private String state;

        private String aggregationPeriod;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListScanJobSummariesRequest model) {
            super(model);
            accountId(model.accountId);
            resourceType(model.resourceType);
            malwareScanner(model.malwareScanner);
            scanResultStatus(model.scanResultStatus);
            state(model.state);
            aggregationPeriod(model.aggregationPeriod);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final String getMalwareScanner() {
            return malwareScanner;
        }

        public final void setMalwareScanner(String malwareScanner) {
            this.malwareScanner = malwareScanner;
        }

        @Override
        public final Builder malwareScanner(String malwareScanner) {
            this.malwareScanner = malwareScanner;
            return this;
        }

        @Override
        public final Builder malwareScanner(MalwareScanner malwareScanner) {
            this.malwareScanner(malwareScanner == null ? null : malwareScanner.toString());
            return this;
        }

        public final String getScanResultStatus() {
            return scanResultStatus;
        }

        public final void setScanResultStatus(String scanResultStatus) {
            this.scanResultStatus = scanResultStatus;
        }

        @Override
        public final Builder scanResultStatus(String scanResultStatus) {
            this.scanResultStatus = scanResultStatus;
            return this;
        }

        @Override
        public final Builder scanResultStatus(ScanResultStatus scanResultStatus) {
            this.scanResultStatus(scanResultStatus == null ? null : scanResultStatus.toString());
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ScanJobStatus state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getAggregationPeriod() {
            return aggregationPeriod;
        }

        public final void setAggregationPeriod(String aggregationPeriod) {
            this.aggregationPeriod = aggregationPeriod;
        }

        @Override
        public final Builder aggregationPeriod(String aggregationPeriod) {
            this.aggregationPeriod = aggregationPeriod;
            return this;
        }

        @Override
        public final Builder aggregationPeriod(AggregationPeriod aggregationPeriod) {
            this.aggregationPeriod(aggregationPeriod == null ? null : aggregationPeriod.toString());
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListScanJobSummariesRequest build() {
            return new ListScanJobSummariesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
