/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateTieringConfigurationRequest extends BackupRequest implements
        ToCopyableBuilder<CreateTieringConfigurationRequest.Builder, CreateTieringConfigurationRequest> {
    private static final SdkField<TieringConfigurationInputForCreate> TIERING_CONFIGURATION_FIELD = SdkField
            .<TieringConfigurationInputForCreate> builder(MarshallingType.SDK_POJO).memberName("TieringConfiguration")
            .getter(getter(CreateTieringConfigurationRequest::tieringConfiguration))
            .setter(setter(Builder::tieringConfiguration)).constructor(TieringConfigurationInputForCreate::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TieringConfiguration").build())
            .build();

    private static final SdkField<Map<String, String>> TIERING_CONFIGURATION_TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("TieringConfigurationTags")
            .getter(getter(CreateTieringConfigurationRequest::tieringConfigurationTags))
            .setter(setter(Builder::tieringConfigurationTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TieringConfigurationTags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> CREATOR_REQUEST_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CreatorRequestId")
            .getter(getter(CreateTieringConfigurationRequest::creatorRequestId))
            .setter(setter(Builder::creatorRequestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatorRequestId").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIERING_CONFIGURATION_FIELD,
            TIERING_CONFIGURATION_TAGS_FIELD, CREATOR_REQUEST_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final TieringConfigurationInputForCreate tieringConfiguration;

    private final Map<String, String> tieringConfigurationTags;

    private final String creatorRequestId;

    private CreateTieringConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.tieringConfiguration = builder.tieringConfiguration;
        this.tieringConfigurationTags = builder.tieringConfigurationTags;
        this.creatorRequestId = builder.creatorRequestId;
    }

    /**
     * <p>
     * A tiering configuration must contain a unique <code>TieringConfigurationName</code> string you create and must
     * contain a <code>BackupVaultName</code> and <code>ResourceSelection</code>. You may optionally include a
     * <code>CreatorRequestId</code> string.
     * </p>
     * <p>
     * The <code>TieringConfigurationName</code> is a unique string that is the name of the tiering configuration. This
     * cannot be changed after creation, and it must consist of only alphanumeric characters and underscores.
     * </p>
     * 
     * @return A tiering configuration must contain a unique <code>TieringConfigurationName</code> string you create and
     *         must contain a <code>BackupVaultName</code> and <code>ResourceSelection</code>. You may optionally
     *         include a <code>CreatorRequestId</code> string.</p>
     *         <p>
     *         The <code>TieringConfigurationName</code> is a unique string that is the name of the tiering
     *         configuration. This cannot be changed after creation, and it must consist of only alphanumeric characters
     *         and underscores.
     */
    public final TieringConfigurationInputForCreate tieringConfiguration() {
        return tieringConfiguration;
    }

    /**
     * For responses, this returns true if the service returned a value for the TieringConfigurationTags property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasTieringConfigurationTags() {
        return tieringConfigurationTags != null && !(tieringConfigurationTags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags to assign to the tiering configuration.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTieringConfigurationTags} method.
     * </p>
     * 
     * @return The tags to assign to the tiering configuration.
     */
    public final Map<String, String> tieringConfigurationTags() {
        return tieringConfigurationTags;
    }

    /**
     * <p>
     * This is a unique string that identifies the request and allows failed requests to be retried without the risk of
     * running the operation twice. This parameter is optional. If used, this parameter must contain 1 to 50
     * alphanumeric or '-_.' characters.
     * </p>
     * 
     * @return This is a unique string that identifies the request and allows failed requests to be retried without the
     *         risk of running the operation twice. This parameter is optional. If used, this parameter must contain 1
     *         to 50 alphanumeric or '-_.' characters.
     */
    public final String creatorRequestId() {
        return creatorRequestId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(tieringConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasTieringConfigurationTags() ? tieringConfigurationTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(creatorRequestId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateTieringConfigurationRequest)) {
            return false;
        }
        CreateTieringConfigurationRequest other = (CreateTieringConfigurationRequest) obj;
        return Objects.equals(tieringConfiguration(), other.tieringConfiguration())
                && hasTieringConfigurationTags() == other.hasTieringConfigurationTags()
                && Objects.equals(tieringConfigurationTags(), other.tieringConfigurationTags())
                && Objects.equals(creatorRequestId(), other.creatorRequestId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateTieringConfigurationRequest").add("TieringConfiguration", tieringConfiguration())
                .add("TieringConfigurationTags", tieringConfigurationTags() == null ? null : "*** Sensitive Data Redacted ***")
                .add("CreatorRequestId", creatorRequestId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "TieringConfiguration":
            return Optional.ofNullable(clazz.cast(tieringConfiguration()));
        case "TieringConfigurationTags":
            return Optional.ofNullable(clazz.cast(tieringConfigurationTags()));
        case "CreatorRequestId":
            return Optional.ofNullable(clazz.cast(creatorRequestId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("TieringConfiguration", TIERING_CONFIGURATION_FIELD);
        map.put("TieringConfigurationTags", TIERING_CONFIGURATION_TAGS_FIELD);
        map.put("CreatorRequestId", CREATOR_REQUEST_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateTieringConfigurationRequest, T> g) {
        return obj -> g.apply((CreateTieringConfigurationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BackupRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateTieringConfigurationRequest> {
        /**
         * <p>
         * A tiering configuration must contain a unique <code>TieringConfigurationName</code> string you create and
         * must contain a <code>BackupVaultName</code> and <code>ResourceSelection</code>. You may optionally include a
         * <code>CreatorRequestId</code> string.
         * </p>
         * <p>
         * The <code>TieringConfigurationName</code> is a unique string that is the name of the tiering configuration.
         * This cannot be changed after creation, and it must consist of only alphanumeric characters and underscores.
         * </p>
         * 
         * @param tieringConfiguration
         *        A tiering configuration must contain a unique <code>TieringConfigurationName</code> string you create
         *        and must contain a <code>BackupVaultName</code> and <code>ResourceSelection</code>. You may optionally
         *        include a <code>CreatorRequestId</code> string.</p>
         *        <p>
         *        The <code>TieringConfigurationName</code> is a unique string that is the name of the tiering
         *        configuration. This cannot be changed after creation, and it must consist of only alphanumeric
         *        characters and underscores.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tieringConfiguration(TieringConfigurationInputForCreate tieringConfiguration);

        /**
         * <p>
         * A tiering configuration must contain a unique <code>TieringConfigurationName</code> string you create and
         * must contain a <code>BackupVaultName</code> and <code>ResourceSelection</code>. You may optionally include a
         * <code>CreatorRequestId</code> string.
         * </p>
         * <p>
         * The <code>TieringConfigurationName</code> is a unique string that is the name of the tiering configuration.
         * This cannot be changed after creation, and it must consist of only alphanumeric characters and underscores.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link TieringConfigurationInputForCreate.Builder} avoiding the need to create one manually via
         * {@link TieringConfigurationInputForCreate#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TieringConfigurationInputForCreate.Builder#build()} is called
         * immediately and its result is passed to {@link #tieringConfiguration(TieringConfigurationInputForCreate)}.
         * 
         * @param tieringConfiguration
         *        a consumer that will call methods on {@link TieringConfigurationInputForCreate.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tieringConfiguration(TieringConfigurationInputForCreate)
         */
        default Builder tieringConfiguration(Consumer<TieringConfigurationInputForCreate.Builder> tieringConfiguration) {
            return tieringConfiguration(TieringConfigurationInputForCreate.builder().applyMutation(tieringConfiguration).build());
        }

        /**
         * <p>
         * The tags to assign to the tiering configuration.
         * </p>
         * 
         * @param tieringConfigurationTags
         *        The tags to assign to the tiering configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tieringConfigurationTags(Map<String, String> tieringConfigurationTags);

        /**
         * <p>
         * This is a unique string that identifies the request and allows failed requests to be retried without the risk
         * of running the operation twice. This parameter is optional. If used, this parameter must contain 1 to 50
         * alphanumeric or '-_.' characters.
         * </p>
         * 
         * @param creatorRequestId
         *        This is a unique string that identifies the request and allows failed requests to be retried without
         *        the risk of running the operation twice. This parameter is optional. If used, this parameter must
         *        contain 1 to 50 alphanumeric or '-_.' characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creatorRequestId(String creatorRequestId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BackupRequest.BuilderImpl implements Builder {
        private TieringConfigurationInputForCreate tieringConfiguration;

        private Map<String, String> tieringConfigurationTags = DefaultSdkAutoConstructMap.getInstance();

        private String creatorRequestId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateTieringConfigurationRequest model) {
            super(model);
            tieringConfiguration(model.tieringConfiguration);
            tieringConfigurationTags(model.tieringConfigurationTags);
            creatorRequestId(model.creatorRequestId);
        }

        public final TieringConfigurationInputForCreate.Builder getTieringConfiguration() {
            return tieringConfiguration != null ? tieringConfiguration.toBuilder() : null;
        }

        public final void setTieringConfiguration(TieringConfigurationInputForCreate.BuilderImpl tieringConfiguration) {
            this.tieringConfiguration = tieringConfiguration != null ? tieringConfiguration.build() : null;
        }

        @Override
        public final Builder tieringConfiguration(TieringConfigurationInputForCreate tieringConfiguration) {
            this.tieringConfiguration = tieringConfiguration;
            return this;
        }

        public final Map<String, String> getTieringConfigurationTags() {
            if (tieringConfigurationTags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tieringConfigurationTags;
        }

        public final void setTieringConfigurationTags(Map<String, String> tieringConfigurationTags) {
            this.tieringConfigurationTags = TagsCopier.copy(tieringConfigurationTags);
        }

        @Override
        public final Builder tieringConfigurationTags(Map<String, String> tieringConfigurationTags) {
            this.tieringConfigurationTags = TagsCopier.copy(tieringConfigurationTags);
            return this;
        }

        public final String getCreatorRequestId() {
            return creatorRequestId;
        }

        public final void setCreatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
        }

        @Override
        public final Builder creatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateTieringConfigurationRequest build() {
            return new CreateTieringConfigurationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
