/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.backup.BackupClient;
import software.amazon.awssdk.services.backup.internal.UserAgentUtils;
import software.amazon.awssdk.services.backup.model.ListScanJobsRequest;
import software.amazon.awssdk.services.backup.model.ListScanJobsResponse;
import software.amazon.awssdk.services.backup.model.ScanJob;

public class ListScanJobsIterable
implements SdkIterable<ListScanJobsResponse> {
    private final BackupClient client;
    private final ListScanJobsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListScanJobsIterable(BackupClient client, ListScanJobsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListScanJobsResponseFetcher();
    }

    public Iterator<ListScanJobsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ScanJob> scanJobs() {
        Function<ListScanJobsResponse, Iterator> getIterator = response -> {
            if (response != null && response.scanJobs() != null) {
                return response.scanJobs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListScanJobsResponseFetcher
    implements SyncPageFetcher<ListScanJobsResponse> {
        private ListScanJobsResponseFetcher() {
        }

        public boolean hasNextPage(ListScanJobsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListScanJobsResponse nextPage(ListScanJobsResponse previousPage) {
            if (previousPage == null) {
                return ListScanJobsIterable.this.client.listScanJobs(ListScanJobsIterable.this.firstRequest);
            }
            return ListScanJobsIterable.this.client.listScanJobs((ListScanJobsRequest)((Object)ListScanJobsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

