/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.backup.model.AggregationPeriod;
import software.amazon.awssdk.services.backup.model.BackupRequest;
import software.amazon.awssdk.services.backup.model.MalwareScanner;
import software.amazon.awssdk.services.backup.model.ScanJobStatus;
import software.amazon.awssdk.services.backup.model.ScanResultStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListScanJobSummariesRequest
extends BackupRequest
implements ToCopyableBuilder<Builder, ListScanJobSummariesRequest> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountId").getter(ListScanJobSummariesRequest.getter(ListScanJobSummariesRequest::accountId)).setter(ListScanJobSummariesRequest.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("AccountId").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceType").getter(ListScanJobSummariesRequest.getter(ListScanJobSummariesRequest::resourceType)).setter(ListScanJobSummariesRequest.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("ResourceType").build()}).build();
    private static final SdkField<String> MALWARE_SCANNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MalwareScanner").getter(ListScanJobSummariesRequest.getter(ListScanJobSummariesRequest::malwareScannerAsString)).setter(ListScanJobSummariesRequest.setter(Builder::malwareScanner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("MalwareScanner").build()}).build();
    private static final SdkField<String> SCAN_RESULT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScanResultStatus").getter(ListScanJobSummariesRequest.getter(ListScanJobSummariesRequest::scanResultStatusAsString)).setter(ListScanJobSummariesRequest.setter(Builder::scanResultStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("ScanResultStatus").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(ListScanJobSummariesRequest.getter(ListScanJobSummariesRequest::stateAsString)).setter(ListScanJobSummariesRequest.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("State").build()}).build();
    private static final SdkField<String> AGGREGATION_PERIOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AggregationPeriod").getter(ListScanJobSummariesRequest.getter(ListScanJobSummariesRequest::aggregationPeriodAsString)).setter(ListScanJobSummariesRequest.setter(Builder::aggregationPeriod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("AggregationPeriod").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListScanJobSummariesRequest.getter(ListScanJobSummariesRequest::maxResults)).setter(ListScanJobSummariesRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("MaxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListScanJobSummariesRequest.getter(ListScanJobSummariesRequest::nextToken)).setter(ListScanJobSummariesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, RESOURCE_TYPE_FIELD, MALWARE_SCANNER_FIELD, SCAN_RESULT_STATUS_FIELD, STATE_FIELD, AGGREGATION_PERIOD_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListScanJobSummariesRequest.memberNameToFieldInitializer();
    private final String accountId;
    private final String resourceType;
    private final String malwareScanner;
    private final String scanResultStatus;
    private final String state;
    private final String aggregationPeriod;
    private final Integer maxResults;
    private final String nextToken;

    private ListScanJobSummariesRequest(BuilderImpl builder) {
        super(builder);
        this.accountId = builder.accountId;
        this.resourceType = builder.resourceType;
        this.malwareScanner = builder.malwareScanner;
        this.scanResultStatus = builder.scanResultStatus;
        this.state = builder.state;
        this.aggregationPeriod = builder.aggregationPeriod;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final String resourceType() {
        return this.resourceType;
    }

    public final MalwareScanner malwareScanner() {
        return MalwareScanner.fromValue(this.malwareScanner);
    }

    public final String malwareScannerAsString() {
        return this.malwareScanner;
    }

    public final ScanResultStatus scanResultStatus() {
        return ScanResultStatus.fromValue(this.scanResultStatus);
    }

    public final String scanResultStatusAsString() {
        return this.scanResultStatus;
    }

    public final ScanJobStatus state() {
        return ScanJobStatus.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final AggregationPeriod aggregationPeriod() {
        return AggregationPeriod.fromValue(this.aggregationPeriod);
    }

    public final String aggregationPeriodAsString() {
        return this.aggregationPeriod;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.malwareScannerAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.scanResultStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.aggregationPeriodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListScanJobSummariesRequest)) {
            return false;
        }
        ListScanJobSummariesRequest other = (ListScanJobSummariesRequest)((Object)obj);
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.resourceType(), other.resourceType()) && Objects.equals(this.malwareScannerAsString(), other.malwareScannerAsString()) && Objects.equals(this.scanResultStatusAsString(), other.scanResultStatusAsString()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.aggregationPeriodAsString(), other.aggregationPeriodAsString()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListScanJobSummariesRequest").add("AccountId", (Object)this.accountId()).add("ResourceType", (Object)this.resourceType()).add("MalwareScanner", (Object)this.malwareScannerAsString()).add("ScanResultStatus", (Object)this.scanResultStatusAsString()).add("State", (Object)this.stateAsString()).add("AggregationPeriod", (Object)this.aggregationPeriodAsString()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceType()));
            }
            case "MalwareScanner": {
                return Optional.ofNullable(clazz.cast(this.malwareScannerAsString()));
            }
            case "ScanResultStatus": {
                return Optional.ofNullable(clazz.cast(this.scanResultStatusAsString()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "AggregationPeriod": {
                return Optional.ofNullable(clazz.cast(this.aggregationPeriodAsString()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AccountId", ACCOUNT_ID_FIELD);
        map.put("ResourceType", RESOURCE_TYPE_FIELD);
        map.put("MalwareScanner", MALWARE_SCANNER_FIELD);
        map.put("ScanResultStatus", SCAN_RESULT_STATUS_FIELD);
        map.put("State", STATE_FIELD);
        map.put("AggregationPeriod", AGGREGATION_PERIOD_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListScanJobSummariesRequest, T> g) {
        return obj -> g.apply((ListScanJobSummariesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BackupRequest.BuilderImpl
    implements Builder {
        private String accountId;
        private String resourceType;
        private String malwareScanner;
        private String scanResultStatus;
        private String state;
        private String aggregationPeriod;
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListScanJobSummariesRequest model) {
            super(model);
            this.accountId(model.accountId);
            this.resourceType(model.resourceType);
            this.malwareScanner(model.malwareScanner);
            this.scanResultStatus(model.scanResultStatus);
            this.state(model.state);
            this.aggregationPeriod(model.aggregationPeriod);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final String getMalwareScanner() {
            return this.malwareScanner;
        }

        public final void setMalwareScanner(String malwareScanner) {
            this.malwareScanner = malwareScanner;
        }

        @Override
        public final Builder malwareScanner(String malwareScanner) {
            this.malwareScanner = malwareScanner;
            return this;
        }

        @Override
        public final Builder malwareScanner(MalwareScanner malwareScanner) {
            this.malwareScanner(malwareScanner == null ? null : malwareScanner.toString());
            return this;
        }

        public final String getScanResultStatus() {
            return this.scanResultStatus;
        }

        public final void setScanResultStatus(String scanResultStatus) {
            this.scanResultStatus = scanResultStatus;
        }

        @Override
        public final Builder scanResultStatus(String scanResultStatus) {
            this.scanResultStatus = scanResultStatus;
            return this;
        }

        @Override
        public final Builder scanResultStatus(ScanResultStatus scanResultStatus) {
            this.scanResultStatus(scanResultStatus == null ? null : scanResultStatus.toString());
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ScanJobStatus state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getAggregationPeriod() {
            return this.aggregationPeriod;
        }

        public final void setAggregationPeriod(String aggregationPeriod) {
            this.aggregationPeriod = aggregationPeriod;
        }

        @Override
        public final Builder aggregationPeriod(String aggregationPeriod) {
            this.aggregationPeriod = aggregationPeriod;
            return this;
        }

        @Override
        public final Builder aggregationPeriod(AggregationPeriod aggregationPeriod) {
            this.aggregationPeriod(aggregationPeriod == null ? null : aggregationPeriod.toString());
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListScanJobSummariesRequest build() {
            return new ListScanJobSummariesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BackupRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListScanJobSummariesRequest> {
        public Builder accountId(String var1);

        public Builder resourceType(String var1);

        public Builder malwareScanner(String var1);

        public Builder malwareScanner(MalwareScanner var1);

        public Builder scanResultStatus(String var1);

        public Builder scanResultStatus(ScanResultStatus var1);

        public Builder state(String var1);

        public Builder state(ScanJobStatus var1);

        public Builder aggregationPeriod(String var1);

        public Builder aggregationPeriod(AggregationPeriod var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

