/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.backup.model.BackupResponse;
import software.amazon.awssdk.services.backup.model.MalwareScanner;
import software.amazon.awssdk.services.backup.model.ScanJobCreator;
import software.amazon.awssdk.services.backup.model.ScanMode;
import software.amazon.awssdk.services.backup.model.ScanResourceType;
import software.amazon.awssdk.services.backup.model.ScanResultInfo;
import software.amazon.awssdk.services.backup.model.ScanState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeScanJobResponse
extends BackupResponse
implements ToCopyableBuilder<Builder, DescribeScanJobResponse> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountId").getter(DescribeScanJobResponse.getter(DescribeScanJobResponse::accountId)).setter(DescribeScanJobResponse.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()}).build();
    private static final SdkField<String> BACKUP_VAULT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BackupVaultArn").getter(DescribeScanJobResponse.getter(DescribeScanJobResponse::backupVaultArn)).setter(DescribeScanJobResponse.setter(Builder::backupVaultArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupVaultArn").build()}).build();
    private static final SdkField<String> BACKUP_VAULT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BackupVaultName").getter(DescribeScanJobResponse.getter(DescribeScanJobResponse::backupVaultName)).setter(DescribeScanJobResponse.setter(Builder::backupVaultName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupVaultName").build()}).build();
    private static final SdkField<Instant> COMPLETION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CompletionDate").getter(DescribeScanJobResponse.getter(DescribeScanJobResponse::completionDate)).setter(DescribeScanJobResponse.setter(Builder::completionDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompletionDate").build()}).build();
    private static final SdkField<ScanJobCreator> CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("CreatedBy").getter(DescribeScanJobResponse.getter(DescribeScanJobResponse::createdBy)).setter(DescribeScanJobResponse.setter(Builder::createdBy)).constructor(ScanJobCreator::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedBy").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreationDate").getter(DescribeScanJobResponse.getter(DescribeScanJobResponse::creationDate)).setter(DescribeScanJobResponse.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()}).build();
    private static final SdkField<String> IAM_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IamRoleArn").getter(DescribeScanJobResponse.getter(DescribeScanJobResponse::iamRoleArn)).setter(DescribeScanJobResponse.setter(Builder::iamRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamRoleArn").build()}).build();
    private static final SdkField<String> MALWARE_SCANNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MalwareScanner").getter(DescribeScanJobResponse.getter(DescribeScanJobResponse::malwareScannerAsString)).setter(DescribeScanJobResponse.setter(Builder::malwareScanner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MalwareScanner").build()}).build();
    private static final SdkField<String> RECOVERY_POINT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RecoveryPointArn").getter(DescribeScanJobResponse.getter(DescribeScanJobResponse::recoveryPointArn)).setter(DescribeScanJobResponse.setter(Builder::recoveryPointArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecoveryPointArn").build()}).build();
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceArn").getter(DescribeScanJobResponse.getter(DescribeScanJobResponse::resourceArn)).setter(DescribeScanJobResponse.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceArn").build()}).build();
    private static final SdkField<String> RESOURCE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceName").getter(DescribeScanJobResponse.getter(DescribeScanJobResponse::resourceName)).setter(DescribeScanJobResponse.setter(Builder::resourceName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceName").build()}).build();
    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResourceType").getter(DescribeScanJobResponse.getter(DescribeScanJobResponse::resourceTypeAsString)).setter(DescribeScanJobResponse.setter(Builder::resourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()}).build();
    private static final SdkField<String> SCAN_BASE_RECOVERY_POINT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScanBaseRecoveryPointArn").getter(DescribeScanJobResponse.getter(DescribeScanJobResponse::scanBaseRecoveryPointArn)).setter(DescribeScanJobResponse.setter(Builder::scanBaseRecoveryPointArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScanBaseRecoveryPointArn").build()}).build();
    private static final SdkField<String> SCAN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScanId").getter(DescribeScanJobResponse.getter(DescribeScanJobResponse::scanId)).setter(DescribeScanJobResponse.setter(Builder::scanId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScanId").build()}).build();
    private static final SdkField<String> SCAN_JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScanJobId").getter(DescribeScanJobResponse.getter(DescribeScanJobResponse::scanJobId)).setter(DescribeScanJobResponse.setter(Builder::scanJobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScanJobId").build()}).build();
    private static final SdkField<String> SCAN_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScanMode").getter(DescribeScanJobResponse.getter(DescribeScanJobResponse::scanModeAsString)).setter(DescribeScanJobResponse.setter(Builder::scanMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScanMode").build()}).build();
    private static final SdkField<ScanResultInfo> SCAN_RESULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ScanResult").getter(DescribeScanJobResponse.getter(DescribeScanJobResponse::scanResult)).setter(DescribeScanJobResponse.setter(Builder::scanResult)).constructor(ScanResultInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScanResult").build()}).build();
    private static final SdkField<String> SCANNER_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ScannerRoleArn").getter(DescribeScanJobResponse.getter(DescribeScanJobResponse::scannerRoleArn)).setter(DescribeScanJobResponse.setter(Builder::scannerRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScannerRoleArn").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(DescribeScanJobResponse.getter(DescribeScanJobResponse::stateAsString)).setter(DescribeScanJobResponse.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("StatusMessage").getter(DescribeScanJobResponse.getter(DescribeScanJobResponse::statusMessage)).setter(DescribeScanJobResponse.setter(Builder::statusMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatusMessage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, BACKUP_VAULT_ARN_FIELD, BACKUP_VAULT_NAME_FIELD, COMPLETION_DATE_FIELD, CREATED_BY_FIELD, CREATION_DATE_FIELD, IAM_ROLE_ARN_FIELD, MALWARE_SCANNER_FIELD, RECOVERY_POINT_ARN_FIELD, RESOURCE_ARN_FIELD, RESOURCE_NAME_FIELD, RESOURCE_TYPE_FIELD, SCAN_BASE_RECOVERY_POINT_ARN_FIELD, SCAN_ID_FIELD, SCAN_JOB_ID_FIELD, SCAN_MODE_FIELD, SCAN_RESULT_FIELD, SCANNER_ROLE_ARN_FIELD, STATE_FIELD, STATUS_MESSAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeScanJobResponse.memberNameToFieldInitializer();
    private final String accountId;
    private final String backupVaultArn;
    private final String backupVaultName;
    private final Instant completionDate;
    private final ScanJobCreator createdBy;
    private final Instant creationDate;
    private final String iamRoleArn;
    private final String malwareScanner;
    private final String recoveryPointArn;
    private final String resourceArn;
    private final String resourceName;
    private final String resourceType;
    private final String scanBaseRecoveryPointArn;
    private final String scanId;
    private final String scanJobId;
    private final String scanMode;
    private final ScanResultInfo scanResult;
    private final String scannerRoleArn;
    private final String state;
    private final String statusMessage;

    private DescribeScanJobResponse(BuilderImpl builder) {
        super(builder);
        this.accountId = builder.accountId;
        this.backupVaultArn = builder.backupVaultArn;
        this.backupVaultName = builder.backupVaultName;
        this.completionDate = builder.completionDate;
        this.createdBy = builder.createdBy;
        this.creationDate = builder.creationDate;
        this.iamRoleArn = builder.iamRoleArn;
        this.malwareScanner = builder.malwareScanner;
        this.recoveryPointArn = builder.recoveryPointArn;
        this.resourceArn = builder.resourceArn;
        this.resourceName = builder.resourceName;
        this.resourceType = builder.resourceType;
        this.scanBaseRecoveryPointArn = builder.scanBaseRecoveryPointArn;
        this.scanId = builder.scanId;
        this.scanJobId = builder.scanJobId;
        this.scanMode = builder.scanMode;
        this.scanResult = builder.scanResult;
        this.scannerRoleArn = builder.scannerRoleArn;
        this.state = builder.state;
        this.statusMessage = builder.statusMessage;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final String backupVaultArn() {
        return this.backupVaultArn;
    }

    public final String backupVaultName() {
        return this.backupVaultName;
    }

    public final Instant completionDate() {
        return this.completionDate;
    }

    public final ScanJobCreator createdBy() {
        return this.createdBy;
    }

    public final Instant creationDate() {
        return this.creationDate;
    }

    public final String iamRoleArn() {
        return this.iamRoleArn;
    }

    public final MalwareScanner malwareScanner() {
        return MalwareScanner.fromValue(this.malwareScanner);
    }

    public final String malwareScannerAsString() {
        return this.malwareScanner;
    }

    public final String recoveryPointArn() {
        return this.recoveryPointArn;
    }

    public final String resourceArn() {
        return this.resourceArn;
    }

    public final String resourceName() {
        return this.resourceName;
    }

    public final ScanResourceType resourceType() {
        return ScanResourceType.fromValue(this.resourceType);
    }

    public final String resourceTypeAsString() {
        return this.resourceType;
    }

    public final String scanBaseRecoveryPointArn() {
        return this.scanBaseRecoveryPointArn;
    }

    public final String scanId() {
        return this.scanId;
    }

    public final String scanJobId() {
        return this.scanJobId;
    }

    public final ScanMode scanMode() {
        return ScanMode.fromValue(this.scanMode);
    }

    public final String scanModeAsString() {
        return this.scanMode;
    }

    public final ScanResultInfo scanResult() {
        return this.scanResult;
    }

    public final String scannerRoleArn() {
        return this.scannerRoleArn;
    }

    public final ScanState state() {
        return ScanState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final String statusMessage() {
        return this.statusMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.backupVaultArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.backupVaultName());
        hashCode = 31 * hashCode + Objects.hashCode(this.completionDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.malwareScannerAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.recoveryPointArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceName());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.scanBaseRecoveryPointArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.scanId());
        hashCode = 31 * hashCode + Objects.hashCode(this.scanJobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.scanModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.scanResult());
        hashCode = 31 * hashCode + Objects.hashCode(this.scannerRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusMessage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeScanJobResponse)) {
            return false;
        }
        DescribeScanJobResponse other = (DescribeScanJobResponse)((Object)obj);
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.backupVaultArn(), other.backupVaultArn()) && Objects.equals(this.backupVaultName(), other.backupVaultName()) && Objects.equals(this.completionDate(), other.completionDate()) && Objects.equals(this.createdBy(), other.createdBy()) && Objects.equals(this.creationDate(), other.creationDate()) && Objects.equals(this.iamRoleArn(), other.iamRoleArn()) && Objects.equals(this.malwareScannerAsString(), other.malwareScannerAsString()) && Objects.equals(this.recoveryPointArn(), other.recoveryPointArn()) && Objects.equals(this.resourceArn(), other.resourceArn()) && Objects.equals(this.resourceName(), other.resourceName()) && Objects.equals(this.resourceTypeAsString(), other.resourceTypeAsString()) && Objects.equals(this.scanBaseRecoveryPointArn(), other.scanBaseRecoveryPointArn()) && Objects.equals(this.scanId(), other.scanId()) && Objects.equals(this.scanJobId(), other.scanJobId()) && Objects.equals(this.scanModeAsString(), other.scanModeAsString()) && Objects.equals(this.scanResult(), other.scanResult()) && Objects.equals(this.scannerRoleArn(), other.scannerRoleArn()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.statusMessage(), other.statusMessage());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeScanJobResponse").add("AccountId", (Object)this.accountId()).add("BackupVaultArn", (Object)this.backupVaultArn()).add("BackupVaultName", (Object)this.backupVaultName()).add("CompletionDate", (Object)this.completionDate()).add("CreatedBy", (Object)this.createdBy()).add("CreationDate", (Object)this.creationDate()).add("IamRoleArn", (Object)this.iamRoleArn()).add("MalwareScanner", (Object)this.malwareScannerAsString()).add("RecoveryPointArn", (Object)this.recoveryPointArn()).add("ResourceArn", (Object)this.resourceArn()).add("ResourceName", (Object)this.resourceName()).add("ResourceType", (Object)this.resourceTypeAsString()).add("ScanBaseRecoveryPointArn", (Object)this.scanBaseRecoveryPointArn()).add("ScanId", (Object)this.scanId()).add("ScanJobId", (Object)this.scanJobId()).add("ScanMode", (Object)this.scanModeAsString()).add("ScanResult", (Object)this.scanResult()).add("ScannerRoleArn", (Object)this.scannerRoleArn()).add("State", (Object)this.stateAsString()).add("StatusMessage", (Object)this.statusMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "BackupVaultArn": {
                return Optional.ofNullable(clazz.cast(this.backupVaultArn()));
            }
            case "BackupVaultName": {
                return Optional.ofNullable(clazz.cast(this.backupVaultName()));
            }
            case "CompletionDate": {
                return Optional.ofNullable(clazz.cast(this.completionDate()));
            }
            case "CreatedBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
            case "CreationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
            case "IamRoleArn": {
                return Optional.ofNullable(clazz.cast(this.iamRoleArn()));
            }
            case "MalwareScanner": {
                return Optional.ofNullable(clazz.cast(this.malwareScannerAsString()));
            }
            case "RecoveryPointArn": {
                return Optional.ofNullable(clazz.cast(this.recoveryPointArn()));
            }
            case "ResourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
            case "ResourceName": {
                return Optional.ofNullable(clazz.cast(this.resourceName()));
            }
            case "ResourceType": {
                return Optional.ofNullable(clazz.cast(this.resourceTypeAsString()));
            }
            case "ScanBaseRecoveryPointArn": {
                return Optional.ofNullable(clazz.cast(this.scanBaseRecoveryPointArn()));
            }
            case "ScanId": {
                return Optional.ofNullable(clazz.cast(this.scanId()));
            }
            case "ScanJobId": {
                return Optional.ofNullable(clazz.cast(this.scanJobId()));
            }
            case "ScanMode": {
                return Optional.ofNullable(clazz.cast(this.scanModeAsString()));
            }
            case "ScanResult": {
                return Optional.ofNullable(clazz.cast(this.scanResult()));
            }
            case "ScannerRoleArn": {
                return Optional.ofNullable(clazz.cast(this.scannerRoleArn()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "StatusMessage": {
                return Optional.ofNullable(clazz.cast(this.statusMessage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("AccountId", ACCOUNT_ID_FIELD);
        map.put("BackupVaultArn", BACKUP_VAULT_ARN_FIELD);
        map.put("BackupVaultName", BACKUP_VAULT_NAME_FIELD);
        map.put("CompletionDate", COMPLETION_DATE_FIELD);
        map.put("CreatedBy", CREATED_BY_FIELD);
        map.put("CreationDate", CREATION_DATE_FIELD);
        map.put("IamRoleArn", IAM_ROLE_ARN_FIELD);
        map.put("MalwareScanner", MALWARE_SCANNER_FIELD);
        map.put("RecoveryPointArn", RECOVERY_POINT_ARN_FIELD);
        map.put("ResourceArn", RESOURCE_ARN_FIELD);
        map.put("ResourceName", RESOURCE_NAME_FIELD);
        map.put("ResourceType", RESOURCE_TYPE_FIELD);
        map.put("ScanBaseRecoveryPointArn", SCAN_BASE_RECOVERY_POINT_ARN_FIELD);
        map.put("ScanId", SCAN_ID_FIELD);
        map.put("ScanJobId", SCAN_JOB_ID_FIELD);
        map.put("ScanMode", SCAN_MODE_FIELD);
        map.put("ScanResult", SCAN_RESULT_FIELD);
        map.put("ScannerRoleArn", SCANNER_ROLE_ARN_FIELD);
        map.put("State", STATE_FIELD);
        map.put("StatusMessage", STATUS_MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeScanJobResponse, T> g) {
        return obj -> g.apply((DescribeScanJobResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BackupResponse.BuilderImpl
    implements Builder {
        private String accountId;
        private String backupVaultArn;
        private String backupVaultName;
        private Instant completionDate;
        private ScanJobCreator createdBy;
        private Instant creationDate;
        private String iamRoleArn;
        private String malwareScanner;
        private String recoveryPointArn;
        private String resourceArn;
        private String resourceName;
        private String resourceType;
        private String scanBaseRecoveryPointArn;
        private String scanId;
        private String scanJobId;
        private String scanMode;
        private ScanResultInfo scanResult;
        private String scannerRoleArn;
        private String state;
        private String statusMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeScanJobResponse model) {
            super(model);
            this.accountId(model.accountId);
            this.backupVaultArn(model.backupVaultArn);
            this.backupVaultName(model.backupVaultName);
            this.completionDate(model.completionDate);
            this.createdBy(model.createdBy);
            this.creationDate(model.creationDate);
            this.iamRoleArn(model.iamRoleArn);
            this.malwareScanner(model.malwareScanner);
            this.recoveryPointArn(model.recoveryPointArn);
            this.resourceArn(model.resourceArn);
            this.resourceName(model.resourceName);
            this.resourceType(model.resourceType);
            this.scanBaseRecoveryPointArn(model.scanBaseRecoveryPointArn);
            this.scanId(model.scanId);
            this.scanJobId(model.scanJobId);
            this.scanMode(model.scanMode);
            this.scanResult(model.scanResult);
            this.scannerRoleArn(model.scannerRoleArn);
            this.state(model.state);
            this.statusMessage(model.statusMessage);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getBackupVaultArn() {
            return this.backupVaultArn;
        }

        public final void setBackupVaultArn(String backupVaultArn) {
            this.backupVaultArn = backupVaultArn;
        }

        @Override
        public final Builder backupVaultArn(String backupVaultArn) {
            this.backupVaultArn = backupVaultArn;
            return this;
        }

        public final String getBackupVaultName() {
            return this.backupVaultName;
        }

        public final void setBackupVaultName(String backupVaultName) {
            this.backupVaultName = backupVaultName;
        }

        @Override
        public final Builder backupVaultName(String backupVaultName) {
            this.backupVaultName = backupVaultName;
            return this;
        }

        public final Instant getCompletionDate() {
            return this.completionDate;
        }

        public final void setCompletionDate(Instant completionDate) {
            this.completionDate = completionDate;
        }

        @Override
        public final Builder completionDate(Instant completionDate) {
            this.completionDate = completionDate;
            return this;
        }

        public final ScanJobCreator.Builder getCreatedBy() {
            return this.createdBy != null ? this.createdBy.toBuilder() : null;
        }

        public final void setCreatedBy(ScanJobCreator.BuilderImpl createdBy) {
            this.createdBy = createdBy != null ? createdBy.build() : null;
        }

        @Override
        public final Builder createdBy(ScanJobCreator createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final String getIamRoleArn() {
            return this.iamRoleArn;
        }

        public final void setIamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
        }

        @Override
        public final Builder iamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
            return this;
        }

        public final String getMalwareScanner() {
            return this.malwareScanner;
        }

        public final void setMalwareScanner(String malwareScanner) {
            this.malwareScanner = malwareScanner;
        }

        @Override
        public final Builder malwareScanner(String malwareScanner) {
            this.malwareScanner = malwareScanner;
            return this;
        }

        @Override
        public final Builder malwareScanner(MalwareScanner malwareScanner) {
            this.malwareScanner(malwareScanner == null ? null : malwareScanner.toString());
            return this;
        }

        public final String getRecoveryPointArn() {
            return this.recoveryPointArn;
        }

        public final void setRecoveryPointArn(String recoveryPointArn) {
            this.recoveryPointArn = recoveryPointArn;
        }

        @Override
        public final Builder recoveryPointArn(String recoveryPointArn) {
            this.recoveryPointArn = recoveryPointArn;
            return this;
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final String getResourceName() {
            return this.resourceName;
        }

        public final void setResourceName(String resourceName) {
            this.resourceName = resourceName;
        }

        @Override
        public final Builder resourceName(String resourceName) {
            this.resourceName = resourceName;
            return this;
        }

        public final String getResourceType() {
            return this.resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        @Override
        public final Builder resourceType(ScanResourceType resourceType) {
            this.resourceType(resourceType == null ? null : resourceType.toString());
            return this;
        }

        public final String getScanBaseRecoveryPointArn() {
            return this.scanBaseRecoveryPointArn;
        }

        public final void setScanBaseRecoveryPointArn(String scanBaseRecoveryPointArn) {
            this.scanBaseRecoveryPointArn = scanBaseRecoveryPointArn;
        }

        @Override
        public final Builder scanBaseRecoveryPointArn(String scanBaseRecoveryPointArn) {
            this.scanBaseRecoveryPointArn = scanBaseRecoveryPointArn;
            return this;
        }

        public final String getScanId() {
            return this.scanId;
        }

        public final void setScanId(String scanId) {
            this.scanId = scanId;
        }

        @Override
        public final Builder scanId(String scanId) {
            this.scanId = scanId;
            return this;
        }

        public final String getScanJobId() {
            return this.scanJobId;
        }

        public final void setScanJobId(String scanJobId) {
            this.scanJobId = scanJobId;
        }

        @Override
        public final Builder scanJobId(String scanJobId) {
            this.scanJobId = scanJobId;
            return this;
        }

        public final String getScanMode() {
            return this.scanMode;
        }

        public final void setScanMode(String scanMode) {
            this.scanMode = scanMode;
        }

        @Override
        public final Builder scanMode(String scanMode) {
            this.scanMode = scanMode;
            return this;
        }

        @Override
        public final Builder scanMode(ScanMode scanMode) {
            this.scanMode(scanMode == null ? null : scanMode.toString());
            return this;
        }

        public final ScanResultInfo.Builder getScanResult() {
            return this.scanResult != null ? this.scanResult.toBuilder() : null;
        }

        public final void setScanResult(ScanResultInfo.BuilderImpl scanResult) {
            this.scanResult = scanResult != null ? scanResult.build() : null;
        }

        @Override
        public final Builder scanResult(ScanResultInfo scanResult) {
            this.scanResult = scanResult;
            return this;
        }

        public final String getScannerRoleArn() {
            return this.scannerRoleArn;
        }

        public final void setScannerRoleArn(String scannerRoleArn) {
            this.scannerRoleArn = scannerRoleArn;
        }

        @Override
        public final Builder scannerRoleArn(String scannerRoleArn) {
            this.scannerRoleArn = scannerRoleArn;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ScanState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getStatusMessage() {
            return this.statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        @Override
        public DescribeScanJobResponse build() {
            return new DescribeScanJobResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BackupResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeScanJobResponse> {
        public Builder accountId(String var1);

        public Builder backupVaultArn(String var1);

        public Builder backupVaultName(String var1);

        public Builder completionDate(Instant var1);

        public Builder createdBy(ScanJobCreator var1);

        default public Builder createdBy(Consumer<ScanJobCreator.Builder> createdBy) {
            return this.createdBy((ScanJobCreator)((ScanJobCreator.Builder)ScanJobCreator.builder().applyMutation(createdBy)).build());
        }

        public Builder creationDate(Instant var1);

        public Builder iamRoleArn(String var1);

        public Builder malwareScanner(String var1);

        public Builder malwareScanner(MalwareScanner var1);

        public Builder recoveryPointArn(String var1);

        public Builder resourceArn(String var1);

        public Builder resourceName(String var1);

        public Builder resourceType(String var1);

        public Builder resourceType(ScanResourceType var1);

        public Builder scanBaseRecoveryPointArn(String var1);

        public Builder scanId(String var1);

        public Builder scanJobId(String var1);

        public Builder scanMode(String var1);

        public Builder scanMode(ScanMode var1);

        public Builder scanResult(ScanResultInfo var1);

        default public Builder scanResult(Consumer<ScanResultInfo.Builder> scanResult) {
            return this.scanResult((ScanResultInfo)((ScanResultInfo.Builder)ScanResultInfo.builder().applyMutation(scanResult)).build());
        }

        public Builder scannerRoleArn(String var1);

        public Builder state(String var1);

        public Builder state(ScanState var1);

        public Builder statusMessage(String var1);
    }
}

