/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This contains metadata about a restore testing selection.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RestoreTestingSelectionForList implements SdkPojo, Serializable,
        ToCopyableBuilder<RestoreTestingSelectionForList.Builder, RestoreTestingSelectionForList> {
    private static final SdkField<Instant> CREATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationTime").getter(getter(RestoreTestingSelectionForList::creationTime))
            .setter(setter(Builder::creationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationTime").build()).build();

    private static final SdkField<String> IAM_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IamRoleArn").getter(getter(RestoreTestingSelectionForList::iamRoleArn))
            .setter(setter(Builder::iamRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamRoleArn").build()).build();

    private static final SdkField<String> PROTECTED_RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProtectedResourceType").getter(getter(RestoreTestingSelectionForList::protectedResourceType))
            .setter(setter(Builder::protectedResourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProtectedResourceType").build())
            .build();

    private static final SdkField<String> RESTORE_TESTING_PLAN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RestoreTestingPlanName").getter(getter(RestoreTestingSelectionForList::restoreTestingPlanName))
            .setter(setter(Builder::restoreTestingPlanName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestoreTestingPlanName").build())
            .build();

    private static final SdkField<String> RESTORE_TESTING_SELECTION_NAME_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("RestoreTestingSelectionName")
            .getter(getter(RestoreTestingSelectionForList::restoreTestingSelectionName))
            .setter(setter(Builder::restoreTestingSelectionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestoreTestingSelectionName")
                    .build()).build();

    private static final SdkField<Integer> VALIDATION_WINDOW_HOURS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ValidationWindowHours").getter(getter(RestoreTestingSelectionForList::validationWindowHours))
            .setter(setter(Builder::validationWindowHours))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationWindowHours").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATION_TIME_FIELD,
            IAM_ROLE_ARN_FIELD, PROTECTED_RESOURCE_TYPE_FIELD, RESTORE_TESTING_PLAN_NAME_FIELD,
            RESTORE_TESTING_SELECTION_NAME_FIELD, VALIDATION_WINDOW_HOURS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Instant creationTime;

    private final String iamRoleArn;

    private final String protectedResourceType;

    private final String restoreTestingPlanName;

    private final String restoreTestingSelectionName;

    private final Integer validationWindowHours;

    private RestoreTestingSelectionForList(BuilderImpl builder) {
        this.creationTime = builder.creationTime;
        this.iamRoleArn = builder.iamRoleArn;
        this.protectedResourceType = builder.protectedResourceType;
        this.restoreTestingPlanName = builder.restoreTestingPlanName;
        this.restoreTestingSelectionName = builder.restoreTestingSelectionName;
        this.validationWindowHours = builder.validationWindowHours;
    }

    /**
     * <p>
     * The date and time that a restore testing selection was created, in Unix format and Coordinated Universal Time
     * (UTC). The value of <code>CreationTime</code> is accurate to milliseconds. For example, the value 1516925490.087
     * represents Friday, January 26,2018 12:11:30.087 AM.
     * </p>
     * 
     * @return The date and time that a restore testing selection was created, in Unix format and Coordinated Universal
     *         Time (UTC). The value of <code>CreationTime</code> is accurate to milliseconds. For example, the value
     *         1516925490.087 represents Friday, January 26,2018 12:11:30.087 AM.
     */
    public final Instant creationTime() {
        return creationTime;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the IAM role that Backup uses to create the target resource; for example:
     * <code>arn:aws:iam::123456789012:role/S3Access</code>.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the IAM role that Backup uses to create the target resource; for
     *         example: <code>arn:aws:iam::123456789012:role/S3Access</code>.
     */
    public final String iamRoleArn() {
        return iamRoleArn;
    }

    /**
     * <p>
     * The type of Amazon Web Services resource included in a restore testing selection; for example, an Amazon EBS
     * volume or an Amazon RDS database.
     * </p>
     * 
     * @return The type of Amazon Web Services resource included in a restore testing selection; for example, an Amazon
     *         EBS volume or an Amazon RDS database.
     */
    public final String protectedResourceType() {
        return protectedResourceType;
    }

    /**
     * <p>
     * Unique string that is the name of the restore testing plan.
     * </p>
     * <p>
     * The name cannot be changed after creation. The name must consist of only alphanumeric characters and underscores.
     * Maximum length is 50.
     * </p>
     * 
     * @return Unique string that is the name of the restore testing plan.</p>
     *         <p>
     *         The name cannot be changed after creation. The name must consist of only alphanumeric characters and
     *         underscores. Maximum length is 50.
     */
    public final String restoreTestingPlanName() {
        return restoreTestingPlanName;
    }

    /**
     * <p>
     * Unique name of a restore testing selection.
     * </p>
     * <p>
     * The name consists of only alphanumeric characters and underscores. Maximum length is 50.
     * </p>
     * 
     * @return Unique name of a restore testing selection.</p>
     *         <p>
     *         The name consists of only alphanumeric characters and underscores. Maximum length is 50.
     */
    public final String restoreTestingSelectionName() {
        return restoreTestingSelectionName;
    }

    /**
     * <p>
     * This value represents the time, in hours, data is retained after a restore test so that optional validation can
     * be completed.
     * </p>
     * <p>
     * Accepted value is an integer between 0 and 168 (the hourly equivalent of seven days).
     * </p>
     * 
     * @return This value represents the time, in hours, data is retained after a restore test so that optional
     *         validation can be completed.</p>
     *         <p>
     *         Accepted value is an integer between 0 and 168 (the hourly equivalent of seven days).
     */
    public final Integer validationWindowHours() {
        return validationWindowHours;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(creationTime());
        hashCode = 31 * hashCode + Objects.hashCode(iamRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(protectedResourceType());
        hashCode = 31 * hashCode + Objects.hashCode(restoreTestingPlanName());
        hashCode = 31 * hashCode + Objects.hashCode(restoreTestingSelectionName());
        hashCode = 31 * hashCode + Objects.hashCode(validationWindowHours());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RestoreTestingSelectionForList)) {
            return false;
        }
        RestoreTestingSelectionForList other = (RestoreTestingSelectionForList) obj;
        return Objects.equals(creationTime(), other.creationTime()) && Objects.equals(iamRoleArn(), other.iamRoleArn())
                && Objects.equals(protectedResourceType(), other.protectedResourceType())
                && Objects.equals(restoreTestingPlanName(), other.restoreTestingPlanName())
                && Objects.equals(restoreTestingSelectionName(), other.restoreTestingSelectionName())
                && Objects.equals(validationWindowHours(), other.validationWindowHours());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RestoreTestingSelectionForList").add("CreationTime", creationTime())
                .add("IamRoleArn", iamRoleArn()).add("ProtectedResourceType", protectedResourceType())
                .add("RestoreTestingPlanName", restoreTestingPlanName())
                .add("RestoreTestingSelectionName", restoreTestingSelectionName())
                .add("ValidationWindowHours", validationWindowHours()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CreationTime":
            return Optional.ofNullable(clazz.cast(creationTime()));
        case "IamRoleArn":
            return Optional.ofNullable(clazz.cast(iamRoleArn()));
        case "ProtectedResourceType":
            return Optional.ofNullable(clazz.cast(protectedResourceType()));
        case "RestoreTestingPlanName":
            return Optional.ofNullable(clazz.cast(restoreTestingPlanName()));
        case "RestoreTestingSelectionName":
            return Optional.ofNullable(clazz.cast(restoreTestingSelectionName()));
        case "ValidationWindowHours":
            return Optional.ofNullable(clazz.cast(validationWindowHours()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CreationTime", CREATION_TIME_FIELD);
        map.put("IamRoleArn", IAM_ROLE_ARN_FIELD);
        map.put("ProtectedResourceType", PROTECTED_RESOURCE_TYPE_FIELD);
        map.put("RestoreTestingPlanName", RESTORE_TESTING_PLAN_NAME_FIELD);
        map.put("RestoreTestingSelectionName", RESTORE_TESTING_SELECTION_NAME_FIELD);
        map.put("ValidationWindowHours", VALIDATION_WINDOW_HOURS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RestoreTestingSelectionForList, T> g) {
        return obj -> g.apply((RestoreTestingSelectionForList) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RestoreTestingSelectionForList> {
        /**
         * <p>
         * The date and time that a restore testing selection was created, in Unix format and Coordinated Universal Time
         * (UTC). The value of <code>CreationTime</code> is accurate to milliseconds. For example, the value
         * 1516925490.087 represents Friday, January 26,2018 12:11:30.087 AM.
         * </p>
         * 
         * @param creationTime
         *        The date and time that a restore testing selection was created, in Unix format and Coordinated
         *        Universal Time (UTC). The value of <code>CreationTime</code> is accurate to milliseconds. For example,
         *        the value 1516925490.087 represents Friday, January 26,2018 12:11:30.087 AM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationTime(Instant creationTime);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the IAM role that Backup uses to create the target resource; for example:
         * <code>arn:aws:iam::123456789012:role/S3Access</code>.
         * </p>
         * 
         * @param iamRoleArn
         *        The Amazon Resource Name (ARN) of the IAM role that Backup uses to create the target resource; for
         *        example: <code>arn:aws:iam::123456789012:role/S3Access</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamRoleArn(String iamRoleArn);

        /**
         * <p>
         * The type of Amazon Web Services resource included in a restore testing selection; for example, an Amazon EBS
         * volume or an Amazon RDS database.
         * </p>
         * 
         * @param protectedResourceType
         *        The type of Amazon Web Services resource included in a restore testing selection; for example, an
         *        Amazon EBS volume or an Amazon RDS database.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder protectedResourceType(String protectedResourceType);

        /**
         * <p>
         * Unique string that is the name of the restore testing plan.
         * </p>
         * <p>
         * The name cannot be changed after creation. The name must consist of only alphanumeric characters and
         * underscores. Maximum length is 50.
         * </p>
         * 
         * @param restoreTestingPlanName
         *        Unique string that is the name of the restore testing plan.</p>
         *        <p>
         *        The name cannot be changed after creation. The name must consist of only alphanumeric characters and
         *        underscores. Maximum length is 50.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restoreTestingPlanName(String restoreTestingPlanName);

        /**
         * <p>
         * Unique name of a restore testing selection.
         * </p>
         * <p>
         * The name consists of only alphanumeric characters and underscores. Maximum length is 50.
         * </p>
         * 
         * @param restoreTestingSelectionName
         *        Unique name of a restore testing selection.</p>
         *        <p>
         *        The name consists of only alphanumeric characters and underscores. Maximum length is 50.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restoreTestingSelectionName(String restoreTestingSelectionName);

        /**
         * <p>
         * This value represents the time, in hours, data is retained after a restore test so that optional validation
         * can be completed.
         * </p>
         * <p>
         * Accepted value is an integer between 0 and 168 (the hourly equivalent of seven days).
         * </p>
         * 
         * @param validationWindowHours
         *        This value represents the time, in hours, data is retained after a restore test so that optional
         *        validation can be completed.</p>
         *        <p>
         *        Accepted value is an integer between 0 and 168 (the hourly equivalent of seven days).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validationWindowHours(Integer validationWindowHours);
    }

    static final class BuilderImpl implements Builder {
        private Instant creationTime;

        private String iamRoleArn;

        private String protectedResourceType;

        private String restoreTestingPlanName;

        private String restoreTestingSelectionName;

        private Integer validationWindowHours;

        private BuilderImpl() {
        }

        private BuilderImpl(RestoreTestingSelectionForList model) {
            creationTime(model.creationTime);
            iamRoleArn(model.iamRoleArn);
            protectedResourceType(model.protectedResourceType);
            restoreTestingPlanName(model.restoreTestingPlanName);
            restoreTestingSelectionName(model.restoreTestingSelectionName);
            validationWindowHours(model.validationWindowHours);
        }

        public final Instant getCreationTime() {
            return creationTime;
        }

        public final void setCreationTime(Instant creationTime) {
            this.creationTime = creationTime;
        }

        @Override
        public final Builder creationTime(Instant creationTime) {
            this.creationTime = creationTime;
            return this;
        }

        public final String getIamRoleArn() {
            return iamRoleArn;
        }

        public final void setIamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
        }

        @Override
        public final Builder iamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
            return this;
        }

        public final String getProtectedResourceType() {
            return protectedResourceType;
        }

        public final void setProtectedResourceType(String protectedResourceType) {
            this.protectedResourceType = protectedResourceType;
        }

        @Override
        public final Builder protectedResourceType(String protectedResourceType) {
            this.protectedResourceType = protectedResourceType;
            return this;
        }

        public final String getRestoreTestingPlanName() {
            return restoreTestingPlanName;
        }

        public final void setRestoreTestingPlanName(String restoreTestingPlanName) {
            this.restoreTestingPlanName = restoreTestingPlanName;
        }

        @Override
        public final Builder restoreTestingPlanName(String restoreTestingPlanName) {
            this.restoreTestingPlanName = restoreTestingPlanName;
            return this;
        }

        public final String getRestoreTestingSelectionName() {
            return restoreTestingSelectionName;
        }

        public final void setRestoreTestingSelectionName(String restoreTestingSelectionName) {
            this.restoreTestingSelectionName = restoreTestingSelectionName;
        }

        @Override
        public final Builder restoreTestingSelectionName(String restoreTestingSelectionName) {
            this.restoreTestingSelectionName = restoreTestingSelectionName;
            return this;
        }

        public final Integer getValidationWindowHours() {
            return validationWindowHours;
        }

        public final void setValidationWindowHours(Integer validationWindowHours) {
            this.validationWindowHours = validationWindowHours;
        }

        @Override
        public final Builder validationWindowHours(Integer validationWindowHours) {
            this.validationWindowHours = validationWindowHours;
            return this;
        }

        @Override
        public RestoreTestingSelectionForList build() {
            return new RestoreTestingSelectionForList(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
