/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a restore access backup vault.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RestoreAccessBackupVaultListMember implements SdkPojo, Serializable,
        ToCopyableBuilder<RestoreAccessBackupVaultListMember.Builder, RestoreAccessBackupVaultListMember> {
    private static final SdkField<String> RESTORE_ACCESS_BACKUP_VAULT_ARN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("RestoreAccessBackupVaultArn")
            .getter(getter(RestoreAccessBackupVaultListMember::restoreAccessBackupVaultArn))
            .setter(setter(Builder::restoreAccessBackupVaultArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RestoreAccessBackupVaultArn")
                    .build()).build();

    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationDate").getter(getter(RestoreAccessBackupVaultListMember::creationDate))
            .setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build()).build();

    private static final SdkField<Instant> APPROVAL_DATE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ApprovalDate").getter(getter(RestoreAccessBackupVaultListMember::approvalDate))
            .setter(setter(Builder::approvalDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApprovalDate").build()).build();

    private static final SdkField<String> VAULT_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("VaultState").getter(getter(RestoreAccessBackupVaultListMember::vaultStateAsString))
            .setter(setter(Builder::vaultState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VaultState").build()).build();

    private static final SdkField<LatestRevokeRequest> LATEST_REVOKE_REQUEST_FIELD = SdkField
            .<LatestRevokeRequest> builder(MarshallingType.SDK_POJO).memberName("LatestRevokeRequest")
            .getter(getter(RestoreAccessBackupVaultListMember::latestRevokeRequest)).setter(setter(Builder::latestRevokeRequest))
            .constructor(LatestRevokeRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LatestRevokeRequest").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            RESTORE_ACCESS_BACKUP_VAULT_ARN_FIELD, CREATION_DATE_FIELD, APPROVAL_DATE_FIELD, VAULT_STATE_FIELD,
            LATEST_REVOKE_REQUEST_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String restoreAccessBackupVaultArn;

    private final Instant creationDate;

    private final Instant approvalDate;

    private final String vaultState;

    private final LatestRevokeRequest latestRevokeRequest;

    private RestoreAccessBackupVaultListMember(BuilderImpl builder) {
        this.restoreAccessBackupVaultArn = builder.restoreAccessBackupVaultArn;
        this.creationDate = builder.creationDate;
        this.approvalDate = builder.approvalDate;
        this.vaultState = builder.vaultState;
        this.latestRevokeRequest = builder.latestRevokeRequest;
    }

    /**
     * <p>
     * The ARN of the restore access backup vault.
     * </p>
     * 
     * @return The ARN of the restore access backup vault.
     */
    public final String restoreAccessBackupVaultArn() {
        return restoreAccessBackupVaultArn;
    }

    /**
     * <p>
     * The date and time when the restore access backup vault was created.
     * </p>
     * 
     * @return The date and time when the restore access backup vault was created.
     */
    public final Instant creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * The date and time when the restore access backup vault was approved.
     * </p>
     * 
     * @return The date and time when the restore access backup vault was approved.
     */
    public final Instant approvalDate() {
        return approvalDate;
    }

    /**
     * <p>
     * The current state of the restore access backup vault.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #vaultState} will
     * return {@link VaultState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #vaultStateAsString}.
     * </p>
     * 
     * @return The current state of the restore access backup vault.
     * @see VaultState
     */
    public final VaultState vaultState() {
        return VaultState.fromValue(vaultState);
    }

    /**
     * <p>
     * The current state of the restore access backup vault.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #vaultState} will
     * return {@link VaultState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #vaultStateAsString}.
     * </p>
     * 
     * @return The current state of the restore access backup vault.
     * @see VaultState
     */
    public final String vaultStateAsString() {
        return vaultState;
    }

    /**
     * <p>
     * Information about the latest request to revoke access to this backup vault.
     * </p>
     * 
     * @return Information about the latest request to revoke access to this backup vault.
     */
    public final LatestRevokeRequest latestRevokeRequest() {
        return latestRevokeRequest;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(restoreAccessBackupVaultArn());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(approvalDate());
        hashCode = 31 * hashCode + Objects.hashCode(vaultStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(latestRevokeRequest());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RestoreAccessBackupVaultListMember)) {
            return false;
        }
        RestoreAccessBackupVaultListMember other = (RestoreAccessBackupVaultListMember) obj;
        return Objects.equals(restoreAccessBackupVaultArn(), other.restoreAccessBackupVaultArn())
                && Objects.equals(creationDate(), other.creationDate()) && Objects.equals(approvalDate(), other.approvalDate())
                && Objects.equals(vaultStateAsString(), other.vaultStateAsString())
                && Objects.equals(latestRevokeRequest(), other.latestRevokeRequest());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RestoreAccessBackupVaultListMember")
                .add("RestoreAccessBackupVaultArn", restoreAccessBackupVaultArn()).add("CreationDate", creationDate())
                .add("ApprovalDate", approvalDate()).add("VaultState", vaultStateAsString())
                .add("LatestRevokeRequest", latestRevokeRequest()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "RestoreAccessBackupVaultArn":
            return Optional.ofNullable(clazz.cast(restoreAccessBackupVaultArn()));
        case "CreationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        case "ApprovalDate":
            return Optional.ofNullable(clazz.cast(approvalDate()));
        case "VaultState":
            return Optional.ofNullable(clazz.cast(vaultStateAsString()));
        case "LatestRevokeRequest":
            return Optional.ofNullable(clazz.cast(latestRevokeRequest()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("RestoreAccessBackupVaultArn", RESTORE_ACCESS_BACKUP_VAULT_ARN_FIELD);
        map.put("CreationDate", CREATION_DATE_FIELD);
        map.put("ApprovalDate", APPROVAL_DATE_FIELD);
        map.put("VaultState", VAULT_STATE_FIELD);
        map.put("LatestRevokeRequest", LATEST_REVOKE_REQUEST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RestoreAccessBackupVaultListMember, T> g) {
        return obj -> g.apply((RestoreAccessBackupVaultListMember) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RestoreAccessBackupVaultListMember> {
        /**
         * <p>
         * The ARN of the restore access backup vault.
         * </p>
         * 
         * @param restoreAccessBackupVaultArn
         *        The ARN of the restore access backup vault.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder restoreAccessBackupVaultArn(String restoreAccessBackupVaultArn);

        /**
         * <p>
         * The date and time when the restore access backup vault was created.
         * </p>
         * 
         * @param creationDate
         *        The date and time when the restore access backup vault was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);

        /**
         * <p>
         * The date and time when the restore access backup vault was approved.
         * </p>
         * 
         * @param approvalDate
         *        The date and time when the restore access backup vault was approved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder approvalDate(Instant approvalDate);

        /**
         * <p>
         * The current state of the restore access backup vault.
         * </p>
         * 
         * @param vaultState
         *        The current state of the restore access backup vault.
         * @see VaultState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VaultState
         */
        Builder vaultState(String vaultState);

        /**
         * <p>
         * The current state of the restore access backup vault.
         * </p>
         * 
         * @param vaultState
         *        The current state of the restore access backup vault.
         * @see VaultState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VaultState
         */
        Builder vaultState(VaultState vaultState);

        /**
         * <p>
         * Information about the latest request to revoke access to this backup vault.
         * </p>
         * 
         * @param latestRevokeRequest
         *        Information about the latest request to revoke access to this backup vault.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestRevokeRequest(LatestRevokeRequest latestRevokeRequest);

        /**
         * <p>
         * Information about the latest request to revoke access to this backup vault.
         * </p>
         * This is a convenience method that creates an instance of the {@link LatestRevokeRequest.Builder} avoiding the
         * need to create one manually via {@link LatestRevokeRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LatestRevokeRequest.Builder#build()} is called immediately and
         * its result is passed to {@link #latestRevokeRequest(LatestRevokeRequest)}.
         * 
         * @param latestRevokeRequest
         *        a consumer that will call methods on {@link LatestRevokeRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #latestRevokeRequest(LatestRevokeRequest)
         */
        default Builder latestRevokeRequest(Consumer<LatestRevokeRequest.Builder> latestRevokeRequest) {
            return latestRevokeRequest(LatestRevokeRequest.builder().applyMutation(latestRevokeRequest).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String restoreAccessBackupVaultArn;

        private Instant creationDate;

        private Instant approvalDate;

        private String vaultState;

        private LatestRevokeRequest latestRevokeRequest;

        private BuilderImpl() {
        }

        private BuilderImpl(RestoreAccessBackupVaultListMember model) {
            restoreAccessBackupVaultArn(model.restoreAccessBackupVaultArn);
            creationDate(model.creationDate);
            approvalDate(model.approvalDate);
            vaultState(model.vaultState);
            latestRevokeRequest(model.latestRevokeRequest);
        }

        public final String getRestoreAccessBackupVaultArn() {
            return restoreAccessBackupVaultArn;
        }

        public final void setRestoreAccessBackupVaultArn(String restoreAccessBackupVaultArn) {
            this.restoreAccessBackupVaultArn = restoreAccessBackupVaultArn;
        }

        @Override
        public final Builder restoreAccessBackupVaultArn(String restoreAccessBackupVaultArn) {
            this.restoreAccessBackupVaultArn = restoreAccessBackupVaultArn;
            return this;
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final Instant getApprovalDate() {
            return approvalDate;
        }

        public final void setApprovalDate(Instant approvalDate) {
            this.approvalDate = approvalDate;
        }

        @Override
        public final Builder approvalDate(Instant approvalDate) {
            this.approvalDate = approvalDate;
            return this;
        }

        public final String getVaultState() {
            return vaultState;
        }

        public final void setVaultState(String vaultState) {
            this.vaultState = vaultState;
        }

        @Override
        public final Builder vaultState(String vaultState) {
            this.vaultState = vaultState;
            return this;
        }

        @Override
        public final Builder vaultState(VaultState vaultState) {
            this.vaultState(vaultState == null ? null : vaultState.toString());
            return this;
        }

        public final LatestRevokeRequest.Builder getLatestRevokeRequest() {
            return latestRevokeRequest != null ? latestRevokeRequest.toBuilder() : null;
        }

        public final void setLatestRevokeRequest(LatestRevokeRequest.BuilderImpl latestRevokeRequest) {
            this.latestRevokeRequest = latestRevokeRequest != null ? latestRevokeRequest.build() : null;
        }

        @Override
        public final Builder latestRevokeRequest(LatestRevokeRequest latestRevokeRequest) {
            this.latestRevokeRequest = latestRevokeRequest;
            return this;
        }

        @Override
        public RestoreAccessBackupVaultListMember build() {
            return new RestoreAccessBackupVaultListMember(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
