/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateBackupPlanRequest extends BackupRequest implements
        ToCopyableBuilder<CreateBackupPlanRequest.Builder, CreateBackupPlanRequest> {
    private static final SdkField<BackupPlanInput> BACKUP_PLAN_FIELD = SdkField
            .<BackupPlanInput> builder(MarshallingType.SDK_POJO).memberName("BackupPlan")
            .getter(getter(CreateBackupPlanRequest::backupPlan)).setter(setter(Builder::backupPlan))
            .constructor(BackupPlanInput::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupPlan").build()).build();

    private static final SdkField<Map<String, String>> BACKUP_PLAN_TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("BackupPlanTags")
            .getter(getter(CreateBackupPlanRequest::backupPlanTags))
            .setter(setter(Builder::backupPlanTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupPlanTags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> CREATOR_REQUEST_ID_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("CreatorRequestId")
            .getter(getter(CreateBackupPlanRequest::creatorRequestId))
            .setter(setter(Builder::creatorRequestId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatorRequestId").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKUP_PLAN_FIELD,
            BACKUP_PLAN_TAGS_FIELD, CREATOR_REQUEST_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final BackupPlanInput backupPlan;

    private final Map<String, String> backupPlanTags;

    private final String creatorRequestId;

    private CreateBackupPlanRequest(BuilderImpl builder) {
        super(builder);
        this.backupPlan = builder.backupPlan;
        this.backupPlanTags = builder.backupPlanTags;
        this.creatorRequestId = builder.creatorRequestId;
    }

    /**
     * <p>
     * The body of a backup plan. Includes a <code>BackupPlanName</code> and one or more sets of <code>Rules</code>.
     * </p>
     * 
     * @return The body of a backup plan. Includes a <code>BackupPlanName</code> and one or more sets of
     *         <code>Rules</code>.
     */
    public final BackupPlanInput backupPlan() {
        return backupPlan;
    }

    /**
     * For responses, this returns true if the service returned a value for the BackupPlanTags property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasBackupPlanTags() {
        return backupPlanTags != null && !(backupPlanTags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags to assign to the backup plan.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasBackupPlanTags} method.
     * </p>
     * 
     * @return The tags to assign to the backup plan.
     */
    public final Map<String, String> backupPlanTags() {
        return backupPlanTags;
    }

    /**
     * <p>
     * Identifies the request and allows failed requests to be retried without the risk of running the operation twice.
     * If the request includes a <code>CreatorRequestId</code> that matches an existing backup plan, that plan is
     * returned. This parameter is optional.
     * </p>
     * <p>
     * If used, this parameter must contain 1 to 50 alphanumeric or '-_.' characters.
     * </p>
     * 
     * @return Identifies the request and allows failed requests to be retried without the risk of running the operation
     *         twice. If the request includes a <code>CreatorRequestId</code> that matches an existing backup plan, that
     *         plan is returned. This parameter is optional.</p>
     *         <p>
     *         If used, this parameter must contain 1 to 50 alphanumeric or '-_.' characters.
     */
    public final String creatorRequestId() {
        return creatorRequestId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(backupPlan());
        hashCode = 31 * hashCode + Objects.hashCode(hasBackupPlanTags() ? backupPlanTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(creatorRequestId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateBackupPlanRequest)) {
            return false;
        }
        CreateBackupPlanRequest other = (CreateBackupPlanRequest) obj;
        return Objects.equals(backupPlan(), other.backupPlan()) && hasBackupPlanTags() == other.hasBackupPlanTags()
                && Objects.equals(backupPlanTags(), other.backupPlanTags())
                && Objects.equals(creatorRequestId(), other.creatorRequestId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateBackupPlanRequest").add("BackupPlan", backupPlan())
                .add("BackupPlanTags", backupPlanTags() == null ? null : "*** Sensitive Data Redacted ***")
                .add("CreatorRequestId", creatorRequestId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BackupPlan":
            return Optional.ofNullable(clazz.cast(backupPlan()));
        case "BackupPlanTags":
            return Optional.ofNullable(clazz.cast(backupPlanTags()));
        case "CreatorRequestId":
            return Optional.ofNullable(clazz.cast(creatorRequestId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("BackupPlan", BACKUP_PLAN_FIELD);
        map.put("BackupPlanTags", BACKUP_PLAN_TAGS_FIELD);
        map.put("CreatorRequestId", CREATOR_REQUEST_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateBackupPlanRequest, T> g) {
        return obj -> g.apply((CreateBackupPlanRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BackupRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateBackupPlanRequest> {
        /**
         * <p>
         * The body of a backup plan. Includes a <code>BackupPlanName</code> and one or more sets of <code>Rules</code>.
         * </p>
         * 
         * @param backupPlan
         *        The body of a backup plan. Includes a <code>BackupPlanName</code> and one or more sets of
         *        <code>Rules</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupPlan(BackupPlanInput backupPlan);

        /**
         * <p>
         * The body of a backup plan. Includes a <code>BackupPlanName</code> and one or more sets of <code>Rules</code>.
         * </p>
         * This is a convenience method that creates an instance of the {@link BackupPlanInput.Builder} avoiding the
         * need to create one manually via {@link BackupPlanInput#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BackupPlanInput.Builder#build()} is called immediately and its
         * result is passed to {@link #backupPlan(BackupPlanInput)}.
         * 
         * @param backupPlan
         *        a consumer that will call methods on {@link BackupPlanInput.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #backupPlan(BackupPlanInput)
         */
        default Builder backupPlan(Consumer<BackupPlanInput.Builder> backupPlan) {
            return backupPlan(BackupPlanInput.builder().applyMutation(backupPlan).build());
        }

        /**
         * <p>
         * The tags to assign to the backup plan.
         * </p>
         * 
         * @param backupPlanTags
         *        The tags to assign to the backup plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupPlanTags(Map<String, String> backupPlanTags);

        /**
         * <p>
         * Identifies the request and allows failed requests to be retried without the risk of running the operation
         * twice. If the request includes a <code>CreatorRequestId</code> that matches an existing backup plan, that
         * plan is returned. This parameter is optional.
         * </p>
         * <p>
         * If used, this parameter must contain 1 to 50 alphanumeric or '-_.' characters.
         * </p>
         * 
         * @param creatorRequestId
         *        Identifies the request and allows failed requests to be retried without the risk of running the
         *        operation twice. If the request includes a <code>CreatorRequestId</code> that matches an existing
         *        backup plan, that plan is returned. This parameter is optional.</p>
         *        <p>
         *        If used, this parameter must contain 1 to 50 alphanumeric or '-_.' characters.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creatorRequestId(String creatorRequestId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BackupRequest.BuilderImpl implements Builder {
        private BackupPlanInput backupPlan;

        private Map<String, String> backupPlanTags = DefaultSdkAutoConstructMap.getInstance();

        private String creatorRequestId;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateBackupPlanRequest model) {
            super(model);
            backupPlan(model.backupPlan);
            backupPlanTags(model.backupPlanTags);
            creatorRequestId(model.creatorRequestId);
        }

        public final BackupPlanInput.Builder getBackupPlan() {
            return backupPlan != null ? backupPlan.toBuilder() : null;
        }

        public final void setBackupPlan(BackupPlanInput.BuilderImpl backupPlan) {
            this.backupPlan = backupPlan != null ? backupPlan.build() : null;
        }

        @Override
        public final Builder backupPlan(BackupPlanInput backupPlan) {
            this.backupPlan = backupPlan;
            return this;
        }

        public final Map<String, String> getBackupPlanTags() {
            if (backupPlanTags instanceof SdkAutoConstructMap) {
                return null;
            }
            return backupPlanTags;
        }

        public final void setBackupPlanTags(Map<String, String> backupPlanTags) {
            this.backupPlanTags = TagsCopier.copy(backupPlanTags);
        }

        @Override
        public final Builder backupPlanTags(Map<String, String> backupPlanTags) {
            this.backupPlanTags = TagsCopier.copy(backupPlanTags);
            return this;
        }

        public final String getCreatorRequestId() {
            return creatorRequestId;
        }

        public final void setCreatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
        }

        @Override
        public final Builder creatorRequestId(String creatorRequestId) {
            this.creatorRequestId = creatorRequestId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateBackupPlanRequest build() {
            return new CreateBackupPlanRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
