/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This is a summary of jobs created or running within the most recent 30 days.
 * </p>
 * <p>
 * The returned summary may contain the following: Region, Account, State, RestourceType, MessageCategory, StartTime,
 * EndTime, and Count of included jobs.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BackupJobSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<BackupJobSummary.Builder, BackupJobSummary> {
    private static final SdkField<String> REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Region")
            .getter(getter(BackupJobSummary::region)).setter(setter(Builder::region))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Region").build()).build();

    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AccountId").getter(getter(BackupJobSummary::accountId)).setter(setter(Builder::accountId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(BackupJobSummary::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ResourceType").getter(getter(BackupJobSummary::resourceType)).setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResourceType").build()).build();

    private static final SdkField<String> MESSAGE_CATEGORY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MessageCategory").getter(getter(BackupJobSummary::messageCategory))
            .setter(setter(Builder::messageCategory))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MessageCategory").build()).build();

    private static final SdkField<Integer> COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("Count")
            .getter(getter(BackupJobSummary::count)).setter(setter(Builder::count))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Count").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StartTime").getter(getter(BackupJobSummary::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("EndTime").getter(getter(BackupJobSummary::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EndTime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REGION_FIELD,
            ACCOUNT_ID_FIELD, STATE_FIELD, RESOURCE_TYPE_FIELD, MESSAGE_CATEGORY_FIELD, COUNT_FIELD, START_TIME_FIELD,
            END_TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String region;

    private final String accountId;

    private final String state;

    private final String resourceType;

    private final String messageCategory;

    private final Integer count;

    private final Instant startTime;

    private final Instant endTime;

    private BackupJobSummary(BuilderImpl builder) {
        this.region = builder.region;
        this.accountId = builder.accountId;
        this.state = builder.state;
        this.resourceType = builder.resourceType;
        this.messageCategory = builder.messageCategory;
        this.count = builder.count;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
    }

    /**
     * <p>
     * The Amazon Web Services Regions within the job summary.
     * </p>
     * 
     * @return The Amazon Web Services Regions within the job summary.
     */
    public final String region() {
        return region;
    }

    /**
     * <p>
     * The account ID that owns the jobs within the summary.
     * </p>
     * 
     * @return The account ID that owns the jobs within the summary.
     */
    public final String accountId() {
        return accountId;
    }

    /**
     * <p>
     * This value is job count for jobs with the specified state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link BackupJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return This value is job count for jobs with the specified state.
     * @see BackupJobStatus
     */
    public final BackupJobStatus state() {
        return BackupJobStatus.fromValue(state);
    }

    /**
     * <p>
     * This value is job count for jobs with the specified state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link BackupJobStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return This value is job count for jobs with the specified state.
     * @see BackupJobStatus
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * This value is the job count for the specified resource type. The request <code>GetSupportedResourceTypes</code>
     * returns strings for supported resource types.
     * </p>
     * 
     * @return This value is the job count for the specified resource type. The request
     *         <code>GetSupportedResourceTypes</code> returns strings for supported resource types.
     */
    public final String resourceType() {
        return resourceType;
    }

    /**
     * <p>
     * This parameter is the job count for the specified message category.
     * </p>
     * <p>
     * Example strings include <code>AccessDenied</code>, <code>Success</code>, and <code>InvalidParameters</code>. See
     * <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/monitoring.html">Monitoring</a> for a list of
     * MessageCategory strings.
     * </p>
     * <p>
     * The the value ANY returns count of all message categories.
     * </p>
     * <p>
     * <code>AGGREGATE_ALL</code> aggregates job counts for all message categories and returns the sum.
     * </p>
     * 
     * @return This parameter is the job count for the specified message category.</p>
     *         <p>
     *         Example strings include <code>AccessDenied</code>, <code>Success</code>, and
     *         <code>InvalidParameters</code>. See <a
     *         href="https://docs.aws.amazon.com/aws-backup/latest/devguide/monitoring.html">Monitoring</a> for a list
     *         of MessageCategory strings.
     *         </p>
     *         <p>
     *         The the value ANY returns count of all message categories.
     *         </p>
     *         <p>
     *         <code>AGGREGATE_ALL</code> aggregates job counts for all message categories and returns the sum.
     */
    public final String messageCategory() {
        return messageCategory;
    }

    /**
     * <p>
     * The value as a number of jobs in a job summary.
     * </p>
     * 
     * @return The value as a number of jobs in a job summary.
     */
    public final Integer count() {
        return count;
    }

    /**
     * <p>
     * The value of time in number format of a job start time.
     * </p>
     * <p>
     * This value is the time in Unix format, Coordinated Universal Time (UTC), and accurate to milliseconds. For
     * example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
     * </p>
     * 
     * @return The value of time in number format of a job start time.</p>
     *         <p>
     *         This value is the time in Unix format, Coordinated Universal Time (UTC), and accurate to milliseconds.
     *         For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The value of time in number format of a job end time.
     * </p>
     * <p>
     * This value is the time in Unix format, Coordinated Universal Time (UTC), and accurate to milliseconds. For
     * example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
     * </p>
     * 
     * @return The value of time in number format of a job end time.</p>
     *         <p>
     *         This value is the time in Unix format, Coordinated Universal Time (UTC), and accurate to milliseconds.
     *         For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
     */
    public final Instant endTime() {
        return endTime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(region());
        hashCode = 31 * hashCode + Objects.hashCode(accountId());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(resourceType());
        hashCode = 31 * hashCode + Objects.hashCode(messageCategory());
        hashCode = 31 * hashCode + Objects.hashCode(count());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BackupJobSummary)) {
            return false;
        }
        BackupJobSummary other = (BackupJobSummary) obj;
        return Objects.equals(region(), other.region()) && Objects.equals(accountId(), other.accountId())
                && Objects.equals(stateAsString(), other.stateAsString()) && Objects.equals(resourceType(), other.resourceType())
                && Objects.equals(messageCategory(), other.messageCategory()) && Objects.equals(count(), other.count())
                && Objects.equals(startTime(), other.startTime()) && Objects.equals(endTime(), other.endTime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BackupJobSummary").add("Region", region()).add("AccountId", accountId())
                .add("State", stateAsString()).add("ResourceType", resourceType()).add("MessageCategory", messageCategory())
                .add("Count", count()).add("StartTime", startTime()).add("EndTime", endTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Region":
            return Optional.ofNullable(clazz.cast(region()));
        case "AccountId":
            return Optional.ofNullable(clazz.cast(accountId()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "ResourceType":
            return Optional.ofNullable(clazz.cast(resourceType()));
        case "MessageCategory":
            return Optional.ofNullable(clazz.cast(messageCategory()));
        case "Count":
            return Optional.ofNullable(clazz.cast(count()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "EndTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Region", REGION_FIELD);
        map.put("AccountId", ACCOUNT_ID_FIELD);
        map.put("State", STATE_FIELD);
        map.put("ResourceType", RESOURCE_TYPE_FIELD);
        map.put("MessageCategory", MESSAGE_CATEGORY_FIELD);
        map.put("Count", COUNT_FIELD);
        map.put("StartTime", START_TIME_FIELD);
        map.put("EndTime", END_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BackupJobSummary, T> g) {
        return obj -> g.apply((BackupJobSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BackupJobSummary> {
        /**
         * <p>
         * The Amazon Web Services Regions within the job summary.
         * </p>
         * 
         * @param region
         *        The Amazon Web Services Regions within the job summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder region(String region);

        /**
         * <p>
         * The account ID that owns the jobs within the summary.
         * </p>
         * 
         * @param accountId
         *        The account ID that owns the jobs within the summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountId(String accountId);

        /**
         * <p>
         * This value is job count for jobs with the specified state.
         * </p>
         * 
         * @param state
         *        This value is job count for jobs with the specified state.
         * @see BackupJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BackupJobStatus
         */
        Builder state(String state);

        /**
         * <p>
         * This value is job count for jobs with the specified state.
         * </p>
         * 
         * @param state
         *        This value is job count for jobs with the specified state.
         * @see BackupJobStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see BackupJobStatus
         */
        Builder state(BackupJobStatus state);

        /**
         * <p>
         * This value is the job count for the specified resource type. The request
         * <code>GetSupportedResourceTypes</code> returns strings for supported resource types.
         * </p>
         * 
         * @param resourceType
         *        This value is the job count for the specified resource type. The request
         *        <code>GetSupportedResourceTypes</code> returns strings for supported resource types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * This parameter is the job count for the specified message category.
         * </p>
         * <p>
         * Example strings include <code>AccessDenied</code>, <code>Success</code>, and <code>InvalidParameters</code>.
         * See <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/monitoring.html">Monitoring</a> for a
         * list of MessageCategory strings.
         * </p>
         * <p>
         * The the value ANY returns count of all message categories.
         * </p>
         * <p>
         * <code>AGGREGATE_ALL</code> aggregates job counts for all message categories and returns the sum.
         * </p>
         * 
         * @param messageCategory
         *        This parameter is the job count for the specified message category.</p>
         *        <p>
         *        Example strings include <code>AccessDenied</code>, <code>Success</code>, and
         *        <code>InvalidParameters</code>. See <a
         *        href="https://docs.aws.amazon.com/aws-backup/latest/devguide/monitoring.html">Monitoring</a> for a
         *        list of MessageCategory strings.
         *        </p>
         *        <p>
         *        The the value ANY returns count of all message categories.
         *        </p>
         *        <p>
         *        <code>AGGREGATE_ALL</code> aggregates job counts for all message categories and returns the sum.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder messageCategory(String messageCategory);

        /**
         * <p>
         * The value as a number of jobs in a job summary.
         * </p>
         * 
         * @param count
         *        The value as a number of jobs in a job summary.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder count(Integer count);

        /**
         * <p>
         * The value of time in number format of a job start time.
         * </p>
         * <p>
         * This value is the time in Unix format, Coordinated Universal Time (UTC), and accurate to milliseconds. For
         * example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
         * </p>
         * 
         * @param startTime
         *        The value of time in number format of a job start time.</p>
         *        <p>
         *        This value is the time in Unix format, Coordinated Universal Time (UTC), and accurate to milliseconds.
         *        For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The value of time in number format of a job end time.
         * </p>
         * <p>
         * This value is the time in Unix format, Coordinated Universal Time (UTC), and accurate to milliseconds. For
         * example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
         * </p>
         * 
         * @param endTime
         *        The value of time in number format of a job end time.</p>
         *        <p>
         *        This value is the time in Unix format, Coordinated Universal Time (UTC), and accurate to milliseconds.
         *        For example, the value 1516925490.087 represents Friday, January 26, 2018 12:11:30.087 AM.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);
    }

    static final class BuilderImpl implements Builder {
        private String region;

        private String accountId;

        private String state;

        private String resourceType;

        private String messageCategory;

        private Integer count;

        private Instant startTime;

        private Instant endTime;

        private BuilderImpl() {
        }

        private BuilderImpl(BackupJobSummary model) {
            region(model.region);
            accountId(model.accountId);
            state(model.state);
            resourceType(model.resourceType);
            messageCategory(model.messageCategory);
            count(model.count);
            startTime(model.startTime);
            endTime(model.endTime);
        }

        public final String getRegion() {
            return region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final String getAccountId() {
            return accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(BackupJobStatus state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final String getMessageCategory() {
            return messageCategory;
        }

        public final void setMessageCategory(String messageCategory) {
            this.messageCategory = messageCategory;
        }

        @Override
        public final Builder messageCategory(String messageCategory) {
            this.messageCategory = messageCategory;
            return this;
        }

        public final Integer getCount() {
            return count;
        }

        public final void setCount(Integer count) {
            this.count = count;
        }

        @Override
        public final Builder count(Integer count) {
            this.count = count;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        @Override
        public BackupJobSummary build() {
            return new BackupJobSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
