/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.backup.model.RuleExecutionType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ScheduledPlanExecutionMember
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ScheduledPlanExecutionMember> {
    private static final SdkField<Instant> EXECUTION_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ExecutionTime").getter(ScheduledPlanExecutionMember.getter(ScheduledPlanExecutionMember::executionTime)).setter(ScheduledPlanExecutionMember.setter(Builder::executionTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExecutionTime").build()}).build();
    private static final SdkField<String> RULE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RuleId").getter(ScheduledPlanExecutionMember.getter(ScheduledPlanExecutionMember::ruleId)).setter(ScheduledPlanExecutionMember.setter(Builder::ruleId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleId").build()}).build();
    private static final SdkField<String> RULE_EXECUTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RuleExecutionType").getter(ScheduledPlanExecutionMember.getter(ScheduledPlanExecutionMember::ruleExecutionTypeAsString)).setter(ScheduledPlanExecutionMember.setter(Builder::ruleExecutionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RuleExecutionType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXECUTION_TIME_FIELD, RULE_ID_FIELD, RULE_EXECUTION_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ScheduledPlanExecutionMember.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Instant executionTime;
    private final String ruleId;
    private final String ruleExecutionType;

    private ScheduledPlanExecutionMember(BuilderImpl builder) {
        this.executionTime = builder.executionTime;
        this.ruleId = builder.ruleId;
        this.ruleExecutionType = builder.ruleExecutionType;
    }

    public final Instant executionTime() {
        return this.executionTime;
    }

    public final String ruleId() {
        return this.ruleId;
    }

    public final RuleExecutionType ruleExecutionType() {
        return RuleExecutionType.fromValue(this.ruleExecutionType);
    }

    public final String ruleExecutionTypeAsString() {
        return this.ruleExecutionType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.executionTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleExecutionTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ScheduledPlanExecutionMember)) {
            return false;
        }
        ScheduledPlanExecutionMember other = (ScheduledPlanExecutionMember)obj;
        return Objects.equals(this.executionTime(), other.executionTime()) && Objects.equals(this.ruleId(), other.ruleId()) && Objects.equals(this.ruleExecutionTypeAsString(), other.ruleExecutionTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ScheduledPlanExecutionMember").add("ExecutionTime", (Object)this.executionTime()).add("RuleId", (Object)this.ruleId()).add("RuleExecutionType", (Object)this.ruleExecutionTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ExecutionTime": {
                return Optional.ofNullable(clazz.cast(this.executionTime()));
            }
            case "RuleId": {
                return Optional.ofNullable(clazz.cast(this.ruleId()));
            }
            case "RuleExecutionType": {
                return Optional.ofNullable(clazz.cast(this.ruleExecutionTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ExecutionTime", EXECUTION_TIME_FIELD);
        map.put("RuleId", RULE_ID_FIELD);
        map.put("RuleExecutionType", RULE_EXECUTION_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ScheduledPlanExecutionMember, T> g) {
        return obj -> g.apply((ScheduledPlanExecutionMember)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant executionTime;
        private String ruleId;
        private String ruleExecutionType;

        private BuilderImpl() {
        }

        private BuilderImpl(ScheduledPlanExecutionMember model) {
            this.executionTime(model.executionTime);
            this.ruleId(model.ruleId);
            this.ruleExecutionType(model.ruleExecutionType);
        }

        public final Instant getExecutionTime() {
            return this.executionTime;
        }

        public final void setExecutionTime(Instant executionTime) {
            this.executionTime = executionTime;
        }

        @Override
        public final Builder executionTime(Instant executionTime) {
            this.executionTime = executionTime;
            return this;
        }

        public final String getRuleId() {
            return this.ruleId;
        }

        public final void setRuleId(String ruleId) {
            this.ruleId = ruleId;
        }

        @Override
        public final Builder ruleId(String ruleId) {
            this.ruleId = ruleId;
            return this;
        }

        public final String getRuleExecutionType() {
            return this.ruleExecutionType;
        }

        public final void setRuleExecutionType(String ruleExecutionType) {
            this.ruleExecutionType = ruleExecutionType;
        }

        @Override
        public final Builder ruleExecutionType(String ruleExecutionType) {
            this.ruleExecutionType = ruleExecutionType;
            return this;
        }

        @Override
        public final Builder ruleExecutionType(RuleExecutionType ruleExecutionType) {
            this.ruleExecutionType(ruleExecutionType == null ? null : ruleExecutionType.toString());
            return this;
        }

        public ScheduledPlanExecutionMember build() {
            return new ScheduledPlanExecutionMember(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ScheduledPlanExecutionMember> {
        public Builder executionTime(Instant var1);

        public Builder ruleId(String var1);

        public Builder ruleExecutionType(String var1);

        public Builder ruleExecutionType(RuleExecutionType var1);
    }
}

