/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ScanJobStatus {
    CREATED("CREATED"),
    COMPLETED("COMPLETED"),
    COMPLETED_WITH_ISSUES("COMPLETED_WITH_ISSUES"),
    RUNNING("RUNNING"),
    FAILED("FAILED"),
    CANCELED("CANCELED"),
    AGGREGATE_ALL("AGGREGATE_ALL"),
    ANY("ANY"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ScanJobStatus> VALUE_MAP;
    private final String value;

    private ScanJobStatus(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ScanJobStatus fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ScanJobStatus> knownValues() {
        EnumSet<ScanJobStatus> knownValues = EnumSet.allOf(ScanJobStatus.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ScanJobStatus.class, ScanJobStatus::toString);
    }
}

