/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.backup.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.backup.model.BackupRequest;
import software.amazon.awssdk.services.backup.model.MalwareScanner;
import software.amazon.awssdk.services.backup.model.ScanResourceType;
import software.amazon.awssdk.services.backup.model.ScanResultStatus;
import software.amazon.awssdk.services.backup.model.ScanState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListScanJobsRequest
extends BackupRequest
implements ToCopyableBuilder<Builder, ListScanJobsRequest> {
    private static final SdkField<String> BY_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ByAccountId").getter(ListScanJobsRequest.getter(ListScanJobsRequest::byAccountId)).setter(ListScanJobsRequest.setter(Builder::byAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("ByAccountId").build()}).build();
    private static final SdkField<String> BY_BACKUP_VAULT_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ByBackupVaultName").getter(ListScanJobsRequest.getter(ListScanJobsRequest::byBackupVaultName)).setter(ListScanJobsRequest.setter(Builder::byBackupVaultName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("ByBackupVaultName").build()}).build();
    private static final SdkField<Instant> BY_COMPLETE_AFTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ByCompleteAfter").getter(ListScanJobsRequest.getter(ListScanJobsRequest::byCompleteAfter)).setter(ListScanJobsRequest.setter(Builder::byCompleteAfter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("ByCompleteAfter").build()}).build();
    private static final SdkField<Instant> BY_COMPLETE_BEFORE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("ByCompleteBefore").getter(ListScanJobsRequest.getter(ListScanJobsRequest::byCompleteBefore)).setter(ListScanJobsRequest.setter(Builder::byCompleteBefore)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("ByCompleteBefore").build()}).build();
    private static final SdkField<String> BY_MALWARE_SCANNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ByMalwareScanner").getter(ListScanJobsRequest.getter(ListScanJobsRequest::byMalwareScannerAsString)).setter(ListScanJobsRequest.setter(Builder::byMalwareScanner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("ByMalwareScanner").build()}).build();
    private static final SdkField<String> BY_RECOVERY_POINT_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ByRecoveryPointArn").getter(ListScanJobsRequest.getter(ListScanJobsRequest::byRecoveryPointArn)).setter(ListScanJobsRequest.setter(Builder::byRecoveryPointArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("ByRecoveryPointArn").build()}).build();
    private static final SdkField<String> BY_RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ByResourceArn").getter(ListScanJobsRequest.getter(ListScanJobsRequest::byResourceArn)).setter(ListScanJobsRequest.setter(Builder::byResourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("ByResourceArn").build()}).build();
    private static final SdkField<String> BY_RESOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ByResourceType").getter(ListScanJobsRequest.getter(ListScanJobsRequest::byResourceTypeAsString)).setter(ListScanJobsRequest.setter(Builder::byResourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("ByResourceType").build()}).build();
    private static final SdkField<String> BY_SCAN_RESULT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ByScanResultStatus").getter(ListScanJobsRequest.getter(ListScanJobsRequest::byScanResultStatusAsString)).setter(ListScanJobsRequest.setter(Builder::byScanResultStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("ByScanResultStatus").build()}).build();
    private static final SdkField<String> BY_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ByState").getter(ListScanJobsRequest.getter(ListScanJobsRequest::byStateAsString)).setter(ListScanJobsRequest.setter(Builder::byState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("ByState").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxResults").getter(ListScanJobsRequest.getter(ListScanJobsRequest::maxResults)).setter(ListScanJobsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("MaxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListScanJobsRequest.getter(ListScanJobsRequest::nextToken)).setter(ListScanJobsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BY_ACCOUNT_ID_FIELD, BY_BACKUP_VAULT_NAME_FIELD, BY_COMPLETE_AFTER_FIELD, BY_COMPLETE_BEFORE_FIELD, BY_MALWARE_SCANNER_FIELD, BY_RECOVERY_POINT_ARN_FIELD, BY_RESOURCE_ARN_FIELD, BY_RESOURCE_TYPE_FIELD, BY_SCAN_RESULT_STATUS_FIELD, BY_STATE_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListScanJobsRequest.memberNameToFieldInitializer();
    private final String byAccountId;
    private final String byBackupVaultName;
    private final Instant byCompleteAfter;
    private final Instant byCompleteBefore;
    private final String byMalwareScanner;
    private final String byRecoveryPointArn;
    private final String byResourceArn;
    private final String byResourceType;
    private final String byScanResultStatus;
    private final String byState;
    private final Integer maxResults;
    private final String nextToken;

    private ListScanJobsRequest(BuilderImpl builder) {
        super(builder);
        this.byAccountId = builder.byAccountId;
        this.byBackupVaultName = builder.byBackupVaultName;
        this.byCompleteAfter = builder.byCompleteAfter;
        this.byCompleteBefore = builder.byCompleteBefore;
        this.byMalwareScanner = builder.byMalwareScanner;
        this.byRecoveryPointArn = builder.byRecoveryPointArn;
        this.byResourceArn = builder.byResourceArn;
        this.byResourceType = builder.byResourceType;
        this.byScanResultStatus = builder.byScanResultStatus;
        this.byState = builder.byState;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    public final String byAccountId() {
        return this.byAccountId;
    }

    public final String byBackupVaultName() {
        return this.byBackupVaultName;
    }

    public final Instant byCompleteAfter() {
        return this.byCompleteAfter;
    }

    public final Instant byCompleteBefore() {
        return this.byCompleteBefore;
    }

    public final MalwareScanner byMalwareScanner() {
        return MalwareScanner.fromValue(this.byMalwareScanner);
    }

    public final String byMalwareScannerAsString() {
        return this.byMalwareScanner;
    }

    public final String byRecoveryPointArn() {
        return this.byRecoveryPointArn;
    }

    public final String byResourceArn() {
        return this.byResourceArn;
    }

    public final ScanResourceType byResourceType() {
        return ScanResourceType.fromValue(this.byResourceType);
    }

    public final String byResourceTypeAsString() {
        return this.byResourceType;
    }

    public final ScanResultStatus byScanResultStatus() {
        return ScanResultStatus.fromValue(this.byScanResultStatus);
    }

    public final String byScanResultStatusAsString() {
        return this.byScanResultStatus;
    }

    public final ScanState byState() {
        return ScanState.fromValue(this.byState);
    }

    public final String byStateAsString() {
        return this.byState;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.byAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.byBackupVaultName());
        hashCode = 31 * hashCode + Objects.hashCode(this.byCompleteAfter());
        hashCode = 31 * hashCode + Objects.hashCode(this.byCompleteBefore());
        hashCode = 31 * hashCode + Objects.hashCode(this.byMalwareScannerAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.byRecoveryPointArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.byResourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.byResourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.byScanResultStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.byStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListScanJobsRequest)) {
            return false;
        }
        ListScanJobsRequest other = (ListScanJobsRequest)((Object)obj);
        return Objects.equals(this.byAccountId(), other.byAccountId()) && Objects.equals(this.byBackupVaultName(), other.byBackupVaultName()) && Objects.equals(this.byCompleteAfter(), other.byCompleteAfter()) && Objects.equals(this.byCompleteBefore(), other.byCompleteBefore()) && Objects.equals(this.byMalwareScannerAsString(), other.byMalwareScannerAsString()) && Objects.equals(this.byRecoveryPointArn(), other.byRecoveryPointArn()) && Objects.equals(this.byResourceArn(), other.byResourceArn()) && Objects.equals(this.byResourceTypeAsString(), other.byResourceTypeAsString()) && Objects.equals(this.byScanResultStatusAsString(), other.byScanResultStatusAsString()) && Objects.equals(this.byStateAsString(), other.byStateAsString()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListScanJobsRequest").add("ByAccountId", (Object)this.byAccountId()).add("ByBackupVaultName", (Object)this.byBackupVaultName()).add("ByCompleteAfter", (Object)this.byCompleteAfter()).add("ByCompleteBefore", (Object)this.byCompleteBefore()).add("ByMalwareScanner", (Object)this.byMalwareScannerAsString()).add("ByRecoveryPointArn", (Object)this.byRecoveryPointArn()).add("ByResourceArn", (Object)this.byResourceArn()).add("ByResourceType", (Object)this.byResourceTypeAsString()).add("ByScanResultStatus", (Object)this.byScanResultStatusAsString()).add("ByState", (Object)this.byStateAsString()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ByAccountId": {
                return Optional.ofNullable(clazz.cast(this.byAccountId()));
            }
            case "ByBackupVaultName": {
                return Optional.ofNullable(clazz.cast(this.byBackupVaultName()));
            }
            case "ByCompleteAfter": {
                return Optional.ofNullable(clazz.cast(this.byCompleteAfter()));
            }
            case "ByCompleteBefore": {
                return Optional.ofNullable(clazz.cast(this.byCompleteBefore()));
            }
            case "ByMalwareScanner": {
                return Optional.ofNullable(clazz.cast(this.byMalwareScannerAsString()));
            }
            case "ByRecoveryPointArn": {
                return Optional.ofNullable(clazz.cast(this.byRecoveryPointArn()));
            }
            case "ByResourceArn": {
                return Optional.ofNullable(clazz.cast(this.byResourceArn()));
            }
            case "ByResourceType": {
                return Optional.ofNullable(clazz.cast(this.byResourceTypeAsString()));
            }
            case "ByScanResultStatus": {
                return Optional.ofNullable(clazz.cast(this.byScanResultStatusAsString()));
            }
            case "ByState": {
                return Optional.ofNullable(clazz.cast(this.byStateAsString()));
            }
            case "MaxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ByAccountId", BY_ACCOUNT_ID_FIELD);
        map.put("ByBackupVaultName", BY_BACKUP_VAULT_NAME_FIELD);
        map.put("ByCompleteAfter", BY_COMPLETE_AFTER_FIELD);
        map.put("ByCompleteBefore", BY_COMPLETE_BEFORE_FIELD);
        map.put("ByMalwareScanner", BY_MALWARE_SCANNER_FIELD);
        map.put("ByRecoveryPointArn", BY_RECOVERY_POINT_ARN_FIELD);
        map.put("ByResourceArn", BY_RESOURCE_ARN_FIELD);
        map.put("ByResourceType", BY_RESOURCE_TYPE_FIELD);
        map.put("ByScanResultStatus", BY_SCAN_RESULT_STATUS_FIELD);
        map.put("ByState", BY_STATE_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListScanJobsRequest, T> g) {
        return obj -> g.apply((ListScanJobsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BackupRequest.BuilderImpl
    implements Builder {
        private String byAccountId;
        private String byBackupVaultName;
        private Instant byCompleteAfter;
        private Instant byCompleteBefore;
        private String byMalwareScanner;
        private String byRecoveryPointArn;
        private String byResourceArn;
        private String byResourceType;
        private String byScanResultStatus;
        private String byState;
        private Integer maxResults;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListScanJobsRequest model) {
            super(model);
            this.byAccountId(model.byAccountId);
            this.byBackupVaultName(model.byBackupVaultName);
            this.byCompleteAfter(model.byCompleteAfter);
            this.byCompleteBefore(model.byCompleteBefore);
            this.byMalwareScanner(model.byMalwareScanner);
            this.byRecoveryPointArn(model.byRecoveryPointArn);
            this.byResourceArn(model.byResourceArn);
            this.byResourceType(model.byResourceType);
            this.byScanResultStatus(model.byScanResultStatus);
            this.byState(model.byState);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
        }

        public final String getByAccountId() {
            return this.byAccountId;
        }

        public final void setByAccountId(String byAccountId) {
            this.byAccountId = byAccountId;
        }

        @Override
        public final Builder byAccountId(String byAccountId) {
            this.byAccountId = byAccountId;
            return this;
        }

        public final String getByBackupVaultName() {
            return this.byBackupVaultName;
        }

        public final void setByBackupVaultName(String byBackupVaultName) {
            this.byBackupVaultName = byBackupVaultName;
        }

        @Override
        public final Builder byBackupVaultName(String byBackupVaultName) {
            this.byBackupVaultName = byBackupVaultName;
            return this;
        }

        public final Instant getByCompleteAfter() {
            return this.byCompleteAfter;
        }

        public final void setByCompleteAfter(Instant byCompleteAfter) {
            this.byCompleteAfter = byCompleteAfter;
        }

        @Override
        public final Builder byCompleteAfter(Instant byCompleteAfter) {
            this.byCompleteAfter = byCompleteAfter;
            return this;
        }

        public final Instant getByCompleteBefore() {
            return this.byCompleteBefore;
        }

        public final void setByCompleteBefore(Instant byCompleteBefore) {
            this.byCompleteBefore = byCompleteBefore;
        }

        @Override
        public final Builder byCompleteBefore(Instant byCompleteBefore) {
            this.byCompleteBefore = byCompleteBefore;
            return this;
        }

        public final String getByMalwareScanner() {
            return this.byMalwareScanner;
        }

        public final void setByMalwareScanner(String byMalwareScanner) {
            this.byMalwareScanner = byMalwareScanner;
        }

        @Override
        public final Builder byMalwareScanner(String byMalwareScanner) {
            this.byMalwareScanner = byMalwareScanner;
            return this;
        }

        @Override
        public final Builder byMalwareScanner(MalwareScanner byMalwareScanner) {
            this.byMalwareScanner(byMalwareScanner == null ? null : byMalwareScanner.toString());
            return this;
        }

        public final String getByRecoveryPointArn() {
            return this.byRecoveryPointArn;
        }

        public final void setByRecoveryPointArn(String byRecoveryPointArn) {
            this.byRecoveryPointArn = byRecoveryPointArn;
        }

        @Override
        public final Builder byRecoveryPointArn(String byRecoveryPointArn) {
            this.byRecoveryPointArn = byRecoveryPointArn;
            return this;
        }

        public final String getByResourceArn() {
            return this.byResourceArn;
        }

        public final void setByResourceArn(String byResourceArn) {
            this.byResourceArn = byResourceArn;
        }

        @Override
        public final Builder byResourceArn(String byResourceArn) {
            this.byResourceArn = byResourceArn;
            return this;
        }

        public final String getByResourceType() {
            return this.byResourceType;
        }

        public final void setByResourceType(String byResourceType) {
            this.byResourceType = byResourceType;
        }

        @Override
        public final Builder byResourceType(String byResourceType) {
            this.byResourceType = byResourceType;
            return this;
        }

        @Override
        public final Builder byResourceType(ScanResourceType byResourceType) {
            this.byResourceType(byResourceType == null ? null : byResourceType.toString());
            return this;
        }

        public final String getByScanResultStatus() {
            return this.byScanResultStatus;
        }

        public final void setByScanResultStatus(String byScanResultStatus) {
            this.byScanResultStatus = byScanResultStatus;
        }

        @Override
        public final Builder byScanResultStatus(String byScanResultStatus) {
            this.byScanResultStatus = byScanResultStatus;
            return this;
        }

        @Override
        public final Builder byScanResultStatus(ScanResultStatus byScanResultStatus) {
            this.byScanResultStatus(byScanResultStatus == null ? null : byScanResultStatus.toString());
            return this;
        }

        public final String getByState() {
            return this.byState;
        }

        public final void setByState(String byState) {
            this.byState = byState;
        }

        @Override
        public final Builder byState(String byState) {
            this.byState = byState;
            return this;
        }

        @Override
        public final Builder byState(ScanState byState) {
            this.byState(byState == null ? null : byState.toString());
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListScanJobsRequest build() {
            return new ListScanJobsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BackupRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListScanJobsRequest> {
        public Builder byAccountId(String var1);

        public Builder byBackupVaultName(String var1);

        public Builder byCompleteAfter(Instant var1);

        public Builder byCompleteBefore(Instant var1);

        public Builder byMalwareScanner(String var1);

        public Builder byMalwareScanner(MalwareScanner var1);

        public Builder byRecoveryPointArn(String var1);

        public Builder byResourceArn(String var1);

        public Builder byResourceType(String var1);

        public Builder byResourceType(ScanResourceType var1);

        public Builder byScanResultStatus(String var1);

        public Builder byScanResultStatus(ScanResultStatus var1);

        public Builder byState(String var1);

        public Builder byState(ScanState var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

