/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about the backup plan and rule that Backup used to initiate the recovery point backup.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RecoveryPointCreator implements SdkPojo, Serializable,
        ToCopyableBuilder<RecoveryPointCreator.Builder, RecoveryPointCreator> {
    private static final SdkField<String> BACKUP_PLAN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BackupPlanId").getter(getter(RecoveryPointCreator::backupPlanId)).setter(setter(Builder::backupPlanId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupPlanId").build()).build();

    private static final SdkField<String> BACKUP_PLAN_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BackupPlanArn").getter(getter(RecoveryPointCreator::backupPlanArn))
            .setter(setter(Builder::backupPlanArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupPlanArn").build()).build();

    private static final SdkField<String> BACKUP_PLAN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BackupPlanName").getter(getter(RecoveryPointCreator::backupPlanName))
            .setter(setter(Builder::backupPlanName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupPlanName").build()).build();

    private static final SdkField<String> BACKUP_PLAN_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BackupPlanVersion").getter(getter(RecoveryPointCreator::backupPlanVersion))
            .setter(setter(Builder::backupPlanVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupPlanVersion").build()).build();

    private static final SdkField<String> BACKUP_RULE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BackupRuleId").getter(getter(RecoveryPointCreator::backupRuleId)).setter(setter(Builder::backupRuleId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupRuleId").build()).build();

    private static final SdkField<String> BACKUP_RULE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BackupRuleName").getter(getter(RecoveryPointCreator::backupRuleName))
            .setter(setter(Builder::backupRuleName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupRuleName").build()).build();

    private static final SdkField<String> BACKUP_RULE_CRON_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BackupRuleCron").getter(getter(RecoveryPointCreator::backupRuleCron))
            .setter(setter(Builder::backupRuleCron))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupRuleCron").build()).build();

    private static final SdkField<String> BACKUP_RULE_TIMEZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("BackupRuleTimezone").getter(getter(RecoveryPointCreator::backupRuleTimezone))
            .setter(setter(Builder::backupRuleTimezone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BackupRuleTimezone").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BACKUP_PLAN_ID_FIELD,
            BACKUP_PLAN_ARN_FIELD, BACKUP_PLAN_NAME_FIELD, BACKUP_PLAN_VERSION_FIELD, BACKUP_RULE_ID_FIELD,
            BACKUP_RULE_NAME_FIELD, BACKUP_RULE_CRON_FIELD, BACKUP_RULE_TIMEZONE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String backupPlanId;

    private final String backupPlanArn;

    private final String backupPlanName;

    private final String backupPlanVersion;

    private final String backupRuleId;

    private final String backupRuleName;

    private final String backupRuleCron;

    private final String backupRuleTimezone;

    private RecoveryPointCreator(BuilderImpl builder) {
        this.backupPlanId = builder.backupPlanId;
        this.backupPlanArn = builder.backupPlanArn;
        this.backupPlanName = builder.backupPlanName;
        this.backupPlanVersion = builder.backupPlanVersion;
        this.backupRuleId = builder.backupRuleId;
        this.backupRuleName = builder.backupRuleName;
        this.backupRuleCron = builder.backupRuleCron;
        this.backupRuleTimezone = builder.backupRuleTimezone;
    }

    /**
     * <p>
     * Uniquely identifies a backup plan.
     * </p>
     * 
     * @return Uniquely identifies a backup plan.
     */
    public final String backupPlanId() {
        return backupPlanId;
    }

    /**
     * <p>
     * An Amazon Resource Name (ARN) that uniquely identifies a backup plan; for example,
     * <code>arn:aws:backup:us-east-1:123456789012:plan:8F81F553-3A74-4A3F-B93D-B3360DC80C50</code>.
     * </p>
     * 
     * @return An Amazon Resource Name (ARN) that uniquely identifies a backup plan; for example,
     *         <code>arn:aws:backup:us-east-1:123456789012:plan:8F81F553-3A74-4A3F-B93D-B3360DC80C50</code>.
     */
    public final String backupPlanArn() {
        return backupPlanArn;
    }

    /**
     * <p>
     * The name of the backup plan that created this recovery point. This provides human-readable context about which
     * backup plan was responsible for the backup job.
     * </p>
     * 
     * @return The name of the backup plan that created this recovery point. This provides human-readable context about
     *         which backup plan was responsible for the backup job.
     */
    public final String backupPlanName() {
        return backupPlanName;
    }

    /**
     * <p>
     * Version IDs are unique, randomly generated, Unicode, UTF-8 encoded strings that are at most 1,024 bytes long.
     * They cannot be edited.
     * </p>
     * 
     * @return Version IDs are unique, randomly generated, Unicode, UTF-8 encoded strings that are at most 1,024 bytes
     *         long. They cannot be edited.
     */
    public final String backupPlanVersion() {
        return backupPlanVersion;
    }

    /**
     * <p>
     * Uniquely identifies a rule used to schedule the backup of a selection of resources.
     * </p>
     * 
     * @return Uniquely identifies a rule used to schedule the backup of a selection of resources.
     */
    public final String backupRuleId() {
        return backupRuleId;
    }

    /**
     * <p>
     * The name of the backup rule within the backup plan that created this recovery point. This helps identify which
     * specific rule triggered the backup job.
     * </p>
     * 
     * @return The name of the backup rule within the backup plan that created this recovery point. This helps identify
     *         which specific rule triggered the backup job.
     */
    public final String backupRuleName() {
        return backupRuleName;
    }

    /**
     * <p>
     * The cron expression that defines the schedule for the backup rule. This shows the frequency and timing of when
     * backups are automatically triggered.
     * </p>
     * 
     * @return The cron expression that defines the schedule for the backup rule. This shows the frequency and timing of
     *         when backups are automatically triggered.
     */
    public final String backupRuleCron() {
        return backupRuleCron;
    }

    /**
     * <p>
     * The timezone used for the backup rule schedule. This provides context for when backups are scheduled to run in
     * the specified timezone.
     * </p>
     * 
     * @return The timezone used for the backup rule schedule. This provides context for when backups are scheduled to
     *         run in the specified timezone.
     */
    public final String backupRuleTimezone() {
        return backupRuleTimezone;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(backupPlanId());
        hashCode = 31 * hashCode + Objects.hashCode(backupPlanArn());
        hashCode = 31 * hashCode + Objects.hashCode(backupPlanName());
        hashCode = 31 * hashCode + Objects.hashCode(backupPlanVersion());
        hashCode = 31 * hashCode + Objects.hashCode(backupRuleId());
        hashCode = 31 * hashCode + Objects.hashCode(backupRuleName());
        hashCode = 31 * hashCode + Objects.hashCode(backupRuleCron());
        hashCode = 31 * hashCode + Objects.hashCode(backupRuleTimezone());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecoveryPointCreator)) {
            return false;
        }
        RecoveryPointCreator other = (RecoveryPointCreator) obj;
        return Objects.equals(backupPlanId(), other.backupPlanId()) && Objects.equals(backupPlanArn(), other.backupPlanArn())
                && Objects.equals(backupPlanName(), other.backupPlanName())
                && Objects.equals(backupPlanVersion(), other.backupPlanVersion())
                && Objects.equals(backupRuleId(), other.backupRuleId())
                && Objects.equals(backupRuleName(), other.backupRuleName())
                && Objects.equals(backupRuleCron(), other.backupRuleCron())
                && Objects.equals(backupRuleTimezone(), other.backupRuleTimezone());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RecoveryPointCreator").add("BackupPlanId", backupPlanId()).add("BackupPlanArn", backupPlanArn())
                .add("BackupPlanName", backupPlanName()).add("BackupPlanVersion", backupPlanVersion())
                .add("BackupRuleId", backupRuleId()).add("BackupRuleName", backupRuleName())
                .add("BackupRuleCron", backupRuleCron()).add("BackupRuleTimezone", backupRuleTimezone()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "BackupPlanId":
            return Optional.ofNullable(clazz.cast(backupPlanId()));
        case "BackupPlanArn":
            return Optional.ofNullable(clazz.cast(backupPlanArn()));
        case "BackupPlanName":
            return Optional.ofNullable(clazz.cast(backupPlanName()));
        case "BackupPlanVersion":
            return Optional.ofNullable(clazz.cast(backupPlanVersion()));
        case "BackupRuleId":
            return Optional.ofNullable(clazz.cast(backupRuleId()));
        case "BackupRuleName":
            return Optional.ofNullable(clazz.cast(backupRuleName()));
        case "BackupRuleCron":
            return Optional.ofNullable(clazz.cast(backupRuleCron()));
        case "BackupRuleTimezone":
            return Optional.ofNullable(clazz.cast(backupRuleTimezone()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("BackupPlanId", BACKUP_PLAN_ID_FIELD);
        map.put("BackupPlanArn", BACKUP_PLAN_ARN_FIELD);
        map.put("BackupPlanName", BACKUP_PLAN_NAME_FIELD);
        map.put("BackupPlanVersion", BACKUP_PLAN_VERSION_FIELD);
        map.put("BackupRuleId", BACKUP_RULE_ID_FIELD);
        map.put("BackupRuleName", BACKUP_RULE_NAME_FIELD);
        map.put("BackupRuleCron", BACKUP_RULE_CRON_FIELD);
        map.put("BackupRuleTimezone", BACKUP_RULE_TIMEZONE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RecoveryPointCreator, T> g) {
        return obj -> g.apply((RecoveryPointCreator) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RecoveryPointCreator> {
        /**
         * <p>
         * Uniquely identifies a backup plan.
         * </p>
         * 
         * @param backupPlanId
         *        Uniquely identifies a backup plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupPlanId(String backupPlanId);

        /**
         * <p>
         * An Amazon Resource Name (ARN) that uniquely identifies a backup plan; for example,
         * <code>arn:aws:backup:us-east-1:123456789012:plan:8F81F553-3A74-4A3F-B93D-B3360DC80C50</code>.
         * </p>
         * 
         * @param backupPlanArn
         *        An Amazon Resource Name (ARN) that uniquely identifies a backup plan; for example,
         *        <code>arn:aws:backup:us-east-1:123456789012:plan:8F81F553-3A74-4A3F-B93D-B3360DC80C50</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupPlanArn(String backupPlanArn);

        /**
         * <p>
         * The name of the backup plan that created this recovery point. This provides human-readable context about
         * which backup plan was responsible for the backup job.
         * </p>
         * 
         * @param backupPlanName
         *        The name of the backup plan that created this recovery point. This provides human-readable context
         *        about which backup plan was responsible for the backup job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupPlanName(String backupPlanName);

        /**
         * <p>
         * Version IDs are unique, randomly generated, Unicode, UTF-8 encoded strings that are at most 1,024 bytes long.
         * They cannot be edited.
         * </p>
         * 
         * @param backupPlanVersion
         *        Version IDs are unique, randomly generated, Unicode, UTF-8 encoded strings that are at most 1,024
         *        bytes long. They cannot be edited.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupPlanVersion(String backupPlanVersion);

        /**
         * <p>
         * Uniquely identifies a rule used to schedule the backup of a selection of resources.
         * </p>
         * 
         * @param backupRuleId
         *        Uniquely identifies a rule used to schedule the backup of a selection of resources.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupRuleId(String backupRuleId);

        /**
         * <p>
         * The name of the backup rule within the backup plan that created this recovery point. This helps identify
         * which specific rule triggered the backup job.
         * </p>
         * 
         * @param backupRuleName
         *        The name of the backup rule within the backup plan that created this recovery point. This helps
         *        identify which specific rule triggered the backup job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupRuleName(String backupRuleName);

        /**
         * <p>
         * The cron expression that defines the schedule for the backup rule. This shows the frequency and timing of
         * when backups are automatically triggered.
         * </p>
         * 
         * @param backupRuleCron
         *        The cron expression that defines the schedule for the backup rule. This shows the frequency and timing
         *        of when backups are automatically triggered.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupRuleCron(String backupRuleCron);

        /**
         * <p>
         * The timezone used for the backup rule schedule. This provides context for when backups are scheduled to run
         * in the specified timezone.
         * </p>
         * 
         * @param backupRuleTimezone
         *        The timezone used for the backup rule schedule. This provides context for when backups are scheduled
         *        to run in the specified timezone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder backupRuleTimezone(String backupRuleTimezone);
    }

    static final class BuilderImpl implements Builder {
        private String backupPlanId;

        private String backupPlanArn;

        private String backupPlanName;

        private String backupPlanVersion;

        private String backupRuleId;

        private String backupRuleName;

        private String backupRuleCron;

        private String backupRuleTimezone;

        private BuilderImpl() {
        }

        private BuilderImpl(RecoveryPointCreator model) {
            backupPlanId(model.backupPlanId);
            backupPlanArn(model.backupPlanArn);
            backupPlanName(model.backupPlanName);
            backupPlanVersion(model.backupPlanVersion);
            backupRuleId(model.backupRuleId);
            backupRuleName(model.backupRuleName);
            backupRuleCron(model.backupRuleCron);
            backupRuleTimezone(model.backupRuleTimezone);
        }

        public final String getBackupPlanId() {
            return backupPlanId;
        }

        public final void setBackupPlanId(String backupPlanId) {
            this.backupPlanId = backupPlanId;
        }

        @Override
        public final Builder backupPlanId(String backupPlanId) {
            this.backupPlanId = backupPlanId;
            return this;
        }

        public final String getBackupPlanArn() {
            return backupPlanArn;
        }

        public final void setBackupPlanArn(String backupPlanArn) {
            this.backupPlanArn = backupPlanArn;
        }

        @Override
        public final Builder backupPlanArn(String backupPlanArn) {
            this.backupPlanArn = backupPlanArn;
            return this;
        }

        public final String getBackupPlanName() {
            return backupPlanName;
        }

        public final void setBackupPlanName(String backupPlanName) {
            this.backupPlanName = backupPlanName;
        }

        @Override
        public final Builder backupPlanName(String backupPlanName) {
            this.backupPlanName = backupPlanName;
            return this;
        }

        public final String getBackupPlanVersion() {
            return backupPlanVersion;
        }

        public final void setBackupPlanVersion(String backupPlanVersion) {
            this.backupPlanVersion = backupPlanVersion;
        }

        @Override
        public final Builder backupPlanVersion(String backupPlanVersion) {
            this.backupPlanVersion = backupPlanVersion;
            return this;
        }

        public final String getBackupRuleId() {
            return backupRuleId;
        }

        public final void setBackupRuleId(String backupRuleId) {
            this.backupRuleId = backupRuleId;
        }

        @Override
        public final Builder backupRuleId(String backupRuleId) {
            this.backupRuleId = backupRuleId;
            return this;
        }

        public final String getBackupRuleName() {
            return backupRuleName;
        }

        public final void setBackupRuleName(String backupRuleName) {
            this.backupRuleName = backupRuleName;
        }

        @Override
        public final Builder backupRuleName(String backupRuleName) {
            this.backupRuleName = backupRuleName;
            return this;
        }

        public final String getBackupRuleCron() {
            return backupRuleCron;
        }

        public final void setBackupRuleCron(String backupRuleCron) {
            this.backupRuleCron = backupRuleCron;
        }

        @Override
        public final Builder backupRuleCron(String backupRuleCron) {
            this.backupRuleCron = backupRuleCron;
            return this;
        }

        public final String getBackupRuleTimezone() {
            return backupRuleTimezone;
        }

        public final void setBackupRuleTimezone(String backupRuleTimezone) {
            this.backupRuleTimezone = backupRuleTimezone;
        }

        @Override
        public final Builder backupRuleTimezone(String backupRuleTimezone) {
            this.backupRuleTimezone = backupRuleTimezone;
            return this;
        }

        @Override
        public RecoveryPointCreator build() {
            return new RecoveryPointCreator(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
