/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.backup.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListScanJobsRequest extends BackupRequest implements
        ToCopyableBuilder<ListScanJobsRequest.Builder, ListScanJobsRequest> {
    private static final SdkField<String> BY_ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ByAccountId").getter(getter(ListScanJobsRequest::byAccountId)).setter(setter(Builder::byAccountId))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("ByAccountId").build()).build();

    private static final SdkField<String> BY_BACKUP_VAULT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ByBackupVaultName").getter(getter(ListScanJobsRequest::byBackupVaultName))
            .setter(setter(Builder::byBackupVaultName))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("ByBackupVaultName").build())
            .build();

    private static final SdkField<Instant> BY_COMPLETE_AFTER_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ByCompleteAfter").getter(getter(ListScanJobsRequest::byCompleteAfter))
            .setter(setter(Builder::byCompleteAfter))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("ByCompleteAfter").build())
            .build();

    private static final SdkField<Instant> BY_COMPLETE_BEFORE_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("ByCompleteBefore").getter(getter(ListScanJobsRequest::byCompleteBefore))
            .setter(setter(Builder::byCompleteBefore))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("ByCompleteBefore").build())
            .build();

    private static final SdkField<String> BY_MALWARE_SCANNER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ByMalwareScanner").getter(getter(ListScanJobsRequest::byMalwareScannerAsString))
            .setter(setter(Builder::byMalwareScanner))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("ByMalwareScanner").build())
            .build();

    private static final SdkField<String> BY_RECOVERY_POINT_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ByRecoveryPointArn").getter(getter(ListScanJobsRequest::byRecoveryPointArn))
            .setter(setter(Builder::byRecoveryPointArn))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("ByRecoveryPointArn").build())
            .build();

    private static final SdkField<String> BY_RESOURCE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ByResourceArn").getter(getter(ListScanJobsRequest::byResourceArn))
            .setter(setter(Builder::byResourceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("ByResourceArn").build()).build();

    private static final SdkField<String> BY_RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ByResourceType").getter(getter(ListScanJobsRequest::byResourceTypeAsString))
            .setter(setter(Builder::byResourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("ByResourceType").build())
            .build();

    private static final SdkField<String> BY_SCAN_RESULT_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ByScanResultStatus").getter(getter(ListScanJobsRequest::byScanResultStatusAsString))
            .setter(setter(Builder::byScanResultStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("ByScanResultStatus").build())
            .build();

    private static final SdkField<String> BY_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ByState").getter(getter(ListScanJobsRequest::byStateAsString)).setter(setter(Builder::byState))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("ByState").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(ListScanJobsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(ListScanJobsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BY_ACCOUNT_ID_FIELD,
            BY_BACKUP_VAULT_NAME_FIELD, BY_COMPLETE_AFTER_FIELD, BY_COMPLETE_BEFORE_FIELD, BY_MALWARE_SCANNER_FIELD,
            BY_RECOVERY_POINT_ARN_FIELD, BY_RESOURCE_ARN_FIELD, BY_RESOURCE_TYPE_FIELD, BY_SCAN_RESULT_STATUS_FIELD,
            BY_STATE_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String byAccountId;

    private final String byBackupVaultName;

    private final Instant byCompleteAfter;

    private final Instant byCompleteBefore;

    private final String byMalwareScanner;

    private final String byRecoveryPointArn;

    private final String byResourceArn;

    private final String byResourceType;

    private final String byScanResultStatus;

    private final String byState;

    private final Integer maxResults;

    private final String nextToken;

    private ListScanJobsRequest(BuilderImpl builder) {
        super(builder);
        this.byAccountId = builder.byAccountId;
        this.byBackupVaultName = builder.byBackupVaultName;
        this.byCompleteAfter = builder.byCompleteAfter;
        this.byCompleteBefore = builder.byCompleteBefore;
        this.byMalwareScanner = builder.byMalwareScanner;
        this.byRecoveryPointArn = builder.byRecoveryPointArn;
        this.byResourceArn = builder.byResourceArn;
        this.byResourceType = builder.byResourceType;
        this.byScanResultStatus = builder.byScanResultStatus;
        this.byState = builder.byState;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The account ID to list the jobs from. Returns only backup jobs associated with the specified account ID.
     * </p>
     * <p>
     * If used from an Amazon Web Services Organizations management account, passing <code>*</code> returns all jobs
     * across the organization.
     * </p>
     * <p>
     * Pattern: <code>^[0-9]{12}$</code>
     * </p>
     * 
     * @return The account ID to list the jobs from. Returns only backup jobs associated with the specified account
     *         ID.</p>
     *         <p>
     *         If used from an Amazon Web Services Organizations management account, passing <code>*</code> returns all
     *         jobs across the organization.
     *         </p>
     *         <p>
     *         Pattern: <code>^[0-9]{12}$</code>
     */
    public final String byAccountId() {
        return byAccountId;
    }

    /**
     * <p>
     * Returns only scan jobs that will be stored in the specified backup vault. Backup vaults are identified by names
     * that are unique to the account used to create them and the Amazon Web Services Region where they are created.
     * </p>
     * <p>
     * Pattern: <code>^[a-zA-Z0-9\-\_\.]{2,50}$</code>
     * </p>
     * 
     * @return Returns only scan jobs that will be stored in the specified backup vault. Backup vaults are identified by
     *         names that are unique to the account used to create them and the Amazon Web Services Region where they
     *         are created.</p>
     *         <p>
     *         Pattern: <code>^[a-zA-Z0-9\-\_\.]{2,50}$</code>
     */
    public final String byBackupVaultName() {
        return byBackupVaultName;
    }

    /**
     * <p>
     * Returns only scan jobs completed after a date expressed in Unix format and Coordinated Universal Time (UTC).
     * </p>
     * 
     * @return Returns only scan jobs completed after a date expressed in Unix format and Coordinated Universal Time
     *         (UTC).
     */
    public final Instant byCompleteAfter() {
        return byCompleteAfter;
    }

    /**
     * <p>
     * Returns only backup jobs completed before a date expressed in Unix format and Coordinated Universal Time (UTC).
     * </p>
     * 
     * @return Returns only backup jobs completed before a date expressed in Unix format and Coordinated Universal Time
     *         (UTC).
     */
    public final Instant byCompleteBefore() {
        return byCompleteBefore;
    }

    /**
     * <p>
     * Returns only the scan jobs for the specified malware scanner. Currently only supports <code>GUARDDUTY</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #byMalwareScanner}
     * will return {@link MalwareScanner#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #byMalwareScannerAsString}.
     * </p>
     * 
     * @return Returns only the scan jobs for the specified malware scanner. Currently only supports
     *         <code>GUARDDUTY</code>.
     * @see MalwareScanner
     */
    public final MalwareScanner byMalwareScanner() {
        return MalwareScanner.fromValue(byMalwareScanner);
    }

    /**
     * <p>
     * Returns only the scan jobs for the specified malware scanner. Currently only supports <code>GUARDDUTY</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #byMalwareScanner}
     * will return {@link MalwareScanner#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #byMalwareScannerAsString}.
     * </p>
     * 
     * @return Returns only the scan jobs for the specified malware scanner. Currently only supports
     *         <code>GUARDDUTY</code>.
     * @see MalwareScanner
     */
    public final String byMalwareScannerAsString() {
        return byMalwareScanner;
    }

    /**
     * <p>
     * Returns only the scan jobs that are ran against the specified recovery point.
     * </p>
     * 
     * @return Returns only the scan jobs that are ran against the specified recovery point.
     */
    public final String byRecoveryPointArn() {
        return byRecoveryPointArn;
    }

    /**
     * <p>
     * Returns only scan jobs that match the specified resource Amazon Resource Name (ARN).
     * </p>
     * 
     * @return Returns only scan jobs that match the specified resource Amazon Resource Name (ARN).
     */
    public final String byResourceArn() {
        return byResourceArn;
    }

    /**
     * <p>
     * Returns restore testing selections by the specified restore testing plan name.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>EBS</code>for Amazon Elastic Block Store
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>EC2</code>for Amazon Elastic Compute Cloud
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>S3</code>for Amazon Simple Storage Service (Amazon S3)
     * </p>
     * </li>
     * </ul>
     * <p>
     * Pattern: <code>^[a-zA-Z0-9\-\_\.]{1,50}$</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #byResourceType}
     * will return {@link ScanResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #byResourceTypeAsString}.
     * </p>
     * 
     * @return Returns restore testing selections by the specified restore testing plan name.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>EBS</code>for Amazon Elastic Block Store
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>EC2</code>for Amazon Elastic Compute Cloud
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>S3</code>for Amazon Simple Storage Service (Amazon S3)
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Pattern: <code>^[a-zA-Z0-9\-\_\.]{1,50}$</code>
     * @see ScanResourceType
     */
    public final ScanResourceType byResourceType() {
        return ScanResourceType.fromValue(byResourceType);
    }

    /**
     * <p>
     * Returns restore testing selections by the specified restore testing plan name.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>EBS</code>for Amazon Elastic Block Store
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>EC2</code>for Amazon Elastic Compute Cloud
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>S3</code>for Amazon Simple Storage Service (Amazon S3)
     * </p>
     * </li>
     * </ul>
     * <p>
     * Pattern: <code>^[a-zA-Z0-9\-\_\.]{1,50}$</code>
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #byResourceType}
     * will return {@link ScanResourceType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #byResourceTypeAsString}.
     * </p>
     * 
     * @return Returns restore testing selections by the specified restore testing plan name.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>EBS</code>for Amazon Elastic Block Store
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>EC2</code>for Amazon Elastic Compute Cloud
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>S3</code>for Amazon Simple Storage Service (Amazon S3)
     *         </p>
     *         </li>
     *         </ul>
     *         <p>
     *         Pattern: <code>^[a-zA-Z0-9\-\_\.]{1,50}$</code>
     * @see ScanResourceType
     */
    public final String byResourceTypeAsString() {
        return byResourceType;
    }

    /**
     * <p>
     * Returns only the scan jobs for the specified scan results:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>THREATS_FOUND</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NO_THREATS_FOUND</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #byScanResultStatus} will return {@link ScanResultStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #byScanResultStatusAsString}.
     * </p>
     * 
     * @return Returns only the scan jobs for the specified scan results:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>THREATS_FOUND</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NO_THREATS_FOUND</code>
     *         </p>
     *         </li>
     * @see ScanResultStatus
     */
    public final ScanResultStatus byScanResultStatus() {
        return ScanResultStatus.fromValue(byScanResultStatus);
    }

    /**
     * <p>
     * Returns only the scan jobs for the specified scan results:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>THREATS_FOUND</code>
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NO_THREATS_FOUND</code>
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #byScanResultStatus} will return {@link ScanResultStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #byScanResultStatusAsString}.
     * </p>
     * 
     * @return Returns only the scan jobs for the specified scan results:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>THREATS_FOUND</code>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NO_THREATS_FOUND</code>
     *         </p>
     *         </li>
     * @see ScanResultStatus
     */
    public final String byScanResultStatusAsString() {
        return byScanResultStatus;
    }

    /**
     * <p>
     * Returns only the scan jobs for the specified scanning job state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #byState} will
     * return {@link ScanState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #byStateAsString}.
     * </p>
     * 
     * @return Returns only the scan jobs for the specified scanning job state.
     * @see ScanState
     */
    public final ScanState byState() {
        return ScanState.fromValue(byState);
    }

    /**
     * <p>
     * Returns only the scan jobs for the specified scanning job state.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #byState} will
     * return {@link ScanState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #byStateAsString}.
     * </p>
     * 
     * @return Returns only the scan jobs for the specified scanning job state.
     * @see ScanState
     */
    public final String byStateAsString() {
        return byState;
    }

    /**
     * <p>
     * The maximum number of items to be returned.
     * </p>
     * <p>
     * Valid Range: Minimum value of 1. Maximum value of 1000.
     * </p>
     * 
     * @return The maximum number of items to be returned.</p>
     *         <p>
     *         Valid Range: Minimum value of 1. Maximum value of 1000.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * The next item following a partial list of returned items. For example, if a request is made to return
     * <code>MaxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list
     * starting at the location pointed to by the next token.
     * </p>
     * 
     * @return The next item following a partial list of returned items. For example, if a request is made to return
     *         <code>MaxResults</code> number of items, <code>NextToken</code> allows you to return more items in your
     *         list starting at the location pointed to by the next token.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(byAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(byBackupVaultName());
        hashCode = 31 * hashCode + Objects.hashCode(byCompleteAfter());
        hashCode = 31 * hashCode + Objects.hashCode(byCompleteBefore());
        hashCode = 31 * hashCode + Objects.hashCode(byMalwareScannerAsString());
        hashCode = 31 * hashCode + Objects.hashCode(byRecoveryPointArn());
        hashCode = 31 * hashCode + Objects.hashCode(byResourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(byResourceTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(byScanResultStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(byStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListScanJobsRequest)) {
            return false;
        }
        ListScanJobsRequest other = (ListScanJobsRequest) obj;
        return Objects.equals(byAccountId(), other.byAccountId())
                && Objects.equals(byBackupVaultName(), other.byBackupVaultName())
                && Objects.equals(byCompleteAfter(), other.byCompleteAfter())
                && Objects.equals(byCompleteBefore(), other.byCompleteBefore())
                && Objects.equals(byMalwareScannerAsString(), other.byMalwareScannerAsString())
                && Objects.equals(byRecoveryPointArn(), other.byRecoveryPointArn())
                && Objects.equals(byResourceArn(), other.byResourceArn())
                && Objects.equals(byResourceTypeAsString(), other.byResourceTypeAsString())
                && Objects.equals(byScanResultStatusAsString(), other.byScanResultStatusAsString())
                && Objects.equals(byStateAsString(), other.byStateAsString()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListScanJobsRequest").add("ByAccountId", byAccountId())
                .add("ByBackupVaultName", byBackupVaultName()).add("ByCompleteAfter", byCompleteAfter())
                .add("ByCompleteBefore", byCompleteBefore()).add("ByMalwareScanner", byMalwareScannerAsString())
                .add("ByRecoveryPointArn", byRecoveryPointArn()).add("ByResourceArn", byResourceArn())
                .add("ByResourceType", byResourceTypeAsString()).add("ByScanResultStatus", byScanResultStatusAsString())
                .add("ByState", byStateAsString()).add("MaxResults", maxResults()).add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ByAccountId":
            return Optional.ofNullable(clazz.cast(byAccountId()));
        case "ByBackupVaultName":
            return Optional.ofNullable(clazz.cast(byBackupVaultName()));
        case "ByCompleteAfter":
            return Optional.ofNullable(clazz.cast(byCompleteAfter()));
        case "ByCompleteBefore":
            return Optional.ofNullable(clazz.cast(byCompleteBefore()));
        case "ByMalwareScanner":
            return Optional.ofNullable(clazz.cast(byMalwareScannerAsString()));
        case "ByRecoveryPointArn":
            return Optional.ofNullable(clazz.cast(byRecoveryPointArn()));
        case "ByResourceArn":
            return Optional.ofNullable(clazz.cast(byResourceArn()));
        case "ByResourceType":
            return Optional.ofNullable(clazz.cast(byResourceTypeAsString()));
        case "ByScanResultStatus":
            return Optional.ofNullable(clazz.cast(byScanResultStatusAsString()));
        case "ByState":
            return Optional.ofNullable(clazz.cast(byStateAsString()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ByAccountId", BY_ACCOUNT_ID_FIELD);
        map.put("ByBackupVaultName", BY_BACKUP_VAULT_NAME_FIELD);
        map.put("ByCompleteAfter", BY_COMPLETE_AFTER_FIELD);
        map.put("ByCompleteBefore", BY_COMPLETE_BEFORE_FIELD);
        map.put("ByMalwareScanner", BY_MALWARE_SCANNER_FIELD);
        map.put("ByRecoveryPointArn", BY_RECOVERY_POINT_ARN_FIELD);
        map.put("ByResourceArn", BY_RESOURCE_ARN_FIELD);
        map.put("ByResourceType", BY_RESOURCE_TYPE_FIELD);
        map.put("ByScanResultStatus", BY_SCAN_RESULT_STATUS_FIELD);
        map.put("ByState", BY_STATE_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListScanJobsRequest, T> g) {
        return obj -> g.apply((ListScanJobsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends BackupRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListScanJobsRequest> {
        /**
         * <p>
         * The account ID to list the jobs from. Returns only backup jobs associated with the specified account ID.
         * </p>
         * <p>
         * If used from an Amazon Web Services Organizations management account, passing <code>*</code> returns all jobs
         * across the organization.
         * </p>
         * <p>
         * Pattern: <code>^[0-9]{12}$</code>
         * </p>
         * 
         * @param byAccountId
         *        The account ID to list the jobs from. Returns only backup jobs associated with the specified account
         *        ID.</p>
         *        <p>
         *        If used from an Amazon Web Services Organizations management account, passing <code>*</code> returns
         *        all jobs across the organization.
         *        </p>
         *        <p>
         *        Pattern: <code>^[0-9]{12}$</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder byAccountId(String byAccountId);

        /**
         * <p>
         * Returns only scan jobs that will be stored in the specified backup vault. Backup vaults are identified by
         * names that are unique to the account used to create them and the Amazon Web Services Region where they are
         * created.
         * </p>
         * <p>
         * Pattern: <code>^[a-zA-Z0-9\-\_\.]{2,50}$</code>
         * </p>
         * 
         * @param byBackupVaultName
         *        Returns only scan jobs that will be stored in the specified backup vault. Backup vaults are identified
         *        by names that are unique to the account used to create them and the Amazon Web Services Region where
         *        they are created.</p>
         *        <p>
         *        Pattern: <code>^[a-zA-Z0-9\-\_\.]{2,50}$</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder byBackupVaultName(String byBackupVaultName);

        /**
         * <p>
         * Returns only scan jobs completed after a date expressed in Unix format and Coordinated Universal Time (UTC).
         * </p>
         * 
         * @param byCompleteAfter
         *        Returns only scan jobs completed after a date expressed in Unix format and Coordinated Universal Time
         *        (UTC).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder byCompleteAfter(Instant byCompleteAfter);

        /**
         * <p>
         * Returns only backup jobs completed before a date expressed in Unix format and Coordinated Universal Time
         * (UTC).
         * </p>
         * 
         * @param byCompleteBefore
         *        Returns only backup jobs completed before a date expressed in Unix format and Coordinated Universal
         *        Time (UTC).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder byCompleteBefore(Instant byCompleteBefore);

        /**
         * <p>
         * Returns only the scan jobs for the specified malware scanner. Currently only supports <code>GUARDDUTY</code>.
         * </p>
         * 
         * @param byMalwareScanner
         *        Returns only the scan jobs for the specified malware scanner. Currently only supports
         *        <code>GUARDDUTY</code>.
         * @see MalwareScanner
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MalwareScanner
         */
        Builder byMalwareScanner(String byMalwareScanner);

        /**
         * <p>
         * Returns only the scan jobs for the specified malware scanner. Currently only supports <code>GUARDDUTY</code>.
         * </p>
         * 
         * @param byMalwareScanner
         *        Returns only the scan jobs for the specified malware scanner. Currently only supports
         *        <code>GUARDDUTY</code>.
         * @see MalwareScanner
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MalwareScanner
         */
        Builder byMalwareScanner(MalwareScanner byMalwareScanner);

        /**
         * <p>
         * Returns only the scan jobs that are ran against the specified recovery point.
         * </p>
         * 
         * @param byRecoveryPointArn
         *        Returns only the scan jobs that are ran against the specified recovery point.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder byRecoveryPointArn(String byRecoveryPointArn);

        /**
         * <p>
         * Returns only scan jobs that match the specified resource Amazon Resource Name (ARN).
         * </p>
         * 
         * @param byResourceArn
         *        Returns only scan jobs that match the specified resource Amazon Resource Name (ARN).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder byResourceArn(String byResourceArn);

        /**
         * <p>
         * Returns restore testing selections by the specified restore testing plan name.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>EBS</code>for Amazon Elastic Block Store
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>EC2</code>for Amazon Elastic Compute Cloud
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>S3</code>for Amazon Simple Storage Service (Amazon S3)
         * </p>
         * </li>
         * </ul>
         * <p>
         * Pattern: <code>^[a-zA-Z0-9\-\_\.]{1,50}$</code>
         * </p>
         * 
         * @param byResourceType
         *        Returns restore testing selections by the specified restore testing plan name.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>EBS</code>for Amazon Elastic Block Store
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>EC2</code>for Amazon Elastic Compute Cloud
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>S3</code>for Amazon Simple Storage Service (Amazon S3)
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Pattern: <code>^[a-zA-Z0-9\-\_\.]{1,50}$</code>
         * @see ScanResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScanResourceType
         */
        Builder byResourceType(String byResourceType);

        /**
         * <p>
         * Returns restore testing selections by the specified restore testing plan name.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>EBS</code>for Amazon Elastic Block Store
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>EC2</code>for Amazon Elastic Compute Cloud
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>S3</code>for Amazon Simple Storage Service (Amazon S3)
         * </p>
         * </li>
         * </ul>
         * <p>
         * Pattern: <code>^[a-zA-Z0-9\-\_\.]{1,50}$</code>
         * </p>
         * 
         * @param byResourceType
         *        Returns restore testing selections by the specified restore testing plan name.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>EBS</code>for Amazon Elastic Block Store
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>EC2</code>for Amazon Elastic Compute Cloud
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>S3</code>for Amazon Simple Storage Service (Amazon S3)
         *        </p>
         *        </li>
         *        </ul>
         *        <p>
         *        Pattern: <code>^[a-zA-Z0-9\-\_\.]{1,50}$</code>
         * @see ScanResourceType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScanResourceType
         */
        Builder byResourceType(ScanResourceType byResourceType);

        /**
         * <p>
         * Returns only the scan jobs for the specified scan results:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>THREATS_FOUND</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NO_THREATS_FOUND</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param byScanResultStatus
         *        Returns only the scan jobs for the specified scan results:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>THREATS_FOUND</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NO_THREATS_FOUND</code>
         *        </p>
         *        </li>
         * @see ScanResultStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScanResultStatus
         */
        Builder byScanResultStatus(String byScanResultStatus);

        /**
         * <p>
         * Returns only the scan jobs for the specified scan results:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>THREATS_FOUND</code>
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NO_THREATS_FOUND</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param byScanResultStatus
         *        Returns only the scan jobs for the specified scan results:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>THREATS_FOUND</code>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NO_THREATS_FOUND</code>
         *        </p>
         *        </li>
         * @see ScanResultStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScanResultStatus
         */
        Builder byScanResultStatus(ScanResultStatus byScanResultStatus);

        /**
         * <p>
         * Returns only the scan jobs for the specified scanning job state.
         * </p>
         * 
         * @param byState
         *        Returns only the scan jobs for the specified scanning job state.
         * @see ScanState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScanState
         */
        Builder byState(String byState);

        /**
         * <p>
         * Returns only the scan jobs for the specified scanning job state.
         * </p>
         * 
         * @param byState
         *        Returns only the scan jobs for the specified scanning job state.
         * @see ScanState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ScanState
         */
        Builder byState(ScanState byState);

        /**
         * <p>
         * The maximum number of items to be returned.
         * </p>
         * <p>
         * Valid Range: Minimum value of 1. Maximum value of 1000.
         * </p>
         * 
         * @param maxResults
         *        The maximum number of items to be returned.</p>
         *        <p>
         *        Valid Range: Minimum value of 1. Maximum value of 1000.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * The next item following a partial list of returned items. For example, if a request is made to return
         * <code>MaxResults</code> number of items, <code>NextToken</code> allows you to return more items in your list
         * starting at the location pointed to by the next token.
         * </p>
         * 
         * @param nextToken
         *        The next item following a partial list of returned items. For example, if a request is made to return
         *        <code>MaxResults</code> number of items, <code>NextToken</code> allows you to return more items in
         *        your list starting at the location pointed to by the next token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BackupRequest.BuilderImpl implements Builder {
        private String byAccountId;

        private String byBackupVaultName;

        private Instant byCompleteAfter;

        private Instant byCompleteBefore;

        private String byMalwareScanner;

        private String byRecoveryPointArn;

        private String byResourceArn;

        private String byResourceType;

        private String byScanResultStatus;

        private String byState;

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListScanJobsRequest model) {
            super(model);
            byAccountId(model.byAccountId);
            byBackupVaultName(model.byBackupVaultName);
            byCompleteAfter(model.byCompleteAfter);
            byCompleteBefore(model.byCompleteBefore);
            byMalwareScanner(model.byMalwareScanner);
            byRecoveryPointArn(model.byRecoveryPointArn);
            byResourceArn(model.byResourceArn);
            byResourceType(model.byResourceType);
            byScanResultStatus(model.byScanResultStatus);
            byState(model.byState);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final String getByAccountId() {
            return byAccountId;
        }

        public final void setByAccountId(String byAccountId) {
            this.byAccountId = byAccountId;
        }

        @Override
        public final Builder byAccountId(String byAccountId) {
            this.byAccountId = byAccountId;
            return this;
        }

        public final String getByBackupVaultName() {
            return byBackupVaultName;
        }

        public final void setByBackupVaultName(String byBackupVaultName) {
            this.byBackupVaultName = byBackupVaultName;
        }

        @Override
        public final Builder byBackupVaultName(String byBackupVaultName) {
            this.byBackupVaultName = byBackupVaultName;
            return this;
        }

        public final Instant getByCompleteAfter() {
            return byCompleteAfter;
        }

        public final void setByCompleteAfter(Instant byCompleteAfter) {
            this.byCompleteAfter = byCompleteAfter;
        }

        @Override
        public final Builder byCompleteAfter(Instant byCompleteAfter) {
            this.byCompleteAfter = byCompleteAfter;
            return this;
        }

        public final Instant getByCompleteBefore() {
            return byCompleteBefore;
        }

        public final void setByCompleteBefore(Instant byCompleteBefore) {
            this.byCompleteBefore = byCompleteBefore;
        }

        @Override
        public final Builder byCompleteBefore(Instant byCompleteBefore) {
            this.byCompleteBefore = byCompleteBefore;
            return this;
        }

        public final String getByMalwareScanner() {
            return byMalwareScanner;
        }

        public final void setByMalwareScanner(String byMalwareScanner) {
            this.byMalwareScanner = byMalwareScanner;
        }

        @Override
        public final Builder byMalwareScanner(String byMalwareScanner) {
            this.byMalwareScanner = byMalwareScanner;
            return this;
        }

        @Override
        public final Builder byMalwareScanner(MalwareScanner byMalwareScanner) {
            this.byMalwareScanner(byMalwareScanner == null ? null : byMalwareScanner.toString());
            return this;
        }

        public final String getByRecoveryPointArn() {
            return byRecoveryPointArn;
        }

        public final void setByRecoveryPointArn(String byRecoveryPointArn) {
            this.byRecoveryPointArn = byRecoveryPointArn;
        }

        @Override
        public final Builder byRecoveryPointArn(String byRecoveryPointArn) {
            this.byRecoveryPointArn = byRecoveryPointArn;
            return this;
        }

        public final String getByResourceArn() {
            return byResourceArn;
        }

        public final void setByResourceArn(String byResourceArn) {
            this.byResourceArn = byResourceArn;
        }

        @Override
        public final Builder byResourceArn(String byResourceArn) {
            this.byResourceArn = byResourceArn;
            return this;
        }

        public final String getByResourceType() {
            return byResourceType;
        }

        public final void setByResourceType(String byResourceType) {
            this.byResourceType = byResourceType;
        }

        @Override
        public final Builder byResourceType(String byResourceType) {
            this.byResourceType = byResourceType;
            return this;
        }

        @Override
        public final Builder byResourceType(ScanResourceType byResourceType) {
            this.byResourceType(byResourceType == null ? null : byResourceType.toString());
            return this;
        }

        public final String getByScanResultStatus() {
            return byScanResultStatus;
        }

        public final void setByScanResultStatus(String byScanResultStatus) {
            this.byScanResultStatus = byScanResultStatus;
        }

        @Override
        public final Builder byScanResultStatus(String byScanResultStatus) {
            this.byScanResultStatus = byScanResultStatus;
            return this;
        }

        @Override
        public final Builder byScanResultStatus(ScanResultStatus byScanResultStatus) {
            this.byScanResultStatus(byScanResultStatus == null ? null : byScanResultStatus.toString());
            return this;
        }

        public final String getByState() {
            return byState;
        }

        public final void setByState(String byState) {
            this.byState = byState;
        }

        @Override
        public final Builder byState(String byState) {
            this.byState = byState;
            return this;
        }

        @Override
        public final Builder byState(ScanState byState) {
            this.byState(byState == null ? null : byState.toString());
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListScanJobsRequest build() {
            return new ListScanJobsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
